/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomFragmentProvider;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomSwitch;
import org.eclipse.etrice.ui.common.support.AutoUpdateFeature;
import org.eclipse.etrice.ui.common.support.RemoveBendpointsFeature;
import org.eclipse.etrice.ui.structure.support.ActorContainerRefSupport;
import org.eclipse.etrice.ui.structure.support.BindingSupport;
import org.eclipse.etrice.ui.structure.support.DecorationProvider;
import org.eclipse.etrice.ui.structure.support.LayerConnectionSupport;
import org.eclipse.etrice.ui.structure.support.PortSupport;
import org.eclipse.etrice.ui.structure.support.SPPSupport;
import org.eclipse.etrice.ui.structure.support.StructureClassSupport;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.ShapeSelectionInfoImpl;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.IColorConstant;

public class ProviderDispatcher {
    private StructureClassSupport structureClassSupport;
    private PortSupport portSupport;
    private SPPSupport sppSupport;
    private ActorContainerRefSupport actorContainerRefSupport;
    private BindingSupport bindingSupport;
    private LayerConnectionSupport layerConnectionSupport;
    private FeatureProviderSwitch featureSwitch;
    private ToolBehaviorProviderSwitch behaviorSwitch;
    private DispatchingFeatureProvider dispatchingFP;
    private DispatchingToolBehaviorProvider dispatchingBP;

    public ProviderDispatcher(IDiagramTypeProvider dtp) {
        this.dispatchingFP = new DispatchingFeatureProvider(dtp);
        this.dispatchingBP = new DispatchingToolBehaviorProvider(dtp);
        this.structureClassSupport = new StructureClassSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.portSupport = new PortSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.sppSupport = new SPPSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.actorContainerRefSupport = new ActorContainerRefSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.bindingSupport = new BindingSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.layerConnectionSupport = new LayerConnectionSupport(dtp, (IFeatureProvider)this.dispatchingFP);
        this.featureSwitch = new FeatureProviderSwitch();
        this.behaviorSwitch = new ToolBehaviorProviderSwitch();
    }

    public IFeatureProvider getFeatureProvider() {
        return this.dispatchingFP;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.dispatchingBP;
    }

    private ICreateFeature[] getAllCreateFeatures() {
        return this.featureSwitch.getCreateFeatures();
    }

    private ICreateConnectionFeature[] getAllCreateConnectionFeatures() {
        return this.featureSwitch.getCreateConnectionFeatures();
    }

    private static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        T[][] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            totalLength += array.length;
            ++n2;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        T[][] TArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    private class DispatchingFeatureProvider
    extends DefaultFeatureProvider {
        public DispatchingFeatureProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICreateFeature[] getCreateFeatures() {
            return ProviderDispatcher.this.getAllCreateFeatures();
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return ProviderDispatcher.this.getAllCreateConnectionFeatures();
        }

        public IAddFeature getAddFeature(IAddContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch((EObject)context.getNewObject());
            if (fp == null) {
                return super.getAddFeature(context);
            }
            return fp.getAddFeature(context);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject((IPictogramElementContext)context));
            if (fp == null) {
                return super.getLayoutFeature(context);
            }
            return fp.getLayoutFeature(context);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject((IPictogramElementContext)context));
            if (fp == null) {
                return super.getMoveShapeFeature(context);
            }
            return fp.getMoveShapeFeature(context);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject((IPictogramElementContext)context));
            if (fp == null) {
                return super.getResizeShapeFeature(context);
            }
            return fp.getResizeShapeFeature(context);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Diagram) {
                return new AutoUpdateFeature((IFeatureProvider)this);
            }
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject((IPictogramElementContext)context));
            if (fp != null) {
                return fp.getUpdateFeature(context);
            }
            return super.getUpdateFeature(context);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            IFeatureProvider fp = this.getFeatureProvider(context);
            if (fp != null) {
                return fp.getReconnectionFeature(context);
            }
            return super.getReconnectionFeature(context);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject((IPictogramElementContext)context));
            if (fp != null) {
                return fp.getDeleteFeature(context);
            }
            return super.getDeleteFeature(context);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject((IPictogramElementContext)context));
            if (fp != null) {
                return fp.getRemoveFeature(context);
            }
            return super.getRemoveFeature(context);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            PictogramElement[] pes;
            ArrayList<Object> result = new ArrayList<Object>();
            IFeatureProvider fp = ProviderDispatcher.this.featureSwitch.doSwitch(this.getBusinessObject(context));
            ICustomFeature[] custom = fp != null ? fp.getCustomFeatures(context) : super.getCustomFeatures(context);
            ICustomFeature[] iCustomFeatureArray = custom;
            int n = custom.length;
            int n2 = 0;
            while (n2 < n) {
                ICustomFeature cust = iCustomFeatureArray[n2];
                result.add(cust);
                ++n2;
            }
            boolean allFreeForm = true;
            PictogramElement[] pictogramElementArray = pes = context.getPictogramElements();
            int n3 = pes.length;
            int n4 = 0;
            while (n4 < n3) {
                PictogramElement pe = pictogramElementArray[n4];
                if (!(pe instanceof FreeFormConnection)) {
                    allFreeForm = false;
                }
                ++n4;
            }
            if (allFreeForm) {
                result.add(new RemoveBendpointsFeature(fp));
            }
            ICustomFeature[] features = new ICustomFeature[result.size()];
            return result.toArray(features);
        }

        private EObject getBusinessObject(IPictogramElementContext context) {
            PictogramElement pictogramElement = context.getPictogramElement();
            EObject bo = (EObject)this.getBusinessObjectForPictogramElement(pictogramElement);
            return bo;
        }

        private EObject getBusinessObject(ICustomContext context) {
            PictogramElement[] pes = context.getPictogramElements();
            if (pes.length > 0) {
                EObject bo = (EObject)this.getBusinessObjectForPictogramElement(pes[0]);
                return bo;
            }
            return null;
        }

        private IFeatureProvider getFeatureProvider(IReconnectionContext context) {
            return ProviderDispatcher.this.featureSwitch.doSwitch((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection()));
        }
    }

    private class DispatchingToolBehaviorProvider
    extends DefaultToolBehaviorProvider {
        public DispatchingToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
            super(diagramTypeProvider);
        }

        public IDecorator[] getDecorators(PictogramElement pe) {
            return DecorationProvider.getDecorators(pe);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getClickArea(pe);
            }
            return bp.getClickArea(pe);
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(pe);
            if (bp == null) {
                return super.getSelectionBorder(pe);
            }
            return bp.getSelectionBorder(pe);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElements()[0]);
            if (bp == null) {
                return super.getDoubleClickFeature(context);
            }
            return bp.getDoubleClickFeature(context);
        }

        protected IToolBehaviorProvider getToolBehaviorProvider(PictogramElement pe) {
            IFeatureProvider fp = this.getFeatureProvider();
            EObject bo = (EObject)fp.getBusinessObjectForPictogramElement(pe);
            if (bo == null) {
                return null;
            }
            IToolBehaviorProvider bp = ProviderDispatcher.this.behaviorSwitch.doSwitch(bo);
            return bp;
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElement());
            if (bp == null) {
                return super.getContextButtonPad(context);
            }
            return bp.getContextButtonPad(context);
        }

        public Object getToolTip(GraphicsAlgorithm context) {
            IToolBehaviorProvider bp = this.getToolBehaviorProvider(context.getPictogramElement());
            if (bp == null) {
                return super.getToolTip(context);
            }
            return bp.getToolTip(context);
        }

        public IShapeSelectionInfo getSelectionInfoForShape(Shape shape) {
            ShapeSelectionInfoImpl ssi = new ShapeSelectionInfoImpl();
            ssi.setColor(IColorConstant.SHAPE_SELECTION_FG);
            ssi.setPrimarySelectionHandleForegroundColor(IColorConstant.HANDLE_FG);
            ssi.setPrimarySelectionHandleBackgroundColor(IColorConstant.HANDLE_BG);
            ssi.setLineStyle(LineStyle.DASH);
            ssi.setPrimarySelectionBackgroundColor(IColorConstant.LIGHT_ORANGE);
            ssi.setSecondarySelectionBackgroundColor(IColorConstant.LIGHT_ORANGE);
            return ssi;
        }
    }

    private class FeatureProviderSwitch
    extends RoomSwitch<IFeatureProvider> {
        private FeatureProviderSwitch() {
        }

        public IFeatureProvider doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return null;
            }
            if (theEObject.eIsProxy()) {
                if (RoomFragmentProvider.isPort((EObject)theEObject)) {
                    return ProviderDispatcher.this.portSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isSPP((EObject)theEObject)) {
                    return ProviderDispatcher.this.sppSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isStructureClass((EObject)theEObject)) {
                    return ProviderDispatcher.this.structureClassSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isBinding((EObject)theEObject)) {
                    return ProviderDispatcher.this.bindingSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isLayerConnection((EObject)theEObject)) {
                    return ProviderDispatcher.this.layerConnectionSupport.getFeatureProvider();
                }
                if (RoomFragmentProvider.isRef((EObject)theEObject)) {
                    return ProviderDispatcher.this.actorContainerRefSupport.getFeatureProvider();
                }
            }
            return (IFeatureProvider)super.doSwitch(theEObject);
        }

        public IFeatureProvider caseStructureClass(StructureClass object) {
            return ProviderDispatcher.this.structureClassSupport.getFeatureProvider();
        }

        public IFeatureProvider casePort(Port port) {
            return ProviderDispatcher.this.portSupport.getFeatureProvider();
        }

        public IFeatureProvider caseSPPRef(SPPRef object) {
            return ProviderDispatcher.this.sppSupport.getFeatureProvider();
        }

        public IFeatureProvider caseActorContainerRef(ActorContainerRef object) {
            return ProviderDispatcher.this.actorContainerRefSupport.getFeatureProvider();
        }

        public IFeatureProvider caseBinding(Binding object) {
            return ProviderDispatcher.this.bindingSupport.getFeatureProvider();
        }

        public IFeatureProvider caseLayerConnection(LayerConnection object) {
            return ProviderDispatcher.this.layerConnectionSupport.getFeatureProvider();
        }

        public IFeatureProvider defaultCase(EObject object) {
            return null;
        }

        public ICreateFeature[] getCreateFeatures() {
            return (ICreateFeature[])ProviderDispatcher.concatAll(ProviderDispatcher.this.structureClassSupport.getFeatureProvider().getCreateFeatures(), new ICreateFeature[][]{ProviderDispatcher.this.portSupport.getFeatureProvider().getCreateFeatures(), ProviderDispatcher.this.sppSupport.getFeatureProvider().getCreateFeatures(), ProviderDispatcher.this.actorContainerRefSupport.getFeatureProvider().getCreateFeatures()});
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return (ICreateConnectionFeature[])ProviderDispatcher.concatAll(ProviderDispatcher.this.bindingSupport.getFeatureProvider().getCreateConnectionFeatures(), new ICreateConnectionFeature[][]{ProviderDispatcher.this.layerConnectionSupport.getFeatureProvider().getCreateConnectionFeatures()});
        }
    }

    private class ToolBehaviorProviderSwitch
    extends RoomSwitch<IToolBehaviorProvider> {
        private ToolBehaviorProviderSwitch() {
        }

        public IToolBehaviorProvider doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return null;
            }
            if (theEObject.eIsProxy()) {
                if (RoomFragmentProvider.isPort((EObject)theEObject)) {
                    return ProviderDispatcher.this.portSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isSPP((EObject)theEObject)) {
                    return ProviderDispatcher.this.sppSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isStructureClass((EObject)theEObject)) {
                    return ProviderDispatcher.this.structureClassSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isBinding((EObject)theEObject)) {
                    return ProviderDispatcher.this.bindingSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isLayerConnection((EObject)theEObject)) {
                    return ProviderDispatcher.this.layerConnectionSupport.getToolBehaviorProvider();
                }
                if (RoomFragmentProvider.isRef((EObject)theEObject)) {
                    return ProviderDispatcher.this.actorContainerRefSupport.getToolBehaviorProvider();
                }
            }
            return (IToolBehaviorProvider)super.doSwitch(theEObject);
        }

        public IToolBehaviorProvider caseStructureClass(StructureClass object) {
            return ProviderDispatcher.this.structureClassSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider casePort(Port port) {
            return ProviderDispatcher.this.portSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseSPPRef(SPPRef object) {
            return ProviderDispatcher.this.sppSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseActorContainerRef(ActorContainerRef object) {
            return ProviderDispatcher.this.actorContainerRefSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseBinding(Binding object) {
            return ProviderDispatcher.this.bindingSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider caseLayerConnection(LayerConnection object) {
            return ProviderDispatcher.this.layerConnectionSupport.getToolBehaviorProvider();
        }

        public IToolBehaviorProvider defaultCase(EObject object) {
            return null;
        }
    }
}

