/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.ui.structure.support.StructureClassSupport;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class PopulateDiagramCommand
extends RecordingCommand {
    private StructureClass sc;
    private Diagram diagram;

    public PopulateDiagramCommand(Diagram diag, StructureClass sc, TransactionalEditingDomain domain) {
        super(domain);
        this.diagram = diag;
        this.sc = sc;
    }

    protected void doExecute() {
        IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(this.diagram, "org.eclipse.etrice.ui.structure.diagramTypeProvider");
        IFeatureProvider featureProvider = dtp.getFeatureProvider();
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)this.sc);
        addContext.setTargetContainer((ContainerShape)this.diagram);
        addContext.setX(40);
        addContext.setY(40);
        HashMap<String, Anchor> ifitem2anchor = new HashMap<String, Anchor>();
        IAddFeature addFeature = featureProvider.getAddFeature((IAddContext)addContext);
        if (addFeature != null && addFeature.canAdd((IAddContext)addContext)) {
            ActorClass base;
            ArrayList items;
            ContainerShape acShape = (ContainerShape)addFeature.add((IAddContext)addContext);
            int width = ((GraphicsAlgorithm)acShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
            if (this.sc instanceof ActorClass) {
                items = new ArrayList();
                items.addAll(((ActorClass)this.sc).getIfPorts());
                items.addAll(((ActorClass)this.sc).getIfSPPs());
                SupportUtil.addInterfaceItems(items, 0, acShape, width, featureProvider, ifitem2anchor);
                SupportUtil.addInterfaceItems((List<? extends InterfaceItem>)((ActorClass)this.sc).getIntPorts(), 120, acShape, width, featureProvider, ifitem2anchor);
            } else if (this.sc instanceof SubSystemClass) {
                items = new ArrayList();
                items.addAll(((SubSystemClass)this.sc).getRelayPorts());
                items.addAll(((SubSystemClass)this.sc).getIfSPPs());
                SupportUtil.addInterfaceItems(items, 0, acShape, width, featureProvider, ifitem2anchor);
            }
            if (this.sc instanceof ActorContainerClass) {
                ActorContainerClass acc = (ActorContainerClass)this.sc;
                SupportUtil.addRefItems((List<? extends ActorContainerRef>)acc.getActorRefs(), acShape, width, featureProvider, ifitem2anchor);
            } else if (this.sc instanceof LogicalSystem) {
                LogicalSystem sys = (LogicalSystem)this.sc;
                SupportUtil.addRefItems((List<? extends ActorContainerRef>)sys.getSubSystems(), acShape, width, featureProvider, ifitem2anchor);
            }
            if (this.sc instanceof ActorClass && (base = ((ActorClass)this.sc).getBase()) != null) {
                StructureClassSupport.addInheritedItems(base, acShape, ifitem2anchor, featureProvider);
            }
            for (LayerConnection lc : this.sc.getConnections()) {
                SupportUtil.addLayerConnection(lc, featureProvider, ifitem2anchor);
            }
            for (Binding bind : this.sc.getBindings()) {
                SupportUtil.addBinding(bind, featureProvider, ifitem2anchor);
            }
        }
    }
}

