/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.dialogs.SubProtocolSelectionDialog;
import org.eclipse.etrice.ui.structure.support.DecorationProvider;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BindingSupport {
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public BindingSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public Object getToolTip(GraphicsAlgorithm ga) {
            EObject bo;
            PictogramElement pe = ga.getPictogramElement();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Binding) {
                Binding bind = (Binding)bo;
                return RoomNameProvider.getDisplayName((Binding)bind);
            }
            return super.getToolTip(ga);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }
    }

    static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        private boolean isInherited(Diagram diag, Binding b) {
            ActorContainerClass ac = (ActorContainerClass)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag.getChildren().get(0));
            return b.eContainer() != ac;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp)};
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context instanceof IAddConnectionContext && context.getNewObject() instanceof Binding;
            }

            public PictogramElement add(IAddContext context) {
                IAddConnectionContext addConContext = (IAddConnectionContext)context;
                Binding bind = (Binding)context.getNewObject();
                boolean inherited = FeatureProvider.this.isInherited(this.getDiagram(), bind);
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
                connection.setStart(addConContext.getSourceAnchor());
                connection.setEnd(addConContext.getTargetAnchor());
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "bind");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                polyline.setForeground(this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR));
                this.link((PictogramElement)connection, bind);
                return connection;
            }
        }

        private class CreateFeature
        extends AbstractCreateConnectionFeature {
            private boolean doneChanges;

            public CreateFeature(IFeatureProvider fp) {
                super(fp, "Binding", "create Binding");
                this.doneChanges = false;
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.binding";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(context.getSourceAnchor(), featureProvider);
                Port tgt = SupportUtil.getPort(context.getTargetAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                if (src == null || tgt == null) {
                    return false;
                }
                StructureClass ac = SupportUtil.getParent(context, featureProvider);
                if (ac == null) {
                    return false;
                }
                ActorContainerRef tgtRef = SupportUtil.getRef(context.getTargetAnchor(), featureProvider);
                return ValidationUtil.isConnectable((Port)src, (ActorContainerRef)srcRef, null, (Port)tgt, (ActorContainerRef)tgtRef, null, (StructureClass)ac, null, (boolean)false).isOk();
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                boolean canStart;
                Port src = SupportUtil.getPort(context.getSourceAnchor(), this.getFeatureProvider());
                boolean bl = canStart = src != null;
                if (canStart) {
                    ActorContainerRef ref = SupportUtil.getRef(context.getSourceAnchor(), this.getFeatureProvider());
                    if (ref == null) {
                        ActorContainerClass acc = (ActorContainerClass)src.eContainer();
                        if (!ValidationUtil.isConnectable((Port)src, null, (StructureClass)acc).isOk()) {
                            canStart = false;
                        }
                    } else {
                        ActorContainerClass acc = (ActorContainerClass)ref.eContainer();
                        if (!ValidationUtil.isConnectable((Port)src, (ActorContainerRef)ref, (StructureClass)acc).isOk()) {
                            canStart = false;
                        }
                    }
                }
                return canStart;
            }

            public Connection create(ICreateConnectionContext context) {
                Connection newConnection = null;
                this.endHighLightMatches();
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(context.getSourceAnchor(), featureProvider);
                Port dst = SupportUtil.getPort(context.getTargetAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getParent(context, featureProvider);
                if (src != null && dst != null && sc != null) {
                    Binding bind = RoomFactory.eINSTANCE.createBinding();
                    BindingEndPoint ep1 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar1 = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                    ep1.setPort(src);
                    ep1.setActorRef(ar1);
                    BindingEndPoint ep2 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar2 = SupportUtil.getRef(context.getTargetAnchor(), featureProvider);
                    ep2.setPort(dst);
                    ep2.setActorRef(ar2);
                    bind.setEndpoint1(ep1);
                    bind.setEndpoint2(ep2);
                    GeneralProtocolClass srcGPC = src.getProtocol();
                    GeneralProtocolClass dstGPC = dst.getProtocol();
                    if (srcGPC instanceof CompoundProtocolClass || dstGPC instanceof CompoundProtocolClass) {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        SubProtocolSelectionDialog dlg = new SubProtocolSelectionDialog(shell, src, ar1, dst, ar2, null, sc);
                        if (dlg.open() != 0) {
                            return null;
                        }
                        ep1.setSub(dlg.getSelected().getLeft());
                        ep2.setSub(dlg.getSelected().getRight());
                    }
                    sc.getBindings().add((Object)bind);
                    AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                    addContext.setNewObject((Object)bind);
                    newConnection = (Connection)featureProvider.addIfPossible((IAddContext)addContext);
                    this.doneChanges = true;
                }
                return newConnection;
            }

            public void attachedToSource(ICreateConnectionContext context) {
                Port src = SupportUtil.getPort(context.getSourceAnchor(), this.getFeatureProvider());
                ActorContainerRef ref = SupportUtil.getRef(context.getSourceAnchor(), this.getFeatureProvider());
                StructureClass sc = SupportUtil.getParent(context, this.getFeatureProvider());
                this.beginHighLightMatches(sc, src, ref);
            }

            public void canceledAttaching(ICreateConnectionContext context) {
                this.endHighLightMatches();
            }

            public void endConnecting() {
                this.endHighLightMatches();
            }

            private void beginHighLightMatches(StructureClass sc, Port src, ActorContainerRef srcRef) {
                if (src == null) {
                    return;
                }
                ContainerShape scContainer = (ContainerShape)this.getDiagram().getChildren().get(0);
                for (Shape subShape : scContainer.getChildren()) {
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)subShape);
                    if (bo instanceof Port) {
                        if (!ValidationUtil.isConnectable((Port)src, (ActorContainerRef)srcRef, null, (Port)((Port)bo), null, null, (StructureClass)sc, null, (boolean)false).isOk()) continue;
                        DecorationProvider.addAllowedPortShape(subShape);
                        this.getDiagramBehavior().refreshRenderingDecorators((PictogramElement)subShape);
                        continue;
                    }
                    if (!(bo instanceof ActorContainerRef)) continue;
                    ActorContainerRef tgtRef = (ActorContainerRef)bo;
                    for (Shape subSubShape : ((ContainerShape)subShape).getChildren()) {
                        bo = this.getBusinessObjectForPictogramElement((PictogramElement)subSubShape);
                        if (!(bo instanceof Port) || !ValidationUtil.isConnectable((Port)src, (ActorContainerRef)srcRef, null, (Port)((Port)bo), (ActorContainerRef)tgtRef, null, (StructureClass)sc, null, (boolean)false).isOk()) continue;
                        DecorationProvider.addAllowedPortShape(subSubShape);
                        this.getDiagramBehavior().refreshRenderingDecorators((PictogramElement)subSubShape);
                    }
                }
            }

            private void endHighLightMatches() {
                DecorationProvider.clearAllowedPortShapes();
                this.getDiagramBehavior().refresh();
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getPictogramElement());
                if (bo instanceof Binding) {
                    Binding b = (Binding)bo;
                    if (FeatureProvider.this.isInherited(this.getDiagram(), b)) {
                        return false;
                    }
                }
                return true;
            }
        }

        private static class PropertyFeature
        extends AbstractCustomFeature {
            private boolean doneChanges;

            public PropertyFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Edit Binding...";
            }

            public String getDescription() {
                return "Edit Binding Properties";
            }

            public boolean canExecute(ICustomContext context) {
                return this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]) instanceof Binding;
            }

            public void execute(ICustomContext context) {
                this.doneChanges = false;
                Binding bind = (Binding)this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                StructureClass sc = (StructureClass)bind.eContainer();
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SubProtocolSelectionDialog dlg = new SubProtocolSelectionDialog(shell, bind.getEndpoint1().getPort(), bind.getEndpoint1().getActorRef(), bind.getEndpoint2().getPort(), bind.getEndpoint2().getActorRef(), bind, sc);
                if (dlg.open() != 0) {
                    return;
                }
                bind.getEndpoint1().setSub(dlg.getSelected().getLeft());
                bind.getEndpoint2().setSub(dlg.getSelected().getRight());
                this.doneChanges = true;
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                Binding bind = (Binding)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                if (FeatureProvider.this.isInherited(this.getDiagram(), bind)) {
                    return false;
                }
                Anchor asrc = context.getConnection().getStart();
                Anchor atgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    asrc = context.getNewAnchor();
                } else {
                    atgt = context.getNewAnchor();
                }
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(asrc, featureProvider);
                Port tgt = SupportUtil.getPort(atgt, featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(asrc, featureProvider);
                if (src == null || tgt == null) {
                    return false;
                }
                StructureClass ac = SupportUtil.getParent((ContainerShape)this.getDiagram(), featureProvider);
                if (ac == null) {
                    return false;
                }
                ActorContainerRef tgtRef = SupportUtil.getRef(atgt, featureProvider);
                return ValidationUtil.isConnectable((Port)src, (ActorContainerRef)srcRef, (SubProtocol)bind.getEndpoint1().getSub(), (Port)tgt, (ActorContainerRef)tgtRef, (SubProtocol)bind.getEndpoint2().getSub(), (StructureClass)ac, (Binding)bind, (boolean)true).isOk();
            }

            public void postReconnect(IReconnectionContext context) {
                super.postReconnect(context);
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(context.getConnection().getStart(), featureProvider);
                Port dst = SupportUtil.getPort(context.getConnection().getEnd(), featureProvider);
                StructureClass sc = SupportUtil.getParent((ContainerShape)this.getDiagram(), featureProvider);
                if (src != null && dst != null && sc != null) {
                    Binding bind = (Binding)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                    BindingEndPoint ep1 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar1 = SupportUtil.getRef(context.getConnection().getStart(), featureProvider);
                    ep1.setPort(src);
                    ep1.setActorRef(ar1);
                    BindingEndPoint ep2 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar2 = SupportUtil.getRef(context.getConnection().getEnd(), featureProvider);
                    ep2.setPort(dst);
                    ep2.setActorRef(ar2);
                    GeneralProtocolClass srcGPC = src.getProtocol();
                    GeneralProtocolClass dstGPC = dst.getProtocol();
                    if (srcGPC instanceof GeneralProtocolClass || dstGPC instanceof GeneralProtocolClass) {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        SubProtocolSelectionDialog dlg = new SubProtocolSelectionDialog(shell, src, ar1, dst, ar2, bind, sc);
                        if (dlg.open() != 0) {
                            return;
                        }
                        ep1.setSub(dlg.getSelected().getLeft());
                        ep2.setSub(dlg.getSelected().getRight());
                    }
                    bind.setEndpoint1(ep1);
                    bind.setEndpoint2(ep2);
                    this.doneChanges = true;
                }
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                return bo instanceof EObject && ((EObject)bo).eIsProxy();
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Binding deleted from model");
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                PictogramElement pe = context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext(pe);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                return false;
            }
        }
    }
}

