/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.common.support.NoResizeFeature;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.ILocationContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class InterfaceItemSupport {
    public static final int ITEM_SIZE = 40;
    public static final int ITEM_SIZE_SMALL = 18;
    public static final int MARGIN = 40;
    public static final int MARGIN_SMALL = 30;
    protected static final int LINE_WIDTH = 2;
    protected static final IColorConstant DARK_COLOR = new ColorConstant(0, 0, 0);
    protected static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    protected static final IColorConstant BRIGHT_COLOR = new ColorConstant(255, 255, 255);
    protected static final String PROP_KIND = "item-kind";

    public static void createRefItems(ActorContainerRef acr, ContainerShape refShape, IFeatureProvider featureProvider) {
        ActorClass refClass = acr instanceof ActorRef ? ((ActorRef)acr).getType() : ((SubSystemRef)acr).getType();
        List refItems = RoomHelpers.getInterfaceItems((StructureClass)refClass, (boolean)true);
        if (refShape != null && refClass != null && !refItems.isEmpty()) {
            Diagram refDiag = new DiagramAccess().getDiagram((StructureClass)refClass);
            ResourceSet rs = acr.eResource().getResourceSet();
            if (!refDiag.getChildren().isEmpty()) {
                ContainerShape refAcShape = (ContainerShape)refDiag.getChildren().get(0);
                Object bo = featureProvider.getBusinessObjectForPictogramElement((PictogramElement)refAcShape);
                if (bo instanceof ActorContainerClass) {
                    ActorContainerClass extRefClass = (ActorContainerClass)bo;
                    assert (extRefClass.getName().equals(refClass.getName())) : "structure class names must match";
                    List extRefItems = RoomHelpers.getInterfaceItems((StructureClass)extRefClass, (boolean)true);
                    List<InterfaceItem> intRefItems = SupportUtil.getInterfaceItems(refShape, featureProvider);
                    double scaleX = (double)(refAcShape.getGraphicsAlgorithm().getWidth() - 80) / (double)(refShape.getGraphicsAlgorithm().getWidth() - 60);
                    double scaleY = (double)(refAcShape.getGraphicsAlgorithm().getHeight() - 80) / (double)(refShape.getGraphicsAlgorithm().getHeight() - 60);
                    for (Shape childShape : refAcShape.getChildren()) {
                        EObject ownObject;
                        bo = featureProvider.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                        if (!(bo instanceof InterfaceItem) || !extRefItems.contains(bo) || intRefItems.contains(ownObject = SupportUtil.getOwnObject((EObject)((InterfaceItem)bo), rs))) continue;
                        int origMidX = childShape.getGraphicsAlgorithm().getX();
                        int origMidY = childShape.getGraphicsAlgorithm().getY();
                        int x = (int)((double)origMidX / scaleX);
                        int y = (int)((double)origMidY / scaleY);
                        SupportUtil.addItem(ownObject, x += 30, y += 30, refShape, featureProvider);
                    }
                }
            } else assert (false) : "empty referenced structure class diagram";
        }
    }

    protected static void createInheritedRefItems(ActorContainerRef acr, ContainerShape arShape, IFeatureProvider fp) {
        ContainerShape refAcShape;
        Object bo;
        ActorClass ac = (ActorClass)acr.eContainer();
        ResourceSet rs = ac.eResource().getResourceSet();
        List<InterfaceItem> presentObjects = SupportUtil.getInterfaceItems(arShape, fp);
        Diagram refDiag = new DiagramAccess().getDiagram((StructureClass)ac);
        if (!refDiag.getChildren().isEmpty() && (bo = fp.getBusinessObjectForPictogramElement((PictogramElement)(refAcShape = (ContainerShape)refDiag.getChildren().get(0)))) instanceof ActorClass) {
            ActorClass extRefClass = (ActorClass)bo;
            assert (extRefClass.getName().equals(ac.getName())) : "actor class names must match";
            for (Shape childShape : refAcShape.getChildren()) {
                EObject ownObject;
                bo = fp.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                if (!(bo instanceof ActorRef) || (ownObject = SupportUtil.getOwnObject((EObject)((ActorRef)bo), rs)) != acr) continue;
                int subScaleX = arShape.getGraphicsAlgorithm().getWidth() / 120;
                int subScaleY = arShape.getGraphicsAlgorithm().getHeight() / 80;
                for (Shape grandChildShape : ((ContainerShape)childShape).getChildren()) {
                    bo = fp.getBusinessObjectForPictogramElement((PictogramElement)grandChildShape);
                    if (!(bo instanceof InterfaceItem) || presentObjects.contains(ownObject = SupportUtil.getOwnObject((EObject)((Port)bo), rs))) continue;
                    int x = 9 + grandChildShape.getGraphicsAlgorithm().getX() / subScaleX;
                    int y = 9 + grandChildShape.getGraphicsAlgorithm().getY() / subScaleY;
                    SupportUtil.addItem(ownObject, x, y, arShape, fp);
                }
            }
        }
    }

    protected static class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public Object getToolTip(GraphicsAlgorithm ga) {
            PictogramElement pe = ga.getPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            if (bo instanceof InterfaceItem) {
                InterfaceItem ifitem = (InterfaceItem)bo;
                String name = ifitem.getName();
                String protocol = RoomHelpers.getGeneralProtocol((InterfaceItem)ifitem).getName();
                if (ifitem instanceof Port) {
                    Port port = (Port)ifitem;
                    if (port.getMultiplicity() == -1) {
                        name = String.valueOf(name) + "[*]";
                    } else if (port.getMultiplicity() > 1) {
                        name = String.valueOf(name) + "[" + port.getMultiplicity() + "]";
                    }
                    if (port.isConjugated()) {
                        protocol = "conj " + protocol;
                    }
                }
                return String.valueOf(name) + "\n(" + protocol + ")";
            }
            return super.getToolTip(ga);
        }
    }

    protected static class FeatureProvider
    extends DefaultFeatureProvider {
        protected IFeatureProvider fp;

        protected FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        protected static boolean isRefItem(PictogramElement pe) {
            if (!(pe instanceof ContainerShape)) {
                return false;
            }
            ContainerShape acShape = ((ContainerShape)pe).getContainer();
            if (acShape.getLink() == null || acShape.getLink().getBusinessObjects().isEmpty()) {
                return false;
            }
            Object parent = acShape.getLink().getBusinessObjects().get(0);
            return parent instanceof ActorContainerRef;
        }

        protected static boolean isInternal(InterfaceItem item) {
            if (item instanceof Port) {
                ActorClass ac;
                Port port = (Port)item;
                ActorContainerClass acc = (ActorContainerClass)port.eContainer();
                if (acc instanceof ActorClass && (ac = (ActorClass)acc).getIntPorts().contains((Object)port)) {
                    return true;
                }
            } else {
                if (item instanceof SPPRef) {
                    return false;
                }
                assert (false) : "unexpected sub type";
            }
            return false;
        }

        protected static boolean isInherited(InterfaceItem item, Object container, ContainerShape cs) {
            if (container instanceof ActorClass) {
                ActorClass ac = (ActorClass)container;
                return item.eContainer() != ac;
            }
            if (container instanceof ActorRef) {
                ActorRef ar = (ActorRef)container;
                ContainerShape arCont = cs.getContainer();
                EObject cls = (EObject)arCont.getLink().getBusinessObjects().get(0);
                if (cls instanceof ActorClass) {
                    return ar.eContainer() != cls;
                }
                return false;
            }
            if (container instanceof SubSystemRef) {
                return false;
            }
            return false;
        }

        protected static boolean isValidPosition(ILocationContext loc, ITargetContext tgt, boolean internal, int margin) {
            if (tgt.getTargetContainer().getGraphicsAlgorithm() == null) {
                return false;
            }
            if (tgt.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().isEmpty()) {
                return false;
            }
            int x = loc.getX();
            int y = loc.getY();
            if (loc instanceof ICreateContext) {
                x -= margin;
                y -= margin;
            }
            int width = ((GraphicsAlgorithm)tgt.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
            int height = ((GraphicsAlgorithm)tgt.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getHeight();
            boolean inStripe = false;
            int stripe = margin / 2;
            if (x <= stripe) {
                inStripe = true;
            } else if (y <= stripe) {
                inStripe = true;
            } else if (width - stripe <= x) {
                inStripe = true;
            } else if (height - stripe <= y) {
                inStripe = true;
            }
            if (internal) {
                return !inStripe;
            }
            return inStripe;
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new NoResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        protected static void adjustLabel(Text label, int x, int y, int width, int margin, int size) {
            Orientation align = Orientation.ALIGNMENT_CENTER;
            label.setHorizontalAlignment(align);
            int pos = margin + size / 2;
            if (x <= margin) {
                align = Orientation.ALIGNMENT_LEFT;
            } else if (width - margin <= x) {
                align = Orientation.ALIGNMENT_RIGHT;
            }
            if (y <= margin) {
                pos = (margin - size) / 2;
            }
            if (align != label.getHorizontalAlignment()) {
                label.setHorizontalAlignment(align);
            }
            if (pos != label.getY()) {
                IGaService gaService = Graphiti.getGaService();
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, pos, 2 * margin, margin / 2);
            }
        }

        protected static abstract class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                if (context.getNewObject() instanceof InterfaceItem && context.getTargetContainer().getLink().getBusinessObjects().size() == 1) {
                    EObject obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                    if (obj instanceof ActorContainerClass) {
                        return true;
                    }
                    if (obj instanceof ActorContainerRef) {
                        return true;
                    }
                }
                return false;
            }

            public PictogramElement add(IAddContext context) {
                InterfaceItem port = (InterfaceItem)context.getNewObject();
                boolean internal = FeatureProvider.isInternal(port);
                ContainerShape acShape = context.getTargetContainer();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)acShape);
                boolean inherited = FeatureProvider.isInherited(port, bo, acShape);
                boolean refport = bo instanceof ActorContainerRef;
                int margin = refport ? 30 : 40;
                int size = refport ? 18 : 40;
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(acShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "port");
                String kind = this.getItemKind(port);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, InterfaceItemSupport.PROP_KIND, kind);
                int x = context.getX();
                int y = context.getY();
                int width = acShape.getGraphicsAlgorithm().getWidth();
                int height = acShape.getGraphicsAlgorithm().getHeight();
                if (internal) {
                    if (x < 2 * margin) {
                        x = 2 * margin;
                    } else if (x > width - 2 * margin) {
                        x = width - 2 * margin;
                    }
                    if (y < 2 * margin) {
                        y = 2 * margin;
                    } else if (y > height - 2 * margin) {
                        y = height - 2 * margin;
                    }
                } else {
                    int dy;
                    int dx = x <= width / 2 ? x : width - x;
                    int n = dy = y <= height / 2 ? y : height - y;
                    if (dx > dy) {
                        y = y <= height / 2 ? margin : height - margin;
                        if (x < margin) {
                            x = margin;
                        } else if (x > width - margin) {
                            x = width - margin;
                        }
                    } else {
                        x = x <= width / 2 ? margin : width - margin;
                        if (y < margin) {
                            y = margin;
                        } else if (y > height - margin) {
                            y = height - margin;
                        }
                    }
                }
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, x -= margin, y -= margin, 2 * margin, 2 * margin);
                this.createItemFigure(port, refport, containerShape, (GraphicsAlgorithm)invisibleRectangle, dark, this.manageColor(BRIGHT_COLOR));
                this.link((PictogramElement)containerShape, port);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, port.getName());
                label.setForeground(dark);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, margin + size / 2, 2 * margin, margin / 2);
                FeatureProvider.adjustLabel(label, x, y, width, margin, size);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }

            protected abstract String getItemKind(InterfaceItem var1);

            protected abstract void createItemFigure(InterfaceItem var1, boolean var2, ContainerShape var3, GraphicsAlgorithm var4, Color var5, Color var6);
        }

        protected static abstract class CreateFeature
        extends AbstractCreateFeature {
            protected boolean internal;
            protected boolean doneChanges = false;

            public CreateFeature(IFeatureProvider fp, boolean internal, String name, String description) {
                super(fp, name, description);
                this.internal = internal;
            }

            public boolean canCreate(ICreateContext context) {
                EObject obj;
                if (context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof ActorContainerClass) {
                    if (obj instanceof ActorClass) {
                        return FeatureProvider.isValidPosition((ILocationContext)context, (ITargetContext)context, this.internal, 40);
                    }
                    return !this.internal;
                }
                return false;
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                ContainerShape shape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                InterfaceItem item = (InterfaceItem)bo;
                Object parentBO = this.getBusinessObjectForPictogramElement((PictogramElement)shape.getContainer());
                return !FeatureProvider.isRefItem((PictogramElement)shape) && !FeatureProvider.isInherited(item, parentBO, shape);
            }
        }

        protected class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                boolean canMove = super.canMoveShape(context);
                if (canMove) {
                    Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                    if (bo instanceof InterfaceItem) {
                        InterfaceItem item = (InterfaceItem)bo;
                        ContainerShape acShape = context.getTargetContainer();
                        Object parentBO = this.getBusinessObjectForPictogramElement((PictogramElement)acShape);
                        boolean refport = parentBO instanceof ActorContainerRef;
                        if (refport) {
                            return true;
                        }
                        if (FeatureProvider.isInherited(item, parentBO, acShape)) {
                            return false;
                        }
                        int margin = refport ? 30 : 40;
                        return FeatureProvider.isValidPosition((ILocationContext)context, (ITargetContext)context, FeatureProvider.isInternal(item), margin);
                    }
                    return false;
                }
                return canMove;
            }

            protected void postMoveShape(IMoveShapeContext context) {
                ContainerShape shapeToMove = (ContainerShape)context.getShape();
                InterfaceItem item = (InterfaceItem)this.getBusinessObjectForPictogramElement((PictogramElement)shapeToMove);
                boolean internal = FeatureProvider.isInternal(item);
                ContainerShape acShape = context.getTargetContainer();
                boolean refport = this.getBusinessObjectForPictogramElement((PictogramElement)acShape) instanceof ActorContainerRef;
                int margin = refport ? 30 : 40;
                int size = refport ? 18 : 40;
                int x = context.getX();
                int y = context.getY();
                int width = ((GraphicsAlgorithm)context.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
                int height = ((GraphicsAlgorithm)context.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getHeight();
                if (!internal) {
                    if (refport) {
                        int dy;
                        int dx = x <= width / 2 ? x : width - x;
                        int n = dy = y <= height / 2 ? y : height - y;
                        if (dx > dy) {
                            y = y <= height / 2 ? 0 : height - 0;
                            if (x < 0) {
                                x = 0;
                            } else if (x > width - 0) {
                                x = width - 0;
                            }
                        } else {
                            x = x <= width / 2 ? 0 : width - 0;
                            if (y < 0) {
                                y = 0;
                            } else if (y > height - 0) {
                                y = height - 0;
                            }
                        }
                    } else {
                        if (x <= margin) {
                            x = 0;
                        }
                        if (y <= margin) {
                            y = 0;
                        }
                        if (width - margin <= x) {
                            x = width;
                        }
                        if (height - margin <= y) {
                            y = height;
                        }
                    }
                }
                Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
                GraphicsAlgorithm ga = ((Shape)shapeToMove.getChildren().get(0)).getGraphicsAlgorithm();
                if (ga instanceof Text) {
                    FeatureProvider.adjustLabel((Text)ga, x, y, width, margin, size);
                }
            }
        }

        protected static abstract class PropertyFeature
        extends AbstractCustomFeature {
            private String name;
            private String description;

            public PropertyFeature(IFeatureProvider fp, String name, String description) {
                super(fp);
                this.name = name;
                this.description = description;
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof InterfaceItem) {
                    ContainerShape shape = ((ContainerShape)pes[0]).getContainer();
                    InterfaceItem item = (InterfaceItem)bo;
                    Object parentBO = this.getBusinessObjectForPictogramElement((PictogramElement)shape.getContainer());
                    return !FeatureProvider.isRefItem((PictogramElement)shape) && !FeatureProvider.isInherited(item, parentBO, shape);
                }
                return false;
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        protected abstract class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof InterfaceItem;
            }

            public IReason updateNeeded(IUpdateContext context) {
                GraphicsAlgorithm ga;
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"InterfaceItem deleted from model");
                }
                InterfaceItem port = (InterfaceItem)bo;
                String reason = "";
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof ActorClass) {
                    ActorClass ac = (ActorClass)bo;
                    boolean found = false;
                    do {
                        if (ac == port.eContainer()) {
                            found = true;
                        }
                        ac = ac.getBase();
                    } while (!found && ac != null);
                    if (!found) {
                        reason = String.valueOf(reason) + "InterfaceItem not inherited anymore\n";
                    }
                }
                if ((ga = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm()) instanceof Text) {
                    String kind;
                    if (!port.getName().equals(((Text)ga).getValue())) {
                        reason = String.valueOf(reason) + "Name is out of date\n";
                    }
                    if (!(kind = this.getItemKind(port)).equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)context.getPictogramElement(), InterfaceItemSupport.PROP_KIND))) {
                        reason = String.valueOf(reason) + "Figure is out of date\n";
                    }
                }
                if (!reason.isEmpty()) {
                    return Reason.createTrueReason((String)reason.substring(0, reason.length() - 1));
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                InterfaceItem port = (InterfaceItem)bo;
                boolean inherited = FeatureProvider.isInherited(port, bo, containerShape);
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                this.updateFigure(port, (PictogramElement)containerShape, dark, this.manageColor(BRIGHT_COLOR));
                String kind = this.getItemKind(port);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, InterfaceItemSupport.PROP_KIND, kind);
                return true;
            }

            protected abstract String getItemKind(InterfaceItem var1);

            protected abstract void updateFigure(InterfaceItem var1, PictogramElement var2, Color var3, Color var4);
        }
    }
}

