/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.ManhattanConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class LayerConnectionSupport {
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final int LINE_WIDTH = 2;
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public LayerConnectionSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }
    }

    class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        private boolean isInherited(Diagram diag, LayerConnection lc) {
            ActorContainerClass acc = (ActorContainerClass)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag.getChildren().get(0));
            return lc.eContainer() != acc;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context instanceof IAddConnectionContext && context.getNewObject() instanceof LayerConnection;
            }

            public PictogramElement add(IAddContext context) {
                IAddConnectionContext addConContext = (IAddConnectionContext)context;
                LayerConnection lc = (LayerConnection)context.getNewObject();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                Connection connection = this.createConnection();
                connection.setStart(addConContext.getSourceAnchor());
                connection.setEnd(addConContext.getTargetAnchor());
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "conn");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                polyline.setForeground(this.manageColor(LINE_COLOR));
                polyline.setLineWidth(Integer.valueOf(2));
                ConnectionDecorator cd = peCreateService.createConnectionDecorator(connection, false, 1.0, true);
                this.createArrow((GraphicsAlgorithmContainer)cd);
                this.link((PictogramElement)connection, lc);
                return connection;
            }

            private Connection createConnection() {
                ManhattanConnection ret = PictogramsFactory.eINSTANCE.createManhattanConnection();
                ret.setVisible(true);
                ret.setActive(true);
                ret.setParent(this.getDiagram());
                return ret;
            }

            private Polyline createArrow(GraphicsAlgorithmContainer gaContainer) {
                IGaService gaService = Graphiti.getGaService();
                int[] nArray = new int[6];
                nArray[0] = -15;
                nArray[1] = 10;
                nArray[4] = -15;
                nArray[5] = -10;
                Polyline polyline = gaService.createPolyline(gaContainer, nArray);
                polyline.setForeground(this.manageColor(LINE_COLOR));
                polyline.setLineWidth(Integer.valueOf(2));
                return polyline;
            }
        }

        private class CreateFeature
        extends AbstractCreateConnectionFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, "LayerConnection", "create LayerConnection");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.layer_connection";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPPRef src = SupportUtil.getSPPRef(context.getSourceAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                SPPRef tgt = SupportUtil.getSPPRef(context.getTargetAnchor(), featureProvider);
                ActorContainerRef tgtRef = SupportUtil.getRef(context.getTargetAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getParent(context, featureProvider);
                return ValidationUtil.isConnectable((SPPRef)src, (ActorContainerRef)srcRef, (SPPRef)tgt, (ActorContainerRef)tgtRef, (StructureClass)sc).isOk();
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPPRef src = SupportUtil.getSPPRef(context.getSourceAnchor(), featureProvider);
                ActorContainerRef ref = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getParent(context, featureProvider);
                return ValidationUtil.isConnectableSrc((SPPRef)src, (ActorContainerRef)ref, (StructureClass)sc);
            }

            public Connection create(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPPRef src = SupportUtil.getSPPRef(context.getSourceAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                SPPRef dst = SupportUtil.getSPPRef(context.getTargetAnchor(), featureProvider);
                ActorContainerRef dstRef = SupportUtil.getRef(context.getTargetAnchor(), featureProvider);
                StructureClass sc = SupportUtil.getParent(context, featureProvider);
                LayerConnection lc = RoomFactory.eINSTANCE.createLayerConnection();
                RelaySAPoint sapt = null;
                if (src != null) {
                    sapt = RoomFactory.eINSTANCE.createRelaySAPoint();
                    sapt.setRelay(src);
                } else if (srcRef != null) {
                    sapt = RoomFactory.eINSTANCE.createRefSAPoint();
                    ((RefSAPoint)sapt).setRef(srcRef);
                }
                lc.setFrom((SAPoint)sapt);
                SPPoint sppt = RoomFactory.eINSTANCE.createSPPoint();
                sppt.setRef(dstRef);
                sppt.setService(dst);
                lc.setTo(sppt);
                sc.getConnections().add((Object)lc);
                AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                addContext.setNewObject((Object)lc);
                return (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getPictogramElement());
                if (bo instanceof LayerConnection) {
                    LayerConnection lc = (LayerConnection)bo;
                    if (FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                        return false;
                    }
                }
                return true;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                LayerConnection lc = (LayerConnection)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                if (FeatureProvider.this.isInherited(this.getDiagram(), lc)) {
                    return false;
                }
                Anchor asrc = context.getConnection().getStart();
                Anchor atgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    asrc = context.getNewAnchor();
                } else {
                    atgt = context.getNewAnchor();
                }
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPPRef src = SupportUtil.getSPPRef(asrc, featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(asrc, featureProvider);
                SPPRef tgt = SupportUtil.getSPPRef(atgt, featureProvider);
                ActorContainerRef tgtRef = SupportUtil.getRef(atgt, featureProvider);
                StructureClass sc = SupportUtil.getParent((ContainerShape)this.getDiagram(), featureProvider);
                return ValidationUtil.isConnectable((SPPRef)src, (ActorContainerRef)srcRef, (SPPRef)tgt, (ActorContainerRef)tgtRef, (StructureClass)sc).isOk();
            }

            public void postReconnect(IReconnectionContext context) {
                super.postReconnect(context);
                IFeatureProvider featureProvider = this.getFeatureProvider();
                SPPRef src = SupportUtil.getSPPRef(context.getConnection().getStart(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(context.getConnection().getStart(), featureProvider);
                SPPRef dst = SupportUtil.getSPPRef(context.getConnection().getEnd(), featureProvider);
                ActorContainerRef dstRef = SupportUtil.getRef(context.getConnection().getEnd(), featureProvider);
                this.doneChanges = true;
                LayerConnection lc = (LayerConnection)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                RelaySAPoint sapt = null;
                if (src != null) {
                    sapt = RoomFactory.eINSTANCE.createRelaySAPoint();
                    sapt.setRelay(src);
                } else if (srcRef != null) {
                    sapt = RoomFactory.eINSTANCE.createRefSAPoint();
                    ((RefSAPoint)sapt).setRef(srcRef);
                }
                lc.setFrom((SAPoint)sapt);
                SPPoint sppt = RoomFactory.eINSTANCE.createSPPoint();
                sppt.setRef(dstRef);
                sppt.setService(dst);
                lc.setTo(sppt);
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                return bo instanceof EObject && ((EObject)bo).eIsProxy();
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"LayerConnection deleted from model");
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                PictogramElement pe = context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext(pe);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                return false;
            }
        }
    }
}

