/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class SupportUtil {
    public static final String SEP = "#";

    public static EObject getOwnObject(EObject obj, ResourceSet rs) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        EObject own = rs.getEObject(uri, true);
        assert (own != null) : "own object must exist";
        return own;
    }

    public static ContainerShape addItem(EObject obj, int x, int y, ContainerShape container, IFeatureProvider fp) {
        return SupportUtil.addItem(obj, x, y, container, null, fp);
    }

    public static ContainerShape addItem(EObject obj, int x, int y, ContainerShape container, Map<String, Anchor> ifitem2anchor, IFeatureProvider fp) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)obj);
        addContext.setTargetContainer(container);
        addContext.setX(x);
        addContext.setY(y);
        ContainerShape newShape = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (newShape != null) : "shape creation must succeed";
        if (ifitem2anchor != null) {
            if (obj instanceof ActorContainerRef) {
                SupportUtil.getAnchors((ActorContainerRef)obj, (PictogramElement)newShape, ifitem2anchor);
            } else if (obj instanceof InterfaceItem) {
                assert (!newShape.getAnchors().isEmpty()) : "interface item must have an anchor";
                ifitem2anchor.put(SEP + ((InterfaceItem)obj).getName(), (Anchor)newShape.getAnchors().get(0));
            }
        }
        return newShape;
    }

    public static void getAnchors(ActorContainerRef acr, PictogramElement refShape, Map<String, Anchor> ifitem2anchor) {
        if (refShape instanceof ContainerShape) {
            ifitem2anchor.put(String.valueOf(acr.getName()) + SEP, (Anchor)((ContainerShape)refShape).getAnchors().get(0));
            for (Shape child : ((ContainerShape)refShape).getChildren()) {
                ContainerShape childShape;
                if (!(child instanceof ContainerShape) || (childShape = (ContainerShape)child).getAnchors().isEmpty() || childShape.getLink().getBusinessObjects().isEmpty()) continue;
                EObject obj = (EObject)childShape.getLink().getBusinessObjects().get(0);
                if (obj instanceof Port) {
                    ifitem2anchor.put(String.valueOf(acr.getName()) + SEP + ((Port)obj).getName(), (Anchor)childShape.getAnchors().get(0));
                }
                if (!(obj instanceof SPPRef)) continue;
                ifitem2anchor.put(String.valueOf(acr.getName()) + SEP + ((SPPRef)obj).getName(), (Anchor)childShape.getAnchors().get(0));
            }
        }
    }

    public static void addRefItem(ActorContainerRef obj, ContainerShape acShape, int x, int y, IFeatureProvider featureProvider, Map<String, Anchor> ifitem2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)obj);
        addContext.setTargetContainer(acShape);
        addContext.setX(x);
        addContext.setY(y);
        ContainerShape refShape = (ContainerShape)featureProvider.addIfPossible((IAddContext)addContext);
        SupportUtil.getAnchors(obj, (PictogramElement)refShape, ifitem2anchor);
    }

    public static void addInterfaceItem(InterfaceItem item, ContainerShape acShape, int x, int y, IFeatureProvider featureProvider, Map<String, Anchor> ifitem2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)item);
        addContext.setTargetContainer(acShape);
        addContext.setX(x);
        addContext.setY(y);
        ContainerShape pe = (ContainerShape)featureProvider.addIfPossible((IAddContext)addContext);
        assert (!pe.getAnchors().isEmpty()) : "interface item should have an anchor";
        ifitem2anchor.put(SEP + item.getName(), (Anchor)pe.getAnchors().get(0));
    }

    public static void addBinding(Binding bind, IFeatureProvider featureProvider, Map<String, Anchor> ifitem2anchor) {
        String ep1 = SupportUtil.getName(bind.getEndpoint1());
        String ep2 = SupportUtil.getName(bind.getEndpoint2());
        Anchor a1 = ifitem2anchor.get(ep1);
        Anchor a2 = ifitem2anchor.get(ep2);
        assert (a1 != null && a2 != null) : "ports for binding must be present";
        AddConnectionContext context = new AddConnectionContext(a1, a2);
        context.setNewObject((Object)bind);
        featureProvider.addIfPossible((IAddContext)context);
    }

    public static void addLayerConnection(LayerConnection lc, IFeatureProvider featureProvider, Map<String, Anchor> ifitem2anchor) {
        String ep1 = SupportUtil.getName(lc.getFrom());
        String ep2 = SupportUtil.getName(lc.getTo());
        Anchor a1 = ifitem2anchor.get(ep1);
        Anchor a2 = ifitem2anchor.get(ep2);
        assert (a1 != null && a2 != null) : "spps for layer connection must be present";
        AddConnectionContext context = new AddConnectionContext(a1, a2);
        context.setNewObject((Object)lc);
        featureProvider.addIfPossible((IAddContext)context);
    }

    public static void addInterfaceItems(List<? extends InterfaceItem> items, int y, ContainerShape acShape, int width, IFeatureProvider fp, Map<String, Anchor> ifitem2anchor) {
        int delta;
        int n = items.size();
        int pos = delta = width / (n + 1);
        for (InterfaceItem interfaceItem : items) {
            SupportUtil.addInterfaceItem(interfaceItem, acShape, pos + 40, y, fp, ifitem2anchor);
            pos += delta;
        }
    }

    public static void addRefItems(List<? extends ActorContainerRef> actorRefs, ContainerShape acShape, int width, IFeatureProvider fp, Map<String, Anchor> ifitem2anchor) {
        int ncols = width / 120;
        int nrows = actorRefs.size() / ncols;
        int gap = (width - ncols * 120) / (ncols + 1);
        int delta = gap + 120;
        int x0 = gap + 60;
        int y0 = 200;
        int i = 0;
        for (ActorContainerRef actorContainerRef : actorRefs) {
            int row = i / ncols;
            int col = i % ncols;
            if (row >= nrows) {
                int nc = actorRefs.size() % ncols;
                gap = (width - nc * 120) / (nc + 1);
                delta = gap + 120;
                x0 = gap + 60;
            }
            int x = x0 + delta * col;
            int y = y0 + 110 * row;
            SupportUtil.addRefItem(actorContainerRef, acShape, x + 40, y + 40, fp, ifitem2anchor);
            ++i;
        }
    }

    public static String getName(BindingEndPoint ep) {
        String ar = ep.getActorRef() == null ? "" : ep.getActorRef().getName();
        String p = ep.getPort().getName();
        return String.valueOf(ar) + SEP + p;
    }

    public static String getName(SAPoint sapt) {
        if (sapt instanceof RelaySAPoint) {
            return SEP + ((RelaySAPoint)sapt).getRelay().getName();
        }
        if (sapt instanceof RefSAPoint) {
            RefSAPoint rpt = (RefSAPoint)sapt;
            return String.valueOf(rpt.getRef().getName()) + SEP;
        }
        assert (false) : "unexpected sub type";
        return null;
    }

    public static String getName(SPPoint sppt) {
        return String.valueOf(sppt.getRef().getName()) + SEP + sppt.getService().getName();
    }

    public static List<InterfaceItem> getInterfaceItems(ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getInterfaceItems(shape, fp, null);
    }

    public static List<InterfaceItem> getInterfaceItems(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> ifitem2anchor) {
        ArrayList<InterfaceItem> items = new ArrayList<InterfaceItem>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof InterfaceItem)) continue;
            items.add((InterfaceItem)bo);
            if (ifitem2anchor == null) continue;
            ifitem2anchor.put(SEP + ((InterfaceItem)bo).getName(), (Anchor)ch.getAnchors().get(0));
        }
        return items;
    }

    public static List<ActorContainerRef> getRefs(ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getRefs(shape, fp, null);
    }

    public static List<ActorContainerRef> getRefs(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> ifitem2anchor) {
        ArrayList<ActorContainerRef> refs = new ArrayList<ActorContainerRef>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof ActorContainerRef)) continue;
            refs.add((ActorContainerRef)bo);
            if (ifitem2anchor == null) continue;
            SupportUtil.getAnchors((ActorContainerRef)bo, (PictogramElement)ch, ifitem2anchor);
        }
        return refs;
    }

    public static List<Binding> getBindings(Diagram diag, IFeatureProvider fp) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Connection conn : diag.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof Binding)) continue;
            bindings.add((Binding)bo);
        }
        return bindings;
    }

    public static List<LayerConnection> getConnections(Diagram diag, IFeatureProvider fp) {
        ArrayList<LayerConnection> bindings = new ArrayList<LayerConnection>();
        for (Connection conn : diag.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof LayerConnection)) continue;
            bindings.add((LayerConnection)bo);
        }
        return bindings;
    }

    public static StructureClass getParent(ICreateConnectionContext context, IFeatureProvider fp) {
        ContainerShape shape = (ContainerShape)context.getSourcePictogramElement().eContainer();
        return SupportUtil.getParent(shape, fp);
    }

    public static StructureClass getParent(ContainerShape shape, IFeatureProvider fp) {
        Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof StructureClass) {
            return (StructureClass)bo;
        }
        bo = fp.getBusinessObjectForPictogramElement((PictogramElement)(shape = (ContainerShape)shape.eContainer()));
        if (bo instanceof StructureClass) {
            return (StructureClass)bo;
        }
        return null;
    }

    public static Port getPort(Anchor anchor, IFeatureProvider fp) {
        Object obj;
        if (anchor != null && (obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof Port) {
            return (Port)obj;
        }
        return null;
    }

    public static SPPRef getSPPRef(Anchor anchor, IFeatureProvider fp) {
        Object obj;
        if (anchor != null && (obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof SPPRef) {
            return (SPPRef)obj;
        }
        return null;
    }

    public static ActorContainerRef getRef(Anchor anchor, IFeatureProvider fp) {
        if (anchor != null) {
            ContainerShape shape = (ContainerShape)anchor.getParent().eContainer();
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
            if (bo instanceof ActorContainerRef) {
                return (ActorContainerRef)bo;
            }
            shape = (ContainerShape)anchor.getParent();
            bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
            if (bo instanceof ActorContainerRef) {
                return (ActorContainerRef)bo;
            }
        }
        return null;
    }
}

