/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.base.util.RelativePathHelpers;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class DocGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CodegenHelpers _codegenHelpers;
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    private ILogger logger;
    private final String IMGDIR_DEFAULT = "./images";
    private final String IMGWIDTH_DEFAULT = "1.0\\textwidth";

    public void doGenerate(final Root root) {
        EList _models = root.getModels();
        for (RoomModel model : _models) {
            final DocGenContext ctx = new DocGenContext(root, model);
            String path = this.roomExt.getDocGenerationTargetPath((EObject)model);
            String _name = model.getName();
            String file = String.valueOf(_name) + ".tex";
            final HashSet referencedModels = CollectionLiterals.newHashSet((Object[])new RoomModel[0]);
            this.logger.logInfo("generating LaTeX documentation: '" + file + "' in '" + path + "'");
            String _name_1 = model.getName();
            String _plus = String.valueOf(path) + _name_1;
            this.fileAccess.setOutputPath(_plus);
            EList _systems = model.getSystems();
            Procedures.Procedure1<LogicalSystem> _function = new Procedures.Procedure1<LogicalSystem>(){

                public void apply(LogicalSystem it) {
                    CharSequence _generateDoc = DocGen.this.generateDoc((RoomClass)it, ctx);
                    String _docFragmentName = DocGen.this.docFragmentName((RoomClass)it);
                    DocGen.this.saveAs(_generateDoc, _docFragmentName);
                }
            };
            IterableExtensions.forEach((Iterable)_systems, (Procedures.Procedure1)_function);
            EList _systems_1 = model.getSystems();
            Procedures.Procedure1<LogicalSystem> _function_1 = new Procedures.Procedure1<LogicalSystem>(){

                public void apply(LogicalSystem it) {
                    EList _referencedModels = root.getReferencedModels((RoomClass)it);
                    referencedModels.addAll(_referencedModels);
                }
            };
            IterableExtensions.forEach((Iterable)_systems_1, (Procedures.Procedure1)_function_1);
            EList _subSystemClasses = model.getSubSystemClasses();
            Procedures.Procedure1<SubSystemClass> _function_2 = new Procedures.Procedure1<SubSystemClass>(){

                public void apply(SubSystemClass it) {
                    CharSequence _generateDoc = DocGen.this.generateDoc((RoomClass)it, ctx);
                    String _docFragmentName = DocGen.this.docFragmentName((RoomClass)it);
                    DocGen.this.saveAs(_generateDoc, _docFragmentName);
                }
            };
            IterableExtensions.forEach((Iterable)_subSystemClasses, (Procedures.Procedure1)_function_2);
            EList _subSystemClasses_1 = model.getSubSystemClasses();
            Procedures.Procedure1<SubSystemClass> _function_3 = new Procedures.Procedure1<SubSystemClass>(){

                public void apply(SubSystemClass it) {
                    EList _referencedModels = root.getReferencedModels((RoomClass)it);
                    referencedModels.addAll(_referencedModels);
                }
            };
            IterableExtensions.forEach((Iterable)_subSystemClasses_1, (Procedures.Procedure1)_function_3);
            EList _protocolClasses = model.getProtocolClasses();
            Procedures.Procedure1<GeneralProtocolClass> _function_4 = new Procedures.Procedure1<GeneralProtocolClass>(){

                public void apply(GeneralProtocolClass it) {
                    CharSequence _generateDoc = DocGen.this.generateDoc((RoomClass)it, ctx);
                    String _docFragmentName = DocGen.this.docFragmentName((RoomClass)it);
                    DocGen.this.saveAs(_generateDoc, _docFragmentName);
                }
            };
            IterableExtensions.forEach((Iterable)_protocolClasses, (Procedures.Procedure1)_function_4);
            EList _protocolClasses_1 = model.getProtocolClasses();
            Procedures.Procedure1<GeneralProtocolClass> _function_5 = new Procedures.Procedure1<GeneralProtocolClass>(){

                public void apply(GeneralProtocolClass it) {
                    EList _referencedModels = root.getReferencedModels((RoomClass)it);
                    referencedModels.addAll(_referencedModels);
                }
            };
            IterableExtensions.forEach((Iterable)_protocolClasses_1, (Procedures.Procedure1)_function_5);
            EList _enumerationTypes = model.getEnumerationTypes();
            Procedures.Procedure1<EnumerationType> _function_6 = new Procedures.Procedure1<EnumerationType>(){

                public void apply(EnumerationType it) {
                    CharSequence _generateDoc = DocGen.this.generateDoc((RoomClass)it, ctx);
                    String _docFragmentName = DocGen.this.docFragmentName((RoomClass)it);
                    DocGen.this.saveAs(_generateDoc, _docFragmentName);
                }
            };
            IterableExtensions.forEach((Iterable)_enumerationTypes, (Procedures.Procedure1)_function_6);
            EList _enumerationTypes_1 = model.getEnumerationTypes();
            Procedures.Procedure1<EnumerationType> _function_7 = new Procedures.Procedure1<EnumerationType>(){

                public void apply(EnumerationType it) {
                    EList _referencedModels = root.getReferencedModels((RoomClass)it);
                    referencedModels.addAll(_referencedModels);
                }
            };
            IterableExtensions.forEach((Iterable)_enumerationTypes_1, (Procedures.Procedure1)_function_7);
            EList _dataClasses = model.getDataClasses();
            Procedures.Procedure1<DataClass> _function_8 = new Procedures.Procedure1<DataClass>(){

                public void apply(DataClass it) {
                    CharSequence _generateDoc = DocGen.this.generateDoc((RoomClass)it, ctx);
                    String _docFragmentName = DocGen.this.docFragmentName((RoomClass)it);
                    DocGen.this.saveAs(_generateDoc, _docFragmentName);
                }
            };
            IterableExtensions.forEach((Iterable)_dataClasses, (Procedures.Procedure1)_function_8);
            EList _dataClasses_1 = model.getDataClasses();
            Procedures.Procedure1<DataClass> _function_9 = new Procedures.Procedure1<DataClass>(){

                public void apply(DataClass it) {
                    EList _referencedModels = root.getReferencedModels((RoomClass)it);
                    referencedModels.addAll(_referencedModels);
                }
            };
            IterableExtensions.forEach((Iterable)_dataClasses_1, (Procedures.Procedure1)_function_9);
            EList _actorClasses = model.getActorClasses();
            Procedures.Procedure1<ActorClass> _function_10 = new Procedures.Procedure1<ActorClass>(){

                public void apply(ActorClass it) {
                    CharSequence _generateDoc = DocGen.this.generateDoc((RoomClass)it, ctx);
                    String _docFragmentName = DocGen.this.docFragmentName((RoomClass)it);
                    DocGen.this.saveAs(_generateDoc, _docFragmentName);
                }
            };
            IterableExtensions.forEach((Iterable)_actorClasses, (Procedures.Procedure1)_function_10);
            EList _actorClasses_1 = model.getActorClasses();
            Procedures.Procedure1<ActorClass> _function_11 = new Procedures.Procedure1<ActorClass>(){

                public void apply(ActorClass it) {
                    EList _referencedModels = root.getReferencedModels((RoomClass)it);
                    referencedModels.addAll(_referencedModels);
                }
            };
            IterableExtensions.forEach((Iterable)_actorClasses_1, (Procedures.Procedure1)_function_11);
            this.fileAccess.setOutputPath(path);
            CharSequence _generateModelDoc = this.generateModelDoc(ctx, referencedModels);
            this.saveAs(_generateModelDoc, file);
        }
    }

    private String removeLast(String str) {
        int _length = str.length();
        int _minus = _length - 1;
        return str.substring(0, _minus);
    }

    private String appendIfNotEmpty(String txt, String suffix) {
        String _xifexpression = null;
        boolean _isEmpty = txt.isEmpty();
        _xifexpression = _isEmpty ? txt : String.valueOf(txt) + suffix;
        return _xifexpression;
    }

    private CharSequence generateModelDoc(DocGenContext ctx, Set<RoomModel> referencedModels) {
        boolean _not_6;
        boolean _not_5;
        boolean _not_4;
        boolean _not_3;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        RoomModel model = ctx.model;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\documentclass[titlepage]{article}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{import}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{graphicx}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{xr}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{hyperref}");
        _builder.newLine();
        _builder.append((Object)"\\IfFileExists{../doc/userinputs.tex}{\\subimport{../doc/}{userinputs.tex}}{} %hook for conditional user-specific inputs, includes, macros, ... ");
        _builder.newLine();
        _builder.append((Object)"\\usepackage[a4paper,text={160mm,255mm},centering,headsep=5mm,footskip=10mm]{geometry}");
        _builder.newLine();
        _builder.append((Object)"\\usepackage{nonfloat}");
        _builder.newLine();
        _builder.append((Object)"\\parindent 0pt");
        _builder.newLine();
        _builder.append((Object)"\\makeatletter");
        _builder.newLine();
        _builder.append((Object)"\\newcommand\\level[1]{%");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\ifcase#1\\relax\\expandafter\\chapter\\or");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\expandafter\\section\\or");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\expandafter\\subsection\\or");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\expandafter\\subsubsection\\else");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\def\\next{\\@level{#1}}\\expandafter\\next");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\fi}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\newcommand{\\@level}[1]{%");
        _builder.newLine();
        _builder.append((Object)"\\@startsection{level#1}");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{#1}");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{\\z@}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{-3.25ex\\@plus -1ex \\@minus -.2ex}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{1.5ex \\@plus .2ex}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"{\\normalfont\\normalsize\\bfseries}}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\newdimen\\@leveldim");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\newdimen\\@dotsdim");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"{\\normalfont\\normalsize");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"\\sbox\\z@{0}\\global\\@leveldim=\\wd\\z@");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"\\sbox\\z@{.}\\global\\@dotsdim=\\wd\\z@");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"}  ");
        _builder.newLine();
        _builder.append((Object)"\\newcounter{level4}[subsubsection]");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\@namedef{thelevel4}{\\thesubsubsection.\\arabic{level4}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\@namedef{level4mark}#1{}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\l@section{\\@dottedtocline{1}{0pt}{\\dimexpr\\@leveldim*4+\\@dotsdim*1+6pt\\relax}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\l@subsection{\\@dottedtocline{2}{0pt}{\\dimexpr\\@leveldim*5+\\@dotsdim*2+6pt\\relax}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\l@subsubsection{\\@dottedtocline{3}{0pt}{\\dimexpr\\@leveldim*6+\\@dotsdim*3+6pt\\relax}}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\@namedef{l@level4}{\\@dottedtocline{4}{0pt}{\\dimexpr\\@leveldim*7+\\@dotsdim*4+6pt\\relax}}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\count@=4");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\def\\@ncp#1{\\number\\numexpr\\count@+#1\\relax}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\loop\\ifnum\\count@<100");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\begingroup\\edef\\x{\\endgroup");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\newcounter{level\\@ncp{1}}[level\\number\\count@]");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\@namedef{thelevel\\@ncp{1}}{%");
        _builder.newLine();
        _builder.append((Object)"       ");
        _builder.append((Object)"\\noexpand\\@nameuse{thelevel\\@ncp{0}}.\\noexpand\\arabic{level\\@ncp{0}}}");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\@namedef{level\\@ncp{1}mark}####1{}%");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"\\noexpand\\@namedef{l@level\\@ncp{1}}%");
        _builder.newLine();
        _builder.append((Object)"       ");
        _builder.append((Object)"{\\noexpand\\@dottedtocline{\\@ncp{1}}{0pt}{\\the\\dimexpr\\@leveldim*\\@ncp{5}+\\@dotsdim*\\@ncp{0}\\relax}}}%");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\x");
        _builder.newLine();
        _builder.append((Object)"   ");
        _builder.append((Object)"\\advance\\count@\\@ne");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\repeat");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\makeatother");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\setcounter{secnumdepth}{100}");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"\\setcounter{tocdepth}{100}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\title{");
        String _name = model.getName();
        String _escapedString = this.escapedString(_name);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)" Model Documentation}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\date{\\today}");
        _builder.newLine();
        _builder.append((Object)"\\author{generated by eTrice}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\begin{document}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\pagestyle{plain}");
        _builder.newLine();
        _builder.append((Object)"\\maketitle");
        _builder.newLine();
        _builder.append((Object)"\\tableofcontents");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\newpage");
        _builder.newLine();
        _builder.append((Object)"\\listoffigures");
        _builder.newLine();
        _builder.append((Object)"\\newpage");
        _builder.newLine();
        _builder.append((Object)"\\section{Model Description}");
        _builder.newLine();
        _builder.newLine();
        boolean _isEmpty = referencedModels.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\\section{Referenced Models}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\\begin{itemize}");
            _builder.newLine();
            Functions.Function1<RoomModel, String> _function = new Functions.Function1<RoomModel, String>(){

                public String apply(RoomModel it) {
                    return it.getName();
                }
            };
            List _sortBy = IterableExtensions.sortBy(referencedModels, (Functions.Function1)_function);
            for (RoomModel refModel : _sortBy) {
                String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
                String _removeLast = this.removeLast(_docGenerationTargetPath);
                String _docGenerationTargetPath_1 = this.roomExt.getDocGenerationTargetPath((EObject)refModel);
                String _removeLast_1 = this.removeLast(_docGenerationTargetPath_1);
                String _relativePath = RelativePathHelpers.getRelativePath((String)_removeLast, (String)_removeLast_1, (boolean)true);
                String relPath = this.appendIfNotEmpty(_relativePath, "/");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\\item \\href{");
                String _replace = relPath.replace("\\", "/");
                String _name_1 = refModel.getName();
                String _plus = String.valueOf(_replace) + _name_1;
                String _escapedString_1 = this.escapedString(_plus);
                _builder.append((Object)_escapedString_1, "");
                _builder.append((Object)".pdf}{");
                String _name_2 = refModel.getName();
                String _escapedString_2 = this.escapedString(_name_2);
                _builder.append((Object)_escapedString_2, "");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\end{itemize}");
            _builder.newLine();
            _builder.append((Object)"\\newpage");
            _builder.newLine();
        }
        _builder.newLine();
        EList _systems = model.getSystems();
        boolean _isEmpty_1 = _systems.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append((Object)"\\section{Logical System Classes}");
            _builder.newLine();
            EList _systems_1 = model.getSystems();
            for (LogicalSystem s : _systems_1) {
                String _name_3 = model.getName();
                CharSequence _generateImport = this.generateImport((RoomClass)s, _name_3);
                _builder.append((Object)_generateImport, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\newpage");
            _builder.newLine();
        }
        _builder.newLine();
        EList _subSystemClasses = model.getSubSystemClasses();
        boolean _isEmpty_2 = _subSystemClasses.isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append((Object)"\\section{Subsystem Classes}");
            _builder.newLine();
            EList _subSystemClasses_1 = model.getSubSystemClasses();
            for (SubSystemClass s_1 : _subSystemClasses_1) {
                String _name_4 = model.getName();
                CharSequence _generateImport_1 = this.generateImport((RoomClass)s_1, _name_4);
                _builder.append((Object)_generateImport_1, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\newpage");
            _builder.newLine();
        }
        _builder.newLine();
        EList _protocolClasses = model.getProtocolClasses();
        boolean _isEmpty_3 = _protocolClasses.isEmpty();
        boolean bl4 = _not_3 = !_isEmpty_3;
        if (_not_3) {
            _builder.append((Object)"\\section{Protocol Classes}");
            _builder.newLine();
            EList _protocolClasses_1 = model.getProtocolClasses();
            for (GeneralProtocolClass c : _protocolClasses_1) {
                String _name_5 = model.getName();
                CharSequence _generateImport_2 = this.generateImport((RoomClass)c, _name_5);
                _builder.append((Object)_generateImport_2, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\newpage");
            _builder.newLine();
        }
        _builder.newLine();
        EList _enumerationTypes = model.getEnumerationTypes();
        boolean _isEmpty_4 = _enumerationTypes.isEmpty();
        boolean bl5 = _not_4 = !_isEmpty_4;
        if (_not_4) {
            _builder.append((Object)"\\section{Enumeration Types}");
            _builder.newLine();
            EList _enumerationTypes_1 = model.getEnumerationTypes();
            for (EnumerationType e : _enumerationTypes_1) {
                String _name_6 = model.getName();
                CharSequence _generateImport_3 = this.generateImport((RoomClass)e, _name_6);
                _builder.append((Object)_generateImport_3, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\newpage");
            _builder.newLine();
        }
        _builder.newLine();
        EList _dataClasses = model.getDataClasses();
        boolean _isEmpty_5 = _dataClasses.isEmpty();
        boolean bl6 = _not_5 = !_isEmpty_5;
        if (_not_5) {
            _builder.append((Object)"\\section{Data Classes}");
            _builder.newLine();
            EList _dataClasses_1 = model.getDataClasses();
            for (DataClass c_1 : _dataClasses_1) {
                String _name_7 = model.getName();
                CharSequence _generateImport_4 = this.generateImport((RoomClass)c_1, _name_7);
                _builder.append((Object)_generateImport_4, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\newpage");
            _builder.newLine();
        }
        _builder.newLine();
        EList _actorClasses = model.getActorClasses();
        boolean _isEmpty_6 = _actorClasses.isEmpty();
        boolean bl7 = _not_6 = !_isEmpty_6;
        if (_not_6) {
            _builder.append((Object)"\\section{Actor Classes}");
            _builder.newLine();
            EList _actorClasses_1 = model.getActorClasses();
            for (ActorClass c_2 : _actorClasses_1) {
                String _name_8 = model.getName();
                CharSequence _generateImport_5 = this.generateImport((RoomClass)c_2, _name_8);
                _builder.append((Object)_generateImport_5, "");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\\end{document}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence _generateDoc(LogicalSystem system, DocGenContext ctx) {
        StringConcatenation _xblockexpression = null;
        String _name = system.getName();
        String filename = String.valueOf(_name) + "_instanceTree.jpg";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2}{");
        String _name_1 = system.getName();
        String _escapedString = this.escapedString(_name_1);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = system.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Instance Tree}");
        _builder.newLine();
        String _imagePath = this.getImagePath(filename);
        String _fileExists = this.fileExists(ctx.model, _imagePath);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _imagePath_1 = this.getImagePath(filename);
            String _name_2 = system.getName();
            String _plus = String.valueOf(_name_2) + " Instance Tree";
            CharSequence _includeGraphics = this.includeGraphics(_imagePath_1, "1.0\\textwidth", _plus);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence _generateDoc(SubSystemClass ssc, DocGenContext ctx) {
        StringConcatenation _xblockexpression = null;
        String _name = ssc.getName();
        String _escapedString = this.escapedString(_name);
        String filename = String.valueOf(_escapedString) + "_structure.jpg";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2}{");
        String _name_1 = ssc.getName();
        String _escapedString_1 = this.escapedString(_name_1);
        _builder.append((Object)_escapedString_1, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = ssc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Structure}");
        _builder.newLine();
        String _imagePath = this.getImagePath(filename);
        String _fileExists = this.fileExists(ctx.model, _imagePath);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _imagePath_1 = this.getImagePath(filename);
            String _name_2 = ssc.getName();
            String _plus = String.valueOf(_name_2) + " Structure";
            CharSequence _includeGraphics = this.includeGraphics(_imagePath_1, "1.0\\textwidth", _plus);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence _generateDoc(EnumerationType dc, DocGenContext ctx) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2} {");
        String _name = dc.getName();
        String _escapedString = this.escapedString(_name);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = dc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        PrimitiveType _primitiveType = dc.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            _builder.append((Object)"The literals of this enumeration are based on PrimitiveType ");
            PrimitiveType _primitiveType_1 = dc.getPrimitiveType();
            String _name_1 = _primitiveType_1.getName();
            String _escapedString_1 = this.escapedString(_name_1);
            _builder.append((Object)_escapedString_1, "");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"The literals of this enumeration are of type \\texttt{int}.");
            _builder.newLine();
        }
        _builder.append((Object)"\\level{3}{Literals}");
        _builder.newLine();
        _builder.append((Object)"\\begin{tabular}[ht]{|l|r|r|r|}");
        _builder.newLine();
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\textbf{Name} & \\textbf{Value} & \\textbf{Hex Value} & \\textbf{Binary Value}\\\\");
        _builder.newLine();
        EList _literals = dc.getLiterals();
        for (EnumLiteral lit : _literals) {
            _builder.append((Object)"\\hline");
            _builder.newLine();
            String _name_2 = lit.getName();
            String _escapedString_2 = this.escapedString(_name_2);
            _builder.append((Object)_escapedString_2, "");
            _builder.append((Object)" & ");
            long _literalValue = lit.getLiteralValue();
            _builder.append((Object)_literalValue, "");
            _builder.append((Object)" & 0x");
            long _literalValue_1 = lit.getLiteralValue();
            String _hexString = Long.toHexString(_literalValue_1);
            _builder.append((Object)_hexString, "");
            _builder.append((Object)" & ");
            long _literalValue_2 = lit.getLiteralValue();
            String _binaryString = Long.toBinaryString(_literalValue_2);
            _builder.append((Object)_binaryString, "");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\end{tabular}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _generateDoc(DataClass dc, DocGenContext ctx) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2} {");
        String _name = dc.getName();
        String _escapedString = this.escapedString(_name);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = dc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Attributes}");
        _builder.newLine();
        EList _attributes = dc.getAttributes();
        CharSequence _generateAttributesDoc = this.generateAttributesDoc((List<Attribute>)_attributes);
        _builder.append((Object)_generateAttributesDoc, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\\level{3}{Operations}");
        _builder.newLine();
        EList _operations = dc.getOperations();
        CharSequence _generateOperationsDoc = this.generateOperationsDoc((List<StandardOperation>)_operations);
        _builder.append((Object)_generateOperationsDoc, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _generateDoc(ProtocolClass pc, DocGenContext ctx) {
        List _allOutgoingMessages;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2} {");
        String _name = pc.getName();
        String _escapedString = this.escapedString(_name);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = pc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        boolean _isEmpty = _allIncomingMessages.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\\level{3}{Incoming Messages}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\\begin{tabular}[ht]{|l|l|l|p{8cm}|}");
            _builder.newLine();
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"Message & Data & Type & Description\\\\");
            _builder.newLine();
            List _allIncomingMessages_1 = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message ims : _allIncomingMessages_1) {
                boolean _notEquals_1;
                boolean _notEquals;
                _builder.append((Object)"\\hline");
                _builder.newLine();
                String _name_1 = ims.getName();
                String _escapedString_1 = this.escapedString(_name_1);
                _builder.append((Object)_escapedString_1, "");
                _builder.append((Object)" & ");
                VarDecl _data = ims.getData();
                boolean bl2 = _notEquals = !Objects.equal((Object)_data, null);
                if (_notEquals) {
                    _builder.append((Object)" ");
                    VarDecl _data_1 = ims.getData();
                    String _name_2 = _data_1.getName();
                    String _escapedString_2 = this.escapedString(_name_2);
                    _builder.append((Object)_escapedString_2, "");
                    _builder.append((Object)" ");
                }
                _builder.append((Object)" & ");
                VarDecl _data_2 = ims.getData();
                boolean bl3 = _notEquals_1 = !Objects.equal((Object)_data_2, null);
                if (_notEquals_1) {
                    _builder.append((Object)" ");
                    VarDecl _data_3 = ims.getData();
                    RefableType _refType = _data_3.getRefType();
                    DataType _type = _refType.getType();
                    String _name_3 = _type.getName();
                    String _escapedString_3 = this.escapedString(_name_3);
                    _builder.append((Object)_escapedString_3, "");
                    _builder.append((Object)" ");
                }
                _builder.append((Object)" & ");
                Documentation _docu_1 = ims.getDocu();
                CharSequence _generateDocText_1 = this.generateDocText(_docu_1);
                _builder.append((Object)_generateDocText_1, "");
                _builder.append((Object)"\\\\");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\end{tabular}");
            _builder.newLine();
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = (_allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc)).isEmpty());
        if (_not_1) {
            _builder.append((Object)"\\level{3}{Outgoing Messages}");
            _builder.newLine();
            _builder.append((Object)"\\begin{tabular}[ht]{|l|l|l|p{8cm}|}");
            _builder.newLine();
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"Message & Data & Type & Description\\\\");
            _builder.newLine();
            List _allOutgoingMessages_1 = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message oms : _allOutgoingMessages_1) {
                boolean _notEquals_3;
                boolean _notEquals_2;
                _builder.append((Object)"\\hline");
                _builder.newLine();
                String _name_4 = oms.getName();
                String _escapedString_4 = this.escapedString(_name_4);
                _builder.append((Object)_escapedString_4, "");
                _builder.append((Object)" & ");
                VarDecl _data_4 = oms.getData();
                boolean bl5 = _notEquals_2 = !Objects.equal((Object)_data_4, null);
                if (_notEquals_2) {
                    _builder.append((Object)" ");
                    VarDecl _data_5 = oms.getData();
                    String _name_5 = _data_5.getName();
                    String _escapedString_5 = this.escapedString(_name_5);
                    _builder.append((Object)_escapedString_5, "");
                    _builder.append((Object)" ");
                }
                _builder.append((Object)" & ");
                VarDecl _data_6 = oms.getData();
                boolean bl6 = _notEquals_3 = !Objects.equal((Object)_data_6, null);
                if (_notEquals_3) {
                    _builder.append((Object)" ");
                    VarDecl _data_7 = oms.getData();
                    RefableType _refType_1 = _data_7.getRefType();
                    DataType _type_1 = _refType_1.getType();
                    String _name_6 = _type_1.getName();
                    String _escapedString_6 = this.escapedString(_name_6);
                    _builder.append((Object)_escapedString_6, "");
                    _builder.append((Object)" ");
                }
                _builder.append((Object)" & ");
                Documentation _docu_2 = oms.getDocu();
                CharSequence _generateDocText_2 = this.generateDocText(_docu_2);
                _builder.append((Object)_generateDocText_2, "");
                _builder.append((Object)"\\\\");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\end{tabular}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence _generateDoc(CompoundProtocolClass pc, DocGenContext ctx) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2} {");
        String _name = pc.getName();
        String _escapedString = this.escapedString(_name);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = pc.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\level{3}{Sub Protocols}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\\begin{tabular}[ht]{|l|l|}");
        _builder.newLine();
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\textbf{Name} & \\textbf{Protocol}\\\\");
        _builder.newLine();
        EList _subProtocols = pc.getSubProtocols();
        for (SubProtocol sub : _subProtocols) {
            _builder.append((Object)"\\hline");
            _builder.newLine();
            String _name_1 = sub.getName();
            String _escapedString_1 = this.escapedString(_name_1);
            _builder.append((Object)_escapedString_1, "");
            _builder.append((Object)" & ");
            GeneralProtocolClass _protocol = sub.getProtocol();
            String _name_2 = _protocol.getName();
            String _escapedString_2 = this.escapedString(_name_2);
            _builder.append((Object)_escapedString_2, "");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\end{tabular}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _generateDoc(ActorClass ac, DocGenContext ctx) {
        boolean _not_4;
        boolean _not_3;
        boolean _not_2;
        StringConcatenation _xblockexpression = null;
        String _name = ac.getName();
        String filename = String.valueOf(_name) + "_structure.jpg";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{2}{");
        String _name_1 = ac.getName();
        String _escapedString = this.escapedString(_name_1);
        _builder.append((Object)_escapedString, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        Documentation _docu = ac.getDocu();
        CharSequence _generateDocText = this.generateDocText(_docu);
        _builder.append((Object)_generateDocText, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _and = false;
        String _imagePath = this.getImagePath(filename);
        String _fileExists = this.fileExists(ctx.model, _imagePath);
        boolean _equals = _fileExists.equals("true");
        if (!_equals) {
            _and = false;
        } else {
            EList _actorRefs;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            boolean _or = false;
            List _allInterfaceItems = this._roomHelpers.getAllInterfaceItems(ac);
            boolean _isEmpty = _allInterfaceItems.isEmpty();
            boolean bl = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_actorRefs = ac.getActorRefs()).isEmpty()));
            _and = _or;
        }
        if (_and) {
            _builder.append((Object)"\\level{3}{Structure}");
            _builder.newLine();
            Documentation _structureDocu = ac.getStructureDocu();
            CharSequence _generateDocText_1 = this.generateDocText(_structureDocu);
            _builder.append((Object)_generateDocText_1, "");
            _builder.newLineIfNotEmpty();
            String _imagePath_1 = this.getImagePath(filename);
            String _name_2 = ac.getName();
            String _plus = String.valueOf(_name_2) + " Structure";
            CharSequence _includeGraphics = this.includeGraphics(_imagePath_1, "1.0\\textwidth", _plus);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _notEquals;
            Documentation _structureDocu_1 = ac.getStructureDocu();
            boolean bl = _notEquals = !Objects.equal((Object)_structureDocu_1, null);
            if (_notEquals) {
                _builder.append((Object)"\\level{3}{Structure}");
                _builder.newLine();
                Documentation _structureDocu_2 = ac.getStructureDocu();
                CharSequence _generateDocText_2 = this.generateDocText(_structureDocu_2);
                _builder.append((Object)_generateDocText_2, "");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        List _allPorts = this._roomHelpers.getAllPorts(ac);
        boolean _isEmpty_2 = _allPorts.isEmpty();
        boolean bl = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append((Object)"\\level{3}{Ports}");
            _builder.newLine();
            String _generatePortDoc = this.generatePortDoc(ac);
            _builder.append((Object)_generatePortDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isBehaviorAnnotationPresent = this._roomHelpers.isBehaviorAnnotationPresent(ac, "BehaviorManual");
        if (_isBehaviorAnnotationPresent) {
            _builder.append((Object)"\\level{3}{Behavior}");
            _builder.newLine();
            Documentation _behaviorDocu = ac.getBehaviorDocu();
            CharSequence _generateDocText_3 = this.generateDocText(_behaviorDocu);
            _builder.append((Object)_generateDocText_3, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"The behavior for ActorClass ");
            String _name_3 = ac.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)" is implemented manually.");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _hasNonEmptyStateMachine = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
            if (_hasNonEmptyStateMachine) {
                _builder.append((Object)"\\level{3}{Behavior}");
                _builder.newLine();
                Documentation _behaviorDocu_1 = ac.getBehaviorDocu();
                CharSequence _generateDocText_4 = this.generateDocText(_behaviorDocu_1);
                _builder.append((Object)_generateDocText_4, "");
                _builder.newLineIfNotEmpty();
                CharSequence _generateFsmDoc = this.generateFsmDoc(ctx.model, ac);
                _builder.append((Object)_generateFsmDoc, "");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _notEquals_1;
                Documentation _behaviorDocu_2 = ac.getBehaviorDocu();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_behaviorDocu_2, null);
                if (_notEquals_1) {
                    _builder.append((Object)"\\level{3}{Behavior}");
                    _builder.newLine();
                    Documentation _behaviorDocu_3 = ac.getBehaviorDocu();
                    CharSequence _generateDocText_5 = this.generateDocText(_behaviorDocu_3);
                    _builder.append((Object)_generateDocText_5, "");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        EList _attributes = ac.getAttributes();
        boolean _isEmpty_3 = _attributes.isEmpty();
        boolean bl3 = _not_3 = !_isEmpty_3;
        if (_not_3) {
            _builder.append((Object)"\\level{3}{Attributes}");
            _builder.newLine();
            EList _attributes_1 = ac.getAttributes();
            CharSequence _generateAttributesDoc = this.generateAttributesDoc((List<Attribute>)_attributes_1);
            _builder.append((Object)_generateAttributesDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList _operations = ac.getOperations();
        boolean _isEmpty_4 = _operations.isEmpty();
        boolean bl4 = _not_4 = !_isEmpty_4;
        if (_not_4) {
            _builder.append((Object)"\\level{3}{Operations}");
            _builder.newLine();
            EList _operations_1 = ac.getOperations();
            CharSequence _generateOperationsDoc = this.generateOperationsDoc((List<StandardOperation>)_operations_1);
            _builder.append((Object)_generateOperationsDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateFsmDoc(RoomModel model, ActorClass ac) {
        StringConcatenation _xblockexpression = null;
        String _name = ac.getName();
        String filename = String.valueOf(_name) + "_behavior.jpg";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{4}{Top Level}");
        _builder.newLine();
        String _imagePath = this.getImagePath(filename);
        String _fileExists = this.fileExists(model, _imagePath);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _imagePath_1 = this.getImagePath(filename);
            String _name_1 = ac.getName();
            String _plus = String.valueOf(_name_1) + " Top State";
            CharSequence _includeGraphics = this.includeGraphics(_imagePath_1, "1.0\\textwidth", _plus);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\\begin{par}");
        _builder.newLine();
        StateGraph _stateMachine = ac.getStateMachine();
        EList _states = _stateMachine.getStates();
        for (State s : _states) {
            boolean _notEquals;
            Documentation _docu = s.getDocu();
            boolean bl = _notEquals = !Objects.equal((Object)_docu, null);
            if (!_notEquals) continue;
            _builder.append((Object)"\\textbf{State description} \\textit{");
            String _genStatePathName = this._codegenHelpers.getGenStatePathName(s);
            String _replaceAll = _genStatePathName.replaceAll("_", "\\\\_");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_1 = s.getDocu();
            CharSequence _generateDocText = this.generateDocText(_docu_1);
            _builder.append((Object)_generateDocText, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.newLine();
        StateGraph _stateMachine_1 = ac.getStateMachine();
        EList _chPoints = _stateMachine_1.getChPoints();
        for (ChoicePoint c : _chPoints) {
            boolean _notEquals_1;
            Documentation _docu_2 = c.getDocu();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_docu_2, null);
            if (!_notEquals_1) continue;
            _builder.append((Object)"\\textbf{Choicepoint description} \\textit{");
            String _name_2 = c.getName();
            String _escapedString = this.escapedString(_name_2);
            _builder.append((Object)_escapedString, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_3 = c.getDocu();
            CharSequence _generateDocText_1 = this.generateDocText(_docu_3);
            _builder.append((Object)_generateDocText_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.append((Object)"\\end{par}");
        _builder.newLine();
        _builder.newLine();
        StateGraph _stateMachine_2 = ac.getStateMachine();
        EList _states_1 = _stateMachine_2.getStates();
        for (State s_1 : _states_1) {
            boolean _not;
            boolean _isLeaf = this._roomHelpers.isLeaf(s_1);
            boolean bl = _not = !_isLeaf;
            if (!_not) continue;
            String _generateStateDoc = this.generateStateDoc(model, ac, s_1);
            _builder.append((Object)_generateStateDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getType(Port p) {
        String _xifexpression = null;
        boolean _isConjugated = p.isConjugated();
        _xifexpression = _isConjugated ? "conj." : "reg.";
        return _xifexpression;
    }

    private String getKind(Port p) {
        String _xifexpression = null;
        boolean _isInternal = this._roomHelpers.isInternal(p);
        if (_isInternal) {
            _xifexpression = "internal";
        } else {
            String _xifexpression_1 = null;
            boolean _isExternal = this._roomHelpers.isExternal(p);
            if (_isExternal) {
                _xifexpression_1 = "external";
            } else {
                String _xifexpression_2 = null;
                boolean _isRelay = this._roomHelpers.isRelay(p);
                _xifexpression_2 = _isRelay ? "relay" : "?";
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String getMultAsText(Port p) {
        boolean _equals;
        String _xifexpression = null;
        int _multiplicity = p.getMultiplicity();
        boolean bl = _equals = _multiplicity == -1;
        if (_equals) {
            _xifexpression = "*";
        } else {
            int _multiplicity_1 = p.getMultiplicity();
            _xifexpression = Integer.valueOf(_multiplicity_1).toString();
        }
        return _xifexpression;
    }

    private String generatePortDoc(ActorClass ac) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\begin{tabular}[ht]{|l|l|l|l|l|p{5cm}|}");
        _builder.newLine();
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\textbf{Name} & \\textbf{Protocol} & \\textbf{Type} & \\textbf{Kind} & \\textbf{Multiplicity} & \\textbf{Description}\\\\");
        _builder.newLine();
        List _allPorts = this._roomHelpers.getAllPorts(ac);
        for (Port at : _allPorts) {
            _builder.append((Object)"\\hline");
            _builder.newLine();
            String _name = at.getName();
            String _escapedString = this.escapedString(_name);
            _builder.append((Object)_escapedString, "");
            _builder.append((Object)" & ");
            GeneralProtocolClass _protocol = at.getProtocol();
            String _name_1 = _protocol.getName();
            String _escapedString_1 = this.escapedString(_name_1);
            _builder.append((Object)_escapedString_1, "");
            _builder.append((Object)" & ");
            String _type = this.getType(at);
            _builder.append((Object)_type, "");
            _builder.append((Object)" & ");
            String _kind = this.getKind(at);
            _builder.append((Object)_kind, "");
            _builder.append((Object)" & ");
            String _multAsText = this.getMultAsText(at);
            _builder.append((Object)_multAsText, "");
            _builder.append((Object)" & ");
            Documentation _docu = at.getDocu();
            CharSequence _generateDocText = this.generateDocText(_docu);
            _builder.append((Object)_generateDocText, "");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\\hline");
        _builder.newLine();
        _builder.append((Object)"\\end{tabular}");
        _builder.newLine();
        return _builder.toString();
    }

    private String generateStateDoc(RoomModel model, ActorClass ac, State state) {
        String _xblockexpression = null;
        String _name = ac.getName();
        String _plus = String.valueOf(_name) + "_";
        String _genStatePathName = this._codegenHelpers.getGenStatePathName(state);
        String _plus_1 = String.valueOf(_plus) + _genStatePathName;
        String filename = String.valueOf(_plus_1) + "_behavior.jpg";
        this.logger.logInfo("Gen Filename: " + filename);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\level{4}{Subgraph ");
        String _genStatePathName_1 = this._codegenHelpers.getGenStatePathName(state);
        String _replaceAll = _genStatePathName_1.replaceAll("_", "\\\\_");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        String _imagePath = this.getImagePath(filename);
        String _fileExists = this.fileExists(model, _imagePath);
        boolean _equals = _fileExists.equals("true");
        if (_equals) {
            String _imagePath_1 = this.getImagePath(filename);
            String _name_1 = ac.getName();
            String _plus_2 = String.valueOf(_name_1) + "_";
            String _genStatePathName_2 = this._codegenHelpers.getGenStatePathName(state);
            String _plus_3 = String.valueOf(_plus_2) + _genStatePathName_2;
            CharSequence _includeGraphics = this.includeGraphics(_imagePath_1, "1.0\\textwidth", _plus_3);
            _builder.append((Object)_includeGraphics, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\\begin{par}");
        _builder.newLine();
        StateGraph _subgraph = state.getSubgraph();
        EList _states = _subgraph.getStates();
        for (State s : _states) {
            boolean _notEquals;
            Documentation _docu = s.getDocu();
            boolean bl = _notEquals = !Objects.equal((Object)_docu, null);
            if (!_notEquals) continue;
            _builder.append((Object)"\\textbf{State description} \\textit{");
            String _genStatePathName_3 = this._codegenHelpers.getGenStatePathName(s);
            String _replaceAll_1 = _genStatePathName_3.replaceAll("_", "\\\\_");
            _builder.append((Object)_replaceAll_1, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_1 = s.getDocu();
            CharSequence _generateDocText = this.generateDocText(_docu_1);
            _builder.append((Object)_generateDocText, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.newLine();
        StateGraph _subgraph_1 = state.getSubgraph();
        EList _chPoints = _subgraph_1.getChPoints();
        for (ChoicePoint c : _chPoints) {
            boolean _notEquals_1;
            Documentation _docu_2 = c.getDocu();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_docu_2, null);
            if (!_notEquals_1) continue;
            _builder.append((Object)"\\textbf{Choicepoint description} \\textit{");
            String _name_2 = c.getName();
            String _escapedString = this.escapedString(_name_2);
            _builder.append((Object)_escapedString, "");
            _builder.append((Object)"}:");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline");
            _builder.newLine();
            Documentation _docu_3 = c.getDocu();
            CharSequence _generateDocText_1 = this.generateDocText(_docu_3);
            _builder.append((Object)_generateDocText_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\\newline\\newline");
            _builder.newLine();
        }
        _builder.append((Object)"\\end{par}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        StateGraph _subgraph_2 = state.getSubgraph();
        EList _states_1 = _subgraph_2.getStates();
        for (State s_1 : _states_1) {
            boolean _not;
            boolean _isLeaf = this._roomHelpers.isLeaf(s_1);
            boolean bl = _not = !_isLeaf;
            if (!_not) continue;
            String _generateStateDoc = this.generateStateDoc(model, ac, s_1);
            _builder.append((Object)_generateStateDoc, "");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private CharSequence generateAttributesDoc(List<Attribute> attributes) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = attributes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\\begin{tabular}[ht]{|l|l|p{8cm}|}");
            _builder.newLine();
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\textbf{Name} & \\textbf{Type} & \\textbf{Description}\\\\");
            _builder.newLine();
            for (Attribute at : attributes) {
                _builder.append((Object)"\\hline");
                _builder.newLine();
                String _name = at.getName();
                String _escapedString = this.escapedString(_name);
                _builder.append((Object)_escapedString, "");
                _builder.append((Object)" & ");
                RefableType _type = at.getType();
                DataType _type_1 = _type.getType();
                String _name_1 = _type_1.getName();
                String _escapedString_1 = this.escapedString(_name_1);
                _builder.append((Object)_escapedString_1, "");
                _builder.append((Object)" & ");
                Documentation _docu = at.getDocu();
                CharSequence _generateDocText = this.generateDocText(_docu);
                _builder.append((Object)_generateDocText, "");
                _builder.append((Object)"\\\\");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\end{tabular}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateOperationsDoc(List<StandardOperation> operations) {
        StringConcatenation _builder = new StringConcatenation();
        for (StandardOperation op : operations) {
            boolean _notEquals_1;
            boolean _notEquals;
            _builder.append((Object)"\\begin{tabular}[ht]{|l|l|}");
            _builder.newLine();
            _builder.append((Object)"\\hline\t\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Name: & ");
            String _name = op.getName();
            String _escapedString = this.escapedString(_name);
            _builder.append((Object)_escapedString, "\t");
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"ReturnType: &  ");
            RefableType _returnType = op.getReturnType();
            boolean bl = _notEquals = !Objects.equal((Object)_returnType, null);
            if (_notEquals) {
                RefableType _returnType_1 = op.getReturnType();
                DataType _type = _returnType_1.getType();
                String _name_1 = _type.getName();
                String _escapedString_1 = this.escapedString(_name_1);
                _builder.append((Object)_escapedString_1, "\t");
            } else {
                _builder.append((Object)"void");
            }
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Arguments: & ");
            EList _arguments = op.getArguments();
            boolean _hasElements = false;
            for (VarDecl pa : _arguments) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _name_2 = pa.getName();
                String _escapedString_2 = this.escapedString(_name_2);
                _builder.append((Object)_escapedString_2, "\t");
                _builder.append((Object)":");
                RefableType _refType = pa.getRefType();
                DataType _type_1 = _refType.getType();
                String _name_3 = _type_1.getName();
                String _escapedString_3 = this.escapedString(_name_3);
                _builder.append((Object)_escapedString_3, "\t");
            }
            _builder.append((Object)"\\\\");
            _builder.newLineIfNotEmpty();
            Documentation _docu = op.getDocu();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_docu, null);
            if (_notEquals_1) {
                boolean _greaterThan;
                _builder.append((Object)"\t");
                _builder.append((Object)"\\hline");
                _builder.newLine();
                Documentation _docu_1 = op.getDocu();
                String _string = _docu_1.toString();
                int _length = _string.length();
                boolean bl3 = _greaterThan = _length > 85;
                if (_greaterThan) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\\multicolumn{2} {|p{13cm}|} {");
                    Documentation _docu_2 = op.getDocu();
                    CharSequence _generateDocText = this.generateDocText(_docu_2);
                    _builder.append((Object)_generateDocText, "\t");
                    _builder.append((Object)"}\\\\");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\\multicolumn{2} {|l|} {");
                    Documentation _docu_3 = op.getDocu();
                    CharSequence _generateDocText_1 = this.generateDocText(_docu_3);
                    _builder.append((Object)_generateDocText_1, "\t");
                    _builder.append((Object)"}\\\\");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\\hline");
            _builder.newLine();
            _builder.append((Object)"\\end{tabular}");
            _builder.newLine();
            _builder.append((Object)"\\newline\\newline\\newline");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateDocText(Documentation doc) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)doc, null);
        if (_notEquals) {
            _builder.append((Object)"% begin text from user Documentation");
            _builder.newLine();
            EList _lines = doc.getLines();
            for (String line : _lines) {
                String _escapedString = this.escapedString(line);
                _builder.append((Object)_escapedString, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"% end text from user Documentation");
            _builder.newLine();
        }
        return _builder;
    }

    private String fileExists(RoomModel model, String f) {
        String _docGenerationTargetPath = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String absPath = String.valueOf(_docGenerationTargetPath) + f;
        File file = new File(absPath);
        boolean exist = file.exists();
        if (exist) {
            this.logger.logInfo("File found ! " + f);
            return "true";
        }
        this.logger.logInfo("File not found ! " + f);
        return "false";
    }

    private CharSequence includeGraphics(String filename, String width, String caption) {
        StringConcatenation _xblockexpression = null;
        String latexCaption = caption.replaceAll("_", "\\\\_");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\\centering{}");
        _builder.newLine();
        _builder.append((Object)"\\includegraphics[width=");
        _builder.append((Object)width, "");
        _builder.append((Object)"]{");
        _builder.append((Object)filename, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\\figcaption{");
        _builder.append((Object)latexCaption, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String escapedString(String text) {
        return text.replace("_", "\\_");
    }

    private String getImagePath(String filename) {
        String _replaceAll;
        String filenamei = String.valueOf("./images") + "/" + filename;
        filenamei = _replaceAll = filenamei.replaceAll("\\\\", "/");
        return filenamei;
    }

    private void saveAs(CharSequence content, String filename) {
        this.fileAccess.generateFile(filename, content);
    }

    private String docFragmentName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + ".tex";
    }

    private CharSequence generateImport(RoomClass rc, String dir) {
        StringConcatenation _builder = new StringConcatenation();
        String _docFragmentName = this.docFragmentName(rc);
        CharSequence _generateImport = this.generateImport(_docFragmentName, dir);
        _builder.append((Object)_generateImport, "");
        return _builder;
    }

    private CharSequence generateImport(String name, String dir) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\subimport*{");
        _builder.append((Object)dir, "");
        _builder.append((Object)"/}{");
        _builder.append((Object)name, "");
        _builder.append((Object)"}");
        return _builder;
    }

    private CharSequence generateDoc(RoomClass ac, DocGenContext ctx) {
        if (ac instanceof ActorClass) {
            return this._generateDoc((ActorClass)ac, ctx);
        }
        if (ac instanceof DataClass) {
            return this._generateDoc((DataClass)ac, ctx);
        }
        if (ac instanceof SubSystemClass) {
            return this._generateDoc((SubSystemClass)ac, ctx);
        }
        if (ac instanceof CompoundProtocolClass) {
            return this._generateDoc((CompoundProtocolClass)ac, ctx);
        }
        if (ac instanceof EnumerationType) {
            return this._generateDoc((EnumerationType)ac, ctx);
        }
        if (ac instanceof LogicalSystem) {
            return this._generateDoc((LogicalSystem)ac, ctx);
        }
        if (ac instanceof ProtocolClass) {
            return this._generateDoc((ProtocolClass)ac, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ac, ctx).toString());
    }

    public static class DocGenContext {
        private final Root root;
        private final RoomModel model;

        public DocGenContext(Root r, RoomModel m) {
            this.root = r;
            this.model = m;
        }
    }
}

