/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.hover;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.ui.RoomUiActivator;
import org.eclipse.etrice.doc.ETriceHelp;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.util.Files;

public class KeywordHoverProvider
extends DefaultEObjectHoverProvider {
    private static final String styleSheetFileName = "/eTriceKeywordHoverStyle.css";
    @Inject
    protected ILabelProvider labelProvider;
    private String styleSheet = null;

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        if (element instanceof Keyword) {
            Keyword keyword = (Keyword)element;
            String html = ETriceHelp.getKeywordHoverContentProvider().getHTMLContent(keyword.getValue());
            if (html != null) {
                StringBuffer buffer = new StringBuffer(html);
                HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getKeywordStyleSheet());
                HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                return new XtextBrowserInformationControlInput(previous, element, buffer.toString(), this.labelProvider);
            }
        }
        return super.getHoverInfo(element, hoverRegion, previous);
    }

    protected String getKeywordStyleSheet() {
        String superStyle = super.getStyleSheet();
        if (this.styleSheet == null) {
            this.styleSheet = "";
            try {
                this.styleSheet = Files.readStreamIntoString((InputStream)RoomUiActivator.getDefault().getBundle().getEntry(styleSheetFileName).openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(superStyle) + this.styleSheet;
    }
}

