/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.etrice.core.ui.RoomUiActivator;
import org.eclipse.etrice.core.validation.ValidatorExtensionManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValidationExtensionPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String VALIDATION_EXTENSIONS_EXCLUDED = "ValidationExtensionPreferences.excluded";
    private static final String SEP = "#";
    private CheckboxTableViewer viewer;

    public static void initValidationPreferencesFromStore() {
        Set<String> excludedIds = ValidationExtensionPreferences.readExcludedFromPreferences();
        ValidatorExtensionManager.Registry registry = ValidatorExtensionManager.Registry.getInstance();
        registry.setIncluded(new ArrayList());
        List all = registry.getInfos();
        for (ValidatorExtensionManager.ValidatorInfo val : all) {
            if (excludedIds.contains(val.getName())) continue;
            registry.include(val);
        }
    }

    private static IPreferenceStore getDefaultPreferenceStore() {
        return RoomUiActivator.getDefault().getPreferenceStore();
    }

    private static Set<String> readExcludedFromPreferences() {
        String stored = ValidationExtensionPreferences.getDefaultPreferenceStore().getString(VALIDATION_EXTENSIONS_EXCLUDED);
        String[] excl = stored.split(SEP);
        HashSet<String> excludedIds = new HashSet<String>();
        String[] stringArray = excl;
        int n = excl.length;
        int n2 = 0;
        while (n2 < n) {
            String ex = stringArray[n2];
            excludedIds.add(ex);
            ++n2;
        }
        return excludedIds;
    }

    public ValidationExtensionPreferences() {
        this.setDescription("Preferences for ROOM model validation extensions");
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ValidationExtensionPreferences.getDefaultPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 64);
        label.setAlignment(16384);
        label.setText("Check active validators");
        Composite tableArea = new Composite(composite, 0);
        Table table = new Table(tableArea, 2082);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        tableArea.setLayoutData((Object)gd);
        TableColumn nameColumn = new TableColumn(table, 0, 0);
        nameColumn.setText("Name");
        TableColumn descColumn = new TableColumn(table, 0, 1);
        descColumn.setText("Description");
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ValidationExtensionContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ValidationExtensionLabelProvider());
        this.viewer.setInput((Object)ValidatorExtensionManager.Registry.getInstance().getInfos());
        this.viewer.getTable().setHeaderVisible(true);
        this.setChecks();
        TableColumnLayout layout = new TableColumnLayout();
        tableArea.setLayout((Layout)layout);
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)descColumn, (ColumnLayoutData)new ColumnWeightData(80));
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        return composite;
    }

    public boolean performOk() {
        this.updateExcluded();
        return super.performOk();
    }

    protected void performApply() {
        this.updateExcluded();
        super.performApply();
    }

    private void setChecks() {
        Set<String> excludedIds = ValidationExtensionPreferences.readExcludedFromPreferences();
        ArrayList<ValidatorExtensionManager.ValidatorInfo> allChecked = new ArrayList<ValidatorExtensionManager.ValidatorInfo>();
        for (ValidatorExtensionManager.ValidatorInfo vi : ValidatorExtensionManager.Registry.getInstance().getInfos()) {
            if (excludedIds.contains(vi.getName())) continue;
            allChecked.add(vi);
        }
        this.viewer.setCheckedElements(allChecked.toArray());
    }

    private void updateExcluded() {
        Object[] checked = this.viewer.getCheckedElements();
        HashSet<ValidatorExtensionManager.ValidatorInfo> included = new HashSet<ValidatorExtensionManager.ValidatorInfo>();
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            included.add((ValidatorExtensionManager.ValidatorInfo)object);
            ++n2;
        }
        ValidatorExtensionManager.Registry registry = ValidatorExtensionManager.Registry.getInstance();
        registry.setIncluded(included);
        StringBuilder ex = new StringBuilder();
        for (ValidatorExtensionManager.ValidatorInfo vi : registry.getExcludedInfos()) {
            ex.append(String.valueOf(vi.getName()) + SEP);
        }
        this.getPreferenceStore().setValue(VALIDATION_EXTENSIONS_EXCLUDED, ex.toString());
    }

    private class ValidationExtensionContentProvider
    implements IStructuredContentProvider {
        private ValidationExtensionContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ValidatorExtensionManager.Registry.getInstance().getInfos().toArray();
        }
    }

    private class ValidationExtensionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ValidationExtensionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ValidatorExtensionManager.ValidatorInfo) {
                ValidatorExtensionManager.ValidatorInfo info = (ValidatorExtensionManager.ValidatorInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return info.getName();
                    }
                    case 1: {
                        return info.getDescription();
                    }
                }
            }
            return null;
        }
    }
}

