/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.java.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.genmodel.etricegen.Root
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo
import org.eclipse.etrice.generator.generic.RoomExtensions
import org.eclipse.etrice.core.etmap.util.ETMapUtil
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers

@Singleton
class NodeRunnerGen {

	@Inject extension RoomExtensions roomExt
	@Inject extension JavaExtensions
	@Inject extension FileSystemHelpers
	
	@Inject IGeneratorFileIo fileIO
	
	def doGenerate(Root root) {
		for (nr : ETMapUtil::getNodeRefs()) {
			for (instpath : ETMapUtil::getSubSystemInstancePaths(nr)) {
				val ssi = root.getInstance(instpath) as SubSystemInstance
				if (ssi!=null && ssi.subSystemClass.validGenerationLocation) {
					val file = nr.getJavaClassName(ssi)+"Runner.java"
					val filepath = ssi.subSystemClass.generationTargetPath+ssi.subSystemClass.getPath
					val infopath = ssi.subSystemClass.generationInfoPath+ssi.subSystemClass.getPath
					fileIO.generateFile("generating SubSystemRunner implementation", filepath, infopath, file, root.generate(ssi))
				}
			}
		}
	}
	
	def generate(Root root, SubSystemInstance ssc) {
	val cc = ssc.subSystemClass
	val nr = ETMapUtil::getNodeRef(ssc)
	val clsname = nr.getJavaClassName(ssc)
	'''
		/**
		 * @author generated by eTrice
		 *
		 * this class contains the main function running component ssc.name
		 * it instantiates ssc.name and starts and ends the lifecycle
		 */
		
		package cc.getPackage();
		
		import org.eclipse.etrice.runtime.java.modelbase.RTSystem;
		import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;
		
		public class clsname+"Runner" extends SubSystemRunnerBase {
		
			/**
		     * main function
		     * creates the main component and starts and stops the lifecycle
		     */
			public static void main(String[] args) {
				// instantiate the main component
				RTSystem sys = IF ssc.eContainer instanceof SystemInstancenew RTSystem("(ssc.eContainer as SystemInstance).name")ELSEnullENDIF;
				clsname main_component = new clsname(sys, "ssc.name");
				
				run(main_component, args);
			}
		};
	'''
	}
}