/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm.fsmgen.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedRefinedState;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenFactory;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenPackage;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.TransitionChain;

public class ExpandedModelComponentImpl
extends MinimalEObjectImpl.Container
implements ExpandedModelComponent {
    protected ModelComponent modelComponent;
    protected StateGraph stateMachine;
    protected EList<TransitionChain> transitionChains;
    private static final String TRIGGER_SEP = "#";
    private IDiagnostician validator;
    private boolean prepared = false;
    private HashSet<StateGraphItem> ownObjects = null;
    private HashSet<Transition> targetsOfRefinedTransitions = null;
    private HashSet<Transition> baseTransitionHasDetailCode = null;
    private HashMap<AbstractInterfaceItem, Integer> ifitem2localId = null;
    private HashMap<StateGraphNode, NodeData> node2data = null;
    private HashMap<State, LinkedList<ActiveTrigger>> state2triggers = null;
    private HashMap<String, MessageFromIf> triggerstring2mif = null;
    private LinkedList<TransitionChain> trchains = null;
    private TransitionToChainBundleMap trans2chainBundle = null;
    private HashMap<EObject, EObject> copy2orig = null;
    private HashMap<EObject, EObject> orig2copy = null;
    private FSMHelpers fsmHelpers = new FSMHelpers();
    protected FSMNameProvider fsmNameProvider = new FSMNameProvider();

    protected ExpandedModelComponentImpl() {
    }

    protected EClass eStaticClass() {
        return FsmGenPackage.Literals.EXPANDED_MODEL_COMPONENT;
    }

    @Override
    public ModelComponent getModelComponent() {
        if (this.modelComponent != null && this.modelComponent.eIsProxy()) {
            InternalEObject oldModelComponent = (InternalEObject)this.modelComponent;
            this.modelComponent = (ModelComponent)this.eResolveProxy(oldModelComponent);
            if (this.modelComponent != oldModelComponent && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldModelComponent, (Object)this.modelComponent));
            }
        }
        return this.modelComponent;
    }

    public ModelComponent basicGetModelComponent() {
        return this.modelComponent;
    }

    @Override
    public void setModelComponent(ModelComponent newModelComponent) {
        ModelComponent oldModelComponent = this.modelComponent;
        this.modelComponent = newModelComponent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldModelComponent, (Object)this.modelComponent));
        }
    }

    @Override
    public StateGraph getStateMachine() {
        return this.stateMachine;
    }

    public NotificationChain basicSetStateMachine(StateGraph newStateMachine, NotificationChain msgs) {
        StateGraph oldStateMachine = this.stateMachine;
        this.stateMachine = newStateMachine;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldStateMachine, (Object)newStateMachine);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStateMachine(StateGraph newStateMachine) {
        if (newStateMachine != this.stateMachine) {
            NotificationChain msgs = null;
            if (this.stateMachine != null) {
                msgs = ((InternalEObject)this.stateMachine).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newStateMachine != null) {
                msgs = ((InternalEObject)newStateMachine).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetStateMachine(newStateMachine, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newStateMachine, (Object)newStateMachine));
        }
    }

    protected void validationError(String msg, EObject obj, EStructuralFeature feature) {
        this.validationError(msg, obj, feature, -1);
    }

    protected void validationError(String msg, EObject obj, EStructuralFeature feature, int idx) {
        if (obj.eResource() == null) {
            obj = this.copy2orig.get(obj);
        }
        this.validator.error(msg, obj, feature, idx);
    }

    private void buildStateGraph() {
        ArrayList<StateGraph> stateMachines = new ArrayList<StateGraph>();
        ModelComponent orig = this.getModelComponent();
        if (orig.getStateMachine() != null) {
            stateMachines.add(orig.getStateMachine());
        }
        while (orig.getBase() != null) {
            if ((orig = orig.getBase()).getStateMachine() == null) continue;
            stateMachines.add(orig.getStateMachine());
        }
        Collection<StateGraph> copiedStateMachines = this.createCopyOfStateMachines(stateMachines);
        this.collectContentsInNewStateMachine(copiedStateMachines);
        this.introduceExpandedRefinedStates(this.getStateMachine());
    }

    private void collectContentsInNewStateMachine(Collection<StateGraph> copiedStateMachines) {
        StateGraph myStateMachine = FSMFactory.eINSTANCE.createStateGraph();
        this.setStateMachine(myStateMachine);
        HashMap<Transition, DetailCode> trans2refinedAction = new HashMap<Transition, DetailCode>();
        for (StateGraph stateGraph : copiedStateMachines) {
            myStateMachine.getChPoints().addAll((Collection)stateGraph.getChPoints());
            myStateMachine.getStates().addAll((Collection)stateGraph.getStates());
            myStateMachine.getTrPoints().addAll((Collection)stateGraph.getTrPoints());
            myStateMachine.getTransitions().addAll((Collection)stateGraph.getTransitions());
            for (RefinedTransition rt : stateGraph.getRefinedTransitions()) {
                if (rt.getAction() == null || rt.getAction().getLines().isEmpty()) continue;
                DetailCode code = (DetailCode)trans2refinedAction.get(rt.getTarget());
                if (code == null) {
                    code = FSMFactory.eINSTANCE.createDetailCode();
                    trans2refinedAction.put(rt.getTarget(), code);
                }
                code.getLines().addAll(0, (Collection)rt.getAction().getLines());
                code.setUsed(this.fsmHelpers.hasDetailCode(code));
            }
        }
        for (Map.Entry entry : trans2refinedAction.entrySet()) {
            this.ownObjects.add((StateGraphItem)entry.getKey());
            this.targetsOfRefinedTransitions.add((Transition)entry.getKey());
            if (((Transition)entry.getKey()).getAction() == null) {
                ((Transition)entry.getKey()).setAction((DetailCode)entry.getValue());
                continue;
            }
            this.baseTransitionHasDetailCode.add((Transition)entry.getKey());
            ((Transition)entry.getKey()).getAction().getLines().addAll((Collection)((DetailCode)entry.getValue()).getLines());
        }
    }

    private Collection<StateGraph> createCopyOfStateMachines(List<StateGraph> origStateMachines) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection copiedStateMachines = copier.copyAll(origStateMachines);
        copier.copyReferences();
        for (EObject o : copier.keySet()) {
            EObject c = (EObject)copier.get((Object)o);
            this.copy2orig.put(c, o);
            this.orig2copy.put(o, c);
        }
        if (this.getModelComponent().getStateMachine() != null) {
            StateGraph self = (StateGraph)copiedStateMachines.iterator().next();
            TreeIterator it = self.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof StateGraphItem)) continue;
                this.addOwnObject((StateGraphItem)obj);
            }
        }
        return copiedStateMachines;
    }

    private void introduceExpandedRefinedStates(StateGraph sg) {
        ArrayList states = new ArrayList(sg.getStates());
        for (State s : states) {
            if (!(s instanceof RefinedState)) continue;
            RefinedState rs = (RefinedState)s;
            ExpandedRefinedState state = FsmGenFactory.eINSTANCE.createExpandedRefinedState();
            state.init(rs);
            this.copy2orig.put((EObject)state, this.getOrig((EObject)rs));
            this.orig2copy.put(this.getOrig((EObject)rs), (EObject)state);
            if (!this.isOwnObject((StateGraphItem)rs)) continue;
            this.addOwnObject((StateGraphItem)state);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.introduceExpandedRefinedStates(s.getSubgraph());
        }
    }

    private void addOutgoingTransition(StateGraphNode node, Transition t) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            data = new NodeData();
            this.node2data.put(node, data);
        }
        data.getOutTrans().add(t);
    }

    private void addIncomingTransition(StateGraphNode node, Transition t) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            data = new NodeData();
            this.node2data.put(node, data);
        }
        data.getInTrans().add(t);
    }

    private void findOutgoingTransitions(StateGraph sg) {
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.findOutgoingTransitions(s.getSubgraph());
        }
        for (Transition t : sg.getTransitions()) {
            this.addIncomingTransition(this.getAdjustedTargetNode(t), t);
            if (!(t instanceof NonInitialTransition)) continue;
            this.addOutgoingTransition(this.fsmHelpers.getNode(((NonInitialTransition)t).getFrom()), t);
        }
    }

    private void checkTransitionChains(StateGraph sg) {
        for (Transition t : sg.getTransitions()) {
            TransitionChain chain = this.getChain(t);
            if (chain != null || this.getModelComponent().isAbstract()) continue;
            int idx = sg.getTransitions().indexOf((Object)t);
            Transition orig = (Transition)this.copy2orig.get(t);
            String name = this.fsmNameProvider.getName((EObject)orig);
            this.validator.error("transition '" + name + "' is not part of a transition chain (only allowed for abstract actor classes)", orig.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), idx);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.checkTransitionChains(s.getSubgraph());
        }
    }

    private void doChecks(StateGraph sg) {
        int idx;
        StateGraph origContainer;
        ChoicePoint orig;
        NodeData data;
        if (sg.getTransitions().isEmpty() && sg.getStates().isEmpty() && sg.getChPoints().isEmpty() && sg.getTrPoints().isEmpty()) {
            return;
        }
        int initCount = 0;
        for (Transition t : sg.getTransitions()) {
            if (!(t instanceof InitialTransition)) continue;
            ++initCount;
        }
        if (initCount == 0) {
            if (sg.eContainer() instanceof State) {
                NodeData data2;
                if (!this.getModelComponent().isAbstract() && (data2 = this.node2data.get((State)sg.eContainer())) != null && data2.getLoopTransitions().size() != data2.getInTrans().size()) {
                    this.validationError(String.valueOf(this.getModelComponentName()) + ": Having no initial transition in a nested state is valid only if there is no transition to history except of self transitions!", sg.eContainer(), (EStructuralFeature)FSMPackage.eINSTANCE.getState_Subgraph());
                }
            } else {
                this.validationError(String.valueOf(this.getModelComponentName()) + ": The TOP level has to have an initial transition!", (EObject)this.getModelComponent().getStateMachine(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions());
            }
        } else if (initCount > 1) {
            this.validationError(String.valueOf(this.getModelComponentName()) + ": There has to be exactly one initial transition!", (EObject)this.getModelComponent().getStateMachine(), (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions());
        }
        for (ChoicePoint cp : sg.getChPoints()) {
            data = this.node2data.get(cp);
            orig = (ChoicePoint)this.copy2orig.get(cp);
            origContainer = (StateGraph)orig.eContainer();
            idx = origContainer.getChPoints().indexOf((Object)orig);
            if (data == null) {
                this.validationError(String.valueOf(this.getModelComponentName()) + ": ChoicePoint is not connected!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
                continue;
            }
            if (data.getOutTrans().size() < 2) {
                this.validationError(String.valueOf(this.getModelComponentName()) + ": ChoicePoint should have 2 or more branches but has " + data.getOutTrans().size(), (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
            }
            if (this.getDefaultBranch(data.getOutTrans()) == null) {
                this.validationError(String.valueOf(this.getModelComponentName()) + ": ChoicePoint has no default branch!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
            }
            if (data.getLoopTransitions().isEmpty()) continue;
            this.validationError(String.valueOf(this.getModelComponentName()) + ": ChoicePoint is connected to itself!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
        }
        for (TrPoint tp : sg.getTrPoints()) {
            data = this.node2data.get(tp);
            orig = (TrPoint)this.copy2orig.get(tp);
            origContainer = (StateGraph)orig.eContainer();
            idx = origContainer.getTrPoints().indexOf((Object)orig);
            if (data == null) {
                if (this.getModelComponent((EObject)tp).isAbstract()) continue;
                this.validationError(String.valueOf(this.getModelComponentName()) + ": TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)tp) + " is not connected", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                continue;
            }
            if (tp instanceof EntryPoint || tp instanceof ExitPoint) {
                if (!this.getModelComponent().isAbstract() && data.getInTrans().isEmpty()) {
                    this.validationError(String.valueOf(this.getModelComponentName()) + ": TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)tp) + " has no incoming transition!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                }
                if (this.getModelComponent((EObject)tp).isAbstract()) {
                    if (data.getOutTrans().size() > 1) {
                        this.validationError(String.valueOf(this.getModelComponentName()) + ": TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)tp) + " must have at most one outgoing transition!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                    }
                } else if (data.getOutTrans().size() != 1) {
                    this.validationError(String.valueOf(this.getModelComponentName()) + ": TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)tp) + " must have exactly one outgoing transition!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                }
                if (data.getLoopTransitions().isEmpty()) continue;
                this.validationError(String.valueOf(this.getModelComponentName()) + ": TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)tp) + " must have no self transitions!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                continue;
            }
            if (!(tp instanceof TransitionPoint) || data.getOutTrans().size() >= data.getLoopTransitions().size()) continue;
            this.validationError(String.valueOf(this.getModelComponentName()) + ": TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)tp) + " must have no incoming transitions!", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.doChecks(s.getSubgraph());
        }
    }

    private void findTriggersOfState(State s) {
        LinkedList<ActiveTrigger> triggers = new LinkedList<ActiveTrigger>();
        HashMap<String, ActiveTrigger> caughtTriggers = new HashMap<String, ActiveTrigger>();
        this.collectTriggersAndTransitions(s, caughtTriggers, triggers);
        this.state2triggers.put(s, triggers);
    }

    private String getTriggerString(MessageFromIf mifp) {
        assert (mifp.getFrom().getName() != null) : "ifitem name must not be null";
        assert (this.fsmNameProvider.getMessageName(mifp.getMessage()) != null) : "message name must not be null";
        return String.valueOf(mifp.getFrom().getName()) + TRIGGER_SEP + this.fsmNameProvider.getMessageName(mifp.getMessage());
    }

    private void collectOutgoingTransitions(EList<Transition> sameLevelTransitions, HashMap<String, ActiveTrigger> caughtTriggers, LinkedList<ActiveTrigger> triggers) {
        for (Transition t : sameLevelTransitions) {
            if (!(t instanceof TriggeredTransition)) continue;
            TriggeredTransition tt = (TriggeredTransition)t;
            for (Trigger trig : ((TriggeredTransition)t).getTriggers()) {
                for (MessageFromIf mifp : trig.getMsgFromIfPairs()) {
                    String tr = this.getTriggerString(mifp);
                    ActiveTrigger at = caughtTriggers.get(tr);
                    if (at == null) {
                        at = FsmGenFactory.eINSTANCE.createActiveTrigger();
                        at.setMsg(mifp.getMessage());
                        at.setIfitem(mifp.getFrom());
                        at.setTrigger(tr);
                        at.getTransitions().add((Object)tt);
                        caughtTriggers.put(tr, at);
                        triggers.add(at);
                        continue;
                    }
                    TriggeredTransition unguarded = null;
                    boolean accepted = true;
                    for (TriggeredTransition t2 : at.getTransitions()) {
                        for (Trigger trig2 : t2.getTriggers()) {
                            if (!this.isMatching(trig2, tr) || this.fsmHelpers.isGuarded(trig2)) continue;
                            unguarded = t2;
                            if (sameLevelTransitions.contains((Object)t2)) continue;
                            accepted = false;
                        }
                    }
                    if (!accepted) continue;
                    if (unguarded != null) {
                        if (!this.fsmHelpers.isGuarded(trig)) {
                            this.validationError("Transitions with same trigger on same level have to be guarded!", (EObject)t, (EStructuralFeature)FSMPackage.eINSTANCE.getTriggeredTransition_Triggers());
                            continue;
                        }
                        int idx = at.getTransitions().indexOf(unguarded);
                        at.getTransitions().add(idx, (Object)tt);
                        continue;
                    }
                    at.getTransitions().add((Object)tt);
                }
            }
        }
    }

    private void collectTriggersAndTransitions(State s, HashMap<String, ActiveTrigger> caughtTriggers, LinkedList<ActiveTrigger> triggers) {
        this.collectOutgoingTransitions(this.getOutgoingTransitions((StateGraphNode)s), caughtTriggers, triggers);
        if (s.eContainer() instanceof StateGraph) {
            StateGraph sg = (StateGraph)s.eContainer();
            BasicEList trpTransitions = new BasicEList();
            for (TrPoint tp : sg.getTrPoints()) {
                trpTransitions.addAll(this.getOutgoingTransitions((StateGraphNode)tp));
            }
            this.collectOutgoingTransitions((EList<Transition>)trpTransitions, caughtTriggers, triggers);
            if (sg.eContainer() instanceof State) {
                this.collectTriggersAndTransitions((State)sg.eContainer(), caughtTriggers, triggers);
            }
        } else assert (false) : "A State must always reside in a StateGraph!";
    }

    private void findLeafStateTriggers(StateGraph sg) {
        for (State s : sg.getStates()) {
            if (s.getSubgraph() != null) {
                this.findLeafStateTriggers(s.getSubgraph());
                continue;
            }
            this.findTriggersOfState(s);
        }
    }

    private void fillTriggerStringMap() {
        HashMap<String, AbstractInterfaceItem> name2ifitem = new HashMap<String, AbstractInterfaceItem>();
        HashMap<String, EList<EObject>> name2msgs = new HashMap<String, EList<EObject>>();
        EList<AbstractInterfaceItem> items = this.getAllInterfaceItems();
        for (AbstractInterfaceItem item : items) {
            name2ifitem.put(item.getName(), item);
            name2msgs.put(item.getName(), this.getIncomingMessages(item));
        }
        HashSet<String> triggers = new HashSet<String>();
        for (LinkedList<ActiveTrigger> ttlist : this.state2triggers.values()) {
            for (ActiveTrigger tt : ttlist) {
                triggers.add(tt.getTrigger());
            }
        }
        for (String trig : triggers) {
            String[] parts = trig.split(TRIGGER_SEP);
            assert (parts.length == 2) : "By our convention triggers are composed of two parts separated by #. Here we have '" + trig + "' which doesn't consist of two parts!";
            AbstractInterfaceItem ii = (AbstractInterfaceItem)name2ifitem.get(parts[0]);
            assert (ii != null) : "The name '" + parts[0] + "' did not match an interface item (in name2ifitem)!";
            List msgs = (List)name2msgs.get(parts[0]);
            assert (msgs != null) : "The name '" + parts[0] + "' did not match an interface item (in name2msgs)!";
            EObject msg = null;
            for (EObject m : msgs) {
                if (!this.fsmNameProvider.getMessageName(m).equals(parts[1])) continue;
                msg = m;
            }
            assert (msg != null) : "The message '" + parts[1] + "' did not match a message!";
            MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
            mif.setFrom(ii);
            mif.setMessage(msg);
            this.triggerstring2mif.put(trig, mif);
        }
    }

    private void collectChainTransitions(TransitionChain tc, Transition t) {
        this.trans2chainBundle.put(t, tc);
        StateGraphNode node = this.fsmHelpers.getNode(t.getTo());
        if (node instanceof State) {
            return;
        }
        if (tc.getTransition() instanceof NonInitialTransition && node == this.fsmHelpers.getNode(((NonInitialTransition)tc.getTransition()).getFrom())) {
            return;
        }
        for (Transition next : this.getOutgoingTransitions(node)) {
            if (next instanceof TriggeredTransition) {
                TriggeredTransition orig = (TriggeredTransition)this.copy2orig.get(next);
                StateGraph origContainer = (StateGraph)orig.eContainer();
                int idx = origContainer.getTransitions().indexOf((Object)orig);
                this.validationError("Segments following the triggering transition can have no triggers!\n", (EObject)origContainer, (EStructuralFeature)FSMPackage.eINSTANCE.getStateGraph_Transitions(), idx);
            }
            this.collectChainTransitions(tc, next);
        }
    }

    private void findTransitionChains(StateGraph sg, Class<?> cls) {
        this.findTransitionChains(sg, cls, true);
    }

    private void findTransitionChains(StateGraph sg, Class<?> cls, boolean includeInitial) {
        for (Transition t : sg.getTransitions()) {
            if (!cls.isInstance(t) && (!includeInitial || !(t instanceof InitialTransition))) continue;
            this.addTransitionChain(t);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.findTransitionChains(s.getSubgraph(), cls, includeInitial);
        }
    }

    @Override
    public void prepare(IDiagnostician validator) {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        this.validator = validator;
        this.ifitem2localId = new HashMap();
        this.ownObjects = new HashSet();
        this.targetsOfRefinedTransitions = new HashSet();
        this.baseTransitionHasDetailCode = new HashSet();
        this.node2data = new HashMap();
        this.state2triggers = new HashMap();
        this.triggerstring2mif = new HashMap();
        this.trchains = new LinkedList();
        this.trans2chainBundle = new TransitionToChainBundleMap();
        this.copy2orig = new HashMap();
        this.orig2copy = new HashMap();
        this.buildStateGraph();
        this.computeInterfaceItemLocalIds(this.getModelComponent(), 0);
        this.findOutgoingTransitions(this.getStateMachine());
        this.doChecks(this.getStateMachine());
        if (validator.isFailed()) {
            return;
        }
        if (this.getModelComponent().getCommType() == ComponentCommunicationType.DATA_DRIVEN) {
            this.findTransitionChains(this.getStateMachine(), GuardedTransition.class);
        } else if (this.getModelComponent().getCommType() == ComponentCommunicationType.ASYNCHRONOUS) {
            this.findLeafStateTriggers(this.getStateMachine());
            this.fillTriggerStringMap();
            this.findTransitionChains(this.getStateMachine(), TriggeredTransition.class);
            this.computeCommonChainData();
            this.findTransitionChains(this.getStateMachine(), GuardedTransition.class, false);
            this.checkTransitionChains(this.getStateMachine());
        } else {
            this.findLeafStateTriggers(this.getStateMachine());
            this.fillTriggerStringMap();
            this.findTransitionChains(this.getStateMachine(), TriggeredTransition.class);
            this.computeCommonChainData();
            this.checkTransitionChains(this.getStateMachine());
        }
    }

    private void computeCommonChainData() {
        for (TransitionChainBundle tcb : this.trans2chainBundle.values()) {
            tcb.commonData = this.computeCommonChainData((EList<TransitionChain>)tcb.chains);
        }
    }

    @Override
    public void release() {
        if (!this.prepared) {
            return;
        }
        this.prepared = false;
        this.ifitem2localId = null;
        this.ownObjects = null;
        this.node2data = null;
        this.state2triggers = null;
        this.triggerstring2mif = null;
        this.trchains = null;
        this.trans2chainBundle = null;
        this.copy2orig = null;
    }

    @Override
    public void addOwnObject(StateGraphItem obj) {
        this.ownObjects.add(obj);
    }

    @Override
    public boolean isOwnObject(StateGraphItem obj) {
        return this.ownObjects.contains(obj);
    }

    @Override
    public boolean hasBaseTransitionDetailCode(Transition trans) {
        return this.baseTransitionHasDetailCode.contains(trans);
    }

    private int computeInterfaceItemLocalIds(ModelComponent mc, int offset) {
        if (mc.getBase() != null) {
            offset = this.computeInterfaceItemLocalIds(mc.getBase(), offset);
        }
        EList<AbstractInterfaceItem> items = this.getOwnInterfaceItems(mc);
        for (AbstractInterfaceItem item : items) {
            this.ifitem2localId.put(item, offset);
            ++offset;
        }
        return offset;
    }

    @Override
    public int getInterfaceItemLocalId(AbstractInterfaceItem ifitem) {
        Integer localId = this.ifitem2localId.get(ifitem);
        if (localId != null) {
            return localId;
        }
        return -1;
    }

    @Override
    public EObject computeCommonChainData(EList<TransitionChain> chains) {
        return null;
    }

    @Override
    public boolean hasStateMachine() {
        ModelComponent mc = this.getModelComponent();
        while (mc != null) {
            if (mc.getStateMachine() != null) {
                return true;
            }
            mc = mc.getBase();
        }
        return false;
    }

    @Override
    public String getTriggerCodeName(MessageFromIf mif) {
        return "TRIG_" + mif.getFrom().getName() + "__" + this.fsmNameProvider.getMessageName(mif.getMessage());
    }

    @Override
    public String getTriggerCodeName(ActiveTrigger at) {
        String[] parts = at.getTrigger().split(TRIGGER_SEP);
        return "TRIG_" + parts[0] + "__" + parts[1];
    }

    @Override
    public EList<Transition> getOutgoingTransitions(StateGraphNode node) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            return new BasicEList();
        }
        return new BasicEList(data.getOutTrans());
    }

    @Override
    public EList<Transition> getIncomingTransitions(StateGraphNode node) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            return new BasicEList();
        }
        return new BasicEList(data.getInTrans());
    }

    @Override
    public EList<ActiveTrigger> getActiveTriggers(State state) {
        LinkedList<ActiveTrigger> triggers = this.state2triggers.get(state);
        if (triggers == null) {
            return new BasicEList();
        }
        return new BasicEList(triggers);
    }

    @Override
    public EList<MessageFromIf> getTriggers() {
        return new BasicEList(this.triggerstring2mif.values());
    }

    @Override
    public EList<MessageFromIf> getOwnTriggers() {
        BasicEList result = new BasicEList();
        EList<AbstractInterfaceItem> ownIfItems = this.getOwnInterfaceItems(this.getModelComponent());
        for (MessageFromIf mif : this.triggerstring2mif.values()) {
            if (!ownIfItems.contains((Object)mif.getFrom())) continue;
            result.add((Object)mif);
        }
        Collections.sort(result, new Comparator<MessageFromIf>(){

            @Override
            public int compare(MessageFromIf o1, MessageFromIf o2) {
                return ExpandedModelComponentImpl.this.getTriggerCodeName(o1).compareTo(ExpandedModelComponentImpl.this.getTriggerCodeName(o2));
            }
        });
        return result;
    }

    @Override
    public String getMessageID(MessageFromIf mif) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransitionChain getChain(Transition trans) {
        if (trans == null) {
            return null;
        }
        TransitionChainBundle tcb = (TransitionChainBundle)this.trans2chainBundle.get(trans);
        if (tcb == null || tcb.chains.isEmpty()) {
            return null;
        }
        return (TransitionChain)tcb.chains.get(0);
    }

    @Override
    public EList<TransitionChain> getChains(Transition trans) {
        TransitionChainBundle tcb = (TransitionChainBundle)this.trans2chainBundle.get(trans);
        if (tcb == null) {
            new BasicEList();
        }
        return tcb.chains;
    }

    @Override
    public EObject getData(Transition trans) {
        if (trans == null) {
            return null;
        }
        TransitionChainBundle tcb = (TransitionChainBundle)this.trans2chainBundle.get(trans);
        if (tcb == null || tcb.chains.isEmpty()) {
            return null;
        }
        if (tcb.chains.size() == 1) {
            return ((TransitionChain)tcb.chains.get(0)).getData();
        }
        return tcb.commonData;
    }

    @Override
    public EList<EObject> getIncomingMessages(AbstractInterfaceItem ifitem) {
        return ifitem.getAllIncomingAbstractMessages();
    }

    @Override
    public TransitionChain addTransitionChain(Transition t) {
        TransitionChain tc = FsmGenFactory.eINSTANCE.createTransitionChain();
        tc.setTransition(t);
        this.collectChainTransitions(tc, t);
        this.trchains.add(tc);
        return tc;
    }

    @Override
    public EList<TransitionChain> getTransitionChains() {
        return new BasicEList(this.trchains);
    }

    @Override
    public EList<TransitionChain> getOwnTransitionChains() {
        BasicEList result = new BasicEList();
        for (TransitionChain tc : this.trchains) {
            if (this.targetsOfRefinedTransitions.contains(tc.getTransition()) || !this.isOwnObject((StateGraphItem)tc.getTransition())) continue;
            result.add((Object)tc);
        }
        Collections.sort(result, new Comparator<TransitionChain>(){

            @Override
            public int compare(TransitionChain o1, TransitionChain o2) {
                return ExpandedModelComponentImpl.this.fsmNameProvider.getFullPath((StateGraphItem)o1.getTransition()).compareTo(ExpandedModelComponentImpl.this.fsmNameProvider.getFullPath((StateGraphItem)o2.getTransition()));
            }
        });
        return result;
    }

    @Override
    public EList<AbstractInterfaceItem> getOwnInterfaceItems(ModelComponent mc) {
        return mc.getAbstractInterfaceItems();
    }

    @Override
    public EList<AbstractInterfaceItem> getAllInterfaceItems() {
        return this.getModelComponent().getAllAbstractInterfaceItems();
    }

    private StateGraphNode getAdjustedTargetNode(Transition t) {
        NodeData data;
        StateGraphNode node = this.fsmHelpers.getNode(t.getTo());
        if (node instanceof EntryPoint && ((data = this.node2data.get(node)) == null || data.getOutTrans().isEmpty()) && this.getModelComponent((EObject)node).isAbstract() && node.eContainer().eContainer() instanceof State) {
            State newTarget = (State)node.eContainer().eContainer();
            StateTerminal st = FSMFactory.eINSTANCE.createStateTerminal();
            st.setState(newTarget);
            t.setTo((TransitionTerminal)st);
            node = newTarget;
        }
        return node;
    }

    private ModelComponent getModelComponent(EObject node) {
        node = this.copy2orig.get(node);
        while (node != null) {
            if (node instanceof ModelComponent) {
                return (ModelComponent)node;
            }
            node = node.eContainer();
        }
        return null;
    }

    @Override
    public boolean isMatching(Trigger trig, String trigstr) {
        for (MessageFromIf mifp2 : trig.getMsgFromIfPairs()) {
            String tr2 = this.getTriggerString(mifp2);
            if (!tr2.equals(trigstr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContinuationTransition getDefaultBranch(EList<Transition> out) {
        return this.getDefaultBranch((List<Transition>)out);
    }

    @Override
    public EObject getOrig(EObject copy) {
        return this.copy2orig.get(copy);
    }

    @Override
    public EObject getCopy(EObject orig) {
        return this.orig2copy.get(orig);
    }

    @Override
    public String getModelComponentName() {
        return this.getModelComponent().getComponentName();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetStateMachine(null, msgs);
            }
            case 2: {
                return ((InternalEList)this.getTransitionChains()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    private ContinuationTransition getDefaultBranch(List<Transition> out) {
        for (Transition t : out) {
            if (!(t instanceof ContinuationTransition)) continue;
            return (ContinuationTransition)t;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getModelComponent();
                }
                return this.basicGetModelComponent();
            }
            case 1: {
                return this.getStateMachine();
            }
            case 2: {
                return this.getTransitionChains();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setModelComponent((ModelComponent)newValue);
                return;
            }
            case 1: {
                this.setStateMachine((StateGraph)newValue);
                return;
            }
            case 2: {
                this.getTransitionChains().clear();
                this.getTransitionChains().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setModelComponent(null);
                return;
            }
            case 1: {
                this.setStateMachine(null);
                return;
            }
            case 2: {
                this.getTransitionChains().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.modelComponent != null;
            }
            case 1: {
                return this.stateMachine != null;
            }
            case 2: {
                return this.transitionChains != null && !this.transitionChains.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    private static class NodeData {
        private LinkedList<Transition> inTrans = new LinkedList();
        private LinkedList<Transition> outTrans = new LinkedList();
        private LinkedList<Transition> loopTrans = null;

        private NodeData() {
        }

        LinkedList<Transition> getInTrans() {
            return this.inTrans;
        }

        LinkedList<Transition> getOutTrans() {
            return this.outTrans;
        }

        LinkedList<Transition> getLoopTransitions() {
            if (this.loopTrans == null) {
                this.loopTrans = new LinkedList();
                for (Transition t : this.getOutTrans()) {
                    NonInitialTransition tr = (NonInitialTransition)t;
                    if (tr.getFrom() instanceof StateTerminal) {
                        if (!(tr.getTo() instanceof StateTerminal) || ((StateTerminal)tr.getFrom()).getState() != ((StateTerminal)tr.getTo()).getState()) continue;
                        this.loopTrans.add((Transition)tr);
                        continue;
                    }
                    if (!(tr.getFrom() instanceof TrPointTerminal) || !(tr.getTo() instanceof TrPointTerminal) || ((TrPointTerminal)tr.getFrom()).getTrPoint() != ((TrPointTerminal)tr.getTo()).getTrPoint()) continue;
                    this.loopTrans.add((Transition)tr);
                }
            }
            return this.loopTrans;
        }
    }

    protected static class TransitionChainBundle {
        private BasicEList<TransitionChain> chains = new BasicEList();
        private EObject commonData = null;

        protected TransitionChainBundle() {
        }
    }

    protected class TransitionToChainBundleMap
    extends HashMap<Transition, TransitionChainBundle> {
        private static final long serialVersionUID = 1L;

        protected TransitionToChainBundleMap() {
        }

        @Override
        void put(Transition t, TransitionChain tc) {
            TransitionChainBundle tcb = (TransitionChainBundle)this.get(t);
            if (tcb == null) {
                tcb = new TransitionChainBundle();
                this.put(t, tcb);
            }
            tcb.chains.add((Object)tc);
        }
    }
}

