/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm.fsmgen.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionChainStartTransition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenPackage;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ITransitionChainVisitor;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.TransitionChain;

public class TransitionChainImpl
extends MinimalEObjectImpl.Container
implements TransitionChain {
    private FSMHelpers fsmHelpers = new FSMHelpers();
    private FSMNameProvider fsmNameProvider = new FSMNameProvider();
    protected Transition transition;
    protected EObject data;

    protected TransitionChainImpl() {
    }

    protected EClass eStaticClass() {
        return FsmGenPackage.Literals.TRANSITION_CHAIN;
    }

    @Override
    public Transition getTransition() {
        if (this.transition != null && this.transition.eIsProxy()) {
            InternalEObject oldTransition = (InternalEObject)this.transition;
            this.transition = (Transition)this.eResolveProxy(oldTransition);
            if (this.transition != oldTransition && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldTransition, (Object)this.transition));
            }
        }
        return this.transition;
    }

    public Transition basicGetTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(Transition newTransition) {
        Transition oldTransition = this.transition;
        this.transition = newTransition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldTransition, (Object)this.transition));
        }
    }

    @Override
    public EObject getData() {
        if (this.data != null && this.data.eIsProxy()) {
            InternalEObject oldData = (InternalEObject)this.data;
            this.data = this.eResolveProxy(oldData);
            if (this.data != oldData && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldData, (Object)this.data));
            }
        }
        return this.data;
    }

    public EObject basicGetData() {
        return this.data;
    }

    @Override
    public void setData(EObject newData) {
        EObject oldData = this.data;
        this.data = newData;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldData, (Object)this.data));
        }
    }

    @Override
    public State getStateContext() {
        if (this.getTransition().eContainer().eContainer() instanceof State) {
            return (State)this.getTransition().eContainer().eContainer();
        }
        return null;
    }

    @Override
    public boolean isHandler() {
        if (this.getTransition() instanceof TransitionChainStartTransition) {
            TrPoint tp;
            TransitionChainStartTransition trans = (TransitionChainStartTransition)this.getTransition();
            if (trans.getFrom() instanceof TrPointTerminal) {
                TrPoint tp2 = ((TrPointTerminal)trans.getFrom()).getTrPoint();
                if (tp2 instanceof TransitionPoint) {
                    return ((TransitionPoint)tp2).isHandler();
                }
            } else if (trans.getFrom() instanceof SubStateTrPointTerminal && (tp = ((SubStateTrPointTerminal)trans.getFrom()).getTrPoint()) instanceof TransitionPoint) assert (false) : "not allowed to connect TransitionPoint to exterior";
        }
        return false;
    }

    @Override
    public String genExecuteChain(ITransitionChainVisitor tcv) {
        ExpandedModelComponent emc = this.getExpandedModelComponent();
        StringBuilder result = new StringBuilder();
        result.append(tcv.genTypedData(this));
        this.genChainCode(this.getTransition(), emc, tcv, result);
        return result.toString();
    }

    private void genChainCode(Transition tr, ExpandedModelComponent emc, ITransitionChainVisitor tcv, StringBuilder result) {
        result.append(tcv.genActionOperationCall(tr));
        StateGraphNode node = this.fsmHelpers.getNode(tr.getTo());
        EList<Transition> out = emc.getOutgoingTransitions(node);
        if (node instanceof ChoicePoint) {
            ContinuationTransition dflt = emc.getDefaultBranch(out);
            assert (dflt != null) : "ChoicePoint " + this.fsmNameProvider.getFullPath((StateGraphItem)node) + " has no default branch!";
            boolean isFirst = true;
            for (Transition cond : out) {
                if (cond == dflt) continue;
                assert (cond instanceof CPBranchTransition) : "The non default ChoicePoint branch " + this.fsmNameProvider.getFullPath((StateGraphItem)cond) + " must be of type CPBranchTransition!";
                result.append(tcv.genElseIfBranch((CPBranchTransition)cond, isFirst));
                isFirst = false;
                this.genChainCode(cond, emc, tcv, result);
            }
            result.append(tcv.genElseBranch(dflt));
            this.genChainCode((Transition)dflt, emc, tcv, result);
            result.append(tcv.genEndIf());
        } else if (node instanceof TrPoint) {
            if (node instanceof TransitionPoint) {
                result.append(tcv.genReturnState(this.getStateContext(), false));
                return;
            }
            assert (out.size() <= 1) : "TrPoint " + this.fsmNameProvider.getFullPath((StateGraphItem)node) + " is expected to have at most one outgoing transition!";
            if (out.size() == 1) {
                State state;
                State state2 = state = node.eContainer().eContainer() instanceof State ? (State)node.eContainer().eContainer() : null;
                if (node instanceof EntryPoint) {
                    if (state != null && emc.isOwnObject((StateGraphItem)state) && state.getEntryCode() != null && !state.getEntryCode().getLines().isEmpty()) {
                        result.append(tcv.genEntryOperationCall(state));
                    }
                } else if (node instanceof ExitPoint) {
                    if (state != null && emc.isOwnObject((StateGraphItem)state) && state.getExitCode() != null && !state.getExitCode().getLines().isEmpty()) {
                        result.append(tcv.genExitOperationCall(state));
                    }
                } else assert (false) : "unexpected sub type";
            }
            this.genChainCode((Transition)out.get(0), emc, tcv, result);
        } else {
            assert (node instanceof State) : "A transition target can be a ChoicePoint, a TrPoint or a State!";
            result.append(tcv.genReturnState((State)node, true));
        }
    }

    private ExpandedModelComponent getExpandedModelComponent() {
        Transition obj = this.getTransition();
        while (obj != null) {
            if (!((obj = obj.eContainer()) instanceof ExpandedModelComponent)) continue;
            return (ExpandedModelComponent)obj;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getTransition();
                }
                return this.basicGetTransition();
            }
            case 1: {
                if (resolve) {
                    return this.getData();
                }
                return this.basicGetData();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setTransition((Transition)newValue);
                return;
            }
            case 1: {
                this.setData((EObject)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setTransition(null);
                return;
            }
            case 1: {
                this.setData(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.transition != null;
            }
            case 1: {
                return this.data != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

