/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.naming;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.util.BaseSwitch;
import org.eclipse.etrice.core.common.naming.BaseFragmentProvider;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.FSMModel;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.util.FSMSwitch;
import org.eclipse.xtext.resource.IFragmentProvider;

public class FSMFragmentProvider
extends BaseFragmentProvider {
    protected static final char TYPE_SEP = ':';
    protected static final char SEP = '$';
    private static final String INIT_TRANS = "initial";
    private static final String STATE_GRAPH = "sg";
    private CombinedPathProvider fsmPathProvider = new CombinedPathProvider();

    public String getFragment(EObject obj, IFragmentProvider.Fallback fallback) {
        String path = (String)this.fsmPathProvider.doSwitch(obj);
        if (path != null) {
            return String.valueOf(obj.eClass().getName()) + ':' + path;
        }
        return fallback.getFragment(obj);
    }

    public EObject getEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        FSMModel model;
        EObject result;
        if (!resource.getContents().isEmpty() && (result = this.getEObject(model = (FSMModel)resource.getContents().get(0), fragment)) != null) {
            return result;
        }
        return fallback.getEObject(fragment);
    }

    private EObject getEObject(FSMModel model, String fragment) {
        int begin = 0;
        int end = fragment.indexOf(58);
        if (end < 0) {
            return null;
        }
        String type = fragment.substring(begin, end);
        begin = end + 1;
        if ((end = fragment.indexOf(36, begin)) < 0) {
            end = fragment.length();
        }
        String className = fragment.substring(begin, end);
        ModelComponent mc = this.getModelComponent(model, className);
        if (type.equals(FSMPackage.eINSTANCE.getModelComponent().getName())) {
            return mc;
        }
        if (end < fragment.length()) {
            String remainder = fragment.substring(end + 1, fragment.length());
            if (type.equals("BaseState") || type.equals(FSMPackage.eINSTANCE.getSimpleState().getName()) || type.equals(FSMPackage.eINSTANCE.getRefinedState().getName())) {
                return this.getState(mc, remainder);
            }
            if (type.equals(FSMPackage.eINSTANCE.getTransitionPoint().getName()) || type.equals(FSMPackage.eINSTANCE.getEntryPoint().getName()) || type.equals(FSMPackage.eINSTANCE.getExitPoint().getName())) {
                return this.getTrPoint(mc, remainder);
            }
            if (type.equals(FSMPackage.eINSTANCE.getChoicePoint().getName())) {
                return this.getChoicePoint(mc, remainder);
            }
            if (type.equals(FSMPackage.eINSTANCE.getInitialTransition().getName())) {
                return this.getInitialTransition(mc, remainder);
            }
            if (type.equals(FSMPackage.eINSTANCE.getRefinedTransition().getName())) {
                return this.getRefinedTransition(mc, remainder);
            }
            if (type.equals(FSMPackage.eINSTANCE.getContinuationTransition().getName()) || type.equals(FSMPackage.eINSTANCE.getCPBranchTransition().getName()) || type.equals(FSMPackage.eINSTANCE.getTriggeredTransition().getName()) || type.equals(FSMPackage.eINSTANCE.getGuardedTransition().getName())) {
                return this.getTransition(mc, remainder);
            }
            if (type.equals(FSMPackage.eINSTANCE.getStateGraph().getName()) || type.equals("StateMachine")) {
                return this.getStateGraph(mc, remainder);
            }
        }
        return null;
    }

    public static boolean isState(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith("BaseState")) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getSimpleState().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getRefinedState().getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTrPoint(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getTransitionPoint().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getEntryPoint().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getExitPoint().getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChoicePoint(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(FSMPackage.eINSTANCE.getChoicePoint().getName());
    }

    public static boolean isStateGraph(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(FSMPackage.eINSTANCE.getStateGraph().getName());
    }

    public static boolean isTransition(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getInitialTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getContinuationTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getCPBranchTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getTriggeredTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(FSMPackage.eINSTANCE.getRefinedTransition().getName())) {
                return true;
            }
        }
        return false;
    }

    private ModelComponent getModelComponent(FSMModel model, String className) {
        for (ModelComponent dc : model.getComponents()) {
            if (dc.getComponentName() == null || !dc.getComponentName().equals(className)) continue;
            return dc;
        }
        return null;
    }

    protected Transition getTransition(ModelComponent mc, String remainder) {
        StateGraph sg = this.getStateGraph(mc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (Transition t : sg.getTransitions()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected InitialTransition getInitialTransition(ModelComponent mc, String remainder) {
        StateGraph sg = this.getStateGraph(mc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        if (name.equals(INIT_TRANS)) {
            for (Transition t : sg.getTransitions()) {
                if (!(t instanceof InitialTransition)) continue;
                return (InitialTransition)t;
            }
        }
        return null;
    }

    protected RefinedTransition getRefinedTransition(ModelComponent mc, String remainder) {
        StateGraph sg = this.getStateGraph(mc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (RefinedTransition t : sg.getRefinedTransitions()) {
            if (!t.getTarget().getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected ChoicePoint getChoicePoint(ModelComponent mc, String remainder) {
        StateGraph sg = this.getStateGraph(mc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (ChoicePoint cp : sg.getChPoints()) {
            if (!cp.getName().equals(name)) continue;
            return cp;
        }
        return null;
    }

    protected TrPoint getTrPoint(ModelComponent mc, String remainder) {
        StateGraph sg = this.getStateGraph(mc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (TrPoint tp : sg.getTrPoints()) {
            if (!tp.getName().equals(name)) continue;
            return tp;
        }
        return null;
    }

    protected State getState(ModelComponent mc, String remainder) {
        StateGraph sg = this.getStateGraph(mc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (State s : sg.getStates()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    protected StateGraph getStateGraph(ModelComponent mc, String remainder) {
        StateGraph sg = mc.getStateMachine();
        if (sg == null) {
            mc.setStateMachine(FSMFactory.eINSTANCE.createStateGraph());
            sg = mc.getStateMachine();
        }
        int begin = 0;
        int end = remainder.indexOf(36);
        while (end >= 0) {
            String name = remainder.substring(begin, end);
            boolean found = false;
            for (State s : sg.getStates()) {
                if (!s.getName().equals(name)) continue;
                sg = s.getSubgraph();
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            begin = end + 1;
            end = remainder.indexOf(36, begin);
        }
        return sg;
    }

    protected class BasePathProvider
    extends BaseSwitch<String> {
        public String caseAnnotationType(AnnotationType object) {
            return object.getName();
        }
    }

    private class CombinedPathProvider
    extends ComposedSwitch<String> {
        public CombinedPathProvider() {
            this.addSwitch((Switch)new BasePathProvider());
            this.addSwitch(new FSMPathProvider((Switch<String>)this));
        }
    }

    protected class FSMPathProvider
    extends FSMSwitch<String> {
        private Switch<String> topSwitch;

        public FSMPathProvider(Switch<String> topSwitch) {
            this.topSwitch = topSwitch;
        }

        @Override
        public String caseModelComponent(ModelComponent mc) {
            return mc.getComponentName();
        }

        @Override
        public String caseState(State s) {
            return String.valueOf((String)this.topSwitch.doSwitch(s.eContainer().eContainer())) + '$' + s.getName();
        }

        @Override
        public String caseTrPoint(TrPoint trp) {
            return String.valueOf((String)this.topSwitch.doSwitch(trp.eContainer().eContainer())) + '$' + trp.getName();
        }

        @Override
        public String caseChoicePoint(ChoicePoint cp) {
            return String.valueOf((String)this.topSwitch.doSwitch(cp.eContainer().eContainer())) + '$' + cp.getName();
        }

        @Override
        public String caseInitialTransition(InitialTransition t) {
            return String.valueOf((String)this.topSwitch.doSwitch(t.eContainer().eContainer())) + '$' + FSMFragmentProvider.INIT_TRANS;
        }

        @Override
        public String caseNonInitialTransition(NonInitialTransition t) {
            return String.valueOf((String)this.topSwitch.doSwitch(t.eContainer().eContainer())) + '$' + t.getName();
        }

        @Override
        public String caseRefinedTransition(RefinedTransition t) {
            return String.valueOf((String)this.topSwitch.doSwitch(t.eContainer().eContainer())) + '$' + t.getTarget().getName();
        }

        @Override
        public String caseStateGraph(StateGraph sg) {
            return String.valueOf((String)this.topSwitch.doSwitch(sg.eContainer())) + '$' + FSMFragmentProvider.STATE_GRAPH;
        }
    }
}

