/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class FSMValidationUtilXtend {
    @Inject
    @Extension
    private FSMNameProvider _fSMNameProvider;

    public ArrayList<Result> uniqueOriginTriggers(final State myState) {
        StateGraph parent = this.getStateGraph(myState);
        HashMap trig2trans = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Result[0]);
        EList<Transition> _transitions = parent.getTransitions();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition t) {
                boolean _and = false;
                if (!(t instanceof TriggeredTransition) || !(((TriggeredTransition)t).getFrom() instanceof StateTerminal)) {
                    _and = false;
                } else {
                    boolean _equals;
                    TransitionTerminal _from = ((TriggeredTransition)t).getFrom();
                    State _state = ((StateTerminal)_from).getState();
                    _and = _equals = Objects.equal((Object)myState, (Object)_state);
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter(_transitions, (Functions.Function1)_function);
        for (Transition t : _filter) {
            EList<Trigger> _triggers = ((TriggeredTransition)t).getTriggers();
            Functions.Function1<Trigger, Boolean> _function_1 = new Functions.Function1<Trigger, Boolean>(){

                public Boolean apply(Trigger k) {
                    Guard _guard = k.getGuard();
                    return Objects.equal((Object)_guard, null);
                }
            };
            Iterable _filter_1 = IterableExtensions.filter(_triggers, (Functions.Function1)_function_1);
            for (Trigger k : _filter_1) {
                EList<MessageFromIf> _msgFromIfPairs = k.getMsgFromIfPairs();
                for (MessageFromIf specMethod : _msgFromIfPairs) {
                    String triggerName = this.getTriggerName(specMethod);
                    boolean _containsKey = trig2trans.containsKey(triggerName);
                    if (_containsKey) {
                        TriggeredTransition ot = (TriggeredTransition)trig2trans.get(triggerName);
                        Result _error = Result.error("Triggers originating from a state should be unique.", t, (EStructuralFeature)FSMPackage.Literals.TRIGGERED_TRANSITION__TRIGGERS);
                        result.add(_error);
                        Result _error_1 = Result.error("Triggers originating from a state should be unique.", ot, (EStructuralFeature)FSMPackage.Literals.TRIGGERED_TRANSITION__TRIGGERS);
                        result.add(_error_1);
                    }
                    trig2trans.put(triggerName, (TriggeredTransition)t);
                }
            }
        }
        return result;
    }

    private String getTriggerName(MessageFromIf mif) {
        AbstractInterfaceItem _from = mif.getFrom();
        String _name = _from.getName();
        String _plus = String.valueOf(_name) + "#";
        EObject _message = mif.getMessage();
        String _messageName = this._fSMNameProvider.getMessageName(_message);
        return String.valueOf(_plus) + _messageName;
    }

    public StateGraph getStateGraph(EObject obj) {
        EObject parent = obj.eContainer();
        while (!Objects.equal((Object)parent, null)) {
            EObject _eContainer;
            if (parent instanceof StateGraph) {
                return (StateGraph)parent;
            }
            parent = _eContainer = parent.eContainer();
        }
        return null;
    }

    public static class Result {
        private boolean ok;
        private String msg;
        private EObject source;
        private EStructuralFeature feature;
        private int index;

        public static Result ok() {
            return new Result(true, "", null, null, 0);
        }

        public static Result error(String msg) {
            return new Result(false, msg, null, null, -1);
        }

        public static Result error(String msg, EObject source, EStructuralFeature feature) {
            return new Result(false, msg, source, feature, -1);
        }

        public static Result error(String msg, EObject source, EStructuralFeature feature, int index) {
            return new Result(false, msg, source, feature, index);
        }

        public Result(boolean ok, String msg, EObject source, EStructuralFeature feature, int index) {
            this.ok = ok;
            this.msg = msg;
            this.source = source;
            this.feature = feature;
            this.index = index;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getMsg() {
            return this.msg;
        }

        public EObject getSource() {
            return this.source;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

