/**
 * Copyright (c) 2012 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Juergen Haug (initial contribution)
 */
package org.eclipse.etrice.core.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

/**
 * This post processor adds documentation to the generated EMF model.
 * By intention no {@code null} checks are performed. This way developers
 * find easier if the referenced class, attribute or reference isn't found.
 */
@SuppressWarnings("all")
public class DocuPostprocessor {
  public void process(final GeneratedMetamodel metamodel) {
    final EPackage pckg = metamodel.getEPackage();
    EClass cls = PostprocessingHelpers.getClass(pckg, "RoomModel");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("The root object for the ROOM model. It gives access to {@link Import imports} and");
    _builder.newLine();
    _builder.append("the {@link SubSystemClass sub system},");
    _builder.newLine();
    _builder.append("{@link ActorClass actor}, {@link ProtocolClass protocol} and");
    _builder.newLine();
    _builder.append("{@link DataClass data} classes defined.");
    _builder.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder.toString());
    EAttribute _attribute = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("The model name is a dot separated fully qualified name and is");
    _builder_1.newLine();
    _builder_1.append("used to provide a name space. The generators may use that also");
    _builder_1.newLine();
    _builder_1.append("to place the generated code into separate directories.");
    _builder_1.newLine();
    PostprocessingHelpers.setDocumentation(_attribute, _builder_1.toString());
    EReference _reference = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("This is an optional documentation.");
    _builder_2.newLine();
    PostprocessingHelpers.setDocumentation(_reference, _builder_2.toString());
    EReference _reference_1 = PostprocessingHelpers.getReference(cls, "imports");
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("This is a list of all imported models.");
    _builder_3.newLine();
    PostprocessingHelpers.setDocumentation(_reference_1, _builder_3.toString());
    EReference _reference_2 = PostprocessingHelpers.getReference(cls, "primitiveTypes");
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("This is a list of all primitive types defined by this model.");
    _builder_4.newLine();
    PostprocessingHelpers.setDocumentation(_reference_2, _builder_4.toString());
    EReference _reference_3 = PostprocessingHelpers.getReference(cls, "externalTypes");
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("This is a list of all external types defined by this model.");
    _builder_5.newLine();
    PostprocessingHelpers.setDocumentation(_reference_3, _builder_5.toString());
    EReference _reference_4 = PostprocessingHelpers.getReference(cls, "dataClasses");
    StringConcatenation _builder_6 = new StringConcatenation();
    _builder_6.append("This is a list of all data classes defined by this model.");
    _builder_6.newLine();
    PostprocessingHelpers.setDocumentation(_reference_4, _builder_6.toString());
    EReference _reference_5 = PostprocessingHelpers.getReference(cls, "protocolClasses");
    StringConcatenation _builder_7 = new StringConcatenation();
    _builder_7.append("This is a list of all protocol classes defined by this model.");
    _builder_7.newLine();
    PostprocessingHelpers.setDocumentation(_reference_5, _builder_7.toString());
    EReference _reference_6 = PostprocessingHelpers.getReference(cls, "actorClasses");
    StringConcatenation _builder_8 = new StringConcatenation();
    _builder_8.append("This is a list of all actor classes defined by this model.");
    _builder_8.newLine();
    PostprocessingHelpers.setDocumentation(_reference_6, _builder_8.toString());
    EReference _reference_7 = PostprocessingHelpers.getReference(cls, "subSystemClasses");
    StringConcatenation _builder_9 = new StringConcatenation();
    _builder_9.append("This is a list of all sub system classes defined by this model.");
    _builder_9.newLine();
    PostprocessingHelpers.setDocumentation(_reference_7, _builder_9.toString());
    EReference _reference_8 = PostprocessingHelpers.getReference(cls, "systems");
    StringConcatenation _builder_10 = new StringConcatenation();
    _builder_10.append("This is a list of all logical systems defined by this model.");
    _builder_10.newLine();
    PostprocessingHelpers.setDocumentation(_reference_8, _builder_10.toString());
    EClass _class = PostprocessingHelpers.getClass(pckg, "RoomClass");
    cls = _class;
    StringConcatenation _builder_11 = new StringConcatenation();
    _builder_11.append("This class is the super class of all classes");
    _builder_11.newLine();
    _builder_11.append("of the ROOM class model:");
    _builder_11.newLine();
    _builder_11.append("<ul>");
    _builder_11.newLine();
    _builder_11.append("  ");
    _builder_11.append("<li>{@link DataType}</li>");
    _builder_11.newLine();
    _builder_11.append("  ");
    _builder_11.append("<li>{@link GeneralProtocolClass}</li>");
    _builder_11.newLine();
    _builder_11.append("  ");
    _builder_11.append("<li>{@link StructureClass}</li>");
    _builder_11.newLine();
    _builder_11.append("</ul>");
    _builder_11.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_11.toString());
    EReference _reference_9 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_12 = new StringConcatenation();
    _builder_12.append("This is an optional documentation.");
    _builder_12.newLine();
    PostprocessingHelpers.setDocumentation(_reference_9, _builder_12.toString());
    EClass _class_1 = PostprocessingHelpers.getClass(pckg, "StructureClass");
    cls = _class_1;
    StringConcatenation _builder_13 = new StringConcatenation();
    _builder_13.append("This class is the super class of the structural classes");
    _builder_13.newLine();
    _builder_13.append("<ul>");
    _builder_13.newLine();
    _builder_13.append("  ");
    _builder_13.append("<li>{@link ActorContainerClass}</li>");
    _builder_13.newLine();
    _builder_13.append("  ");
    _builder_13.append("<li>{@link LogicalSystem}</li>");
    _builder_13.newLine();
    _builder_13.append("</ul>");
    _builder_13.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_13.toString());
    EReference _reference_10 = PostprocessingHelpers.getReference(cls, "annotations");
    StringConcatenation _builder_14 = new StringConcatenation();
    _builder_14.append("This is a list of structure class annotations.");
    _builder_14.newLine();
    PostprocessingHelpers.setDocumentation(_reference_10, _builder_14.toString());
    EReference _reference_11 = PostprocessingHelpers.getReference(cls, "bindings");
    StringConcatenation _builder_15 = new StringConcatenation();
    _builder_15.append("This is a list of structure class bindings.");
    _builder_15.newLine();
    PostprocessingHelpers.setDocumentation(_reference_11, _builder_15.toString());
    EReference _reference_12 = PostprocessingHelpers.getReference(cls, "connections");
    StringConcatenation _builder_16 = new StringConcatenation();
    _builder_16.append("This is a list of structure class connections.");
    _builder_16.newLine();
    PostprocessingHelpers.setDocumentation(_reference_12, _builder_16.toString());
    EClass _class_2 = PostprocessingHelpers.getClass(pckg, "ActorContainerClass");
    cls = _class_2;
    StringConcatenation _builder_17 = new StringConcatenation();
    _builder_17.append("This class is the super class of the structural classes");
    _builder_17.newLine();
    _builder_17.append("<ul>");
    _builder_17.newLine();
    _builder_17.append("  ");
    _builder_17.append("<li>{@link ActorClass}</li>");
    _builder_17.newLine();
    _builder_17.append("  ");
    _builder_17.append("<li>{@link SubSystemClass}</li>");
    _builder_17.newLine();
    _builder_17.append("</ul>");
    _builder_17.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_17.toString());
    EReference _reference_13 = PostprocessingHelpers.getReference(cls, "serviceProvisionPoints");
    StringConcatenation _builder_18 = new StringConcatenation();
    _builder_18.append("This is a list of all interface SPPs.");
    _builder_18.newLine();
    PostprocessingHelpers.setDocumentation(_reference_13, _builder_18.toString());
    EReference _reference_14 = PostprocessingHelpers.getReference(cls, "actorRefs");
    StringConcatenation _builder_19 = new StringConcatenation();
    _builder_19.append("This is a list of all actor refs.");
    _builder_19.newLine();
    PostprocessingHelpers.setDocumentation(_reference_14, _builder_19.toString());
    EReference _reference_15 = PostprocessingHelpers.getReference(cls, "userCode1");
    StringConcatenation _builder_20 = new StringConcatenation();
    _builder_20.append("The user code is treated in a generator dependent way.");
    _builder_20.newLine();
    PostprocessingHelpers.setDocumentation(_reference_15, _builder_20.toString());
    EReference _reference_16 = PostprocessingHelpers.getReference(cls, "userCode2");
    StringConcatenation _builder_21 = new StringConcatenation();
    _builder_21.append("The user code is treated in a generator dependent way.");
    _builder_21.newLine();
    PostprocessingHelpers.setDocumentation(_reference_16, _builder_21.toString());
    EReference _reference_17 = PostprocessingHelpers.getReference(cls, "userCode3");
    StringConcatenation _builder_22 = new StringConcatenation();
    _builder_22.append("The user code is treated in a generator dependent way.");
    _builder_22.newLine();
    PostprocessingHelpers.setDocumentation(_reference_17, _builder_22.toString());
    EClass _class_3 = PostprocessingHelpers.getClass(pckg, "VarDecl");
    cls = _class_3;
    StringConcatenation _builder_23 = new StringConcatenation();
    _builder_23.append("A variable declaration consists of a name and a type.");
    _builder_23.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_23.toString());
    EAttribute _attribute_1 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_24 = new StringConcatenation();
    _builder_24.append("By this name the variable is referred to in the model.");
    _builder_24.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_1, _builder_24.toString());
    EReference _reference_18 = PostprocessingHelpers.getReference(cls, "refType");
    StringConcatenation _builder_25 = new StringConcatenation();
    _builder_25.append("This is the data type of the variable.");
    _builder_25.newLine();
    PostprocessingHelpers.setDocumentation(_reference_18, _builder_25.toString());
    EClass _class_4 = PostprocessingHelpers.getClass(pckg, "RefableType");
    cls = _class_4;
    StringConcatenation _builder_26 = new StringConcatenation();
    _builder_26.append("This is a type with an optional reference attribute.");
    _builder_26.newLine();
    _builder_26.append("If \'ref\' is {@code true} then by reference semantic is chosen.");
    _builder_26.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_26.toString());
    EReference _reference_19 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_27 = new StringConcatenation();
    _builder_27.append("This is the data type.");
    _builder_27.newLine();
    PostprocessingHelpers.setDocumentation(_reference_19, _builder_27.toString());
    EAttribute _attribute_2 = PostprocessingHelpers.getAttribute(cls, "ref");
    StringConcatenation _builder_28 = new StringConcatenation();
    _builder_28.append("If {@code true} then by reference semantics is chosen, by value semantics else.");
    _builder_28.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_2, _builder_28.toString());
    EClass _class_5 = PostprocessingHelpers.getClass(pckg, "DataType");
    cls = _class_5;
    StringConcatenation _builder_29 = new StringConcatenation();
    _builder_29.append("The super class of");
    _builder_29.newLine();
    _builder_29.append("<ul>");
    _builder_29.newLine();
    _builder_29.append("  ");
    _builder_29.append("<li>{@link PrimitiveType}</li>");
    _builder_29.newLine();
    _builder_29.append("  ");
    _builder_29.append("<li>{@link EnumerationType}</li>");
    _builder_29.newLine();
    _builder_29.append("  ");
    _builder_29.append("<li>{@link ComplexType}</li>");
    _builder_29.newLine();
    _builder_29.append("</ul>");
    _builder_29.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_29.toString());
    EClass _class_6 = PostprocessingHelpers.getClass(pckg, "EnumerationType");
    cls = _class_6;
    StringConcatenation _builder_30 = new StringConcatenation();
    _builder_30.append("A sub type of {@link DataType} for enumerations.");
    _builder_30.newLine();
    _builder_30.append("The EnumerationType can be associated with a {@link PrimitiveType} as value type for");
    _builder_30.newLine();
    _builder_30.append("the {@link EnumLiteral}s. It has to contain at least one literal.");
    _builder_30.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_30.toString());
    EReference _reference_20 = PostprocessingHelpers.getReference(cls, "primitiveType");
    StringConcatenation _builder_31 = new StringConcatenation();
    _builder_31.append("The value type of the literals.");
    _builder_31.newLine();
    PostprocessingHelpers.setDocumentation(_reference_20, _builder_31.toString());
    EClass _class_7 = PostprocessingHelpers.getClass(pckg, "EnumLiteral");
    cls = _class_7;
    StringConcatenation _builder_32 = new StringConcatenation();
    _builder_32.append("A literal value of the enumeration.");
    _builder_32.newLine();
    _builder_32.append("It can have a value associated.");
    _builder_32.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_32.toString());
    EAttribute _attribute_3 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_33 = new StringConcatenation();
    _builder_33.append("The name of the literal.");
    _builder_33.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_3, _builder_33.toString());
    EReference _reference_21 = PostprocessingHelpers.getReference(cls, "literal");
    StringConcatenation _builder_34 = new StringConcatenation();
    _builder_34.append("The value of the literal. It is associated with a target type which defaults to");
    _builder_34.newLine();
    _builder_34.append("{@code int} and can be set explicitly using the {@link EnumerationType#getPrimitiveType()}");
    _builder_34.newLine();
    PostprocessingHelpers.setDocumentation(_reference_21, _builder_34.toString());
    EClass _class_8 = PostprocessingHelpers.getClass(pckg, "ComplexType");
    cls = _class_8;
    StringConcatenation _builder_35 = new StringConcatenation();
    _builder_35.append("The super class of");
    _builder_35.newLine();
    _builder_35.append("<ul>");
    _builder_35.newLine();
    _builder_35.append("  ");
    _builder_35.append("<li>{@link DataClass}</li>");
    _builder_35.newLine();
    _builder_35.append("  ");
    _builder_35.append("<li>{@link ExternalType}</li>");
    _builder_35.newLine();
    _builder_35.append("</ul>");
    _builder_35.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_35.toString());
    EClass _class_9 = PostprocessingHelpers.getClass(pckg, "PrimitiveType");
    cls = _class_9;
    StringConcatenation _builder_36 = new StringConcatenation();
    _builder_36.append("A primitive type describes a type like int, char, float");
    _builder_36.newLine();
    _builder_36.append("and can represent the type with a certain precision");
    _builder_36.newLine();
    _builder_36.append("in the target language");
    _builder_36.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_36.toString());
    EAttribute _attribute_4 = PostprocessingHelpers.getAttribute(cls, "type");
    StringConcatenation _builder_37 = new StringConcatenation();
    _builder_37.append("This is one of the basic variable types.");
    _builder_37.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_4, _builder_37.toString());
    EAttribute _attribute_5 = PostprocessingHelpers.getAttribute(cls, "targetName");
    StringConcatenation _builder_38 = new StringConcatenation();
    _builder_38.append("This is the type name in the target language.");
    _builder_38.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_5, _builder_38.toString());
    EAttribute _attribute_6 = PostprocessingHelpers.getAttribute(cls, "castName");
    StringConcatenation _builder_39 = new StringConcatenation();
    _builder_39.append("This (optional) name is used for casts to this type.");
    _builder_39.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_6, _builder_39.toString());
    EAttribute _attribute_7 = PostprocessingHelpers.getAttribute(cls, "defaultValueLiteral");
    StringConcatenation _builder_40 = new StringConcatenation();
    _builder_40.append("This is an optional default value literal.");
    _builder_40.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_7, _builder_40.toString());
    EClass _class_10 = PostprocessingHelpers.getClass(pckg, "ExternalType");
    cls = _class_10;
    StringConcatenation _builder_41 = new StringConcatenation();
    _builder_41.append("An external type is not defined in the ROOM model");
    _builder_41.newLine();
    _builder_41.append("but only referenced. It can not be instantiated.");
    _builder_41.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_41.toString());
    EAttribute _attribute_8 = PostprocessingHelpers.getAttribute(cls, "targetName");
    StringConcatenation _builder_42 = new StringConcatenation();
    _builder_42.append("This is the type name in the target language.");
    _builder_42.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_8, _builder_42.toString());
    EAttribute _attribute_9 = PostprocessingHelpers.getAttribute(cls, "defaultValueLiteral");
    StringConcatenation _builder_43 = new StringConcatenation();
    _builder_43.append("This is an optional default value literal.");
    _builder_43.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_9, _builder_43.toString());
    EClass _class_11 = PostprocessingHelpers.getClass(pckg, "DataClass");
    cls = _class_11;
    StringConcatenation _builder_44 = new StringConcatenation();
    _builder_44.append("Together with {@link ProtocolClass} and {@link ActorClass} one of");
    _builder_44.newLine();
    _builder_44.append("the main class types of the ROOM language.");
    _builder_44.newLine();
    _builder_44.newLine();
    _builder_44.append("<p>");
    _builder_44.newLine();
    _builder_44.append("In ROOM this is the equivalent to a class in Java or C++.");
    _builder_44.newLine();
    _builder_44.append("A data class can be derived from a base class (single");
    _builder_44.newLine();
    _builder_44.append("inheritance), has {@link Attribute}s and {@link Operation}s.");
    _builder_44.newLine();
    _builder_44.append("</p>");
    _builder_44.newLine();
    _builder_44.newLine();
    _builder_44.append("<p>");
    _builder_44.newLine();
    _builder_44.append("Additionally it can be annotated with generator specific");
    _builder_44.newLine();
    _builder_44.append("meaning and user ocde can be added in several places");
    _builder_44.newLine();
    _builder_44.append("(again generator specific).");
    _builder_44.newLine();
    _builder_44.append("</p>");
    _builder_44.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_44.toString());
    EAttribute _attribute_10 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_45 = new StringConcatenation();
    _builder_45.append("The name of the data class by which it is referred to in the model.");
    _builder_45.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_10, _builder_45.toString());
    EReference _reference_22 = PostprocessingHelpers.getReference(cls, "base");
    StringConcatenation _builder_46 = new StringConcatenation();
    _builder_46.append("The base class from which all attributes and operations are inherited.");
    _builder_46.newLine();
    PostprocessingHelpers.setDocumentation(_reference_22, _builder_46.toString());
    EReference _reference_23 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_47 = new StringConcatenation();
    _builder_47.append("Attributes are the data members of the data class.");
    _builder_47.newLine();
    PostprocessingHelpers.setDocumentation(_reference_23, _builder_47.toString());
    EReference _reference_24 = PostprocessingHelpers.getReference(cls, "operations");
    StringConcatenation _builder_48 = new StringConcatenation();
    _builder_48.append("Operations are the methods of the data class.");
    _builder_48.newLine();
    PostprocessingHelpers.setDocumentation(_reference_24, _builder_48.toString());
    EReference _reference_25 = PostprocessingHelpers.getReference(cls, "annotations");
    StringConcatenation _builder_49 = new StringConcatenation();
    _builder_49.append("This is a list of data class annotations.");
    _builder_49.newLine();
    PostprocessingHelpers.setDocumentation(_reference_25, _builder_49.toString());
    EReference _reference_26 = PostprocessingHelpers.getReference(cls, "userCode1");
    StringConcatenation _builder_50 = new StringConcatenation();
    _builder_50.append("The user code is treated in a generator dependent way.");
    _builder_50.newLine();
    PostprocessingHelpers.setDocumentation(_reference_26, _builder_50.toString());
    EReference _reference_27 = PostprocessingHelpers.getReference(cls, "userCode2");
    StringConcatenation _builder_51 = new StringConcatenation();
    _builder_51.append("The user code is treated in a generator dependent way.");
    _builder_51.newLine();
    PostprocessingHelpers.setDocumentation(_reference_27, _builder_51.toString());
    EReference _reference_28 = PostprocessingHelpers.getReference(cls, "userCode3");
    StringConcatenation _builder_52 = new StringConcatenation();
    _builder_52.append("The user code is treated in a generator dependent way.");
    _builder_52.newLine();
    PostprocessingHelpers.setDocumentation(_reference_28, _builder_52.toString());
    EClass _class_12 = PostprocessingHelpers.getClass(pckg, "Attribute");
    cls = _class_12;
    StringConcatenation _builder_53 = new StringConcatenation();
    _builder_53.append("An attribute is a named member of a");
    _builder_53.newLine();
    _builder_53.append("<ul>");
    _builder_53.newLine();
    _builder_53.append("  ");
    _builder_53.append("<li>{@link DataClass}</li>");
    _builder_53.newLine();
    _builder_53.append("  ");
    _builder_53.append("<li>{@link ActorClass}</li>");
    _builder_53.newLine();
    _builder_53.append("  ");
    _builder_53.append("<li>{@link PortClass}</li>");
    _builder_53.newLine();
    _builder_53.append("</ul>");
    _builder_53.newLine();
    _builder_53.append("<p>");
    _builder_53.newLine();
    _builder_53.append("It can be of scalar or array type and is of a {@link RefableType}.");
    _builder_53.newLine();
    _builder_53.append("It is possible to assign a default value literal.");
    _builder_53.newLine();
    _builder_53.append("</p>");
    _builder_53.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_53.toString());
    EAttribute _attribute_11 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_54 = new StringConcatenation();
    _builder_54.append("The name of the attribute by which it is referred to in the model.");
    _builder_54.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_11, _builder_54.toString());
    EAttribute _attribute_12 = PostprocessingHelpers.getAttribute(cls, "size");
    StringConcatenation _builder_55 = new StringConcatenation();
    _builder_55.append("The default is scalar ({@code size=1}), values {@code >1} indicate an array.");
    _builder_55.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_12, _builder_55.toString());
    EReference _reference_29 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_56 = new StringConcatenation();
    _builder_56.append("This is the attribute\'s type.");
    _builder_56.newLine();
    PostprocessingHelpers.setDocumentation(_reference_29, _builder_56.toString());
    EAttribute _attribute_13 = PostprocessingHelpers.getAttribute(cls, "defaultValueLiteral");
    StringConcatenation _builder_57 = new StringConcatenation();
    _builder_57.append("This is an optional default value literal.");
    _builder_57.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_13, _builder_57.toString());
    EReference _reference_30 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_58 = new StringConcatenation();
    _builder_58.append("This is an optional documentation.");
    _builder_58.newLine();
    PostprocessingHelpers.setDocumentation(_reference_30, _builder_58.toString());
    EClass _class_13 = PostprocessingHelpers.getClass(pckg, "Operation");
    cls = _class_13;
    StringConcatenation _builder_59 = new StringConcatenation();
    _builder_59.append("The super class of");
    _builder_59.newLine();
    _builder_59.append("<ul>");
    _builder_59.newLine();
    _builder_59.append("  ");
    _builder_59.append("<li>{@link StandardOperation}</li>");
    _builder_59.newLine();
    _builder_59.append("  ");
    _builder_59.append("<li>{@link PortOperation}</li>");
    _builder_59.newLine();
    _builder_59.append("</ul>");
    _builder_59.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_59.toString());
    EAttribute _attribute_14 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_60 = new StringConcatenation();
    _builder_60.append("The name of the operation by which it is referred to in the model.");
    _builder_60.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_14, _builder_60.toString());
    EReference _reference_31 = PostprocessingHelpers.getReference(cls, "arguments");
    StringConcatenation _builder_61 = new StringConcatenation();
    _builder_61.append("This is a list of arguments for the operation.");
    _builder_61.newLine();
    PostprocessingHelpers.setDocumentation(_reference_31, _builder_61.toString());
    EReference _reference_32 = PostprocessingHelpers.getReference(cls, "returnType");
    StringConcatenation _builder_62 = new StringConcatenation();
    _builder_62.append("This is an optional return type of the operation.");
    _builder_62.newLine();
    PostprocessingHelpers.setDocumentation(_reference_32, _builder_62.toString());
    EReference _reference_33 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_63 = new StringConcatenation();
    _builder_63.append("This is an optional documentation.");
    _builder_63.newLine();
    PostprocessingHelpers.setDocumentation(_reference_33, _builder_63.toString());
    EReference _reference_34 = PostprocessingHelpers.getReference(cls, "detailCode");
    StringConcatenation _builder_64 = new StringConcatenation();
    _builder_64.append("This is the operation body written in code generator target language.");
    _builder_64.newLine();
    PostprocessingHelpers.setDocumentation(_reference_34, _builder_64.toString());
    EClass _class_14 = PostprocessingHelpers.getClass(pckg, "StandardOperation");
    cls = _class_14;
    StringConcatenation _builder_65 = new StringConcatenation();
    _builder_65.append("The standard form of an operation as used by");
    _builder_65.newLine();
    _builder_65.append("{@link ActorClass} and {@link DataClass}.");
    _builder_65.newLine();
    _builder_65.append("<p>");
    _builder_65.newLine();
    _builder_65.append("The operation has a list of {@link VarDecl} arguments, an");
    _builder_65.newLine();
    _builder_65.append("optional return {@link RefableType} and a body (specified");
    _builder_65.newLine();
    _builder_65.append("as {@link DetailCode}).");
    _builder_65.newLine();
    _builder_65.append("</p>");
    _builder_65.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_65.toString());
    EClass _class_15 = PostprocessingHelpers.getClass(pckg, "PortOperation");
    cls = _class_15;
    StringConcatenation _builder_66 = new StringConcatenation();
    _builder_66.append("The port operation is very similar to the {@link StandardOperation}");
    _builder_66.newLine();
    _builder_66.append("and is used in the {@link PortClass}.");
    _builder_66.newLine();
    _builder_66.append("<p>");
    _builder_66.newLine();
    _builder_66.append("Optionally a {@link Message} can be specified which is sent");
    _builder_66.newLine();
    _builder_66.append("when the method is invoked. For this reason these operations");
    _builder_66.newLine();
    _builder_66.append("are also shown in the \'messages\' dialog of the behavior editor.");
    _builder_66.newLine();
    _builder_66.append("</p>");
    _builder_66.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_66.toString());
    EReference _reference_35 = PostprocessingHelpers.getReference(cls, "sendsMsg");
    StringConcatenation _builder_67 = new StringConcatenation();
    _builder_67.append("This optional reference to a message means that the operation sends a message.");
    _builder_67.newLine();
    PostprocessingHelpers.setDocumentation(_reference_35, _builder_67.toString());
    EClass _class_16 = PostprocessingHelpers.getClass(pckg, "ClassStructor");
    cls = _class_16;
    StringConcatenation _builder_68 = new StringConcatenation();
    _builder_68.append("Represents either the constructor (ctor) or destructor (dtor) of a ROOM class.");
    _builder_68.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_68.toString());
    EClass _class_17 = PostprocessingHelpers.getClass(pckg, "GeneralProtocolClass");
    cls = _class_17;
    StringConcatenation _builder_69 = new StringConcatenation();
    _builder_69.append("The super class of");
    _builder_69.newLine();
    _builder_69.append("<ul>");
    _builder_69.newLine();
    _builder_69.append("  ");
    _builder_69.append("<li>{@link ProtocolClass}</li>");
    _builder_69.newLine();
    _builder_69.append("  ");
    _builder_69.append("<li>{@link CompoundProtocolClass}</li>");
    _builder_69.newLine();
    _builder_69.append("</ul>");
    _builder_69.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_69.toString());
    EReference _reference_36 = PostprocessingHelpers.getReference(cls, "annotations");
    StringConcatenation _builder_70 = new StringConcatenation();
    _builder_70.append("This is a list of protocol class annotations.");
    _builder_70.newLine();
    PostprocessingHelpers.setDocumentation(_reference_36, _builder_70.toString());
    EClass _class_18 = PostprocessingHelpers.getClass(pckg, "ProtocolClass");
    cls = _class_18;
    StringConcatenation _builder_71 = new StringConcatenation();
    _builder_71.append("Together with {@link ActorClass} and {@link DataClass} one of");
    _builder_71.newLine();
    _builder_71.append("the main class types of the ROOM language.");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("A protocol class specifies a directed {@link Port} interface");
    _builder_71.newLine();
    _builder_71.append("by two sets of {@link Message}s: incoming and outgoing.");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("A protocol class can derive from a base class (single inheritance).");
    _builder_71.newLine();
    _builder_71.append("In this case it must only extend <em>one</em> of the message sets:");
    _builder_71.newLine();
    _builder_71.append("incoming <em>or</em> outgoing.");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("Optionally {@link PortClass}es may be defined for regular and");
    _builder_71.newLine();
    _builder_71.append("conjugate {@link Port}s. These classes can be used to add specific");
    _builder_71.newLine();
    _builder_71.append("behavior e.g. by adding message handlers. This kind of felxibility");
    _builder_71.newLine();
    _builder_71.append("can be used in particular for the efficient implementation of");
    _builder_71.newLine();
    _builder_71.append("services (SAPs and SPPs).");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("Last not least a so called \'legal execution tree\' can be specified");
    _builder_71.newLine();
    _builder_71.append("using {@link ProtocolSemantics}.");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_71.toString());
    EAttribute _attribute_15 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_72 = new StringConcatenation();
    _builder_72.append("The name of the protocol class by which it is referred to in the model.");
    _builder_72.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_15, _builder_72.toString());
    EReference _reference_37 = PostprocessingHelpers.getReference(cls, "base");
    StringConcatenation _builder_73 = new StringConcatenation();
    _builder_73.append("The base class from which all messages are inherited.");
    _builder_73.newLine();
    _builder_73.append("The port classes and the semantics are not inherited.");
    _builder_73.newLine();
    PostprocessingHelpers.setDocumentation(_reference_37, _builder_73.toString());
    EAttribute _attribute_16 = PostprocessingHelpers.getAttribute(cls, "commType");
    StringConcatenation _builder_74 = new StringConcatenation();
    _builder_74.append("This is the communication type of the protocol.");
    _builder_74.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_16, _builder_74.toString());
    EReference _reference_38 = PostprocessingHelpers.getReference(cls, "userCode1");
    StringConcatenation _builder_75 = new StringConcatenation();
    _builder_75.append("The user code is treated in a generator dependent way.");
    _builder_75.newLine();
    PostprocessingHelpers.setDocumentation(_reference_38, _builder_75.toString());
    EReference _reference_39 = PostprocessingHelpers.getReference(cls, "userCode2");
    StringConcatenation _builder_76 = new StringConcatenation();
    _builder_76.append("The user code is treated in a generator dependent way.");
    _builder_76.newLine();
    PostprocessingHelpers.setDocumentation(_reference_39, _builder_76.toString());
    EReference _reference_40 = PostprocessingHelpers.getReference(cls, "userCode3");
    StringConcatenation _builder_77 = new StringConcatenation();
    _builder_77.append("The user code is treated in a generator dependent way.");
    _builder_77.newLine();
    PostprocessingHelpers.setDocumentation(_reference_40, _builder_77.toString());
    EReference _reference_41 = PostprocessingHelpers.getReference(cls, "incomingMessages");
    StringConcatenation _builder_78 = new StringConcatenation();
    _builder_78.append("This is the set of incoming messages of this protocol.");
    _builder_78.newLine();
    PostprocessingHelpers.setDocumentation(_reference_41, _builder_78.toString());
    EReference _reference_42 = PostprocessingHelpers.getReference(cls, "outgoingMessages");
    StringConcatenation _builder_79 = new StringConcatenation();
    _builder_79.append("This is the set of outgoing messages of this protocol.");
    _builder_79.newLine();
    PostprocessingHelpers.setDocumentation(_reference_42, _builder_79.toString());
    EReference _reference_43 = PostprocessingHelpers.getReference(cls, "regular");
    StringConcatenation _builder_80 = new StringConcatenation();
    _builder_80.append("This is the optional regular port class specification.");
    _builder_80.newLine();
    PostprocessingHelpers.setDocumentation(_reference_43, _builder_80.toString());
    EReference _reference_44 = PostprocessingHelpers.getReference(cls, "conjugated");
    StringConcatenation _builder_81 = new StringConcatenation();
    _builder_81.append("This is the optional conjugate port class specification.");
    _builder_81.newLine();
    PostprocessingHelpers.setDocumentation(_reference_44, _builder_81.toString());
    EReference _reference_45 = PostprocessingHelpers.getReference(cls, "semantics");
    StringConcatenation _builder_82 = new StringConcatenation();
    _builder_82.append("This is the optional semantics specification for this protocol.");
    _builder_82.newLine();
    PostprocessingHelpers.setDocumentation(_reference_45, _builder_82.toString());
    EClass _class_19 = PostprocessingHelpers.getClass(pckg, "CompoundProtocolClass");
    cls = _class_19;
    StringConcatenation _builder_83 = new StringConcatenation();
    _builder_83.append("This special protocol class is used to bundle several protocols");
    _builder_83.newLine();
    _builder_83.append("in relay ports. This can be useful to avoid parallel chains");
    _builder_83.newLine();
    _builder_83.append("of {@link Binding}s traversing the structural hierarchy.");
    _builder_83.newLine();
    _builder_83.append("<p>");
    _builder_83.newLine();
    _builder_83.append("The compound protocol class consists of several {@link SubProtocol}s.");
    _builder_83.newLine();
    _builder_83.append("</p>");
    _builder_83.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_83.toString());
    EReference _reference_46 = PostprocessingHelpers.getReference(cls, "subProtocols");
    StringConcatenation _builder_84 = new StringConcatenation();
    _builder_84.append("This is a list of sub protocols.");
    _builder_84.newLine();
    PostprocessingHelpers.setDocumentation(_reference_46, _builder_84.toString());
    EClass _class_20 = PostprocessingHelpers.getClass(pckg, "SubProtocol");
    cls = _class_20;
    StringConcatenation _builder_85 = new StringConcatenation();
    _builder_85.append("The sub protocol is part of the {@link CompoundProtocolClass} and defines");
    _builder_85.newLine();
    _builder_85.append("kind of a named channel for messages. The sub protocols are used to associate an");
    _builder_85.newLine();
    _builder_85.append("end port with a particular channel.");
    _builder_85.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_85.toString());
    EAttribute _attribute_17 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_86 = new StringConcatenation();
    _builder_86.append("By this name the sub protocols or channels are distinguished.");
    _builder_86.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_17, _builder_86.toString());
    EReference _reference_47 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_87 = new StringConcatenation();
    _builder_87.append("This is the protocol of this channel.");
    _builder_87.newLine();
    PostprocessingHelpers.setDocumentation(_reference_47, _builder_87.toString());
    EClass _class_21 = PostprocessingHelpers.getClass(pckg, "Message");
    cls = _class_21;
    StringConcatenation _builder_88 = new StringConcatenation();
    _builder_88.append("This is a concrete sub class of an {@link AbstractMessage}.");
    _builder_88.newLine();
    _builder_88.append("A message in ROOM is part of a {@link ProtocolClass}. Messages are exchanged via {@link Port}s.");
    _builder_88.newLine();
    _builder_88.append("For event driven protocols the message is an object that is deliverd using a message");
    _builder_88.newLine();
    _builder_88.append("service of the runtime. For data driven systems only messages holding data are valid. In this");
    _builder_88.newLine();
    _builder_88.append("case the conjugate port is the one holding (and writing) the data and the regular port is");
    _builder_88.newLine();
    _builder_88.append("reading the data.");
    _builder_88.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_88.toString());
    EAttribute _attribute_18 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_89 = new StringConcatenation();
    _builder_89.append("By this name the message is referred to in the model.");
    _builder_89.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_18, _builder_89.toString());
    EAttribute _attribute_19 = PostprocessingHelpers.getAttribute(cls, "priv");
    StringConcatenation _builder_90 = new StringConcatenation();
    _builder_90.append("If this flag is {@code true} then the message is treated as private for this protocol");
    _builder_90.newLine();
    _builder_90.append("and can only be sent by a PortClass.");
    _builder_90.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_19, _builder_90.toString());
    EReference _reference_48 = PostprocessingHelpers.getReference(cls, "data");
    StringConcatenation _builder_91 = new StringConcatenation();
    _builder_91.append("This is a reference to optional message data.");
    _builder_91.newLine();
    PostprocessingHelpers.setDocumentation(_reference_48, _builder_91.toString());
    EReference _reference_49 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_92 = new StringConcatenation();
    _builder_92.append("This is an optional documentation.");
    _builder_92.newLine();
    PostprocessingHelpers.setDocumentation(_reference_49, _builder_92.toString());
    EClass _class_22 = PostprocessingHelpers.getClass(pckg, "PortClass");
    cls = _class_22;
    StringConcatenation _builder_93 = new StringConcatenation();
    _builder_93.append("A port class can be specified to customize the behavior of a {@link ProtocolClass}.");
    _builder_93.newLine();
    _builder_93.append("There can be one for regular ports and another one for conjugate ports independently.");
    _builder_93.newLine();
    _builder_93.newLine();
    _builder_93.append("<p>");
    _builder_93.newLine();
    _builder_93.append("Port classes can be used to define attributes and operations and message handlers");
    _builder_93.newLine();
    _builder_93.append("(or interceptors).");
    _builder_93.newLine();
    _builder_93.append("</p>");
    _builder_93.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_93.toString());
    EReference _reference_50 = PostprocessingHelpers.getReference(cls, "operations");
    StringConcatenation _builder_94 = new StringConcatenation();
    _builder_94.append("This is a list of operations of this nested class.");
    _builder_94.newLine();
    PostprocessingHelpers.setDocumentation(_reference_50, _builder_94.toString());
    EReference _reference_51 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_95 = new StringConcatenation();
    _builder_95.append("This is a list of attributes of this nested class.");
    _builder_95.newLine();
    PostprocessingHelpers.setDocumentation(_reference_51, _builder_95.toString());
    EReference _reference_52 = PostprocessingHelpers.getReference(cls, "userCode");
    StringConcatenation _builder_96 = new StringConcatenation();
    _builder_96.append("The user code is treated in a generator dependent way.");
    _builder_96.newLine();
    PostprocessingHelpers.setDocumentation(_reference_52, _builder_96.toString());
    EReference _reference_53 = PostprocessingHelpers.getReference(cls, "msgHandlers");
    StringConcatenation _builder_97 = new StringConcatenation();
    _builder_97.append("This is a list of message handlers.");
    _builder_97.newLine();
    PostprocessingHelpers.setDocumentation(_reference_53, _builder_97.toString());
    EClass _class_23 = PostprocessingHelpers.getClass(pckg, "MessageHandler");
    cls = _class_23;
    StringConcatenation _builder_98 = new StringConcatenation();
    _builder_98.append("The super class of");
    _builder_98.newLine();
    _builder_98.append("<ul>");
    _builder_98.newLine();
    _builder_98.append("  ");
    _builder_98.append("<li>{@link InMessageHandler}</li>");
    _builder_98.newLine();
    _builder_98.append("  ");
    _builder_98.append("<li>{@link OutMessageHandler}</li>");
    _builder_98.newLine();
    _builder_98.append("</ul>");
    _builder_98.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_98.toString());
    EReference _reference_54 = PostprocessingHelpers.getReference(cls, "msg");
    StringConcatenation _builder_99 = new StringConcatenation();
    _builder_99.append("This is the message that is handled.");
    _builder_99.newLine();
    PostprocessingHelpers.setDocumentation(_reference_54, _builder_99.toString());
    EReference _reference_55 = PostprocessingHelpers.getReference(cls, "detailCode");
    StringConcatenation _builder_100 = new StringConcatenation();
    _builder_100.append("This is the handler code written in code generator target language.");
    _builder_100.newLine();
    PostprocessingHelpers.setDocumentation(_reference_55, _builder_100.toString());
    EClass _class_24 = PostprocessingHelpers.getClass(pckg, "InMessageHandler");
    cls = _class_24;
    StringConcatenation _builder_101 = new StringConcatenation();
    _builder_101.append("Is a handler (or interceptor) for incoming messages. In the generated code the");
    _builder_101.newLine();
    _builder_101.append("message is available. It is derived from {@link MessageHandler}.");
    _builder_101.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_101.toString());
    EClass _class_25 = PostprocessingHelpers.getClass(pckg, "OutMessageHandler");
    cls = _class_25;
    StringConcatenation _builder_102 = new StringConcatenation();
    _builder_102.append("Is a handler (or interceptor) for outgoing messages. In the generated code the");
    _builder_102.newLine();
    _builder_102.append("message is available. It is derived from {@link MessageHandler}.");
    _builder_102.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_102.toString());
    EClass _class_26 = PostprocessingHelpers.getClass(pckg, "ActorClass");
    cls = _class_26;
    StringConcatenation _builder_103 = new StringConcatenation();
    _builder_103.append("Together with {@link ProtocolClass} and {@link DataClass} one of");
    _builder_103.newLine();
    _builder_103.append("the main class types of the ROOM language.");
    _builder_103.newLine();
    _builder_103.newLine();
    _builder_103.append("<p>");
    _builder_103.newLine();
    _builder_103.append("The actor class in ROOM has three compartments which aren\'t represented as separate model objects.");
    _builder_103.newLine();
    _builder_103.append("To understand to which compartment an attribute or reference belongs to here is a list");
    _builder_103.newLine();
    _builder_103.append("<ul>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("<li>Interface: everything which is visible from the outside from a model point of view");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("<ul>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getInterfacePorts}: a list of all interface {@link Port}s</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link ActorContainerClass#getServiceProvisionPoints()}: a list of all interface {@link SPP}s</li>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("</ul>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("<li>Structure: all internal structural aspects of an actor class</li>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("<ul>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getUserCode1}-3: user defined code with generator dependent meaning</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getInternalPorts}: a list of all internal end {@link Port}s</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getExternalPorts}: a list of all {@link ExternalPort}s (the interface ports that");
    _builder_103.newLine();
    _builder_103.append("       ");
    _builder_103.append("are end ports, not relay ports</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getServiceImplementations}: a list of all {@link ServiceImplementation}s</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getServiceAccessPoints}: a list of all {@link SAP}s used by this actor class</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getAttributes}: a list of all actor class {@link Attribute}s</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getActorRefs}: a list of all referenced actor classes (an {@link ActorRef}");
    _builder_103.newLine();
    _builder_103.append("       ");
    _builder_103.append("has the meaning of a composition)</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getBindings}: a list of all port {@link Binding}s of this actor class</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getConnections}: a list of all {@link LayerConnection}s</li>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("</ul>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("<li>Behavior: the behavioral aspects of an actor class</li>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("<ul>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getOperations}: a list of {@link Operation}s</li>");
    _builder_103.newLine();
    _builder_103.append("    ");
    _builder_103.append("<li>{@link #getStateMachine}: the {@link StateGraph state machine} definition</li>");
    _builder_103.newLine();
    _builder_103.append("  ");
    _builder_103.append("</ul>");
    _builder_103.newLine();
    _builder_103.append("</ul>");
    _builder_103.newLine();
    _builder_103.append("</p>");
    _builder_103.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_103.toString());
    EAttribute _attribute_20 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_104 = new StringConcatenation();
    _builder_104.append("By this name the actor class is referred to in the model.");
    _builder_104.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_20, _builder_104.toString());
    EAttribute _attribute_21 = PostprocessingHelpers.getAttribute(cls, "abstract");
    StringConcatenation _builder_105 = new StringConcatenation();
    _builder_105.append("If {@code true} this actor class can not be instantiated and can only be base class");
    _builder_105.newLine();
    _builder_105.append("for other actor classes.");
    _builder_105.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_21, _builder_105.toString());
    EAttribute _attribute_22 = PostprocessingHelpers.getAttribute(cls, "commType");
    StringConcatenation _builder_106 = new StringConcatenation();
    _builder_106.append("The communication type of this actor class.");
    _builder_106.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_22, _builder_106.toString());
    EReference _reference_56 = PostprocessingHelpers.getReference(cls, "base");
    StringConcatenation _builder_107 = new StringConcatenation();
    _builder_107.append("The base class from which all attributes, operations, ports, SAPs");
    _builder_107.newLine();
    _builder_107.append("and state machine are inherited.");
    _builder_107.newLine();
    PostprocessingHelpers.setDocumentation(_reference_56, _builder_107.toString());
    EReference _reference_57 = PostprocessingHelpers.getReference(cls, "interfacePorts");
    StringConcatenation _builder_108 = new StringConcatenation();
    _builder_108.append("This is a list containing all ports of the actor interface.");
    _builder_108.newLine();
    PostprocessingHelpers.setDocumentation(_reference_57, _builder_108.toString());
    EReference _reference_58 = PostprocessingHelpers.getReference(cls, "internalPorts");
    StringConcatenation _builder_109 = new StringConcatenation();
    _builder_109.append("This is a list containing all ports of the actor structure (internal end ports).");
    _builder_109.newLine();
    PostprocessingHelpers.setDocumentation(_reference_58, _builder_109.toString());
    EReference _reference_59 = PostprocessingHelpers.getReference(cls, "externalPorts");
    StringConcatenation _builder_110 = new StringConcatenation();
    _builder_110.append("This is a list containing all ports of the actor interface that are end ports.");
    _builder_110.newLine();
    PostprocessingHelpers.setDocumentation(_reference_59, _builder_110.toString());
    EReference _reference_60 = PostprocessingHelpers.getReference(cls, "structureDocu");
    StringConcatenation _builder_111 = new StringConcatenation();
    _builder_111.append("This is an optional documentation of the actor structure.");
    _builder_111.newLine();
    PostprocessingHelpers.setDocumentation(_reference_60, _builder_111.toString());
    EReference _reference_61 = PostprocessingHelpers.getReference(cls, "serviceImplementations");
    StringConcatenation _builder_112 = new StringConcatenation();
    _builder_112.append("This is a list of all service implementations.");
    _builder_112.newLine();
    PostprocessingHelpers.setDocumentation(_reference_61, _builder_112.toString());
    EReference _reference_62 = PostprocessingHelpers.getReference(cls, "serviceAccessPoints");
    StringConcatenation _builder_113 = new StringConcatenation();
    _builder_113.append("This is a list of all SAPs.");
    _builder_113.newLine();
    PostprocessingHelpers.setDocumentation(_reference_62, _builder_113.toString());
    EReference _reference_63 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_114 = new StringConcatenation();
    _builder_114.append("This is a list of all actor class private attributes.");
    _builder_114.newLine();
    PostprocessingHelpers.setDocumentation(_reference_63, _builder_114.toString());
    EReference _reference_64 = PostprocessingHelpers.getReference(cls, "behaviorDocu");
    StringConcatenation _builder_115 = new StringConcatenation();
    _builder_115.append("This is an optional documentation of the actor behavior.");
    _builder_115.newLine();
    PostprocessingHelpers.setDocumentation(_reference_64, _builder_115.toString());
    EReference _reference_65 = PostprocessingHelpers.getReference(cls, "behaviorAnnotations");
    StringConcatenation _builder_116 = new StringConcatenation();
    _builder_116.append("This is a list of annotations to the actor behavior.");
    _builder_116.newLine();
    PostprocessingHelpers.setDocumentation(_reference_65, _builder_116.toString());
    EReference _reference_66 = PostprocessingHelpers.getReference(cls, "operations");
    StringConcatenation _builder_117 = new StringConcatenation();
    _builder_117.append("This is a list of all private operations of this actor class.");
    _builder_117.newLine();
    PostprocessingHelpers.setDocumentation(_reference_66, _builder_117.toString());
    EReference _reference_67 = PostprocessingHelpers.getReference(cls, "stateMachine");
    StringConcatenation _builder_118 = new StringConcatenation();
    _builder_118.append("This is the actor\'s optional state machine.");
    _builder_118.newLine();
    PostprocessingHelpers.setDocumentation(_reference_67, _builder_118.toString());
    EClass _class_27 = PostprocessingHelpers.getClass(pckg, "InterfaceItem");
    cls = _class_27;
    StringConcatenation _builder_119 = new StringConcatenation();
    _builder_119.append("This is a concrete sub class of an {@link AbstractInterfaceItem}.");
    _builder_119.newLine();
    _builder_119.newLine();
    _builder_119.append("It is the super class of");
    _builder_119.newLine();
    _builder_119.append("<ul>");
    _builder_119.newLine();
    _builder_119.append("  ");
    _builder_119.append("<li>{@link Port}</li>");
    _builder_119.newLine();
    _builder_119.append("  ");
    _builder_119.append("<li>{@link SAP}</li>");
    _builder_119.newLine();
    _builder_119.append("  ");
    _builder_119.append("<li>{@link SPP}</li>");
    _builder_119.newLine();
    _builder_119.append("</ul>");
    _builder_119.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_119.toString());
    EAttribute _attribute_23 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_120 = new StringConcatenation();
    _builder_120.append("By this name the interface item is referred to in the model.");
    _builder_120.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_23, _builder_120.toString());
    EClass _class_28 = PostprocessingHelpers.getClass(pckg, "Port");
    cls = _class_28;
    StringConcatenation _builder_121 = new StringConcatenation();
    _builder_121.append("A port defines a part of the interface of an {@link ActorClass} in a specific role.");
    _builder_121.newLine();
    _builder_121.append("The port is associated with a {@link ProtocolClass}. If it is conjugated then the");
    _builder_121.newLine();
    _builder_121.append("roles of incoming and outgoing messages of the protocol are inverted.");
    _builder_121.newLine();
    _builder_121.newLine();
    _builder_121.append("<p>");
    _builder_121.newLine();
    _builder_121.append("Ports can have a multiplicity. If it is greater one the port is called replicated.");
    _builder_121.newLine();
    _builder_121.append("</p>");
    _builder_121.newLine();
    _builder_121.newLine();
    _builder_121.append("<p>");
    _builder_121.newLine();
    _builder_121.append("Whether a port is a relay port or not is a property that is derived from how it is");
    _builder_121.newLine();
    _builder_121.append("referenced by its {@link ActorClass}:");
    _builder_121.newLine();
    _builder_121.append("<ul>");
    _builder_121.newLine();
    _builder_121.append("  ");
    _builder_121.append("<li>ports contained in the actor structure are called <em>internal end ports</em></li>");
    _builder_121.newLine();
    _builder_121.append("  ");
    _builder_121.append("<li>ports contained in the actor interface and are also referenced by an {@link ExternalPort}");
    _builder_121.newLine();
    _builder_121.append("     ");
    _builder_121.append("are called <em>external end ports</em></li>");
    _builder_121.newLine();
    _builder_121.append("  ");
    _builder_121.append("<li>ports contained in the actor interface only are called <em>relay ports</em></li>");
    _builder_121.newLine();
    _builder_121.append("</ul>");
    _builder_121.newLine();
    _builder_121.append("Relay ports delegate to sub actors and end ports are connected to the actor\'s state machine.");
    _builder_121.newLine();
    _builder_121.append("</p>");
    _builder_121.newLine();
    _builder_121.newLine();
    _builder_121.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isRelay(Port) RoomHelpers.isRelay(Port)");
    _builder_121.newLine();
    _builder_121.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isInternal(Port) RoomHelpers.isInternal(Port)");
    _builder_121.newLine();
    _builder_121.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isExternal(Port) RoomHelpers.isExternal(Port)");
    _builder_121.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_121.toString());
    EAttribute _attribute_24 = PostprocessingHelpers.getAttribute(cls, "conjugated");
    StringConcatenation _builder_122 = new StringConcatenation();
    _builder_122.append("If a port is conjugated then the roles of outgoing and incoming messages are interchanged.");
    _builder_122.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_24, _builder_122.toString());
    EAttribute _attribute_25 = PostprocessingHelpers.getAttribute(cls, "multiplicity");
    StringConcatenation _builder_123 = new StringConcatenation();
    _builder_123.append("Ports with multiplicity >1 are called relay ports. A multiplicity of {@code -1} means replicated");
    _builder_123.newLine();
    _builder_123.append("port with arbitrary multiplicity.");
    _builder_123.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_25, _builder_123.toString());
    EReference _reference_68 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_124 = new StringConcatenation();
    _builder_124.append("This is the port\'s protocol class.");
    _builder_124.newLine();
    PostprocessingHelpers.setDocumentation(_reference_68, _builder_124.toString());
    EReference _reference_69 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_125 = new StringConcatenation();
    _builder_125.append("This is an optional documentation.");
    _builder_125.newLine();
    PostprocessingHelpers.setDocumentation(_reference_69, _builder_125.toString());
    EClass _class_29 = PostprocessingHelpers.getClass(pckg, "ExternalPort");
    cls = _class_29;
    StringConcatenation _builder_126 = new StringConcatenation();
    _builder_126.append("An external port is part of the actor structure and references an interface port.");
    _builder_126.newLine();
    _builder_126.append("An interface port which is referenced by an external port is an external end port.");
    _builder_126.newLine();
    _builder_126.append("If it is not referenced it is a relay port.");
    _builder_126.newLine();
    _builder_126.newLine();
    _builder_126.append("@see Port");
    _builder_126.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_126.toString());
    EReference _reference_70 = PostprocessingHelpers.getReference(cls, "interfacePort");
    StringConcatenation _builder_127 = new StringConcatenation();
    _builder_127.append("This is the referenced interface port of the actor class which is now an external end port.");
    _builder_127.newLine();
    PostprocessingHelpers.setDocumentation(_reference_70, _builder_127.toString());
    EClass _class_30 = PostprocessingHelpers.getClass(pckg, "SAP");
    cls = _class_30;
    StringConcatenation _builder_128 = new StringConcatenation();
    _builder_128.append("A service access point is similar to a {@link Port} but is not explicitly bound to a peer.");
    _builder_128.newLine();
    _builder_128.append("Rather, it is bound to a {@link ServiceImplementation} which is connected to one of the");
    _builder_128.newLine();
    _builder_128.append("containing actors.");
    _builder_128.newLine();
    _builder_128.newLine();
    _builder_128.append("<p>");
    _builder_128.newLine();
    _builder_128.append("An SAP is associated with a {@link ProtocolClass} and is conjugate to this protocol.");
    _builder_128.newLine();
    _builder_128.append("</p>");
    _builder_128.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_128.toString());
    EReference _reference_71 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_129 = new StringConcatenation();
    _builder_129.append("This is the SAP\'s protocol class.");
    _builder_129.newLine();
    PostprocessingHelpers.setDocumentation(_reference_71, _builder_129.toString());
    EClass _class_31 = PostprocessingHelpers.getClass(pckg, "SPP");
    cls = _class_31;
    StringConcatenation _builder_130 = new StringConcatenation();
    _builder_130.append("A service provision point is used to connect an actor class with a {@link ServiceImplementation}.");
    _builder_130.newLine();
    _builder_130.append("It can (similar to relay ports) delegate to another actor class (using a {@link LayerConnection})");
    _builder_130.newLine();
    _builder_130.append("or connect to a {@link ServiceImplementation} of its actor class.");
    _builder_130.newLine();
    _builder_130.newLine();
    _builder_130.append("<p>");
    _builder_130.newLine();
    _builder_130.append("An SPP is associated with a {@link ProtocolClass} and is regular to this protocol.");
    _builder_130.newLine();
    _builder_130.append("</p>");
    _builder_130.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_130.toString());
    EReference _reference_72 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_131 = new StringConcatenation();
    _builder_131.append("This is the SAP\'s protocol class.");
    _builder_131.newLine();
    PostprocessingHelpers.setDocumentation(_reference_72, _builder_131.toString());
    EClass _class_32 = PostprocessingHelpers.getClass(pckg, "ServiceImplementation");
    cls = _class_32;
    StringConcatenation _builder_132 = new StringConcatenation();
    _builder_132.append("A service implementation can be reagrded as the replicated peer port of all {@link SAP}s");
    _builder_132.newLine();
    _builder_132.append("that are bound to it following the service resolution logic.");
    _builder_132.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_132.toString());
    EReference _reference_73 = PostprocessingHelpers.getReference(cls, "spp");
    StringConcatenation _builder_133 = new StringConcatenation();
    _builder_133.append("This is the SPP connected to the service.");
    _builder_133.newLine();
    PostprocessingHelpers.setDocumentation(_reference_73, _builder_133.toString());
    EClass _class_33 = PostprocessingHelpers.getClass(pckg, "LogicalSystem");
    cls = _class_33;
    StringConcatenation _builder_134 = new StringConcatenation();
    _builder_134.append("The top level structural class. It can only contain sub systems using {@link SubSystemRef}s.");
    _builder_134.newLine();
    _builder_134.append("This way the logical system is composed of sub system instances. It also defines");
    _builder_134.newLine();
    _builder_134.append("{@link Binding}s and {@link LayerConnection}s between those sub systems.");
    _builder_134.newLine();
    _builder_134.newLine();
    _builder_134.append("<p>");
    _builder_134.newLine();
    _builder_134.append("The logical system is the root of the instance tree of the generator model.");
    _builder_134.newLine();
    _builder_134.append("Each {@link SubSystemRef} is turned into a {@link org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance} and each");
    _builder_134.newLine();
    _builder_134.append("{@link ActorRef} is turned into an {@link org.eclipse.etrice.core.genmodel.etricegen.ActorInstance}.");
    _builder_134.newLine();
    _builder_134.append("</p>");
    _builder_134.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_134.toString());
    EReference _reference_74 = PostprocessingHelpers.getReference(cls, "subSystems");
    StringConcatenation _builder_135 = new StringConcatenation();
    _builder_135.append("The list of all sub systems contained in the logical system.");
    _builder_135.newLine();
    PostprocessingHelpers.setDocumentation(_reference_74, _builder_135.toString());
    EClass _class_34 = PostprocessingHelpers.getClass(pckg, "ActorContainerRef");
    cls = _class_34;
    StringConcatenation _builder_136 = new StringConcatenation();
    _builder_136.append("The super class of");
    _builder_136.newLine();
    _builder_136.append("<ul>");
    _builder_136.newLine();
    _builder_136.append("  ");
    _builder_136.append("<li>{@link SubSystemRef}</li>");
    _builder_136.newLine();
    _builder_136.append("  ");
    _builder_136.append("<li>{@link ActorRef}</li>");
    _builder_136.newLine();
    _builder_136.append("</ul>");
    _builder_136.newLine();
    _builder_136.append("The reference designates a specific role of the referenced structure class.");
    _builder_136.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_136.toString());
    EAttribute _attribute_26 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_137 = new StringConcatenation();
    _builder_137.append("By this name the actor container reference is referred to in the model.");
    _builder_137.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_26, _builder_137.toString());
    EReference _reference_75 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_138 = new StringConcatenation();
    _builder_138.append("This is an optional documentation.");
    _builder_138.newLine();
    PostprocessingHelpers.setDocumentation(_reference_75, _builder_138.toString());
    EClass _class_35 = PostprocessingHelpers.getClass(pckg, "SubSystemRef");
    cls = _class_35;
    StringConcatenation _builder_139 = new StringConcatenation();
    _builder_139.append("A means to compose {@link LogicalSystem}s of {@link SubSystemClass}es. Each ref will");
    _builder_139.newLine();
    _builder_139.append("be turned into a sub system instance of the referenced type.");
    _builder_139.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_139.toString());
    EReference _reference_76 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_140 = new StringConcatenation();
    _builder_140.append("The type of the reference.");
    _builder_140.newLine();
    PostprocessingHelpers.setDocumentation(_reference_76, _builder_140.toString());
    EClass _class_36 = PostprocessingHelpers.getClass(pckg, "SubSystemClass");
    cls = _class_36;
    StringConcatenation _builder_141 = new StringConcatenation();
    _builder_141.append("A sub system class corresponds to a process with a separate address space.");
    _builder_141.newLine();
    _builder_141.append("It has no behavior of its own and is composed of {@link ActorClass}es.");
    _builder_141.newLine();
    _builder_141.newLine();
    _builder_141.append("<p>");
    _builder_141.newLine();
    _builder_141.append("Sub systems can be connected using {@link Port}s and {@link Binding}s.");
    _builder_141.newLine();
    _builder_141.append("All ports of a sub system are relay ports.");
    _builder_141.newLine();
    _builder_141.append("</p>");
    _builder_141.newLine();
    _builder_141.newLine();
    _builder_141.append("<p>");
    _builder_141.newLine();
    _builder_141.append("Sub systems can define an arbitrary number of logical threads onto which their actor");
    _builder_141.newLine();
    _builder_141.append("instances are mapped.");
    _builder_141.newLine();
    _builder_141.append("</p>");
    _builder_141.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_141.toString());
    EReference _reference_77 = PostprocessingHelpers.getReference(cls, "relayPorts");
    StringConcatenation _builder_142 = new StringConcatenation();
    _builder_142.append("This is a list of all relay ports of the sub system.");
    _builder_142.newLine();
    PostprocessingHelpers.setDocumentation(_reference_77, _builder_142.toString());
    EReference _reference_78 = PostprocessingHelpers.getReference(cls, "threads");
    StringConcatenation _builder_143 = new StringConcatenation();
    _builder_143.append("This is a list of all threads of the sub system.");
    _builder_143.newLine();
    PostprocessingHelpers.setDocumentation(_reference_78, _builder_143.toString());
    EReference _reference_79 = PostprocessingHelpers.getReference(cls, "threads");
    StringConcatenation _builder_144 = new StringConcatenation();
    _builder_144.append("This is a list of all actor instance mappings of the sub system.");
    _builder_144.newLine();
    PostprocessingHelpers.setDocumentation(_reference_79, _builder_144.toString());
    EReference _reference_80 = PostprocessingHelpers.getReference(cls, "actorInstanceMappings");
    StringConcatenation _builder_145 = new StringConcatenation();
    _builder_145.append("This is a list of actor instance mappings.");
    _builder_145.newLine();
    PostprocessingHelpers.setDocumentation(_reference_80, _builder_145.toString());
    EClass _class_37 = PostprocessingHelpers.getClass(pckg, "LogicalThread");
    cls = _class_37;
    StringConcatenation _builder_146 = new StringConcatenation();
    _builder_146.append("A logical thread is addressed by the {@link ActorInstanceMapping}s of a {@link SubSystemClass}.");
    _builder_146.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_146.toString());
    EAttribute _attribute_27 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_147 = new StringConcatenation();
    _builder_147.append("By this name the thread is referred to in the model.");
    _builder_147.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_27, _builder_147.toString());
    EClass _class_38 = PostprocessingHelpers.getClass(pckg, "ActorInstanceMapping");
    cls = _class_38;
    StringConcatenation _builder_148 = new StringConcatenation();
    _builder_148.append("An actor instance mapping maps an actor instances (described as a path of actor references)");
    _builder_148.newLine();
    _builder_148.append("to a {@link LogicalThread}");
    _builder_148.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_148.toString());
    EReference _reference_81 = PostprocessingHelpers.getReference(cls, "path");
    StringConcatenation _builder_149 = new StringConcatenation();
    _builder_149.append("This is the path of references starting at this sub system that uniquely references an actor instance.");
    _builder_149.newLine();
    PostprocessingHelpers.setDocumentation(_reference_81, _builder_149.toString());
    EReference _reference_82 = PostprocessingHelpers.getReference(cls, "thread");
    StringConcatenation _builder_150 = new StringConcatenation();
    _builder_150.append("This is the logical thread to which the referenced actor instance and all of its contained instances");
    _builder_150.newLine();
    _builder_150.append("are mapped.");
    _builder_150.newLine();
    PostprocessingHelpers.setDocumentation(_reference_82, _builder_150.toString());
    EReference _reference_83 = PostprocessingHelpers.getReference(cls, "actorInstanceMappings");
    StringConcatenation _builder_151 = new StringConcatenation();
    _builder_151.append("This is a list of nested mappings which override parent mappings.");
    _builder_151.newLine();
    PostprocessingHelpers.setDocumentation(_reference_83, _builder_151.toString());
    EClass _class_39 = PostprocessingHelpers.getClass(pckg, "RefPath");
    cls = _class_39;
    StringConcatenation _builder_152 = new StringConcatenation();
    _builder_152.append("A path of strings that are interpreted as {@link org.eclipse.etrice.core.room.ActorRef}s starting at a {@link org.eclipse.etrice.core.room.SubSystemClass}.");
    _builder_152.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_152.toString());
    EReference _reference_84 = PostprocessingHelpers.getReference(cls, "refs");
    StringConcatenation _builder_153 = new StringConcatenation();
    _builder_153.append("This is a path in the instance tree where each segment corresponds to the name of the");
    _builder_153.newLine();
    _builder_153.append("corresponding {@link ActorContainerRef}.");
    _builder_153.newLine();
    PostprocessingHelpers.setDocumentation(_reference_84, _builder_153.toString());
    EClass _class_40 = PostprocessingHelpers.getClass(pckg, "RefSegment");
    cls = _class_40;
    StringConcatenation _builder_154 = new StringConcatenation();
    _builder_154.append("A segment of a {@link RefPath}. It consists of a name and an optional index.");
    _builder_154.newLine();
    _builder_154.append("If the index is not set it will be {@code -1}.");
    _builder_154.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_154.toString());
    EAttribute _attribute_28 = PostprocessingHelpers.getAttribute(cls, "ref");
    StringConcatenation _builder_155 = new StringConcatenation();
    _builder_155.append("The segment name corresponding to an actor reference.");
    _builder_155.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_28, _builder_155.toString());
    EAttribute _attribute_29 = PostprocessingHelpers.getAttribute(cls, "idx");
    StringConcatenation _builder_156 = new StringConcatenation();
    _builder_156.append("The optional index of the reference (for replicated actors).");
    _builder_156.newLine();
    _builder_156.append("If not set the index is {@code -1}.");
    _builder_156.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_29, _builder_156.toString());
    EClass _class_41 = PostprocessingHelpers.getClass(pckg, "Binding");
    cls = _class_41;
    StringConcatenation _builder_157 = new StringConcatenation();
    _builder_157.append("A binding connects two {@link Port}s.");
    _builder_157.newLine();
    _builder_157.append("To be able to distinguish the ports of two {@link ActorContainerRef}s of the same type");
    _builder_157.newLine();
    _builder_157.append("a {@link BindingEndPoint} is needed for disambiguation.");
    _builder_157.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_157.toString());
    EReference _reference_85 = PostprocessingHelpers.getReference(cls, "endpoint1");
    StringConcatenation _builder_158 = new StringConcatenation();
    _builder_158.append("The first end point of a binding.");
    _builder_158.newLine();
    PostprocessingHelpers.setDocumentation(_reference_85, _builder_158.toString());
    EReference _reference_86 = PostprocessingHelpers.getReference(cls, "endpoint2");
    StringConcatenation _builder_159 = new StringConcatenation();
    _builder_159.append("The second end point of a binding.");
    _builder_159.newLine();
    PostprocessingHelpers.setDocumentation(_reference_86, _builder_159.toString());
    EClass _class_42 = PostprocessingHelpers.getClass(pckg, "BindingEndPoint");
    cls = _class_42;
    StringConcatenation _builder_160 = new StringConcatenation();
    _builder_160.append("A binding end point is a pair of an {@link ActorContainerRef} and a {@link Port} and is used");
    _builder_160.newLine();
    _builder_160.append("to uniquely describe a port of a sub actor. If the actor container ref is {@code null} then");
    _builder_160.newLine();
    _builder_160.append("a port of the actor class itself is addressed.");
    _builder_160.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_160.toString());
    EReference _reference_87 = PostprocessingHelpers.getReference(cls, "actorRef");
    StringConcatenation _builder_161 = new StringConcatenation();
    _builder_161.append("The actor reference holding the bound port or {@code null} in case of a local port.");
    _builder_161.newLine();
    PostprocessingHelpers.setDocumentation(_reference_87, _builder_161.toString());
    EReference _reference_88 = PostprocessingHelpers.getReference(cls, "port");
    StringConcatenation _builder_162 = new StringConcatenation();
    _builder_162.append("This is the bound port.");
    _builder_162.newLine();
    PostprocessingHelpers.setDocumentation(_reference_88, _builder_162.toString());
    EReference _reference_89 = PostprocessingHelpers.getReference(cls, "sub");
    StringConcatenation _builder_163 = new StringConcatenation();
    _builder_163.append("This is the bound sub protocol or {@code null} if not applicable.");
    _builder_163.newLine();
    PostprocessingHelpers.setDocumentation(_reference_89, _builder_163.toString());
    EClass _class_43 = PostprocessingHelpers.getClass(pckg, "LayerConnection");
    cls = _class_43;
    StringConcatenation _builder_164 = new StringConcatenation();
    _builder_164.append("Layer connections are used to connect {@link SAP}s and {@link ServiceImplementation}s.");
    _builder_164.newLine();
    _builder_164.append("The source is described by a {@link SAPoint} and the target by a {@link SPPoint}.");
    _builder_164.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_164.toString());
    EReference _reference_90 = PostprocessingHelpers.getReference(cls, "from");
    StringConcatenation _builder_165 = new StringConcatenation();
    _builder_165.append("This is source point of the layer connection.");
    _builder_165.newLine();
    PostprocessingHelpers.setDocumentation(_reference_90, _builder_165.toString());
    EReference _reference_91 = PostprocessingHelpers.getReference(cls, "to");
    StringConcatenation _builder_166 = new StringConcatenation();
    _builder_166.append("This is target point of the layer connection.");
    _builder_166.newLine();
    PostprocessingHelpers.setDocumentation(_reference_91, _builder_166.toString());
    EClass _class_44 = PostprocessingHelpers.getClass(pckg, "SAPoint");
    cls = _class_44;
    StringConcatenation _builder_167 = new StringConcatenation();
    _builder_167.append("The super class of");
    _builder_167.newLine();
    _builder_167.append("<ul>");
    _builder_167.newLine();
    _builder_167.append("  ");
    _builder_167.append("<li>{@link RefSAPoint}</li>");
    _builder_167.newLine();
    _builder_167.append("  ");
    _builder_167.append("<li>{@link RelaySAPoint}</li>");
    _builder_167.newLine();
    _builder_167.append("</ul>");
    _builder_167.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_167.toString());
    EClass _class_45 = PostprocessingHelpers.getClass(pckg, "RefSAPoint");
    cls = _class_45;
    StringConcatenation _builder_168 = new StringConcatenation();
    _builder_168.append("Links from a {@link ActorContainerRef}, i.e. from a sub actor.");
    _builder_168.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_168.toString());
    EReference _reference_92 = PostprocessingHelpers.getReference(cls, "ref");
    StringConcatenation _builder_169 = new StringConcatenation();
    _builder_169.append("This is the referenced actor container ref.");
    _builder_169.newLine();
    PostprocessingHelpers.setDocumentation(_reference_92, _builder_169.toString());
    EClass _class_46 = PostprocessingHelpers.getClass(pckg, "RelaySAPoint");
    cls = _class_46;
    StringConcatenation _builder_170 = new StringConcatenation();
    _builder_170.append("Links from a relay {@link SPP} of the actor class.");
    _builder_170.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_170.toString());
    EReference _reference_93 = PostprocessingHelpers.getReference(cls, "relay");
    StringConcatenation _builder_171 = new StringConcatenation();
    _builder_171.append("This is the referenced SPP.");
    _builder_171.newLine();
    PostprocessingHelpers.setDocumentation(_reference_93, _builder_171.toString());
    EClass _class_47 = PostprocessingHelpers.getClass(pckg, "SPPoint");
    cls = _class_47;
    StringConcatenation _builder_172 = new StringConcatenation();
    _builder_172.append("Links to a {@link SPP} of an {@link ActorContainerRef}, i.e. an SPP of a sub actor");
    _builder_172.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_172.toString());
    EReference _reference_94 = PostprocessingHelpers.getReference(cls, "ref");
    StringConcatenation _builder_173 = new StringConcatenation();
    _builder_173.append("This is the referenced actor container ref.");
    _builder_173.newLine();
    PostprocessingHelpers.setDocumentation(_reference_94, _builder_173.toString());
    EReference _reference_95 = PostprocessingHelpers.getReference(cls, "service");
    StringConcatenation _builder_174 = new StringConcatenation();
    _builder_174.append("This is the referenced service.");
    _builder_174.newLine();
    PostprocessingHelpers.setDocumentation(_reference_95, _builder_174.toString());
    EClass _class_48 = PostprocessingHelpers.getClass(pckg, "ActorRef");
    cls = _class_48;
    StringConcatenation _builder_175 = new StringConcatenation();
    _builder_175.append("A means to compose {@link SubSystemClass}es of {@link ActorClass}es. Each ref will");
    _builder_175.newLine();
    _builder_175.append("be turned into an actor instance of the referenced type.");
    _builder_175.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_175.toString());
    EReference _reference_96 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_176 = new StringConcatenation();
    _builder_176.append("This is the type (i.e. actor class) of the actor ref.");
    _builder_176.newLine();
    PostprocessingHelpers.setDocumentation(_reference_96, _builder_176.toString());
    EAttribute _attribute_30 = PostprocessingHelpers.getAttribute(cls, "multiplicity");
    StringConcatenation _builder_177 = new StringConcatenation();
    _builder_177.append("If the size is >1 then this is a replicated actor.");
    _builder_177.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_30, _builder_177.toString());
  }
}
