/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.naming;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.room.util.RoomSwitch;

public class RoomNameProvider
extends FSMNameProvider {
    @Inject
    protected RoomHelpers roomHelpers;
    private CombinedProvider roomNameProvider = new CombinedProvider();

    public String getName(EObject item) {
        String name = (String)this.roomNameProvider.doSwitch(item);
        if (name == null) {
            name = item.toString();
        }
        return name;
    }

    public String getClassLocation(RoomClass cls) {
        if (cls == null) {
            return null;
        }
        if (cls.eContainer() instanceof RoomModel) {
            return String.valueOf(((RoomModel)cls.eContainer()).getName()) + "." + cls.getName();
        }
        return cls.getName();
    }

    public String getLocation(EObject source) {
        String location = null;
        String clsLocation = this.getClassLocation(this.roomHelpers.getRoomClass(source));
        while (source != null) {
            if (source instanceof StateGraph) {
                location = this.getFullPath((StateGraph)source);
                break;
            }
            if (source instanceof StateGraphItem) {
                location = this.getFullPath((StateGraphItem)source);
                break;
            }
            location = this.getName(source);
            if (location != null) break;
            source = source.eContainer();
        }
        if (location == null) {
            location = "";
        }
        if (clsLocation != null) {
            location = String.valueOf(location) + " [" + clsLocation + "]";
        }
        return location;
    }

    public String getRefLabelName(ActorContainerRef acr) {
        String className = "<unknown>";
        if (acr instanceof ActorRef) {
            if (((ActorRef)acr).getType() != null) {
                className = ((ActorRef)acr).getType().getName();
            }
        } else if (acr instanceof SubSystemRef && ((SubSystemRef)acr).getType() != null) {
            className = ((SubSystemRef)acr).getType().getName();
        }
        return String.valueOf(acr.getName()) + "\n(" + className + ")";
    }

    public String getSignature(Operation op) {
        String rt;
        String signature = "";
        for (VarDecl arg : op.getArguments()) {
            signature = signature.isEmpty() ? String.valueOf(arg.getName()) + ": " + arg.getRefType().getType().getName() : String.valueOf(signature) + ", " + arg.getName() + ": " + arg.getRefType().getType().getName();
        }
        String string = rt = op.getReturnType() != null ? ": " + op.getReturnType().getType().getName() : "";
        if (op instanceof PortOperation && ((PortOperation)op).getSendsMsg() != null) {
            rt = " sends " + ((PortOperation)op).getSendsMsg().getName();
        }
        signature = String.valueOf(op.getName()) + "(" + signature + ")" + rt;
        return signature;
    }

    public String getArguments(Operation op) {
        String signature = "";
        for (VarDecl arg : op.getArguments()) {
            signature = signature.isEmpty() ? arg.getName() : String.valueOf(signature) + ", " + arg.getName();
        }
        signature = "(" + signature + ")";
        return signature;
    }

    public String getTypedArgumentList(Operation op) {
        String signature = "";
        for (VarDecl arg : op.getArguments()) {
            signature = signature.isEmpty() ? String.valueOf(arg.getName()) + ": " + arg.getRefType().getType().getName() : String.valueOf(signature) + ", " + arg.getName() + ": " + arg.getRefType().getType().getName();
        }
        signature = "(" + signature + ")";
        return signature;
    }

    public String getDetailCodeLocation(DetailCode code) {
        if (code.eContainer() instanceof Transition) {
            Transition tr = (Transition)code.eContainer();
            String where = "?";
            if (code == tr.getAction()) {
                where = "action";
            } else if (tr instanceof CPBranchTransition && code == ((CPBranchTransition)tr).getCondition()) {
                where = "condition";
            } else if (tr instanceof GuardedTransition && code == ((GuardedTransition)tr).getGuard()) {
                where = "guard";
            }
            return "transition " + tr.getName() + ": " + this.getTransitionName(tr) + " " + where + " code";
        }
        if (code.eContainer() instanceof Trigger) {
            Transition tr = (Transition)code.eContainer().eContainer();
            return "transition " + tr.getName() + ": " + this.getTransitionName(tr) + " trigger guard";
        }
        if (code.eContainer() instanceof State) {
            State state = (State)code.eContainer();
            String where = "?";
            where = code == state.getEntryCode() ? "entry" : (code == state.getExitCode() ? "exit" : "do");
            return "state " + this.getStatePathName(state) + " " + where + " code";
        }
        if (code.eContainer() instanceof Operation) {
            return "operation " + this.getSignature((Operation)code.eContainer());
        }
        assert (false) : "unexpected detaild code location";
        return "???";
    }

    public String getDisplayName(BindingEndPoint ep) {
        if (ep.getSub() != null) {
            return String.valueOf(ep.getPort().getName()) + " sub " + ep.getSub().getName();
        }
        return ep.getPort().getName();
    }

    public String getDisplayName(Binding bind) {
        return String.valueOf(this.getDisplayName(bind.getEndpoint1())) + " and " + this.getDisplayName(bind.getEndpoint2());
    }

    private class CombinedProvider
    extends ComposedSwitch<String> {
        public CombinedProvider() {
            this.addSwitch(new RoomProvider());
            this.addSwitch((Switch)new FSMNameProvider.FSMNameProviderSwitch((FSMNameProvider)RoomNameProvider.this));
        }
    }

    protected class RoomProvider
    extends RoomSwitch<String> {
        protected RoomProvider() {
        }

        @Override
        public String caseActorRef(ActorRef object) {
            return "ActorRef '" + object.getName() + "'";
        }

        @Override
        public String casePort(Port object) {
            return "Port '" + object.getName() + "'";
        }

        @Override
        public String caseSAP(SAP object) {
            return "SAP '" + object.getName() + "'";
        }

        @Override
        public String caseSPP(SPP object) {
            return "SPP '" + object.getName() + "'";
        }

        @Override
        public String caseActorClass(ActorClass object) {
            return "ActorClass " + object.getName();
        }

        @Override
        public String caseSubSystemClass(SubSystemClass object) {
            return "SubsystemClass " + object.getName();
        }
    }
}

