/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubProtocol;

public class CompoundProtocolHelpers {
    public static List<Match> getMatches(Port left, ActorContainerRef leftRef, Port right, ActorContainerRef rightRef, StructureClass sc, Binding exclude) {
        List<Match> matches = CompoundProtocolHelpers.getMatches(left.getProtocol(), right.getProtocol());
        boolean leftCompound = left.getProtocol() instanceof CompoundProtocolClass;
        boolean rightCompound = right.getProtocol() instanceof CompoundProtocolClass;
        boolean isBound = false;
        for (Binding bind : sc.getBindings()) {
            if (bind == exclude || bind.getEndpoint1().getPort() != left || bind.getEndpoint1().getActorRef() != leftRef || bind.getEndpoint2().getPort() != right || bind.getEndpoint2().getActorRef() != rightRef || bind.getEndpoint2().getPort() != left || bind.getEndpoint2().getActorRef() != leftRef || bind.getEndpoint1().getPort() != right || bind.getEndpoint1().getActorRef() != rightRef) continue;
            isBound = true;
            if (bind.getEndpoint1().getSub() == null && bind.getEndpoint2().getSub() == null) {
                matches.clear();
                return matches;
            }
            ArrayList<Match> copy = new ArrayList<Match>(matches);
            for (Match match : copy) {
                if ((!leftCompound || match.getLeft() != bind.getEndpoint1().getSub()) && (!rightCompound || match.getRight() != bind.getEndpoint2().getSub())) continue;
                matches.remove(match);
            }
        }
        if (isBound) {
            for (Match match : matches) {
                if (match.getLeft() != null || match.getRight() != null) continue;
                matches.remove(match);
                break;
            }
        }
        return matches;
    }

    private static List<Match> getMatches(GeneralProtocolClass left, GeneralProtocolClass right) {
        ProtocolClass regular = null;
        CompoundProtocolClass compound = null;
        if (left instanceof ProtocolClass) {
            regular = (ProtocolClass)left;
        } else {
            compound = (CompoundProtocolClass)left;
        }
        if (right instanceof ProtocolClass) {
            if (regular != null) {
                throw new IllegalArgumentException("not both arguments must be of type ProtocolClass");
            }
            regular = (ProtocolClass)right;
        } else {
            if (compound != null) {
                return CompoundProtocolHelpers.getCompound2CompoundMatches((CompoundProtocolClass)left, (CompoundProtocolClass)right);
            }
            compound = (CompoundProtocolClass)right;
        }
        List<Match> result = CompoundProtocolHelpers.getCompound2RegularMatches(compound, regular);
        if (compound == right) {
            for (Match match : result) {
                match.swap();
            }
        }
        return result;
    }

    private static List<Match> getCompound2RegularMatches(CompoundProtocolClass compound, ProtocolClass regular) {
        ArrayList<Match> result = new ArrayList<Match>();
        for (SubProtocol sub : compound.getSubProtocols()) {
            if (sub.getProtocol() != regular) continue;
            result.add(new Match(sub, null));
        }
        return result;
    }

    private static List<Match> getCompound2CompoundMatches(CompoundProtocolClass left, CompoundProtocolClass right) {
        ArrayList<Match> result = new ArrayList<Match>();
        if (left == right) {
            result.add(new Match(null, null));
        }
        for (SubProtocol lsub : left.getSubProtocols()) {
            for (SubProtocol rsub : right.getSubProtocols()) {
                if (lsub.getProtocol() != rsub.getProtocol()) continue;
                result.add(new Match(lsub, rsub));
            }
        }
        return result;
    }

    public static class Match {
        private SubProtocol left;
        private SubProtocol right;

        public Match(SubProtocol left, SubProtocol right) {
            this.left = left;
            this.right = right;
        }

        public SubProtocol getLeft() {
            return this.left;
        }

        public SubProtocol getRight() {
            return this.right;
        }

        protected void swap() {
            SubProtocol tmp = this.left;
            this.left = this.right;
            this.right = tmp;
        }
    }
}

