/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.ClassStructor;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.RefSegment;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;

public class RoomHelpers
extends FSMHelpers {
    public List<ActorClass> getClassHierarchy(ActorClass ac) {
        ArrayList<ActorClass> result = new ArrayList<ActorClass>();
        while (ac != null) {
            result.add(0, ac);
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<InterfaceItem> getInterfaceItems(StructureClass sc, boolean includeInherited) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<InterfaceItem>)ac.getServiceProvisionPoints());
                result.addAll((Collection<InterfaceItem>)ac.getInterfacePorts());
                ac = ac.getActorBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<InterfaceItem>)((SubSystemClass)sc).getServiceProvisionPoints());
            result.addAll((Collection<InterfaceItem>)((SubSystemClass)sc).getRelayPorts());
        } else if (!(sc instanceof LogicalSystem)) assert (false) : "unexpected sub type";
        return result;
    }

    public List<ActorContainerRef> getRefs(StructureClass sc, boolean includeInherited) {
        ArrayList<ActorContainerRef> result = new ArrayList<ActorContainerRef>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<ActorContainerRef>)ac.getActorRefs());
                ac = ac.getActorBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<ActorContainerRef>)((SubSystemClass)sc).getActorRefs());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<ActorContainerRef>)((LogicalSystem)sc).getSubSystems());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public List<Binding> getBindings(StructureClass sc, boolean includeInherited) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<Binding>)ac.getBindings());
                ac = ac.getActorBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<Binding>)((SubSystemClass)sc).getBindings());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<Binding>)((LogicalSystem)sc).getBindings());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public List<LayerConnection> getConnections(StructureClass sc, boolean includeInherited) {
        ArrayList<LayerConnection> result = new ArrayList<LayerConnection>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<LayerConnection>)ac.getConnections());
                ac = ac.getActorBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<LayerConnection>)((SubSystemClass)sc).getConnections());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<LayerConnection>)((LogicalSystem)sc).getConnections());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public String getDeepUserCode1(DataClass dc) {
        return this.getDeepUserCode(dc, (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__USER_CODE1);
    }

    public String getDeepUserCode2(DataClass dc) {
        return this.getDeepUserCode(dc, (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__USER_CODE2);
    }

    public String getDeepUserCode3(DataClass dc) {
        return this.getDeepUserCode(dc, (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__USER_CODE3);
    }

    public String getDeepUserCode1(ProtocolClass pc) {
        return this.getDeepUserCode(pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__USER_CODE1);
    }

    public String getDeepUserCode2(ProtocolClass pc) {
        return this.getDeepUserCode(pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__USER_CODE2);
    }

    public String getDeepUserCode3(ProtocolClass pc) {
        return this.getDeepUserCode(pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__USER_CODE3);
    }

    public String getDeepUserCode1(ActorContainerClass ac) {
        return this.getDeepUserCode(ac, (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__USER_CODE1);
    }

    public String getDeepUserCode2(ActorContainerClass ac) {
        return this.getDeepUserCode(ac, (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__USER_CODE2);
    }

    public String getDeepUserCode3(ActorContainerClass ac) {
        return this.getDeepUserCode(ac, (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__USER_CODE3);
    }

    private String getDeepUserCode(EObject obj, EStructuralFeature code) {
        StringBuilder result = new StringBuilder();
        while (obj != null) {
            DetailCode dc = (DetailCode)obj.eGet(code);
            result.insert(0, this.getDetailCode(dc));
            if (obj instanceof ActorClass) {
                obj = ((ActorClass)obj).getBase();
                continue;
            }
            if (obj instanceof ProtocolClass) {
                obj = ((ProtocolClass)obj).getBase();
                continue;
            }
            if (!(obj instanceof DataClass)) break;
            obj = ((DataClass)obj).getBase();
        }
        return result.toString();
    }

    public List<Message> getAllIncomingMessages(ProtocolClass pc) {
        return this.getAllMessages(pc, true);
    }

    public List<Message> getAllOutgoingMessages(ProtocolClass pc) {
        return this.getAllMessages(pc, false);
    }

    public List<Message> getAllMessages(ProtocolClass pc, boolean incoming) {
        ArrayList<Message> result = new ArrayList<Message>();
        while (pc != null) {
            if (incoming) {
                result.addAll(0, (Collection<Message>)pc.getIncomingMessages());
            } else {
                result.addAll(0, (Collection<Message>)pc.getOutgoingMessages());
            }
            pc = pc.getBase();
        }
        return result;
    }

    public List<PortOperation> getAllOperations(ProtocolClass pc, boolean incoming) {
        ArrayList<PortOperation> result = new ArrayList<PortOperation>();
        while (pc != null) {
            if (incoming) {
                if (pc.getRegular() != null) {
                    result.addAll(0, (Collection<PortOperation>)pc.getRegular().getOperations());
                }
            } else if (pc.getConjugated() != null) {
                result.addAll(0, (Collection<PortOperation>)pc.getConjugated().getOperations());
            }
            pc = pc.getBase();
        }
        return result;
    }

    public List<Message> getIncoming(InterfaceItem item) {
        if (this.getProtocol(item) != null) {
            return this.getAllMessages(this.getProtocol(item), !this.isConjugated(item));
        }
        return Collections.emptyList();
    }

    public List<Message> getOutgoing(InterfaceItem item) {
        if (this.getProtocol(item) != null) {
            return this.getAllMessages(this.getProtocol(item), this.isConjugated(item));
        }
        return Collections.emptyList();
    }

    public boolean isConjugated(InterfaceItem item) {
        if (item instanceof Port) {
            return ((Port)item).isConjugated();
        }
        if (item instanceof SAP) {
            return true;
        }
        if (item instanceof SPP) {
            return false;
        }
        assert (false) : "unexpected sub type";
        return true;
    }

    public List<Attribute> getAllAttributes(ActorClass ac) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        while (ac != null) {
            result.addAll(0, (Collection<Attribute>)ac.getAttributes());
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<Attribute> getAllAttributes(DataClass dc) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        while (dc != null) {
            result.addAll(0, (Collection<Attribute>)dc.getAttributes());
            dc = dc.getBase();
        }
        return result;
    }

    public List<StandardOperation> getAllOperations(ActorClass ac) {
        ArrayList<StandardOperation> result = new ArrayList<StandardOperation>();
        while (ac != null) {
            result.addAll(0, (Collection<StandardOperation>)ac.getOperations());
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<ClassStructor> getAllStructors(ActorClass ac) {
        ArrayList<ClassStructor> result = new ArrayList<ClassStructor>();
        while (ac != null) {
            result.addAll(0, (Collection<ClassStructor>)ac.getStructors());
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<StandardOperation> getAllOperations(DataClass dc) {
        ArrayList<StandardOperation> result = new ArrayList<StandardOperation>();
        while (dc != null) {
            result.addAll(0, (Collection<StandardOperation>)dc.getOperations());
            dc = dc.getBase();
        }
        return result;
    }

    public List<StandardOperation> getLatestOperations(ActorClass ac) {
        HashMap map = Maps.newHashMap();
        ActorClass base = ac;
        while (base != null) {
            for (StandardOperation op : base.getOperations()) {
                if (map.containsKey(op.getName())) continue;
                map.put(op.getName(), op);
            }
            base = base.getActorBase();
        }
        return Lists.newArrayList(map.values());
    }

    public List<StandardOperation> getLatestOperations(DataClass dc) {
        HashMap map = Maps.newHashMap();
        DataClass base = dc;
        while (base != null) {
            for (StandardOperation op : base.getOperations()) {
                if (map.containsKey(op.getName())) continue;
                map.put(op.getName(), op);
            }
            base = base.getBase();
        }
        return Lists.newArrayList(map.values());
    }

    public List<ClassStructor> getAllStructors(DataClass ac) {
        ArrayList<ClassStructor> result = new ArrayList<ClassStructor>();
        while (ac != null) {
            result.addAll(0, (Collection<ClassStructor>)ac.getStructors());
            ac = ac.getBase();
        }
        return result;
    }

    public List<Port> getEndPorts(ActorClass ac) {
        ArrayList<Port> result = new ArrayList<Port>((Collection<Port>)ac.getInternalPorts());
        int insertAt = 0;
        for (ExternalPort p : ac.getExternalPorts()) {
            result.add(insertAt++, p.getInterfacePort());
        }
        return result;
    }

    public List<SAP> getAllSAPs(ActorClass ac) {
        ArrayList<SAP> result = new ArrayList<SAP>();
        while (ac != null) {
            result.addAll(0, (Collection<SAP>)ac.getServiceAccessPoints());
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<ServiceImplementation> getAllServiceImplementations(ActorClass ac) {
        ArrayList<ServiceImplementation> result = new ArrayList<ServiceImplementation>();
        while (ac != null) {
            result.addAll(0, (Collection<ServiceImplementation>)ac.getServiceImplementations());
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<Port> getAllEndPorts(ActorClass ac) {
        ArrayList<Port> result = new ArrayList<Port>();
        while (ac != null) {
            result.addAll(0, (Collection<Port>)ac.getInternalPorts());
            int insertAt = 0;
            for (ExternalPort p : ac.getExternalPorts()) {
                result.add(insertAt++, p.getInterfacePort());
            }
            ac = ac.getActorBase();
        }
        return result;
    }

    public List<Port> getInterfacePorts(ActorContainerClass ac) {
        if (ac instanceof ActorClass) {
            return ((ActorClass)ac).getInterfacePorts();
        }
        if (ac instanceof SubSystemClass) {
            return ((SubSystemClass)ac).getRelayPorts();
        }
        assert (false) : "unexpected sub type";
        return null;
    }

    public List<Port> getAllInterfacePorts(ActorContainerClass ac) {
        if (ac instanceof ActorClass) {
            ArrayList<Port> result = new ArrayList<Port>();
            ActorClass curr = (ActorClass)ac;
            while (curr != null) {
                result.addAll(0, (Collection<Port>)curr.getInterfacePorts());
                curr = curr.getActorBase();
            }
            return result;
        }
        if (ac instanceof SubSystemClass) {
            return ((SubSystemClass)ac).getRelayPorts();
        }
        assert (false) : "unexpected sub type";
        return null;
    }

    public List<InterfaceItem> getInterfaceItems(ActorClass ac) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        result.addAll((Collection<InterfaceItem>)ac.getInternalPorts());
        result.addAll((Collection<InterfaceItem>)ac.getExternalEndPorts());
        result.addAll((Collection<InterfaceItem>)ac.getServiceAccessPoints());
        result.addAll((Collection<InterfaceItem>)ac.getImplementedSPPs());
        return result;
    }

    public boolean isCircularClassHierarchy(DataClass dc) {
        HashSet<DataClass> classes = new HashSet<DataClass>();
        classes.add(dc);
        while (dc.getBase() != null) {
            if (classes.contains(dc = dc.getBase())) {
                return true;
            }
            classes.add(dc);
        }
        return false;
    }

    public boolean isCircularClassHierarchy(ProtocolClass pc) {
        HashSet<ProtocolClass> classes = new HashSet<ProtocolClass>();
        classes.add(pc);
        while (pc.getBase() != null) {
            if (classes.contains(pc = pc.getBase())) {
                return true;
            }
            classes.add(pc);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public List<InterfaceItem> getAllInterfaceItems(ActorClass ac) {
        result = new ArrayList<InterfaceItem>();
        if (!this.isCircularClassHierarchy(ac)) ** GOTO lbl13
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<InterfaceItem>)ac.getInternalPorts());
            result.addAll((Collection<InterfaceItem>)ac.getExternalEndPorts());
            result.addAll((Collection<InterfaceItem>)ac.getServiceAccessPoints());
            result.addAll((Collection<InterfaceItem>)ac.getImplementedSPPs());
            ac = ac.getActorBase();
lbl13:
            // 2 sources

            ** while (ac != null)
        }
lbl14:
        // 1 sources

        return result;
    }

    /*
     * Unable to fully structure code
     */
    public List<Port> getAllPorts(ActorClass ac) {
        result = new ArrayList<Port>();
        if (!this.isCircularClassHierarchy(ac)) ** GOTO lbl9
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<Port>)ac.getInternalPorts());
            result.addAll((Collection<Port>)ac.getInterfacePorts());
            ac = ac.getActorBase();
lbl9:
            // 2 sources

            ** while (ac != null)
        }
lbl10:
        // 1 sources

        return result;
    }

    public List<ActorContainerRef> getAllActorContainerRefs(StructureClass sc) {
        ArrayList<ActorContainerRef> refs = new ArrayList<ActorContainerRef>();
        if (sc instanceof LogicalSystem) {
            refs.addAll((Collection<ActorContainerRef>)((LogicalSystem)sc).getSubSystems());
        } else if (sc instanceof ActorContainerClass) {
            refs.addAll((Collection<ActorContainerRef>)((ActorContainerClass)sc).getActorRefs());
            if (sc instanceof ActorClass) {
                ActorClass base = (ActorClass)sc;
                while ((base = base.getActorBase()) != null) {
                    refs.addAll((Collection<ActorContainerRef>)base.getActorRefs());
                }
            }
        }
        return refs;
    }

    /*
     * Unable to fully structure code
     */
    public List<Binding> getAllBindings(ActorClass ac) {
        result = new ArrayList<Binding>();
        if (!this.isCircularClassHierarchy(ac)) ** GOTO lbl7
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<Binding>)ac.getBindings());
            ac = ac.getActorBase();
lbl7:
            // 2 sources

            ** while (ac != null)
        }
lbl8:
        // 1 sources

        return result;
    }

    /*
     * Unable to fully structure code
     */
    public List<LayerConnection> getAllLayerConnections(ActorClass ac) {
        result = new ArrayList<LayerConnection>();
        if (!this.isCircularClassHierarchy(ac)) ** GOTO lbl7
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<LayerConnection>)ac.getConnections());
            ac = ac.getActorBase();
lbl7:
            // 2 sources

            ** while (ac != null)
        }
lbl8:
        // 1 sources

        return result;
    }

    public ActorClass getActorClass(StateGraphItem item) {
        StateGraphItem parent = item;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ActorClass)) continue;
            return (ActorClass)parent;
        }
        assert (false) : "data structure broken";
        return null;
    }

    public ActorClass getActorClass(EObject obj) {
        EObject parent = obj;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ActorClass)) continue;
            return (ActorClass)parent;
        }
        return null;
    }

    public RoomClass getRoomClass(EObject obj) {
        while (obj != null) {
            if (obj instanceof RoomClass) {
                return (RoomClass)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public ProtocolClass getProtocolClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ProtocolClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ProtocolClass) {
            return (ProtocolClass)ctx;
        }
        return null;
    }

    public boolean isAnnotationPresent(ActorClass ac, String name) {
        return this.isAnnotationPresent((List)ac.getAnnotations(), name);
    }

    public boolean isBehaviorAnnotationPresent(ActorClass ac, String name) {
        return this.isAnnotationPresent((List)ac.getBehaviorAnnotations(), name);
    }

    public List<KeyValue> getAttributes(ActorClass ac, String name) {
        return this.getAttributes((List)ac.getAnnotations(), name);
    }

    public List<KeyValue> getBehaviorAttributes(ActorClass ac, String name) {
        return this.getAttributes((List)ac.getBehaviorAnnotations(), name);
    }

    public boolean isAttributePresent(ActorClass ac, String name, String key) {
        return this.isAttributePresent((List)ac.getAnnotations(), name, key);
    }

    public boolean isBehaviorAttributePresent(ActorClass ac, String name, String key) {
        return this.isAttributePresent((List)ac.getBehaviorAnnotations(), name, key);
    }

    public String getAttribute(ActorClass ac, String name, String key) {
        return this.getAttribute((List)ac.getAnnotations(), name, key);
    }

    public String getBehaviorAttribute(ActorClass ac, String name, String key) {
        return this.getAttribute((List)ac.getBehaviorAnnotations(), name, key);
    }

    public List<Message> getMessageListDeep(InterfaceItem item, boolean outgoing) {
        ProtocolClass protocol = null;
        if (item instanceof Port) {
            if (!(((Port)item).getProtocol() instanceof ProtocolClass)) {
                assert (false) : "unexpected protocol type";
                return null;
            }
            protocol = (ProtocolClass)((Port)item).getProtocol();
            if (((Port)item).isConjugated()) {
                outgoing = !outgoing;
            }
        } else if (item instanceof SAP) {
            outgoing = !outgoing;
            protocol = ((SAP)item).getProtocol();
        } else if (item instanceof SPP) {
            protocol = ((SPP)item).getProtocol();
        } else {
            assert (false) : "unexpected sub type";
            return null;
        }
        return this.getAllMessages(protocol, !outgoing);
    }

    public PortClass getPortClass(InterfaceItem item) {
        ProtocolClass protocol = null;
        boolean conjugated = false;
        if (item instanceof Port) {
            if (!(((Port)item).getProtocol() instanceof ProtocolClass)) {
                assert (false) : "unexpected protocol type";
                return null;
            }
            protocol = (ProtocolClass)((Port)item).getProtocol();
            conjugated = ((Port)item).isConjugated();
        } else if (item instanceof SAP) {
            protocol = ((SAP)item).getProtocol();
            conjugated = true;
        } else if (item instanceof SPP) {
            protocol = ((SPP)item).getProtocol();
        } else {
            assert (false) : "unexpected sub type";
            return null;
        }
        return conjugated ? protocol.getConjugated() : protocol.getRegular();
    }

    public boolean isRelay(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            if (((ActorClass)acc).getInterfacePorts().contains((Object)port)) {
                for (ExternalPort xp : ((ActorClass)acc).getExternalPorts()) {
                    if (xp.getInterfacePort() != port) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isInternal(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            return ((ActorClass)acc).getInternalPorts().contains((Object)port);
        }
        return false;
    }

    public boolean isExternal(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            for (ExternalPort ep : ((ActorClass)acc).getExternalPorts()) {
                if (ep.getInterfacePort() != port) continue;
                return true;
            }
        }
        return false;
    }

    public ProtocolClass getProtocol(InterfaceItem item) {
        GeneralProtocolClass pc = this.getGeneralProtocol(item);
        if (pc instanceof ProtocolClass) {
            return (ProtocolClass)pc;
        }
        return null;
    }

    public boolean isDataDriven(InterfaceItem item) {
        ProtocolClass pc = this.getProtocol(item);
        return pc != null && pc.getCommType() == CommunicationType.DATA_DRIVEN;
    }

    public GeneralProtocolClass getGeneralProtocol(InterfaceItem item) {
        if (item instanceof Port) {
            return ((Port)item).getProtocol();
        }
        if (item instanceof SAP) {
            return ((SAP)item).getProtocol();
        }
        if (item instanceof SPP) {
            return ((SPP)item).getProtocol();
        }
        assert (item.eIsProxy()) : "unexpected sub type";
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public RefableType getLastCommonSuperType(List<RefableType> types) {
        int nref = 0;
        int ndc = 0;
        for (RefableType rt : types) {
            if (rt == null) {
                return null;
            }
            if (rt.getType() instanceof DataClass) {
                ++ndc;
            }
            if (!rt.isRef()) continue;
            ++nref;
        }
        if (nref != 0 && nref != types.size()) {
            return null;
        }
        if (ndc == 0) {
            DataType type = types.get(0).getType();
            for (RefableType rt : types) {
                if (rt.getType() == type) continue;
                return null;
            }
            return (RefableType)EcoreUtil.copy((EObject)types.get(0));
        }
        if (ndc == types.size()) {
            void var7_15;
            ArrayList allSuperTypes = new ArrayList();
            for (RefableType rt : types) {
                void var7_9;
                DataClass dataClass = (DataClass)rt.getType();
                ArrayList superTypes = new ArrayList();
                allSuperTypes.add(superTypes);
                while (var7_9 != null) {
                    superTypes.add(0, var7_9);
                    DataClass dataClass2 = var7_9.getBase();
                }
            }
            int min = ((ArrayList)allSuperTypes.get(0)).size();
            DataClass common = (DataClass)((ArrayList)allSuperTypes.get(0)).get(0);
            for (ArrayList arrayList : allSuperTypes) {
                min = Math.min(min, arrayList.size());
                if (arrayList.get(0) == common) continue;
                return null;
            }
            boolean bl = true;
            block5: while (var7_15 < min) {
                DataClass better = (DataClass)((ArrayList)allSuperTypes.get(0)).get((int)var7_15);
                for (ArrayList arrayList : allSuperTypes) {
                    if (arrayList.get((int)var7_15) != better) break block5;
                }
                common = better;
                ++var7_15;
            }
            RefableType refableType = RoomFactory.eINSTANCE.createRefableType();
            refableType.setRef(nref > 0);
            refableType.setType(common);
            return refableType;
        }
        return null;
    }

    public ActorContainerClass getParentContainer(ActorInstanceMapping aim) {
        ActorContainerClass root = null;
        if (aim.eContainer() instanceof ActorInstanceMapping) {
            ActorInstanceMapping parent = (ActorInstanceMapping)aim.eContainer();
            root = this.getActorContainerClass(parent);
        } else if (aim.eContainer() instanceof SubSystemClass) {
            root = (SubSystemClass)aim.eContainer();
        }
        return root;
    }

    public ActorContainerClass getActorContainerClass(ActorInstanceMapping aim) {
        ActorContainerClass result = this.getParentContainer(aim);
        for (RefSegment ref : aim.getPath().getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : this.getRefs(result, true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref.getRef())) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
        }
        return result;
    }

    public String asString(RefPath path) {
        StringBuilder sb = new StringBuilder();
        for (RefSegment ref : path.getRefs()) {
            sb.append("/" + ref);
        }
        return sb.toString();
    }

    public ActorRef getLastActorRef(ActorContainerClass root, RefPath path) {
        if (path.getRefs().isEmpty()) {
            return null;
        }
        ActorRef lastMatch = null;
        ActorContainerClass result = root;
        for (RefSegment ref : path.getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : this.getRefs(result, true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref.getRef())) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
            lastMatch = match;
        }
        return lastMatch;
    }

    public String checkPath(ActorContainerClass root, RefPath path) {
        if (path == null) {
            return null;
        }
        ActorContainerClass last = root;
        Iterator it = path.getRefs().iterator();
        while (it.hasNext()) {
            RefSegment ref = (RefSegment)it.next();
            ActorRef match = null;
            for (ActorRef actor : last.getActorRefs()) {
                if (!actor.getName().equals(ref.getRef())) continue;
                match = actor;
                break;
            }
            ArrayList<InterfaceItem> ifs = new ArrayList<InterfaceItem>();
            ifs.addAll((Collection<InterfaceItem>)last.getServiceProvisionPoints());
            if (last instanceof ActorClass) {
                ActorClass actor = (ActorClass)last;
                ifs.addAll((Collection<InterfaceItem>)actor.getInterfacePorts());
                ifs.addAll((Collection<InterfaceItem>)actor.getInternalPorts());
            }
            if (last instanceof SubSystemClass) {
                ifs.addAll((Collection<InterfaceItem>)((SubSystemClass)last).getRelayPorts());
            }
            for (InterfaceItem item : ifs) {
                if (!item.getName().equals(ref) || it.hasNext()) continue;
                return null;
            }
            if (match == null) {
                return ref.getRef();
            }
            if (match.getMultiplicity() == 1) {
                if (ref.getIdx() != -1) {
                    return String.valueOf(ref.toString()) + " (ref not indexed )";
                }
            } else {
                if (ref.getIdx() < 0) {
                    return String.valueOf(ref.toString()) + " (ref needs index)";
                }
                if (ref.getIdx() >= match.getMultiplicity()) {
                    return String.valueOf(ref.toString()) + " (index out of bounds)";
                }
            }
            last = match.getType();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDerivedFrom(ProtocolClass pc1, ProtocolClass pc2) {
        if (pc1 != pc2) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (pc1 == pc2) {
                return true;
            }
            pc1 = pc1.getBase();
lbl6:
            // 2 sources

            ** while (pc1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isKindOf(ActorClass ac1, ActorClass ac2) {
        if (ac2 == null) {
            return false;
        }
        if (ac1 != null && !this.isCircularClassHierarchy(ac1)) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (ac2 == ac1) {
                return true;
            }
            ac1 = ac1.getActorBase();
lbl8:
            // 2 sources

            ** while (ac1 != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    public boolean isReferencing(ActorClass ref, ActorClass ac) {
        if (this.isKindOf(ref, ac)) {
            return true;
        }
        HashSet<ActorClass> visited = new HashSet<ActorClass>();
        LinkedList<ActorClass> stack = new LinkedList<ActorClass>();
        visited.add(ac);
        stack.push(ref);
        while (!stack.isEmpty()) {
            ActorClass next = (ActorClass)stack.pop();
            if (visited.contains(next)) continue;
            for (ActorRef ar : next.getActorRefs()) {
                if (this.isKindOf(ar.getType(), ac) || this.isKindOf(next, ar.getType())) {
                    return true;
                }
                stack.push(ar.getType());
            }
            visited.add(next);
        }
        return false;
    }

    public boolean matchingArguments(Operation op1, Operation op2) {
        ArrayList sig1 = Lists.newArrayList();
        for (VarDecl varDecl : op1.getArguments()) {
            sig1.add(varDecl.getName());
            sig1.add(varDecl.getRefType().getType());
            sig1.add(varDecl.getRefType().isRef());
        }
        ArrayList sig2 = Lists.newArrayList();
        for (VarDecl varDecl : op2.getArguments()) {
            sig2.add(varDecl.getName());
            sig2.add(varDecl.getRefType().getType());
            sig2.add(varDecl.getRefType().isRef());
        }
        return sig1.equals(sig2);
    }

    public boolean matchingReturnType(Operation op1, Operation op2) {
        RefableType refType1 = op1.getReturnType();
        RefableType refType2 = op2.getReturnType();
        if (refType1 != null && refType2 != null) {
            return refType1.getType().equals(refType2.getType()) && refType1.isRef() == refType2.isRef();
        }
        return refType1 == null && refType2 == null;
    }
}

