/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import java.util.HashSet;
import org.eclipse.etrice.core.fsm.util.FSMUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;

public class RoomUtil
extends FSMUtil {
    public String getUniqueActorContainerRefName(StructureClass sc) {
        HashSet<String> names = new HashSet<String>();
        if (sc instanceof ActorContainerClass) {
            for (ActorContainerRef ar : ((ActorContainerClass)sc).getActorRefs()) {
                names.add(ar.getName());
            }
        } else if (sc instanceof LogicalSystem) {
            for (ActorContainerRef ar : ((LogicalSystem)sc).getSubSystems()) {
                names.add(ar.getName());
            }
        }
        int i = 0;
        while (i < 1000) {
            String name = "ref" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public String getUniqueInterfaceItemName(String prefix, ActorContainerClass acc) {
        HashSet<String> names = new HashSet<String>();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            do {
                for (Port p : ac.getInterfacePorts()) {
                    names.add(p.getName());
                }
                for (Port p : ac.getInternalPorts()) {
                    names.add(p.getName());
                }
                for (SAP sap : ac.getServiceAccessPoints()) {
                    names.add(sap.getName());
                }
                for (Object spp : ac.getServiceProvisionPoints()) {
                    names.add(spp.getName());
                }
            } while ((ac = ac.getActorBase()) != null);
        } else if (acc instanceof SubSystemClass) {
            for (Port p : ((SubSystemClass)acc).getRelayPorts()) {
                names.add(p.getName());
            }
            for (SPP spp : ((SubSystemClass)acc).getServiceProvisionPoints()) {
                names.add(spp.getName());
            }
        }
        int i = 0;
        while (i < 1000) {
            String name = String.valueOf(prefix) + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }
}

