/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.fsm.fSM.InSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.OutSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.scoping.FSMScopeProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InMessageHandler;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.OutMessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class RoomScopeProvider
extends FSMScopeProvider {
    @Inject
    private RoomHelpers roomHelpers;

    private ActorClass getActorClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ActorClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ActorClass) {
            return (ActorClass)ctx;
        }
        return null;
    }

    private ActorContainerClass getActorContainerClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ActorContainerClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ActorContainerClass) {
            return (ActorContainerClass)ctx;
        }
        return null;
    }

    private StructureClass getStructureClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof StructureClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof StructureClass) {
            return (StructureClass)ctx;
        }
        return null;
    }

    private LinkedList<ActorClass> getBaseClasses(ActorClass ac) {
        LinkedList<ActorClass> classes = new LinkedList<ActorClass>();
        if (ac != null) {
            classes.addFirst(ac);
            while (ac.getBase() != null) {
                if (ac == ac.getBase()) break;
                ac = ac.getActorBase();
                classes.addFirst(ac);
            }
        }
        return classes;
    }

    private LinkedList<ProtocolClass> getBaseClasses(ProtocolClass pc) {
        LinkedList<ProtocolClass> classes = new LinkedList<ProtocolClass>();
        classes.addFirst(pc);
        while (pc.getBase() != null) {
            pc = pc.getBase();
            classes.addFirst(pc);
        }
        return classes;
    }

    public IScope scope_MessageFromIf_message(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        InterfaceItem item = (InterfaceItem)mfi.getFrom();
        if (item != null) {
            ProtocolClass protocol = null;
            boolean conjugated = false;
            if (item instanceof Port && ((Port)item).getProtocol() instanceof ProtocolClass) {
                protocol = (ProtocolClass)((Port)item).getProtocol();
                conjugated = ((Port)item).isConjugated();
            } else if (item instanceof SAP) {
                protocol = ((SAP)item).getProtocol();
                conjugated = true;
            } else if (item instanceof SPP) {
                protocol = ((SPP)item).getProtocol();
                conjugated = false;
            }
            if (protocol != null) {
                for (Message msg : conjugated ? this.roomHelpers.getAllMessages(protocol, false) : this.roomHelpers.getAllMessages(protocol, true)) {
                    scopes.add(EObjectDescription.create((String)msg.getName(), (EObject)msg));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_port(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass((EObject)mfi);
        for (Object p : ac.getInternalPorts()) {
            scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
        }
        for (Object p : ac.getExternalPorts()) {
            scopes.add(EObjectDescription.create((String)p.getInterfacePort().getName(), (EObject)p.getInterfacePort()));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_from(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass((EObject)mfi);
        List<InterfaceItem> items = this.roomHelpers.getAllInterfaceItems(ac);
        for (InterfaceItem item : items) {
            scopes.add(EObjectDescription.create((String)item.getName(), (EObject)item));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_actorRef(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StructureClass sc = this.getStructureClass(ep);
        if (sc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)sc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else if (sc instanceof SubSystemClass) {
            for (ActorRef ar : ((SubSystemClass)sc).getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        } else {
            LogicalSystem ls = (LogicalSystem)sc;
            for (SubSystemRef ssr : ls.getSubSystems()) {
                scopes.add(EObjectDescription.create((String)ssr.getName(), (EObject)ssr));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_port(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block11: {
            block9: {
                StructureClass sc;
                block10: {
                    scopes = new ArrayList<IEObjectDescription>();
                    sc = this.getStructureClass(ep);
                    if (ep.getActorRef() != null) break block9;
                    if (!(sc instanceof ActorClass)) break block10;
                    ActorClass ac = (ActorClass)sc;
                    LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                    for (ActorClass a : classes) {
                        for (Port p : a.getInternalPorts()) {
                            scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                        }
                        for (Port p : a.getRelayPorts()) {
                            scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                        }
                    }
                    break block11;
                }
                if (!(sc instanceof SubSystemClass)) break block11;
                SubSystemClass ssc = (SubSystemClass)sc;
                for (Port p : ssc.getRelayPorts()) {
                    scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                }
                break block11;
            }
            if (ep.getActorRef() instanceof ActorRef) {
                ActorClass ac = ((ActorRef)ep.getActorRef()).getType();
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (Port p : a.getInterfacePorts()) {
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                }
            } else {
                SubSystemClass ssc = ((SubSystemRef)ep.getActorRef()).getType();
                for (Port p : ssc.getRelayPorts()) {
                    scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_sub(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        if (ep.getPort() != null && ep.getPort().getProtocol() instanceof CompoundProtocolClass) {
            CompoundProtocolClass pc = (CompoundProtocolClass)ep.getPort().getProtocol();
            for (SubProtocol sub : pc.getSubProtocols()) {
                scopes.add(EObjectDescription.create((String)sub.getName(), (EObject)sub));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SemanticsRule_msg(SemanticsRule sr, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = this.roomHelpers.getProtocolClass((EObject)sr);
        LinkedList<ProtocolClass> classes = this.getBaseClasses(pc);
        for (ProtocolClass bpc : classes) {
            if (sr instanceof InSemanticsRule) {
                for (Message m : bpc.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
            if (!(sr instanceof OutSemanticsRule)) continue;
            for (Message m : bpc.getOutgoingMessages()) {
                scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RefSAPoint_ref(RefSAPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass acc = this.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)acc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : acc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RelaySAPoint_relay(RelaySAPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(pt);
        LinkedList<ActorClass> classes = this.getBaseClasses(ac);
        for (ActorClass a : classes) {
            for (SPP spp : a.getServiceProvisionPoints()) {
                scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SPPoint_actorRef(SPPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass acc = this.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)acc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : acc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SPPoint_service(SPPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block3: {
            block4: {
                scopes = new ArrayList<IEObjectDescription>();
                if (pt.getRef() == null) break block3;
                if (!(pt.getRef() instanceof ActorRef)) break block4;
                ActorClass ac = ((ActorRef)pt.getRef()).getType();
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (SPP spp : a.getServiceProvisionPoints()) {
                        scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
                    }
                }
                break block3;
            }
            if (!(pt.getRef() instanceof SubSystemRef)) break block3;
            SubSystemClass ssc = ((SubSystemRef)pt.getRef()).getType();
            for (SPP spp : ssc.getServiceProvisionPoints()) {
                scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageHandler_msg(MessageHandler handler, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = this.roomHelpers.getProtocolClass(handler);
        if (pc != null) {
            if (handler instanceof InMessageHandler) {
                for (Message m : pc.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
            if (handler instanceof OutMessageHandler) {
                for (Message m : pc.getOutgoingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_PortOperation_sendsMsg(PortOperation op, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block4: {
            scopes = new ArrayList<IEObjectDescription>();
            PortClass pcls = (PortClass)op.eContainer();
            ProtocolClass pc = this.roomHelpers.getProtocolClass(op);
            if (pc == null) break block4;
            if (pcls == pc.getConjugated()) {
                for (Message m : pc.getIncomingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            } else {
                for (Message m : pc.getOutgoingMessages()) {
                    scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_ExternalPort_ifport(ExternalPort ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(ep);
        for (Port ip : ac.getInterfacePorts()) {
            scopes.add(EObjectDescription.create((String)ip.getName(), (EObject)ip));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }
}

