/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.validation.ValidationHelpers;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RoomAnnotationTargetEnum;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.AbstractRoomJavaValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.Check;

public class RoomJavaValidator
extends AbstractRoomJavaValidator {
    @Inject
    protected RoomHelpers roomHelpers;
    @Inject
    protected ValidationUtil validationUtil;
    @Inject
    protected IQualifiedNameProvider fqnProvider;
    public static final String OPTIONAL_REFS_HAVE_TO_HAVE_MULTIPLICITY_ANY = "optional refs have to have multiplicity any [*]";
    public static final String MULTIPLICITY_ANY_REQUIRES_OPTIONAL = "multiplicity any [*] requires optional";
    public static final String A_REPLICATED_PORT_MUST_HAVE_AT_MOST_ONE_REPLICATED_PEER = "a replicated port must have at most one replicated peer";
    public static final String THREAD_MISSING = "RoomJavaValidator.ThreadMissing";
    public static final String DUPLICATE_ACTOR_INSTANCE_MAPPING = "RoomJavaValidator.DuplicateActorInstanceMapping";
    public static final String WRONG_NAMESPACE = "RoomJavaValidator.WrongNamespace";
    public static final String CIRCULAR_CONTAINMENT = "RoomJavaValidator.CircularContainment";
    public static final String ACTOR_REF_CHANGE_REF_TYPE_TO_FIXED_OR_MULT_TO_ANY = "RoomJavaValidator.ActorRefChangeRefTypeToFixed";
    public static final String ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL = "RoomJavaValidator.ActorRefChangeRefTypeToOptional";
    public static final String CHANGE_DESTRUCTOR_NAME = "RoomJavaValidator.ChangeDestructorName";
    public static final String CHANGE_CONSTRUCTOR_NAME = "RoomJavaValidator.ChangeConstructorName";
    public static final String INVALID_ANNOTATION_TARGET = "RoomJavaValidator.InvalidAnnotationTarget";
    public static final String OPERATION_MISSING_OVERRIDE = "RoomJavaValidator.OperationMissingOverride";
    public static final String OPERATION_EXTRANEOUS_OVERRIDE = "RoomJavaValidator.OperationExtraneousOverride";
    @Inject
    ImportUriResolver importUriResolver;

    @Check
    public void checkImportedNamespace(Import imp) {
        RoomModel importedModel;
        QualifiedName importedFQN;
        if (imp.getImportURI() == null) {
            return;
        }
        IQualifiedNameConverter.DefaultImpl nameConverter = new IQualifiedNameConverter.DefaultImpl();
        boolean isWildcard = false;
        try {
            QualifiedName orig = nameConverter.toQualifiedName(imp.getImportedNamespace());
            isWildcard = orig.getLastSegment().equals("*");
            importedFQN = isWildcard ? orig.skipLast(1) : orig;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        String uriString = this.importUriResolver.resolve((EObject)imp);
        if (uriString == null) {
            this.warning("could not load referenced model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
        URI uri = URI.createURI((String)uriString);
        ResourceSet rs = imp.eResource().getResourceSet();
        try {
            Resource res = rs.getResource(uri, true);
            if (res == null) {
                return;
            }
            if (res.getContents().isEmpty()) {
                this.error("referenced model is empty", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                return;
            }
            if (!(res.getContents().get(0) instanceof RoomModel)) {
                if (uri.lastSegment().endsWith(".room")) {
                    this.error("referenced model is no ROOM model (but has .room extension)", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                } else {
                    this.warning("referenced model is no ROOM model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
                }
                return;
            }
            importedModel = (RoomModel)res.getContents().get(0);
        }
        catch (RuntimeException re) {
            this.warning("could not load referenced model", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORT_URI);
            return;
        }
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return;
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(importedModel.eResource());
        boolean exportedNameMatch = false;
        if (description != null) {
            Iterator iter = description.getExportedObjects().iterator();
            while (iter.hasNext()) {
                QualifiedName exportedFQN = ((IEObjectDescription)iter.next()).getQualifiedName();
                if (exportedNameMatch |= importedFQN.equals((Object)exportedFQN)) break;
            }
        }
        if (!exportedNameMatch) {
            this.error("no match for imported namespace", (EStructuralFeature)BasePackage.Literals.IMPORT__IMPORTED_NAMESPACE, WRONG_NAMESPACE, new String[]{String.valueOf(importedModel.getName()) + ".*"});
        }
    }

    @Check
    public void checkActorRef(ActorRef ar) {
        ActorClass ac;
        if (ar.eContainer() instanceof ActorClass) {
            ac = (ActorClass)ar.eContainer();
            if (this.roomHelpers.isReferencing(ar.getType(), ac)) {
                this.error("Actor reference is circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_Type());
            }
        }
        if (ar.getMultiplicity() < 0) {
            if (ar.getRefType() != ReferenceType.OPTIONAL) {
                this.error(MULTIPLICITY_ANY_REQUIRES_OPTIONAL, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_RefType(), ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL, new String[0]);
            }
        } else if (ar.getMultiplicity() > 1 && ar.getRefType() == ReferenceType.OPTIONAL) {
            this.error(OPTIONAL_REFS_HAVE_TO_HAVE_MULTIPLICITY_ANY, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_RefType(), ACTOR_REF_CHANGE_REF_TYPE_TO_FIXED_OR_MULT_TO_ANY, new String[]{ar.getName()});
        }
        if (ar != null) {
            ac = ar.getType();
            if (ar.getMultiplicity() > 1) {
                for (Port p : ac.getInterfacePorts()) {
                    if (p.getMultiplicity() >= 0) continue;
                    int idx = ((ActorContainerClass)ar.eContainer()).getActorRefs().indexOf((Object)ar);
                    this.error("replicated actor must not have replicated port with arbitrary multiplicity", null);
                }
            }
        }
    }

    @Check
    public void checkLayerConnectiontarget(LayerConnection lc) {
        if (lc.getTo().getRef() instanceof ActorRef && ((ActorRef)lc.getTo().getRef()).getMultiplicity() > 1) {
            this.error("layer connection must not connect to replicated actor", null);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(DataClass dc) {
        if (dc == null) {
            return;
        }
        if (this.roomHelpers.isCircularClassHierarchy(dc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getDataClass_Base());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Check
    public void checkAttributeNotCircular(Attribute att) {
        if (att.eContainer() instanceof ActorClass) {
            return;
        }
        if (att.eContainer() instanceof PortClass) {
            return;
        }
        if (!(att.eContainer() instanceof DataClass)) {
            if (!RoomJavaValidator.$assertionsDisabled) {
                throw new AssertionError((Object)"unexpected parent class");
            }
            return;
        }
        dc = (DataClass)att.eContainer();
        if (!this.roomHelpers.isCircularClassHierarchy(dc)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            if (att.getType().getType() == dc && !att.getType().isRef()) {
                this.error("Attribute type must not refer to own class or a super class", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__TYPE, "RoomJavaValidator.CircularContainment", new String[]{"" + att.getType().getType().getName().length()});
                break;
            }
            dc = dc.getBase();
lbl16:
            // 2 sources

            ** while (dc != null)
        }
lbl17:
        // 2 sources

    }

    @Check
    public void checkAttributeNoStringArray(Attribute att) {
        PrimitiveType type;
        if (!att.getType().isRef() && att.getType().getType() instanceof PrimitiveType && (type = (PrimitiveType)att.getType().getType()).getName().equalsIgnoreCase("string") && att.getSize() > 0) {
            this.error("string type must have multiplicity 0", (EStructuralFeature)RoomPackage.Literals.ATTRIBUTE__SIZE);
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ProtocolClass pc) {
        if (pc == null) {
            return;
        }
        if (this.roomHelpers.isCircularClassHierarchy(pc)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getProtocolClass_Base());
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ActorClass ac) {
        if (ac == null) {
            return;
        }
        if (this.roomHelpers.isCircularClassHierarchy(ac)) {
            this.error("Base classes are circular", (EStructuralFeature)FSMPackage.eINSTANCE.getModelComponent_Base());
        }
    }

    @Check
    public void checkExecModelConsistent(ActorClass ac) {
        if (this.roomHelpers.isCircularClassHierarchy(ac)) {
            return;
        }
        ComponentCommunicationType commType = ac.getCommType();
        switch (commType) {
            case ASYNCHRONOUS: {
                break;
            }
            case DATA_DRIVEN: {
                break;
            }
            case EVENT_DRIVEN: {
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)FSMPackage.eINSTANCE.getModelComponent_CommType());
            }
        }
        while (ac.getActorBase() != null) {
            if (commType == (ac = ac.getActorBase()).getCommType()) continue;
            this.error("data_driven attribute not consistent in inheritance hierarchy", (EStructuralFeature)FSMPackage.eINSTANCE.getModelComponent_CommType());
        }
    }

    @Check
    public void checkTopLevelRefinedStates(ActorClass ac) {
        List errors = this.validationUtil.checkTopLevelRefinedStates(ac);
        for (FSMValidationUtilXtend.Result err : errors) {
            this.error(err);
        }
    }

    @Check
    public void checkSubSystem(SubSystemClass ssc) {
        if (ssc.getActorRefs().isEmpty()) {
            this.warning("SubSystemClass must contain at least one ActorRef", (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ActorRefs());
        }
        if (ssc.getThreads().isEmpty()) {
            this.warning("at least one thread has to be defined", (EStructuralFeature)RoomPackage.Literals.SUB_SYSTEM_CLASS__THREADS, THREAD_MISSING, new String[]{"LogicalThread defaultThread"});
        }
        this.checkMappings(ssc.getActorInstanceMappings());
    }

    @Check
    public void checkLogicalSystem(LogicalSystem ls) {
        if (ls.getSubSystems().isEmpty()) {
            this.error("LogicalSystem must contain at least one SubSystemRef", (EStructuralFeature)RoomPackage.eINSTANCE.getLogicalSystem_SubSystems());
        }
    }

    @Check
    public void checkActorInstanceMapping(ActorInstanceMapping aim) {
        RefPath path;
        ActorContainerClass root = this.roomHelpers.getParentContainer(aim);
        if (root != null && !root.eIsProxy() && (path = aim.getPath()) != null) {
            String invalidSegment = this.roomHelpers.checkPath(root, path);
            if (invalidSegment != null) {
                this.error("no match for segment '" + invalidSegment + "'", (EStructuralFeature)RoomPackage.Literals.ACTOR_INSTANCE_MAPPING__PATH);
            } else {
                ActorRef aRef = this.roomHelpers.getLastActorRef(root, path);
                if (aRef == null) {
                    this.error("invalid actor reference", (EStructuralFeature)RoomPackage.Literals.ACTOR_INSTANCE_MAPPING__PATH);
                }
            }
        }
        this.checkMappings(aim.getActorInstanceMappings());
    }

    private void checkMappings(EList<ActorInstanceMapping> actorInstanceMappings) {
        HashSet<String> paths = new HashSet<String>();
        for (ActorInstanceMapping aim : actorInstanceMappings) {
            if (paths.add(aim.getPath().toString())) continue;
            EObject parent = aim.eContainer();
            int idx = actorInstanceMappings.indexOf((Object)aim);
            this.error("duplicate mapping", parent, aim.eContainingFeature(), idx, DUPLICATE_ACTOR_INSTANCE_MAPPING, new String[0]);
        }
    }

    @Check
    public void checkPortCompatibility(Binding bind) {
        FSMValidationUtilXtend.Result result = this.validationUtil.isValid(bind);
        if (!result.isOk()) {
            EObject sc = bind.eContainer();
            int idx = ((List)sc.eGet(bind.eContainingFeature())).indexOf(bind);
            this.error(result.getMsg(), sc, bind.eContainingFeature(), idx);
        }
    }

    @Check
    public void checkServiceCompatibility(LayerConnection conn) {
        FSMValidationUtilXtend.Result result = this.validationUtil.isValid(conn);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        }
    }

    @Check
    public void checkPortCommunicationCompatibility(ActorClass ac) {
        if (ac.getCommType() == ComponentCommunicationType.SYNCHRONOUS) {
            return;
        }
        ArrayList<Port> extPorts = new ArrayList<Port>();
        for (ExternalPort exPort : ac.getExternalPorts()) {
            extPorts.add(exPort.getInterfacePort());
        }
        this.checkPortCommunicationCompatibility(ac, extPorts, RoomPackage.eINSTANCE.getActorClass_ExternalPorts());
        this.checkPortCommunicationCompatibility(ac, (List<? extends InterfaceItem>)ac.getInternalPorts(), RoomPackage.eINSTANCE.getActorClass_InternalPorts());
        this.checkPortCommunicationCompatibility(ac, (List<? extends InterfaceItem>)ac.getServiceAccessPoints(), RoomPackage.eINSTANCE.getActorClass_ServiceAccessPoints());
        ArrayList<SPP> serviceImpls = new ArrayList<SPP>();
        for (ServiceImplementation si : ac.getServiceImplementations()) {
            serviceImpls.add(si.getSpp());
        }
        this.checkPortCommunicationCompatibility(ac, serviceImpls, RoomPackage.eINSTANCE.getActorClass_ServiceImplementations());
    }

    private void checkPortCommunicationCompatibility(ActorClass ac, List<? extends InterfaceItem> items, EReference ref) {
        boolean datadriven = ac.getCommType() == ComponentCommunicationType.DATA_DRIVEN;
        boolean eventdriven = ac.getCommType() == ComponentCommunicationType.EVENT_DRIVEN;
        boolean async = ac.getCommType() == ComponentCommunicationType.ASYNCHRONOUS;
        block4: for (InterfaceItem interfaceItem : items) {
            ProtocolClass pc = this.roomHelpers.getProtocol(interfaceItem);
            if (pc == null) continue;
            switch (pc.getCommType()) {
                case DATA_DRIVEN: {
                    if (datadriven || async) continue block4;
                    this.error("ports with datadriven protocols not allowed", (EStructuralFeature)ref, items.indexOf(interfaceItem));
                    break;
                }
                case EVENT_DRIVEN: {
                    if (eventdriven || async) continue block4;
                    this.error("ports with eventdriven protocols not allowed", (EStructuralFeature)ref, items.indexOf(interfaceItem));
                }
            }
        }
    }

    @Check
    public void checkPort(Port port) {
        if (port.getMultiplicity() == 0) {
            this.error("multiplicity must not be 0", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getMultiplicity() < -1) {
            this.error("multiplicity must be -1 or positive", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getProtocol() instanceof ProtocolClass && ((ProtocolClass)port.getProtocol()).getCommType() == CommunicationType.DATA_DRIVEN && port.getMultiplicity() != 1) {
            this.error("multiplicity must be 1 for data driven ports", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
    }

    @Check
    public void checkProtocol(ProtocolClass pc) {
        if (this.roomHelpers.isCircularClassHierarchy(pc)) {
            return;
        }
        switch (pc.getCommType()) {
            case DATA_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.DATA_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (this.roomHelpers.getAllMessages(pc, true).isEmpty()) {
                    this.error("at least one incoming message must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                }
                if (this.roomHelpers.getAllMessages(pc, false).isEmpty()) break;
                this.error("data driven protocols must have no outgoing messages", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
                break;
            }
            case EVENT_DRIVEN: {
                if (pc.getBase() != null && pc.getBase().getCommType() != CommunicationType.EVENT_DRIVEN) {
                    this.error("super protocol has to have same communication type", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
                }
                if (!this.roomHelpers.getAllMessages(pc, true).isEmpty() || !this.roomHelpers.getAllMessages(pc, false).isEmpty() || !this.roomHelpers.getAllOperations(pc, true).isEmpty() || !this.roomHelpers.getAllOperations(pc, false).isEmpty()) break;
                this.error("at least one message/port operation (incoming or outgoing) must be defined", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__INCOMING_MESSAGES);
                break;
            }
            case SYNCHRONOUS: {
                this.error("synchronous communication type not supported yet", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__COMM_TYPE);
            }
        }
        this.checkDuplicates(pc, true);
        this.checkDuplicates(pc, false);
        if (pc.getBase() != null && pc.getIncomingMessages().size() > 0 && pc.getOutgoingMessages().size() > 0) {
            this.warning("a derived protocol should add either incoming or outgoing messages, not both", (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__OUTGOING_MESSAGES);
        }
    }

    private void checkDuplicates(ProtocolClass pc, boolean incoming) {
        ValidationHelpers.NamedObjectList all = new ValidationHelpers.NamedObjectList();
        all.addAll(this.roomHelpers.getAllMessages(pc, incoming), (EStructuralFeature)RoomPackage.Literals.MESSAGE__NAME);
        all.addAll(this.roomHelpers.getAllOperations(pc, incoming), (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME);
        Iterable duplicates = ValidationHelpers.inSameResource((Iterable)ValidationHelpers.removeUniques((List)all), (Resource)pc.eResource());
        for (ValidationHelpers.NamedObject dupl : duplicates) {
            this.error("duplicate message name", dupl.getObj(), dupl.getFeature());
        }
    }

    @Check
    public void checkInheritedNames(ActorClass ac) {
        HashSet overrideFeatures = Sets.newHashSet((Object[])new EReference[]{RoomPackage.Literals.ACTOR_CLASS__OPERATIONS, RoomPackage.Literals.ACTOR_CLASS__STRUCTORS, FSMPackage.Literals.MODEL_COMPONENT__STATE_MACHINE});
        final HashMap superNames = Maps.newHashMap();
        ValidationHelpers.saveRecursiveVisitor((EObject)ac.getActorBase(), (Function)new Function<ActorClass, ActorClass>(){

            public ActorClass apply(ActorClass input) {
                for (EObject containee : input.eContents()) {
                    String name;
                    QualifiedName qualifiedName = (QualifiedName)RoomJavaValidator.this.fqnProvider.apply((Object)containee);
                    String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
                    if (name == null || superNames.containsKey(name)) continue;
                    superNames.put(name, containee);
                }
                return input.getActorBase();
            }
        });
        for (EObject containee : ac.eContents()) {
            EObject existing;
            String name;
            QualifiedName qualifiedName = (QualifiedName)this.fqnProvider.apply((Object)containee);
            String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
            if (name == null || (existing = (EObject)superNames.get(name)) == null || overrideFeatures.contains(containee.eContainingFeature()) && containee.eContainingFeature() == existing.eContainingFeature() || !superNames.containsKey(((QualifiedName)this.fqnProvider.apply((Object)existing)).getLastSegment())) continue;
            this.issueInheritedNameError(containee, existing);
        }
    }

    @Check
    public void checkInheritedNames(DataClass dc) {
        HashSet overrideFeatures = Sets.newHashSet((Object[])new EReference[]{RoomPackage.Literals.DATA_CLASS__OPERATIONS, RoomPackage.Literals.DATA_CLASS__STRUCTORS});
        final HashMap superNames = Maps.newHashMap();
        ValidationHelpers.saveRecursiveVisitor((EObject)dc.getBase(), (Function)new Function<DataClass, DataClass>(){

            public DataClass apply(DataClass input) {
                for (EObject containee : input.eContents()) {
                    String name;
                    QualifiedName qualifiedName = (QualifiedName)RoomJavaValidator.this.fqnProvider.apply((Object)containee);
                    String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
                    if (name == null || superNames.containsKey(name)) continue;
                    superNames.put(name, containee);
                }
                return input.getBase();
            }
        });
        for (EObject containee : dc.eContents()) {
            EObject existing;
            String name;
            QualifiedName qualifiedName = (QualifiedName)this.fqnProvider.apply((Object)containee);
            String string = name = qualifiedName != null ? qualifiedName.getLastSegment() : null;
            if (name == null || (existing = (EObject)superNames.get(name)) == null || overrideFeatures.contains(containee.eContainingFeature()) && containee.eContainingFeature() == existing.eContainingFeature() || !superNames.containsKey(((QualifiedName)this.fqnProvider.apply((Object)existing)).getLastSegment())) continue;
            this.issueInheritedNameError(containee, existing);
        }
    }

    private void issueInheritedNameError(EObject target, EObject source) {
        String targetName = ((QualifiedName)this.fqnProvider.apply((Object)target)).getLastSegment();
        String sourceName = ((QualifiedName)this.fqnProvider.apply((Object)source)).getLastSegment();
        String sourceType = source.eClass().getName();
        String sourceOwner = this.roomHelpers.getRoomClass(source).getName();
        this.error("name '" + targetName + "' is already assigned to " + sourceType + sourceOwner + "." + sourceName, target, target.eClass().getEStructuralFeature("name"));
    }

    @Check
    public void checkMessage(Message msg) {
        ProtocolClass pc = (ProtocolClass)msg.eContainer();
        if (pc.getCommType() == CommunicationType.DATA_DRIVEN && msg.getData() == null) {
            this.error("Messages of data driven protocols must carry data", (EStructuralFeature)RoomPackage.Literals.MESSAGE__DATA);
        }
    }

    @Check
    public void checkMessageFromIf(MessageFromIf mfi) {
        if (mfi.getFrom() != null && this.roomHelpers.getProtocol((InterfaceItem)mfi.getFrom()).getCommType() != CommunicationType.EVENT_DRIVEN) {
            this.error("port must have event driven protocol", (EObject)mfi, (EStructuralFeature)FSMPackage.eINSTANCE.getMessageFromIf_From());
        }
    }

    @Check
    public void checkDataClass(DataClass dc) {
        if (dc.getAttributes().isEmpty() && dc.getBase() == null) {
            this.error("Non-derived data classes have to define at least one attribute", (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__ATTRIBUTES);
        }
    }

    @Check
    public void checkReplicatedPortBindingPatterns(StructureClass sc) {
        HashSet<Port> haveReplPeer = new HashSet<Port>();
        for (Binding bind : sc.getBindings()) {
            Port p1 = bind.getEndpoint1().getPort();
            Port p2 = bind.getEndpoint2().getPort();
            if (p1.getMultiplicity() == 1 || p2.getMultiplicity() == 1) continue;
            if (!haveReplPeer.add(p1)) {
                this.error(A_REPLICATED_PORT_MUST_HAVE_AT_MOST_ONE_REPLICATED_PEER, bind, (EStructuralFeature)RoomPackage.Literals.BINDING__ENDPOINT1);
            }
            if (haveReplPeer.add(p2)) continue;
            this.error(A_REPLICATED_PORT_MUST_HAVE_AT_MOST_ONE_REPLICATED_PEER, bind, (EStructuralFeature)RoomPackage.Literals.BINDING__ENDPOINT2);
        }
    }

    @Check
    public void checkPortClassContents(PortClass pc) {
        if (pc.getAttributes().isEmpty() && pc.getMsgHandlers().isEmpty() && pc.getOperations().isEmpty()) {
            this.error("port class must not be empty", pc, (EStructuralFeature)RoomPackage.Literals.PORT_CLASS__ATTRIBUTES);
        }
    }

    @Check
    public void checkCompoundProtocolClass(CompoundProtocolClass cpc) {
        if (cpc.getSubProtocols().isEmpty()) {
            this.error("no sub protocols defined", cpc, (EStructuralFeature)RoomPackage.Literals.COMPOUND_PROTOCOL_CLASS__SUB_PROTOCOLS);
        }
    }

    @Check
    public void checkAnnotationTarget(Annotation a) {
        if (a.getType() == null || a.getType().eIsProxy()) {
            return;
        }
        EObject parent = a.eContainer();
        EList targetList = a.getType().getTargets();
        RoomAnnotationTargetEnum invalidTargetType = null;
        if (parent instanceof ActorClass) {
            ActorClass actorParent = (ActorClass)parent;
            if (actorParent.getAnnotations().contains((Object)a) && !targetList.contains((Object)RoomAnnotationTargetEnum.ACTOR_CLASS.getLiteral())) {
                invalidTargetType = RoomAnnotationTargetEnum.ACTOR_CLASS;
            } else if (actorParent.getBehaviorAnnotations().contains((Object)a) && !targetList.contains((Object)RoomAnnotationTargetEnum.ACTOR_BEHAVIOR.getLiteral())) {
                invalidTargetType = RoomAnnotationTargetEnum.ACTOR_BEHAVIOR;
            }
        } else if (parent instanceof DataClass && !targetList.contains((Object)RoomAnnotationTargetEnum.DATA_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.DATA_CLASS;
        } else if (parent instanceof ProtocolClass && !targetList.contains((Object)RoomAnnotationTargetEnum.PROTOCOL_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.PROTOCOL_CLASS;
        } else if (parent instanceof CompoundProtocolClass && !targetList.contains((Object)RoomAnnotationTargetEnum.COMPOUND_PROTOCOL_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.COMPOUND_PROTOCOL_CLASS;
        } else if (parent instanceof LogicalSystem && !targetList.contains((Object)RoomAnnotationTargetEnum.LOGICAL_SYSTEM_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.LOGICAL_SYSTEM_CLASS;
        } else if (parent instanceof SubSystemClass && !targetList.contains((Object)RoomAnnotationTargetEnum.SUBSYSTEM_CLASS.getLiteral())) {
            invalidTargetType = RoomAnnotationTargetEnum.SUBSYSTEM_CLASS;
        }
        if (invalidTargetType != null) {
            this.error("AnnotationType " + a.getType().getName() + " is not allowed for target " + invalidTargetType.getLiteral(), (EObject)a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__TYPE, INVALID_ANNOTATION_TARGET, new String[]{a.getType().getName(), String.valueOf(a.getType().getName()) + " {target = " + invalidTargetType.getLiteral() + " ...", invalidTargetType.getLiteral()});
        }
    }

    @Check
    public void checkTestInstanceAnnotation(Annotation annotation) {
        if (annotation.getType() == null || !"TestInstance".equals(annotation.getType().getName())) {
            return;
        }
        RoomClass roomClass = this.roomHelpers.getRoomClass((EObject)annotation);
        if (roomClass instanceof SubSystemClass && ((SubSystemClass)roomClass).getThreads().size() > 0) {
            this.error("Annotation 'TestInstance' does not allow (explicit) LogicalThreads", (EObject)annotation, null);
        }
    }

    @Check
    public void checkEnumeration(EnumerationType et) {
        if (et.getPrimitiveType() != null && et.getPrimitiveType().getType() != LiteralType.INT) {
            this.error("enumerations must be of integer type", (EStructuralFeature)RoomPackage.Literals.ENUMERATION_TYPE__PRIMITIVE_TYPE);
        }
        if (et.getLiterals().isEmpty()) {
            this.error("at least one literal has to be specified", (EStructuralFeature)RoomPackage.Literals.ENUMERATION_TYPE__LITERALS);
        }
    }

    private void error(FSMValidationUtilXtend.Result result) {
        this.error(result.getMsg(), result.getSource(), result.getFeature(), result.getIndex());
    }

    @Check
    public void checkOperations(ActorClass ac) {
        if (this.roomHelpers.isCircularClassHierarchy(ac)) {
            return;
        }
        for (Operation op : ac.getOperations()) {
            if (!ac.getName().equals(op.getName())) continue;
            this.warning("Operation name is discouraged, may be mistaken for ctor/dtor", op, (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME);
        }
        this.checkOperationsOverride(this.roomHelpers.getAllOperations(ac), (List<StandardOperation>)ac.getOperations());
    }

    @Check
    public void checkOperations(DataClass dc) {
        if (this.roomHelpers.isCircularClassHierarchy(dc)) {
            return;
        }
        for (Operation op : dc.getOperations()) {
            if (!dc.getName().equals(op.getName())) continue;
            this.warning("Operation name is discouraged, may be mistaken for ctor/dtor", op, (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME);
        }
        this.checkOperationsOverride(this.roomHelpers.getAllOperations(dc), (List<StandardOperation>)dc.getOperations());
    }

    private void checkOperationsOverride(List<StandardOperation> allOperations, List<StandardOperation> toCheck) {
        HashMap map = Maps.newHashMap();
        for (StandardOperation op : allOperations) {
            if (map.containsKey(op.getName())) continue;
            map.put(op.getName(), op);
        }
        for (StandardOperation op : toCheck) {
            if (op.getName() == null) continue;
            StandardOperation baseOp = (StandardOperation)map.get(op.getName());
            if (baseOp == op) {
                if (!op.isOverride()) continue;
                this.error("Operation '" + op.getName() + "' must override an operation in super class", op, (EStructuralFeature)RoomPackage.Literals.STANDARD_OPERATION__OVERRIDE, OPERATION_EXTRANEOUS_OVERRIDE, new String[0]);
                continue;
            }
            String baseOpFQN = String.valueOf(this.roomHelpers.getRoomClass(baseOp).getName()) + "." + baseOp.getName() + "()";
            if (!op.isOverride()) {
                this.error("Implicit override of operation " + baseOpFQN, op, (EStructuralFeature)RoomPackage.Literals.OPERATION__NAME, OPERATION_MISSING_OVERRIDE, new String[0]);
                continue;
            }
            if (!this.roomHelpers.matchingArguments(baseOp, op)) {
                this.error("Arguments must be identical to overriden operation in " + baseOpFQN, op, (EStructuralFeature)RoomPackage.Literals.OPERATION__ARGUMENTS);
            }
            if (this.roomHelpers.matchingReturnType(baseOp, op)) continue;
            this.error("Return type  must be identical to overriden operation " + baseOpFQN, op, (EStructuralFeature)RoomPackage.Literals.OPERATION__RETURN_TYPE);
        }
    }
}

