/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DataClassGen {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private RoomHelpers roomHelpers;

    public void doGenerate(Root root) {
        EList _usedDataClasses = root.getUsedDataClasses();
        Functions.Function1<DataClass, Boolean> _function = new Functions.Function1<DataClass, Boolean>(){

            public Boolean apply(DataClass cl) {
                return DataClassGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)cl);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_usedDataClasses, (Functions.Function1)_function);
        for (DataClass dc : _filter) {
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)dc);
            String _path = this._roomExtensions.getPath((RoomClass)dc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)dc);
            String _path_1 = this._roomExtensions.getPath((RoomClass)dc);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            String file = this._javaExtensions.getJavaFileName((RoomClass)dc);
            CharSequence _generate = this.generate(root, dc);
            this.fileIO.generateFile("generating DataClass implementation", path, infopath, file, _generate);
        }
    }

    public CharSequence generate(Root root, DataClass dc) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)dc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        _builder.newLine();
        _builder.append((Object)"import java.io.Serializable;");
        _builder.newLine();
        _builder.newLine();
        EList models = root.getReferencedModels((RoomClass)dc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(dc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = dc.getName();
        _builder.append((Object)_name_1, "");
        DataClass _base = dc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            _builder.append((Object)" extends ");
            DataClass _base_1 = dc.getBase();
            String _name_2 = _base_1.getName();
            _builder.append((Object)_name_2, "");
        }
        _builder.append((Object)" implements Serializable {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final long serialVersionUID = ");
        String _package_1 = this._roomExtensions.getPackage((RoomClass)dc);
        String _name_3 = dc.getName();
        String _plus = String.valueOf(_package_1) + _name_3;
        int _hashCode = _plus.hashCode();
        _builder.append((Object)_hashCode, "\t");
        _builder.append((Object)"L;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(dc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes = dc.getAttributes();
        CharSequence _attributes_1 = this._procedureHelpers.attributes((List)_attributes);
        _builder.append((Object)_attributes_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes_2 = dc.getAttributes();
        String _name_4 = dc.getName();
        CharSequence _attributeSettersGettersImplementation = this._procedureHelpers.attributeSettersGettersImplementation((List)_attributes_2, _name_4);
        _builder.append((Object)_attributeSettersGettersImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _operations = dc.getOperations();
        String _name_5 = dc.getName();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)_operations, _name_5);
        _builder.append((Object)_operationsImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// default constructor");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_6 = dc.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _attributes_3 = dc.getAttributes();
        CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)_attributes_3, (EObject)dc, true);
        _builder.append((Object)_attributeInitialization, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _userStructorBody = this._procedureHelpers.userStructorBody((RoomClass)dc, true);
        _builder.append((Object)_userStructorBody, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructor using fields");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_7 = dc.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"(");
        CharSequence _argList = this.argList(dc);
        _builder.append((Object)_argList, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        DataClass _base_2 = dc.getBase();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_base_2, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"super(");
            DataClass _base_3 = dc.getBase();
            String _paramList = this.paramList(_base_3);
            _builder.append((Object)_paramList, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"super();");
            _builder.newLine();
        }
        _builder.newLine();
        EList _attributes_4 = dc.getAttributes();
        for (Attribute a : _attributes_4) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _name_8 = a.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)" = ");
            String _name_9 = a.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _userStructorBody_1 = this._procedureHelpers.userStructorBody((RoomClass)dc, true);
        _builder.append((Object)_userStructorBody_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// deep copy");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_10 = dc.getName();
        _builder.append((Object)_name_10, "\t");
        _builder.append((Object)" deepCopy() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_11 = dc.getName();
        _builder.append((Object)_name_11, "\t\t");
        _builder.append((Object)" copy = new ");
        String _name_12 = dc.getName();
        _builder.append((Object)_name_12, "\t\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _deepCopy = this.deepCopy(dc);
        _builder.append((Object)_deepCopy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return copy;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }

    public String paramList(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (!Objects.equal((Object)dc, null)) {
            boolean _notEquals;
            String _plus;
            EList _attributes = dc.getAttributes();
            CharSequence _paramList = this.paramList((List<Attribute>)_attributes);
            String _string = _paramList.toString();
            result = _plus = String.valueOf(_string) + result;
            DataClass _base = dc.getBase();
            boolean bl = _notEquals = !Objects.equal((Object)(dc = _base), null);
            if (!_notEquals) continue;
            result = ", " + result;
        }
        return result;
    }

    private CharSequence paramList(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name = a.getName();
            _builder.append((Object)_name, "");
        }
        return _builder;
    }

    public CharSequence argList(DataClass dc) {
        List _allAttributes = this.roomHelpers.getAllAttributes(dc);
        return this._procedureHelpers.argList(_allAttributes);
    }

    private String deepCopy(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (!Objects.equal((Object)dc, null)) {
            DataClass _base;
            String _plus;
            EList _attributes = dc.getAttributes();
            CharSequence _deepCopy = this.deepCopy((List<Attribute>)_attributes);
            String _string = _deepCopy.toString();
            result = _plus = String.valueOf(_string) + result;
            dc = _base = dc.getBase();
        }
        return result;
    }

    private CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        for (Attribute a : attributes) {
            boolean _equals;
            RefableType _type = a.getType();
            boolean _isRef = _type.isRef();
            if (_isRef) {
                _builder.append((Object)"copy.");
                String _name = a.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)" = ");
                String _name_1 = a.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            RefableType _type_1 = a.getType();
            DataType _type_2 = _type_1.getType();
            if (_type_2 instanceof ComplexType) {
                boolean _lessEqualsThan;
                _builder.append((Object)"if (");
                String _name_2 = a.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)"!=null) {");
                _builder.newLineIfNotEmpty();
                int _size = a.getSize();
                boolean bl = _lessEqualsThan = _size <= 1;
                if (_lessEqualsThan) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"copy.");
                    String _name_3 = a.getName();
                    _builder.append((Object)_name_3, "\t");
                    _builder.append((Object)" = ");
                    String _name_4 = a.getName();
                    _builder.append((Object)_name_4, "\t");
                    _builder.append((Object)".deepCopy();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (int i=0;i<");
                    String _name_5 = a.getName();
                    _builder.append((Object)_name_5, "\t");
                    _builder.append((Object)".length;i++){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"copy.");
                    String _name_6 = a.getName();
                    _builder.append((Object)_name_6, "\t\t");
                    _builder.append((Object)"[i] = ");
                    String _name_7 = a.getName();
                    _builder.append((Object)_name_7, "\t\t");
                    _builder.append((Object)"[i].deepCopy();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            int _size_1 = a.getSize();
            boolean bl = _equals = _size_1 == 0;
            if (_equals) {
                _builder.append((Object)"copy.");
                String _name_8 = a.getName();
                _builder.append((Object)_name_8, "");
                _builder.append((Object)" = ");
                String _name_9 = a.getName();
                _builder.append((Object)_name_9, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"for (int i=0;i<");
            String _name_10 = a.getName();
            _builder.append((Object)_name_10, "");
            _builder.append((Object)".length;i++){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"copy.");
            String _name_11 = a.getName();
            _builder.append((Object)_name_11, "\t");
            _builder.append((Object)"[i] = ");
            String _name_12 = a.getName();
            _builder.append((Object)_name_12, "\t");
            _builder.append((Object)"[i];");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }
}

