/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class JavaExtensions
implements ILanguageExtension {
    @Inject
    private TypeHelpers typeHelpers;

    public String getTypedDataDefinition(EObject msg) {
        String _xifexpression = null;
        if (msg instanceof Message) {
            VarDecl _data = ((Message)msg).getData();
            String[] _generateArglistAndTypedData = this.generateArglistAndTypedData((EObject)_data);
            _xifexpression = _generateArglistAndTypedData[1];
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    public String getJavaFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + ".java";
    }

    public String getJavaFactoryName(ActorClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + "Factory";
    }

    public String getJavaFactoryFileName(ActorClass rc) {
        String _javaFactoryName = this.getJavaFactoryName(rc);
        return String.valueOf(_javaFactoryName) + ".java";
    }

    public String getJavaScalarInterfaceName(ActorClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + "Interface";
    }

    public String getJavaScalarInterfaceFileName(ActorClass rc) {
        String _javaScalarInterfaceName = this.getJavaScalarInterfaceName(rc);
        return String.valueOf(_javaScalarInterfaceName) + ".java";
    }

    public String getJavaReplicatedInterfaceName(ActorClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + "ReplicatedInterface";
    }

    public String getJavaReplicatedInterfaceFileName(ActorClass rc) {
        String _javaReplicatedInterfaceName = this.getJavaReplicatedInterfaceName(rc);
        return String.valueOf(_javaReplicatedInterfaceName) + ".java";
    }

    public String getJavaInterfaceName(ActorClass ac, boolean replicated) {
        String _xifexpression = null;
        _xifexpression = replicated ? this.getJavaReplicatedInterfaceName(ac) : this.getJavaScalarInterfaceName(ac);
        return _xifexpression;
    }

    public String getJavaInterfaceFileName(ActorClass ac, boolean replicated) {
        String _xifexpression = null;
        _xifexpression = replicated ? this.getJavaReplicatedInterfaceFileName(ac) : this.getJavaScalarInterfaceFileName(ac);
        return _xifexpression;
    }

    public String getJavaClassName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = "Node_" + _name;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _name_1 = ssi.getName();
        return String.valueOf(_plus_1) + _name_1;
    }

    public String getJavaFileName(NodeRef nr, SubSystemInstance ssi) {
        String _javaClassName = this.getJavaClassName(nr, ssi);
        return String.valueOf(_javaClassName) + ".java";
    }

    public String toWrapper(String type) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)type, (Object)"int")) {
            _matched = true;
            _switchResult = "Integer";
        }
        if (!_matched && Objects.equal((Object)type, (Object)"char")) {
            _matched = true;
            _switchResult = "Character";
        }
        if (!_matched) {
            _switchResult = StringExtensions.toFirstUpper((String)type);
        }
        return _switchResult;
    }

    public boolean needsInitialization(Attribute a) {
        RefableType _type;
        DataType _type_1;
        boolean _isEnumerationOrPrimitive;
        boolean _not;
        boolean _greaterThan;
        boolean _or = false;
        boolean _or_1 = false;
        int _size = a.getSize();
        boolean bl = _greaterThan = _size > 0;
        _or_1 = _greaterThan ? true : (_not = !(_isEnumerationOrPrimitive = this.typeHelpers.isEnumerationOrPrimitive(_type_1 = (_type = a.getType()).getType())));
        if (_or_1) {
            _or = true;
        } else {
            boolean _equals;
            RefableType _type_2 = a.getType();
            DataType _type_3 = _type_2.getType();
            String _typeName = this.typeHelpers.typeName(_type_3);
            _or = _equals = _typeName.equals("String");
        }
        return _or;
    }

    public String accessLevelPrivate() {
        return "private ";
    }

    public String accessLevelProtected() {
        return "protected ";
    }

    public String accessLevelPublic() {
        return "public ";
    }

    public String memberAccess() {
        return "this.";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return "";
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return String.valueOf(namespace) + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return false;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation _builder = new StringConcatenation();
        for (Pair<String, String> entry : entries) {
            _builder.append((Object)"public static final int ");
            String _first = (String)entry.getFirst();
            _builder.append((Object)_first, "");
            _builder.append((Object)" = ");
            String _second = (String)entry.getSecond();
            _builder.append((Object)_second, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "";
    }

    public String nullPointer() {
        return "null";
    }

    public String voidPointer() {
        return "Object";
    }

    public String typeArrayModifier() {
        return "[]";
    }

    public String arrayDeclaration(String type, int size, String name, boolean isRef) {
        return String.valueOf(type) + " " + name + "[]";
    }

    public String superCall(String baseClassName, String method, String args) {
        return "super." + method + "(" + args + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        boolean _not;
        String _xifexpression = null;
        boolean _and = false;
        boolean _isCharacterType = this.typeHelpers.isCharacterType(type);
        boolean bl = _not = !_isCharacterType;
        if (!_not) {
            _and = false;
        } else {
            boolean _contains_1;
            boolean _or = false;
            boolean _contains = value.contains(",");
            _or = _contains ? true : (_contains_1 = value.contains("{"));
            _and = _or;
        }
        if (_and) {
            String _xblockexpression = null;
            String _replace = value.replace("{", "");
            String _replace_1 = _replace.replace("}", "");
            String _trim = _replace_1.trim();
            String[] singleValues = _trim.split(",");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"{ ");
            boolean _hasElements = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _trim_1 = v.trim();
                String _castValue = this.castValue(type, _trim_1);
                _builder.append((Object)_castValue, "");
                ++n2;
            }
            _builder.append((Object)" }");
            _xifexpression = _xblockexpression = _builder.toString();
        } else {
            _xifexpression = this.castValue(type, value);
        }
        return _xifexpression;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        boolean _contains_1;
        String _xifexpression = null;
        boolean _or = false;
        boolean _contains = value.contains(",");
        _or = _contains ? true : (_contains_1 = value.contains("{"));
        if (_or) {
            String _xblockexpression = null;
            String _replace = value.replace("{", "");
            String _replace_1 = _replace.replace("}", "");
            String _trim = _replace_1.trim();
            String[] singleValues = _trim.split(",");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"{ ");
            boolean _hasElements = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _trim_1 = v.trim();
                String _convertStringEnumLiteral = this.convertStringEnumLiteral(type, _trim_1);
                _builder.append((Object)_convertStringEnumLiteral, "");
                ++n2;
            }
            _builder.append((Object)" }");
            _xifexpression = _xblockexpression = _builder.toString();
        } else {
            _xifexpression = this.convertStringEnumLiteral(type, value);
        }
        return _xifexpression;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        String _name = type.getName();
        boolean _startsWith = v.startsWith(_name);
        if (_startsWith) {
            String _substring;
            String _name_1 = type.getName();
            int _length = _name_1.length();
            int _plus = _length + 1;
            v = _substring = v.substring(_plus);
        }
        EList _literals = type.getLiterals();
        for (EnumLiteral l : _literals) {
            String _name_2 = l.getName();
            boolean _equals = _name_2.equals(v);
            if (!_equals) continue;
            String _name_3 = type.getName();
            String _plus_1 = String.valueOf(_name_3) + ".";
            String _name_4 = l.getName();
            return String.valueOf(_plus_1) + _name_4;
        }
        return null;
    }

    private String castValue(PrimitiveType type, String value) {
        String _switchResult = null;
        String _targetName = type.getTargetName();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_targetName, (Object)"boolean")) {
            _matched = true;
            _switchResult = value.toLowerCase();
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"byte")) {
            _matched = true;
            _switchResult = "(byte)" + value;
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"short")) {
            _matched = true;
            _switchResult = "(short)" + value;
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"int")) {
            _matched = true;
            _switchResult = value;
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"long")) {
            _matched = true;
            _switchResult = String.valueOf(value) + "L";
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"float")) {
            _matched = true;
            _switchResult = String.valueOf(value) + "f";
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"double")) {
            _matched = true;
            _switchResult = String.valueOf(value) + "d";
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"char")) {
            _matched = true;
            String _xifexpression = null;
            boolean _isEmpty = value.isEmpty();
            if (_isEmpty) {
                _xifexpression = "(char) 0";
            } else {
                boolean _equals;
                String _xifexpression_1 = null;
                int _length = value.length();
                boolean bl = _equals = _length == 1;
                if (_equals) {
                    char _charAt = value.charAt(0);
                    String _plus = "'" + Character.valueOf(_charAt);
                    _xifexpression_1 = String.valueOf(_plus) + "'";
                } else {
                    String _replace = value.replace("\\", "\\\\");
                    String _replace_1 = _replace.replace("\"", "\\\"");
                    String _plus_1 = "\"" + _replace_1;
                    _xifexpression_1 = String.valueOf(_plus_1) + "\".toCharArray()";
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"String")) {
            _matched = true;
            String _replace_2 = value.replace("\\", "\\\\");
            String _replace_3 = _replace_2.replace("\"", "\\\"");
            String _plus_2 = "\"" + _replace_3;
            _switchResult = String.valueOf(_plus_2) + "\"";
        }
        if (!_matched) {
            String _targetName_1 = type.getTargetName();
            throw new UnsupportedOperationException(_targetName_1);
        }
        return _switchResult;
    }

    public String defaultValue(DataType dt) {
        String _plus;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && dt instanceof PrimitiveType) {
            _matched = true;
            String _defaultValueLiteral = ((PrimitiveType)dt).getDefaultValueLiteral();
            _switchResult = this.toValueLiteral((PrimitiveType)dt, _defaultValueLiteral);
        }
        if (!_matched && dt instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getDefaultValue((EnumerationType)dt);
        }
        if (!_matched && dt instanceof ExternalType) {
            _matched = true;
            String _targetName = ((ExternalType)dt).getTargetName();
            _plus = "new " + _targetName;
            _switchResult = String.valueOf(_plus) + "()";
        }
        if (!_matched) {
            String _name = dt.getName();
            _plus = "new " + _name;
            _switchResult = String.valueOf(_plus) + "()";
        }
        return _switchResult;
    }

    public String getDefaultValue(EnumerationType type) {
        String _xifexpression = null;
        EList _literals = type.getLiterals();
        boolean _isEmpty = _literals.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            EList _literals_1 = type.getLiterals();
            EnumLiteral _get = (EnumLiteral)_literals_1.get(0);
            _xifexpression = this.getCastedValue(_get);
        }
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        if (size > 1) {
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = String.valueOf(res) + dv;
                if (++i >= size) continue;
                res = String.valueOf(res) + ",";
            }
            _xifexpression = _xblockexpression_1 = String.valueOf(res) + "}";
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        String typeName;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)d, null);
        if (_equals) {
            _or = true;
        } else {
            boolean bl = _or = !(d instanceof VarDecl);
        }
        if (_or) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        VarDecl data = (VarDecl)d;
        RefableType _refType = data.getRefType();
        DataType _type = _refType.getType();
        String castTypeName = typeName = _type.getName();
        RefableType _refType_1 = data.getRefType();
        DataType _type_1 = _refType_1.getType();
        if (_type_1 instanceof PrimitiveType) {
            boolean _isEmpty;
            boolean _not;
            boolean _notEquals;
            String _targetName;
            RefableType _refType_2 = data.getRefType();
            DataType _type_2 = _refType_2.getType();
            typeName = _targetName = ((PrimitiveType)_type_2).getTargetName();
            RefableType _refType_3 = data.getRefType();
            DataType _type_3 = _refType_3.getType();
            String ct = ((PrimitiveType)_type_3).getCastName();
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)ct, null);
            _and = !_notEquals ? false : (_not = !(_isEmpty = ct.isEmpty()));
            if (_and) {
                castTypeName = ct;
            }
        } else {
            RefableType _refType_4 = data.getRefType();
            DataType _type_4 = _refType_4.getType();
            if (_type_4 instanceof EnumerationType) {
                String _castType;
                String _targetType;
                RefableType _refType_5 = data.getRefType();
                DataType _type_5 = _refType_5.getType();
                typeName = _targetType = this.getTargetType((EnumerationType)_type_5);
                RefableType _refType_6 = data.getRefType();
                DataType _type_6 = _refType_6.getType();
                castTypeName = _castType = this.getCastType((EnumerationType)_type_6);
            }
        }
        String _name = data.getName();
        String _plus = String.valueOf(typeName) + " " + _name;
        String _plus_1 = String.valueOf(_plus) + " = (";
        String _plus_2 = String.valueOf(_plus_1) + castTypeName;
        String typedData = String.valueOf(_plus_2) + ") generic_data__et;\n";
        String _name_1 = data.getName();
        String dataArg = ", " + _name_1;
        String _name_2 = data.getName();
        String typedArgList = ", " + typeName + " " + _name_2;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getTargetType(EnumerationType type) {
        boolean _notEquals;
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            PrimitiveType _primitiveType_1 = type.getPrimitiveType();
            _xifexpression = _primitiveType_1.getTargetName();
        } else {
            _xifexpression = "int";
        }
        return _xifexpression;
    }

    public String getCastedValue(EnumLiteral literal) {
        String _xblockexpression = null;
        EObject _eContainer = literal.eContainer();
        EnumerationType type = (EnumerationType)_eContainer;
        String cast = this.getTargetType(type);
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _equals = Objects.equal((Object)_primitiveType, null);
        if (_equals) {
            long _literalValue = literal.getLiteralValue();
            _xifexpression = Long.toString(_literalValue);
        } else {
            long _literalValue_1 = literal.getLiteralValue();
            String _string = Long.toString(_literalValue_1);
            String _plus = "((" + cast + ")" + _string;
            _xifexpression = String.valueOf(_plus) + ")";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getCastType(EnumerationType type) {
        boolean _notEquals;
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            PrimitiveType _primitiveType_1 = type.getPrimitiveType();
            _xifexpression = _primitiveType_1.getCastName();
        } else {
            _xifexpression = "int";
        }
        return _xifexpression;
    }
}

