/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeClass;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.OptionalActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.fsm.base.Indexed;
import org.eclipse.etrice.generator.fsm.base.IntelligentSeparator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.java.gen.GlobalSettings;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.gen.VariableServiceGen;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    private IDataConfiguration dataConfigExt;
    @Inject
    private ConfigGenAddon configGenAddon;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    private VariableServiceGen varService;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        final HashMap sscc2wired = new HashMap();
        EList _wiredInstances = root.getWiredInstances();
        Functions.Function1<WiredStructureClass, Boolean> _function = new Functions.Function1<WiredStructureClass, Boolean>(){

            public Boolean apply(WiredStructureClass w) {
                return w instanceof WiredSubSystemClass;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_wiredInstances, (Functions.Function1)_function);
        Procedures.Procedure1<WiredStructureClass> _function_1 = new Procedures.Procedure1<WiredStructureClass>(){

            public void apply(WiredStructureClass w) {
                SubSystemClass _subSystemClass = ((WiredSubSystemClass)w).getSubSystemClass();
                sscc2wired.put(_subSystemClass, (WiredSubSystemClass)w);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                boolean _notEquals;
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)ssi, null);
                if (!_notEquals) {
                    _and = false;
                } else {
                    boolean _isValidGenerationLocation;
                    SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                    _and = _isValidGenerationLocation = this._fileSystemHelpers.isValidGenerationLocation((EObject)_subSystemClass);
                }
                if (!_and) continue;
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                WiredSubSystemClass wired = (WiredSubSystemClass)sscc2wired.get(_subSystemClass_1);
                SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
                String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass_2);
                SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
                String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_3);
                String path = String.valueOf(_generationTargetPath) + _path;
                SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
                String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)_subSystemClass_4);
                SubSystemClass _subSystemClass_5 = ssi.getSubSystemClass();
                String _path_1 = this._roomExtensions.getPath((RoomClass)_subSystemClass_5);
                String infopath = String.valueOf(_generationInfoPath) + _path_1;
                String file = this._javaExtensions.getJavaFileName(nr, ssi);
                this.checkDataPorts(ssi);
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                CharSequence _generate = this.generate(root, ssi, wired, usedThreads);
                this.fileIO.generateFile("generating Node implementation", path, infopath, file, _generate);
                boolean _hasVariableService = this.dataConfigExt.hasVariableService(ssi);
                if (!_hasVariableService) continue;
                this.varService.doGenerate(root, ssi);
            }
        }
    }

    private HashSet<ActorClass> getOptionalActorClasses(Root root, StructureInstance si) {
        TreeIterator _eAllContents = si.eAllContents();
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject i) {
                return i instanceof ActorInterfaceInstance;
            }
        };
        Iterator _filter = IteratorExtensions.filter((Iterator)_eAllContents, (Functions.Function1)_function);
        Functions.Function1<EObject, ActorInterfaceInstance> _function_1 = new Functions.Function1<EObject, ActorInterfaceInstance>(){

            public ActorInterfaceInstance apply(EObject aii) {
                return (ActorInterfaceInstance)aii;
            }
        };
        Iterator _map = IteratorExtensions.map((Iterator)_filter, (Functions.Function1)_function_1);
        ArrayList aifs = Lists.newArrayList((Iterator)_map);
        Functions.Function1<ActorInterfaceInstance, ActorClass> _function_2 = new Functions.Function1<ActorInterfaceInstance, ActorClass>(){

            public ActorClass apply(ActorInterfaceInstance aii) {
                return aii.getActorClass();
            }
        };
        List _map_1 = ListExtensions.map((List)aifs, (Functions.Function1)_function_2);
        HashSet result = Sets.newHashSet((Iterable)_map_1);
        for (ActorInterfaceInstance ai : aifs) {
            EList _optionalInstances = ai.getOptionalInstances();
            for (OptionalActorInstance oi : _optionalInstances) {
                HashSet<ActorClass> _optionalActorClasses = this.getOptionalActorClasses(root, (StructureInstance)oi);
                result.addAll(_optionalActorClasses);
            }
        }
        return result;
    }

    public CharSequence generate(Root root, SubSystemInstance comp, WiredSubSystemClass wired, final Collection<PhysicalThread> usedThreads) {
        GlobalSettings _settings_4;
        boolean _isGenerateMSCInstrumentation_4;
        boolean _hasVariableService;
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        EList models = root.getReferencedModels((RoomClass)cc);
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._javaExtensions.getJavaClassName(nr, comp);
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        HashSet<ActorClass> opt = this.getOptionalActorClasses(root, (StructureInstance)comp);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)cc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.config.IVariableService;");
        _builder.newLine();
        GlobalSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.append((Object)"import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            _builder.newLine();
        }
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.IMessageService;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.MessageService;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.MessageServiceController;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.RTServices;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.ActorClassBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.DataPortBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.OptionalActorInterfaceBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.IOptionalActorFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.SubSystemClassBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBroker;");
        _builder.newLine();
        _builder.newLine();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)cc, 1, false);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" extends SubSystemClassBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Iterable _indexed = Indexed.indexed((Iterable)threads);
        for (Indexed thread : _indexed) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int ");
            PhysicalThread _value = (PhysicalThread)thread.getValue();
            String _threadId = this.getThreadId(_value);
            _builder.append((Object)_threadId, "\t");
            _builder.append((Object)" = ");
            int _index0 = thread.getIndex0();
            _builder.append((Object)_index0, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)cc, 2, false);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"(IRTObject parent, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(parent, name);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void receiveEvent(InterfaceItemBase ifitem, int evt, Object data){");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void instantiateMessageServices() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"IMessageService msgService;");
        _builder.newLine();
        for (PhysicalThread thread_1 : threads) {
            boolean _or = false;
            ExecMode _execmode = thread_1.getExecmode();
            boolean _equals = Objects.equal((Object)_execmode, (Object)ExecMode.POLLED);
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                ExecMode _execmode_1 = thread_1.getExecmode();
                _or = _equals_1 = Objects.equal((Object)_execmode_1, (Object)ExecMode.MIXED);
            }
            if (_or) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"msgService = new MessageService(this, MessageService.ExecMode.");
                ExecMode _execmode_2 = thread_1.getExecmode();
                String _name_1 = _execmode_2.getName();
                _builder.append((Object)_name_1, "\t\t");
                _builder.append((Object)", ");
                long _time = thread_1.getTime();
                _builder.append((Object)_time, "\t\t");
                _builder.append((Object)"L, 0, ");
                String _threadId_1 = this.getThreadId(thread_1);
                _builder.append((Object)_threadId_1, "\t\t");
                _builder.append((Object)", \"MessageService_");
                String _name_2 = thread_1.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)"\" /*, thread_prio */);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"msgService = new MessageService(this, MessageService.ExecMode.");
                ExecMode _execmode_3 = thread_1.getExecmode();
                String _name_3 = _execmode_3.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)", 0, ");
                String _threadId_2 = this.getThreadId(thread_1);
                _builder.append((Object)_threadId_2, "\t\t");
                _builder.append((Object)", \"MessageService_");
                String _name_4 = thread_1.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)"\" /*, thread_prio */);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"RTServices.getInstance().getMsgSvcCtrl().addMsgSvc(msgService);");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void instantiateActors() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// thread mappings");
        _builder.newLine();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            boolean _not;
            boolean _isAsParent;
            _builder.append((Object)"\t\t");
            ETMapUtil.MappedThread mapped = ETMapUtil.getMappedThread((AbstractInstance)ai);
            _builder.newLineIfNotEmpty();
            boolean _or_1 = false;
            boolean _isImplicit = mapped.isImplicit();
            _or_1 = _isImplicit ? true : (_isAsParent = mapped.isAsParent());
            boolean bl = _not = !_or_1;
            if (!_not) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"addPathToThread(\"");
            String _path = ai.getPath();
            _builder.append((Object)_path, "\t\t");
            _builder.append((Object)"\", ");
            PhysicalThread _thread = mapped.getThread();
            String _threadId_3 = this.getThreadId(_thread);
            _builder.append((Object)_threadId_3, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// sub actors");
        _builder.newLine();
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (_greaterThan) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"for (int i=0; i<");
                int _multiplicity_1 = sub.getMultiplicity();
                _builder.append((Object)_multiplicity_1, "\t\t");
                _builder.append((Object)"; ++i) {");
                _builder.newLineIfNotEmpty();
                GlobalSettings _settings_1 = Main.getSettings();
                boolean _isGenerateMSCInstrumentation_1 = _settings_1.isGenerateMSCInstrumentation();
                if (_isGenerateMSCInstrumentation_1) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"DebuggingService.getInstance().addMessageActorCreate(this, \"");
                    String _name_5 = sub.getName();
                    _builder.append((Object)_name_5, "\t\t\t");
                    _builder.append((Object)Character.valueOf(':'), "\t\t\t");
                    _builder.append((Object)"\"+i);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"new ");
                ActorClass _type_1 = sub.getType();
                String _name_6 = _type_1.getName();
                _builder.append((Object)_name_6, "\t\t\t");
                _builder.append((Object)"(this, \"");
                String _name_7 = sub.getName();
                _builder.append((Object)_name_7, "\t\t\t");
                _builder.append((Object)Character.valueOf(':'), "\t\t\t");
                _builder.append((Object)"\"+i);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            GlobalSettings _settings_2 = Main.getSettings();
            boolean _isGenerateMSCInstrumentation_2 = _settings_2.isGenerateMSCInstrumentation();
            if (_isGenerateMSCInstrumentation_2) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"DebuggingService.getInstance().addMessageActorCreate(this, \"");
                String _name_8 = sub.getName();
                _builder.append((Object)_name_8, "\t\t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"new ");
            ActorClass _type_2 = sub.getType();
            String _name_9 = _type_2.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)"(this, \"");
            String _name_10 = sub.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// create service brokers in optional actor interfaces");
        _builder.newLine();
        BasicEList _allSubInstances = this._roomExtensions.getAllSubInstances((StructureInstance)comp);
        Functions.Function1<AbstractInstance, Boolean> _function_1 = new Functions.Function1<AbstractInstance, Boolean>(){

            public Boolean apply(AbstractInstance inst) {
                return inst instanceof ActorInterfaceInstance;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allSubInstances, (Functions.Function1)_function_1);
        Functions.Function1<AbstractInstance, ActorInterfaceInstance> _function_2 = new Functions.Function1<AbstractInstance, ActorInterfaceInstance>(){

            public ActorInterfaceInstance apply(AbstractInstance inst) {
                return (ActorInterfaceInstance)inst;
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_2);
        for (ActorInterfaceInstance aii : _map) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"OptionalActorInterfaceBase oai = (OptionalActorInterfaceBase) getObject(\"");
            String _path_1 = aii.getPath();
            _builder.append((Object)_path_1, "\t\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            EList _providedServices = aii.getProvidedServices();
            for (ServiceImplInstance svc : _providedServices) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"new InterfaceItemBroker(oai, \"");
                ProtocolClass _protocol = svc.getProtocol();
                String _fullyQualifiedName = this._roomExtensions.getFullyQualifiedName((RoomClass)_protocol);
                _builder.append((Object)_fullyQualifiedName, "\t\t\t");
                _builder.append((Object)"\", 0);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"InterfaceItemBase.connect(this, \"");
                String _path_2 = svc.getPath();
                _builder.append((Object)_path_2, "\t\t\t");
                _builder.append((Object)"\", \"");
                String _path_3 = aii.getPath();
                String _plus = String.valueOf(_path_3) + Character.valueOf('/');
                ProtocolClass _protocol_1 = svc.getProtocol();
                String _fullyQualifiedName_1 = this._roomExtensions.getFullyQualifiedName((RoomClass)_protocol_1);
                String _plus_1 = String.valueOf(_plus) + _fullyQualifiedName_1;
                _builder.append((Object)_plus_1, "\t\t\t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// wiring");
        _builder.newLine();
        EList _wires = wired.getWires();
        for (Wire wire : _wires) {
            _builder.append((Object)"\t\t");
            String _xifexpression = null;
            boolean _isDataDriven = wire.isDataDriven();
            _xifexpression = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append((Object)_xifexpression, "\t\t");
            _builder.append((Object)".connect(this, \"");
            EList _path1 = wire.getPath1();
            String _join = IterableExtensions.join((Iterable)_path1, (CharSequence)"/");
            _builder.append((Object)_join, "\t\t");
            _builder.append((Object)"\", \"");
            EList _path2 = wire.getPath2();
            String _join_1 = IterableExtensions.join((Iterable)_path2, (CharSequence)"/");
            _builder.append((Object)_join_1, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// apply instance attribute configurations");
        _builder.newLine();
        EList _allContainedInstances_1 = comp.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            boolean _greaterThan_1;
            _builder.append((Object)"\t\t");
            CharSequence cfg = this.configGenAddon.genActorInstanceConfig(ai_1, "inst");
            _builder.newLineIfNotEmpty();
            int _length = cfg.length();
            boolean bl = _greaterThan_1 = _length > 0;
            if (!_greaterThan_1) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            ActorClass _actorClass = ai_1.getActorClass();
            String _name_11 = _actorClass.getName();
            _builder.append((Object)_name_11, "\t\t\t");
            _builder.append((Object)" inst = (");
            ActorClass _actorClass_1 = ai_1.getActorClass();
            String _name_12 = _actorClass_1.getName();
            _builder.append((Object)_name_12, "\t\t\t");
            _builder.append((Object)") getObject(\"");
            String _path_4 = ai_1.getPath();
            _builder.append((Object)_path_4, "\t\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (inst!=null) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)cfg, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void init(){");
        _builder.newLine();
        GlobalSettings _settings_3 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_3 = _settings_3.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"DebuggingService.getInstance().addVisibleComment(\"begin sub system initialization\");");
            _builder.newLine();
        }
        if (_hasVariableService = this.dataConfigExt.hasVariableService(comp)) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"variableService = new ");
            _builder.append((Object)clsname, "\t\t");
            _builder.append((Object)"VariableService(this);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super.init();");
        _builder.newLine();
        boolean _hasVariableService_1 = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"variableService.init();");
            _builder.newLine();
        }
        if (_isGenerateMSCInstrumentation_4 = (_settings_4 = Main.getSettings()).isGenerateMSCInstrumentation()) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"DebuggingService.getInstance().addVisibleComment(\"done sub system initialization\");");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void stop(){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super.stop();");
        _builder.newLine();
        boolean _hasVariableService_2 = this.dataConfigExt.hasVariableService(comp);
        if (_hasVariableService_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"variableService.stop();");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GlobalSettings _settings_5 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_5 = _settings_5.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_5) {
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public boolean hasGeneratedMSCInstrumentation() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void destroy() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().addVisibleComment(\"begin sub system destruction\");");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"super.destroy();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().addVisibleComment(\"done sub system destruction\");");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public IOptionalActorFactory getFactory(String optionalActorClass, String actorClass) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        IntelligentSeparator else1 = new IntelligentSeparator("else ");
        _builder.newLineIfNotEmpty();
        for (ActorClass oa : opt) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)else1, "\t\t");
            _builder.append((Object)"if (optionalActorClass.equals(\"");
            String _name_13 = oa.getName();
            _builder.append((Object)_name_13, "\t\t");
            _builder.append((Object)"\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            IntelligentSeparator else2 = new IntelligentSeparator("else ");
            _builder.newLineIfNotEmpty();
            EList _subClasses = root.getSubClasses(oa);
            List _union = this._roomExtensions.union((Iterable)_subClasses, (Object)oa);
            Functions.Function1<ActorClass, Boolean> _function_3 = new Functions.Function1<ActorClass, Boolean>(){

                public Boolean apply(ActorClass s) {
                    boolean _isAbstract = s.isAbstract();
                    return !_isAbstract;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_union, (Functions.Function1)_function_3);
            for (ActorClass subcls : _filter_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)else2, "\t\t\t");
                _builder.append((Object)"if (\"");
                String _name_14 = subcls.getName();
                _builder.append((Object)_name_14, "\t\t\t");
                _builder.append((Object)"\".equals(actorClass)) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return new ");
                String _javaFactoryName = this._javaExtensions.getJavaFactoryName(subcls);
                _builder.append((Object)_javaFactoryName, "\t\t\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getThreadId(PhysicalThread thread) {
        String _name = thread.getName();
        String _upperCase = _name.toUpperCase();
        return "THREAD_" + _upperCase;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> found = new HashSet<String>();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            int thread = ai.getThreadId();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                ProtocolClass _protocol = pi.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) continue;
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    boolean _not;
                    EObject _eContainer = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)_eContainer;
                    int peer_thread = peer_ai.getThreadId();
                    if (thread == peer_thread) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String _xifexpression = null;
                    int _compareTo = path.compareTo(ppath);
                    boolean _lessThan = _compareTo < 0;
                    _xifexpression = _lessThan ? String.valueOf(path) + " and " + ppath : String.valueOf(ppath) + " and " + path;
                    String pair = _xifexpression;
                    boolean _contains = found.contains(pair);
                    boolean bl = _not = !_contains;
                    if (!_not) continue;
                    found.add(pair);
                    InterfaceItem _interfaceItem = pi.getInterfaceItem();
                    InterfaceItem _interfaceItem_1 = pi.getInterfaceItem();
                    EStructuralFeature _eContainingFeature = _interfaceItem_1.eContainingFeature();
                    this.diagnostician.error(String.valueOf(pair) + ": data ports placed on different threads (not supported yet)", (EObject)_interfaceItem, _eContainingFeature);
                }
            }
        }
    }
}

