/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.etrice.generator.fsm.base.ILineOutput;
import org.eclipse.etrice.generator.launch.ConsoleOutput;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class GeneratorLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(configuration.getName()) + "...", 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            StringBuffer argString = new StringBuffer();
            this.addModels(configuration, argString);
            this.addArguments(configuration, argString);
            String pgmArgs = argString.toString().trim();
            pgmArgs = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(pgmArgs);
            ArrayList<String> res = new ArrayList<String>();
            int begin = 0;
            int end = pgmArgs.indexOf(32);
            boolean inQuotes = false;
            while (end > 0) {
                if (pgmArgs.charAt(begin) == '\"') {
                    inQuotes = true;
                }
                if (inQuotes && pgmArgs.charAt(end - 1) == '\"') {
                    inQuotes = false;
                }
                if (!inQuotes) {
                    res.add(pgmArgs.substring(begin, end).replace("\"", ""));
                    begin = end + 1;
                }
                end = pgmArgs.indexOf(32, end + 1);
            }
            res.add(pgmArgs.substring(begin).replace("\"", ""));
            String[] args = new String[res.size()];
            res.toArray(args);
            final MessageConsole myConsole = this.findConsole(this.getConsoleName());
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                        IWorkbenchPage page = win.getActivePage();
                        String id = "org.eclipse.ui.console.ConsoleView";
                        IConsoleView view = (IConsoleView)page.showView(id);
                        view.display((IConsole)myConsole);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
            MessageConsoleStream out = myConsole.newMessageStream();
            out.getConsole().clearConsole();
            ConsoleOutput output = new ConsoleOutput(out);
            this.runGenerator(args, output);
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            monitor.done();
        }
        this.launchRefreshJob(configuration);
    }

    private void launchRefreshJob(final ILaunchConfiguration configuration) {
        Job job = new Job("refresh resources after code generation"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected void addModels(ILaunchConfiguration configuration, StringBuffer argString) throws CoreException {
        ArrayList models = (ArrayList)configuration.getAttribute("ModelFiles", Collections.EMPTY_LIST);
        for (String model : models) {
            argString.append(" \"" + model + "\"");
        }
    }

    protected void addArguments(ILaunchConfiguration configuration, StringBuffer argString) throws CoreException {
        ScopedPreferenceStore prefStore;
        if (configuration.getAttribute("Lib", false)) {
            argString.append(" -lib");
        }
        if (configuration.getAttribute("SaveGenModel", false)) {
            argString.append(" -saveGenModel");
            argString.append(" " + configuration.getAttribute("GenModelPath", "?"));
        }
        if (!configuration.getAttribute("MainMethodName", "main").equals("main")) {
            argString.append(" -mainName");
            argString.append(" " + configuration.getAttribute("MainMethodName", "main"));
        }
        if (configuration.getAttribute("GenDocumentation", false) || configuration.getAttribute("GenInstanceDiagram", false)) {
            argString.append(" -genDocu");
        }
        if (configuration.getAttribute("Debug", false)) {
            argString.append(" -debug");
        }
        if (configuration.getAttribute("MSC", false)) {
            argString.append(" -msc_instr");
        }
        if (configuration.getAttribute("DataLogging", false)) {
            argString.append(" -data_instr");
        }
        if (configuration.getAttribute("Verbose", false)) {
            argString.append(" -gen_as_verbose");
        }
        if (!configuration.getAttribute("UseTranslation", true)) {
            argString.append(" -notranslate");
        }
        if ((prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.generator.ui")).getBoolean("GenerateIncremental")) {
            argString.append(" -inc");
        }
        boolean override = configuration.getAttribute("OverrideDirectories", false);
        String srcgenDir = prefStore.getString("GenerationDirectory");
        String infoDir = prefStore.getString("GenerationInfoDirectory");
        String docDir = prefStore.getString("GeneratedDocuDirectory");
        if (override) {
            srcgenDir = configuration.getAttribute("SrcgenPath", srcgenDir);
            infoDir = configuration.getAttribute("InfoPath", infoDir);
            docDir = configuration.getAttribute("DocPath", docDir);
        }
        argString.append(" -genDir");
        argString.append(" " + srcgenDir);
        argString.append(" -genInfoDir");
        argString.append(" " + infoDir);
        argString.append(" -genDocDir");
        argString.append(" " + docDir);
    }

    protected abstract void runGenerator(String[] var1, ILineOutput var2);

    protected abstract String getConsoleName();
}

