/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.fsm.ast.tokens;

import java.util.Collections;
import java.util.Map;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCToken;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class DCBracketToken
extends DCToken {
    private static final DCBracketToken leftRoundBracket = new DCBracketToken(BracketKind.LEFT_ROUND);
    private static final DCBracketToken rightRoundBracket = new DCBracketToken(BracketKind.RIGHT_ROUND);
    private static final DCBracketToken leftCurlyBracket = new DCBracketToken(BracketKind.LEFT_CURLY);
    private static final DCBracketToken rightCurlyBracket = new DCBracketToken(BracketKind.RIGHT_CURLY);
    private static final DCBracketToken leftSquareBracket = new DCBracketToken(BracketKind.LEFT_SQUARE);
    private static final DCBracketToken rightSquareBracket = new DCBracketToken(BracketKind.RIGHT_SQUARE);
    private static final Map<Character, DCBracketToken> char2token = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)Character.valueOf('('), (Object)leftRoundBracket), Pair.of((Object)Character.valueOf(')'), (Object)rightRoundBracket), Pair.of((Object)Character.valueOf('{'), (Object)leftCurlyBracket), Pair.of((Object)Character.valueOf('}'), (Object)rightCurlyBracket), Pair.of((Object)Character.valueOf('['), (Object)leftSquareBracket), Pair.of((Object)Character.valueOf(']'), (Object)rightSquareBracket)}));
    private final BracketKind bracketKind;

    private DCBracketToken(BracketKind bk) {
        super(DCToken.Kind.BRACKET);
        this.bracketKind = bk;
    }

    public static DCBracketToken getToken(char c) {
        return char2token.get(Character.valueOf(c));
    }

    @Override
    @Pure
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bracketKind == null ? 0 : this.bracketKind.hashCode());
        return result;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DCBracketToken other = (DCBracketToken)obj;
        return !(this.bracketKind == null ? other.bracketKind != null : !this.bracketKind.equals((Object)other.bracketKind));
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public BracketKind getBracketKind() {
        return this.bracketKind;
    }

    public static enum BracketKind {
        LEFT_ROUND,
        RIGHT_ROUND,
        LEFT_CURLY,
        RIGHT_CURLY,
        LEFT_SQUARE,
        RIGHT_SQUARE;

    }
}

