/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.dctools.fsm.ast

import java.util.HashMap
import org.eclipse.emf.ecore.EObject

class CandidateMap extends HashMap<String, EObject> {
	
	def CandidateMap getMatches(String prefix) {
		val result = new CandidateMap
		
		for (entry : entrySet) {
			if (entry.key.startsWith(prefix)) {
				result.put(entry.key, entry.value)
			}
		}
		
		return result
	}
}