/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.expressions.detailcode.DetailExpressionAssistParser;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.expressions.ui.contentassist.DetailExpressionProposalConfig;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RoomExpressionProposalProvider {
    @Inject
    private DetailExpressionProposalConfig uiExpressionProvider;
    @Inject
    private PrefixMatcher prefixMatcher;

    public List<ICompletionProposal> createProposals(final IDetailExpressionProvider exprProvider, String text, int offset, final int globalOffset) {
        try {
            List list = null;
            Document document = new Document(text);
            final DetailExpressionAssistParser parser = new DetailExpressionAssistParser((IDocument)document, offset, exprProvider);
            ArrayList arrayList = CollectionLiterals.newArrayList((Object[])new IDetailExpressionProvider.ExpressionFeature[0]);
            Procedures.Procedure1<ArrayList<IDetailExpressionProvider.ExpressionFeature>> procedure1 = new Procedures.Procedure1<ArrayList<IDetailExpressionProvider.ExpressionFeature>>(){

                public void apply(ArrayList<IDetailExpressionProvider.ExpressionFeature> features) {
                    boolean bl = parser.isContextExpression();
                    if (bl) {
                        IDetailExpressionProvider.ExpressionFeature contextFeature;
                        IDetailExpressionProvider.ExpressionFeature expressionFeature = null;
                        if (parser != null) {
                            expressionFeature = parser.resolveLatestCompleted();
                        }
                        if ((contextFeature = expressionFeature) != null) {
                            List<IDetailExpressionProvider.ExpressionFeature> list = exprProvider.getContextFeatures(contextFeature);
                            Iterables.addAll(features, list);
                        } else {
                            boolean bl2 = parser.isInitialExpression();
                            if (bl2) {
                                List<IDetailExpressionProvider.ExpressionFeature> list = exprProvider.getInitialFeatures();
                                Iterables.addAll(features, list);
                            }
                        }
                    } else {
                        boolean bl3 = parser.isInitialExpression();
                        if (bl3) {
                            List<IDetailExpressionProvider.ExpressionFeature> list = exprProvider.getInitialFeatures();
                            Iterables.addAll(features, list);
                        }
                    }
                }
            };
            ArrayList availableFeatures = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList, (Procedures.Procedure1)procedure1);
            final String prefix = parser.computeIdentifierPrefix(offset);
            Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean> function1 = new Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean>(){

                public Boolean apply(IDetailExpressionProvider.ExpressionFeature it) {
                    return it.getId().startsWith(prefix);
                }
            };
            Functions.Function1<IDetailExpressionProvider.ExpressionFeature, ICompletionProposal> function12 = new Functions.Function1<IDetailExpressionProvider.ExpressionFeature, ICompletionProposal>(){

                public ICompletionProposal apply(final IDetailExpressionProvider.ExpressionFeature feature) {
                    String string = RoomExpressionProposalProvider.this.uiExpressionProvider.getDisplayString(feature);
                    StyledString displayString = new StyledString(string);
                    Image image = RoomExpressionProposalProvider.this.uiExpressionProvider.getImage(feature);
                    ConfigurableCompletionProposal configurableCompletionProposal = RoomExpressionProposalProvider.this.doCreateProposal(feature.getId(), displayString, image, prefix, globalOffset);
                    Procedures.Procedure1<ConfigurableCompletionProposal> procedure1 = new Procedures.Procedure1<ConfigurableCompletionProposal>(){

                        public void apply(ConfigurableCompletionProposal it) {
                            RoomExpressionProposalProvider.this.processPostfix(it, feature);
                        }
                    };
                    ConfigurableCompletionProposal prop = (ConfigurableCompletionProposal)ObjectExtensions.operator_doubleArrow((Object)configurableCompletionProposal, (Procedures.Procedure1)procedure1);
                    return prop;
                }
            };
            list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)availableFeatures, (Functions.Function1)function1), (Functions.Function1)function12));
            return list;
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    protected ConfigurableCompletionProposal doCreateProposal(final String proposal, StyledString displayString, Image image, String prefix, int globalOffset) {
        int n = prefix.length();
        int n2 = globalOffset - n;
        int n3 = prefix.length();
        int n4 = proposal.length();
        ConfigurableCompletionProposal configurableCompletionProposal = new ConfigurableCompletionProposal(proposal, n2, n3, n4, image, displayString, null, null);
        Procedures.Procedure1<ConfigurableCompletionProposal> procedure1 = new Procedures.Procedure1<ConfigurableCompletionProposal>(){

            public void apply(ConfigurableCompletionProposal it) {
                it.setMatcher(RoomExpressionProposalProvider.this.prefixMatcher);
                it.setAutoInsertable(false);
                it.setReplaceContextLength(proposal.length());
            }
        };
        return (ConfigurableCompletionProposal)ObjectExtensions.operator_doubleArrow((Object)configurableCompletionProposal, (Procedures.Procedure1)procedure1);
    }

    protected ConfigurableCompletionProposal processPostfix(ConfigurableCompletionProposal proposal, final IDetailExpressionProvider.ExpressionFeature feature) {
        Procedures.Procedure1<ConfigurableCompletionProposal> procedure1 = new Procedures.Procedure1<ConfigurableCompletionProposal>(){

            public void apply(ConfigurableCompletionProposal it) {
                boolean bl;
                Pair<String, Point> postfix = RoomExpressionProposalProvider.this.uiExpressionProvider.getPostfixReplacement(feature);
                boolean bl2 = Strings.isEmpty((String)((String)postfix.getKey()));
                boolean bl3 = bl = !bl2;
                if (bl) {
                    int n;
                    int n2;
                    int n3;
                    boolean bl4;
                    Point point = (Point)postfix.getValue();
                    boolean bl5 = bl4 = point != null;
                    if (bl4) {
                        n3 = it.getReplacementOffset();
                        n2 = it.getReplacementString().length();
                        n = n3 + n2;
                        int n4 = n + ((Point)postfix.getValue()).x;
                        it.setSelectionStart(n4);
                        int n5 = it.getCursorPosition();
                        int n6 = n5 + ((Point)postfix.getValue()).x;
                        it.setCursorPosition(n6);
                        it.setSelectionLength(((Point)postfix.getValue()).y);
                    } else {
                        n3 = it.getCursorPosition();
                        n2 = ((String)postfix.getKey()).length();
                        n = n3 + n2;
                        it.setCursorPosition(n);
                    }
                    String string = it.getReplacementString();
                    String string2 = (String)postfix.getKey();
                    String string3 = String.valueOf(string) + string2;
                    it.setReplacementString(string3);
                }
            }
        };
        return (ConfigurableCompletionProposal)ObjectExtensions.operator_doubleArrow((Object)proposal, (Procedures.Procedure1)procedure1);
    }
}

