/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.scoping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.scoping.IModelLocator;

@Singleton
public class ModelLocator {
    private static final String IMODEL_LOCATOR_ID = "org.eclipse.etrice.core.common.modellocator";
    private ArrayList<IModelLocator> locators = new ArrayList();

    @Inject
    public ModelLocator(IModelLocator defaultLocator) {
        this.addLocator(defaultLocator);
    }

    public void loadExtensions() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(IMODEL_LOCATOR_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object ext = e.createExecutableExtension("class");
                if (ext instanceof IModelLocator) {
                    IModelLocator locator = (IModelLocator)ext;
                    this.locators.add(locator);
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
    }

    public void addLocator(IModelLocator locator) {
        if (locator != null) {
            this.locators.add(0, locator);
        }
    }

    public void removeLocator(IModelLocator locator) {
        this.locators.remove(locator);
    }

    public String resolve(String resolve, Resource resource) {
        for (IModelLocator locator : this.locators) {
            String result = locator.resolve(resolve, resource);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

