/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.contentassist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.ui.contentassist.ImportModelAssist;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigValueArray;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.RefSegment;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.ui.contentassist.AbstractConfigProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ConfigProposalProvider
extends AbstractConfigProposalProvider {
    @Inject
    private RoomHelpers roomHelpers;
    @Inject
    private ConfigUtil configUtil;

    public void completeImport_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ImportModelAssist.addPaths((AbstractContentProposalProvider)this, (ContentAssistContext)context, (ICompletionProposalAcceptor)acceptor, (String)".room");
    }

    @Override
    public void completeActorInstanceConfig_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeActorInstanceConfig_Path(model, assignment, context, acceptor);
        List<ActorRef> instances = this.collectInstances((ActorInstanceConfig)model);
        for (ActorRef instance : instances) {
            acceptor.accept(this.createCompletionProposal(instance.getName(), context));
        }
    }

    @Override
    public void completeRefPath_Refs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRefPath_Refs(model, assignment, context, acceptor);
        if (model instanceof ActorInstanceConfig) {
            this.completeActorInstanceConfig_Path(model, assignment, context, acceptor);
            return;
        }
        RefPath path = (RefPath)model;
        if (path.eContainer() instanceof ActorInstanceConfig) {
            List<ActorRef> instances = this.collectInstances((ActorInstanceConfig)path.eContainer());
            for (ActorRef instance : instances) {
                acceptor.accept(this.createCompletionProposal(instance.getName(), context));
            }
        }
    }

    private List<ActorRef> collectInstances(ActorInstanceConfig config) {
        ArrayList<ActorRef> refs = new ArrayList<ActorRef>();
        SubSystemClass root = config.getSubSystem().getType();
        if (root != null) {
            RefPath path = config.getPath();
            if (path != null && !path.getRefs().isEmpty() && path.getRefs().get(0) != null && ((RefSegment)path.getRefs().get(0)).getRef() != null) {
                root = this.configUtil.resolve((ActorContainerClass)root, path);
            }
            if (root != null) {
                for (ActorContainerRef ref : this.roomHelpers.getRefs((StructureClass)root, true)) {
                    ActorRef aRef;
                    if (!(ref instanceof ActorRef) || (aRef = (ActorRef)ref).getMultiplicity() != 1) continue;
                    refs.add((ActorRef)ref);
                }
            }
        }
        return refs;
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        LiteralType type;
        Attribute attr = this.getAttribute(model);
        if (attr != null && (type = this.configUtil.getLiteralType(attr)) != LiteralType.CHAR) {
            return;
        }
        super.complete_STRING(model, ruleCall, context, acceptor);
    }

    public void complete_BooleanLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr != null) {
            mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
            LiteralType type = this.configUtil.getLiteralType(attr);
            if (type != LiteralType.BOOL) {
                return;
            }
        }
        acceptor.accept(this.createCompletionProposal("", "Boolean" + mult, null, context));
        acceptor.accept(this.createCompletionProposal("true", "true", null, context));
        acceptor.accept(this.createCompletionProposal("false", "false", null, context));
    }

    public void complete_IntLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr != null) {
            mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
            LiteralType type = this.configUtil.getLiteralType(attr);
            if (type != LiteralType.INT && type != LiteralType.REAL) {
                return;
            }
        }
        acceptor.accept(this.createCompletionProposal("", "Integer" + mult, null, context));
        acceptor.accept(this.createCompletionProposal("", "Hexadecimal" + mult, null, context));
    }

    public void complete_RealLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr != null) {
            mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
            LiteralType type = this.configUtil.getLiteralType(attr);
            if (type != LiteralType.REAL) {
                return;
            }
        }
        acceptor.accept(this.createCompletionProposal("", "Real" + mult, null, context));
    }

    @Override
    public void completeEnumConfigValue_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr == null) {
            return;
        }
        mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
        DataType type = attr.getType().getType();
        if (!(type instanceof EnumerationType)) {
            return;
        }
        EnumerationType enumType = (EnumerationType)type;
        acceptor.accept(this.createCompletionProposal(enumType.getName(), enumType.getName(), null, context));
        for (EnumLiteral l : enumType.getLiterals()) {
            acceptor.accept(this.createCompletionProposal(l.getFullName(), String.valueOf(l.getFullName()) + mult, null, context));
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject model = contentAssistContext.getCurrentModel();
        if (model instanceof AttrConfig && this.hideKeyword((AttrConfig)model, keyword)) {
            return;
        }
        if (model instanceof ConfigValueArray && this.hideKeyword((ConfigValueArray)model, keyword)) {
            return;
        }
        if (keyword.getValue().equals("true") || keyword.getValue().equals("false")) {
            return;
        }
        if (model instanceof AttrInstanceConfig && this.hideKeyword((AttrInstanceConfig)model, keyword)) {
            return;
        }
        super.completeKeyword(keyword, contentAssistContext, acceptor);
    }

    private boolean hideKeyword(AttrConfig config, Keyword keyword) {
        LiteralType type = this.configUtil.getLiteralType(config.getAttribute());
        DataType dataType = config.getAttribute().getType().getType();
        if ((keyword.getValue().equals("min") || keyword.getValue().equals("max")) && type != LiteralType.INT && type != LiteralType.REAL) {
            return true;
        }
        if (keyword.getValue().equals("Attr") && !(dataType instanceof PrimitiveType) && !(dataType instanceof EnumerationType) && !(dataType instanceof DataClass)) {
            return true;
        }
        return keyword.getValue().equals("=") && !config.getAttribute().eIsProxy() && !(dataType instanceof PrimitiveType) && !(dataType instanceof EnumerationType);
    }

    private boolean hideKeyword(AttrInstanceConfig config, Keyword keyword) {
        return keyword.getValue().equals("dynamic configuration") && !(config.eContainer() instanceof ActorInstanceConfig);
    }

    private boolean hideKeyword(ConfigValueArray array, Keyword keyword) {
        if (keyword.getValue().equals(",") && array.eContainer() instanceof AttrConfig) {
            Attribute attr = ((AttrConfig)array.eContainer()).getAttribute();
            if (attr.getSize() <= array.getValues().size()) {
                return true;
            }
            if (((PrimitiveType)attr.getType().getType()).getType() == LiteralType.CHAR) {
                return true;
            }
        }
        return false;
    }

    private Attribute getAttribute(EObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Attribute) {
            return (Attribute)o;
        }
        if (o instanceof AttrConfig) {
            return ((AttrConfig)o).getAttribute();
        }
        return this.getAttribute(o.eContainer());
    }
}

