/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.Iterator;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.ETMapStandaloneSetup;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.ETPhysStandaloneSetup;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.ILogger;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.java.gen.GlobalSettings;
import org.eclipse.etrice.generator.java.gen.MainGen;
import org.eclipse.etrice.generator.java.gen.Validator;
import org.eclipse.etrice.generator.java.setup.GeneratorModule;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;

@Singleton
public class Main
extends AbstractGenerator {
    public static final String OPTION_GEN_PERSIST = "-persistable";
    public static final String OPTION_GEN_STORE_DATA_OBJ = "-storeDataObj";
    @Inject
    private MainGen mainGenerator;
    @Inject
    protected org.eclipse.etrice.generator.doc.gen.MainGen mainDocGenerator;
    @Inject
    private Validator validator;
    @Inject
    protected IDataConfiguration dataConfig;
    @Inject
    protected ImportUriResolver uriResolver;

    protected void printUsage() {
        output.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + this.getCommonOptions() + " [" + OPTION_GEN_PERSIST + "]" + " [" + OPTION_GEN_STORE_DATA_OBJ + "]" + " <list of model file paths>");
        output.println(this.getCommonOptionDescriptions());
        output.println("      -persistable                       # if specified make actor classes persistable");
        output.println("      -storeDataObj                      # if specified equip actor classes with store/restore using POJOs");
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    protected boolean parseOption(String arg, Iterator<String> it) {
        if (arg.equals(OPTION_GEN_PERSIST)) {
            Main.getSettings().setGeneratePersistenceInterface(true);
            return true;
        }
        if (arg.equals(OPTION_GEN_STORE_DATA_OBJ)) {
            Main.getSettings().setGenerateStoreDataObj(true);
            return true;
        }
        return super.parseOption(arg, it);
    }

    public static GlobalSettings getSettings() {
        return (GlobalSettings)Main.getInstance().getGeneratorSettings();
    }

    protected void setupMappingModel() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ETMapStandaloneSetup.doSetup();
        }
    }

    protected void setupPhysicalModel() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ETPhysStandaloneSetup.doSetup();
        }
    }

    protected int runGenerator() {
        this.setupRoomModel();
        this.dataConfig.doSetup();
        this.setupMappingModel();
        this.setupPhysicalModel();
        try {
            this.activateModelLocator();
            if (!this.loadModels(Main.getSettings().getInputModelURIs())) {
                this.logger.logInfo("loading of models failed");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            if (!this.validateModels()) {
                this.logger.logInfo("validation failed");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            if (!this.dataConfig.setResources(this.getResourceSet(), (ILogger)this.logger)) {
                this.logger.logInfo("configuration errors");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            Root genModel = this.createGeneratorModel(Main.getSettings().isGenerateAsLibrary(), Main.getSettings().getGeneratorModelPath());
            if (this.diagnostician.isFailed() || genModel == null) {
                this.logger.logInfo("errors during build of generator model");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            if (!this.validator.validate(genModel)) {
                this.logger.logInfo("validation failed during build of generator model");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet(), (IDiagnostician)this.diagnostician);
            if (Main.getSettings().isDebugMode()) {
                this.logger.logInfo("-- begin dump of mappings");
                this.logger.logInfo(ETMapUtil.dumpMappings());
                this.logger.logInfo("-- end dump of mappings");
            }
            if (this.diagnostician.isFailed() || genModel == null) {
                this.logger.logInfo("errors in mapping");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            this.logger.logInfo("-- starting code generation");
            this.mainGenerator.doGenerate(genModel.eResource());
            if (Main.getSettings().isGenerateDocumentation()) {
                this.mainDocGenerator.doGenerate(genModel.eResource());
            }
            if (this.diagnostician.isFailed()) {
                this.logger.logInfo("errors during code generation");
                this.logger.logError("-- terminating", null);
                return 1;
            }
            this.logger.logInfo("-- finished code generation");
        }
        finally {
            this.deactivateModelLocator();
        }
        return 0;
    }
}

