/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ActorClassDataGen {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;

    public void doGenerate(final Root root) {
        final HashMap ac2wired = new HashMap();
        Functions.Function1<WiredStructureClass, Boolean> function1 = new Functions.Function1<WiredStructureClass, Boolean>(){

            public Boolean apply(WiredStructureClass w) {
                return w instanceof WiredActorClass;
            }
        };
        Consumer<WiredStructureClass> consumer = new Consumer<WiredStructureClass>(){

            @Override
            public void accept(WiredStructureClass w) {
                ac2wired.put(((WiredActorClass)w).getActorClass(), (WiredActorClass)w);
            }
        };
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)function1).forEach(consumer);
        Functions.Function1<ActorClass, Boolean> function12 = new Functions.Function1<ActorClass, Boolean>(){

            public Boolean apply(ActorClass it) {
                return ActorClassDataGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)it);
            }
        };
        Functions.Function1<ActorClass, ExpandedActorClass> function13 = new Functions.Function1<ActorClass, ExpandedActorClass>(){

            public ExpandedActorClass apply(ActorClass it) {
                return root.getExpandedActorClass(it);
            }
        };
        Iterable iterable = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)function12), (Functions.Function1)function13);
        for (ExpandedActorClass xpac : iterable) {
            WiredActorClass wired = (WiredActorClass)ac2wired.get(xpac.getActorClass());
            String string = this._roomExtensions.getGenerationTargetPath((EObject)xpac.getActorClass());
            String string2 = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String path = String.valueOf(string) + string2;
            String string3 = this._roomExtensions.getGenerationInfoPath((EObject)xpac.getActorClass());
            String string4 = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String infopath = String.valueOf(string3) + string4;
            String string5 = xpac.getActorClass().getName();
            String file = String.valueOf(string5) + "_DataObject.java";
            this.fileIO.generateFile("generating ActorClass implementation", path, infopath, file, this.generate(root, xpac, wired));
        }
    }

    public CharSequence generate(Root root, ExpandedActorClass xpac, WiredActorClass wired) {
        Object object;
        boolean bl;
        Object object2 = null;
        ActorClass ac = xpac.getActorClass();
        String string = ac.getName();
        String clsname = String.valueOf(string) + "_DataObject";
        EList models = root.getReferencedModels((RoomClass)ac);
        String string2 = null;
        ModelComponent modelComponent = ac.getBase();
        boolean bl2 = bl = modelComponent != null;
        if (bl) {
            String string3 = ac.getActorBase().getName();
            object = "extends " + string3;
            string2 = String.valueOf(object) + "_DataObject ";
        } else {
            string2 = "";
        }
        String baseClass = string2;
        object = new StringConcatenation();
        object.append("package ");
        String string4 = this._roomExtensions.getPackage((RoomClass)ac);
        object.append(string4);
        object.append(";");
        object.newLineIfNotEmpty();
        object.newLine();
        object.append("import org.eclipse.etrice.runtime.java.modelbase.IActorClassDataObject;");
        object.newLine();
        for (RoomModel model : models) {
            object.append("import ");
            String string5 = model.getName();
            object.append(string5);
            object.append(".*;");
            object.newLineIfNotEmpty();
        }
        object.newLine();
        object.append("public class ");
        object.append(clsname);
        object.append(" ");
        object.append(baseClass);
        object.append("implements IActorClassDataObject {");
        object.newLineIfNotEmpty();
        object.append("\t");
        object.newLine();
        boolean bl3 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (bl3) {
            object.append("\t");
            object.append("// state and history");
            object.newLine();
            object.append("\t");
            object.append("private int state;");
            object.newLine();
            object.append("\t");
            object.append("private int[] history;");
            object.newLine();
            object.append("\t");
            object.newLine();
        }
        object.append("\t");
        CharSequence charSequence = this._procedureHelpers.attributes((List)ac.getAttributes());
        object.append((Object)charSequence, "\t");
        object.newLineIfNotEmpty();
        object.append("\t");
        object.newLine();
        boolean bl4 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (bl4) {
            object.append("\t");
            object.append("public int getState() {");
            object.newLine();
            object.append("\t");
            object.append("\t");
            object.append("return state;");
            object.newLine();
            object.append("\t");
            object.append("}");
            object.newLine();
            object.append("\t");
            object.newLine();
            object.append("\t");
            object.append("public void setState(int state) {");
            object.newLine();
            object.append("\t");
            object.append("\t");
            object.append("this.state = state;");
            object.newLine();
            object.append("\t");
            object.append("}");
            object.newLine();
            object.append("\t");
            object.newLine();
            object.append("\t");
            object.append("public int[] getHistory() {");
            object.newLine();
            object.append("\t");
            object.append("\t");
            object.append("return history;");
            object.newLine();
            object.append("\t");
            object.append("}");
            object.newLine();
            object.append("\t");
            object.newLine();
            object.append("\t");
            object.append("public void setHistory(int[] history)  {");
            object.newLine();
            object.append("\t");
            object.append("\t");
            object.append("this.history = history;");
            object.newLine();
            object.append("\t");
            object.append("}");
            object.newLine();
            object.append("\t");
            object.newLine();
        }
        object.append("\t");
        CharSequence charSequence2 = this._procedureHelpers.attributeSettersGettersImplementation((List)ac.getAttributes(), ac.getName());
        object.append((Object)charSequence2, "\t");
        object.newLineIfNotEmpty();
        object.append("\t");
        object.newLine();
        object.append("};");
        object.newLine();
        object2 = object;
        return object2;
    }
}

