/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DataClassGen {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private RoomHelpers roomHelpers;

    public void doGenerate(Root root) {
        Functions.Function1<DataClass, Boolean> function1 = new Functions.Function1<DataClass, Boolean>(){

            public Boolean apply(DataClass cl) {
                return DataClassGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)cl);
            }
        };
        Iterable iterable = IterableExtensions.filter((Iterable)root.getDataClasses(), (Functions.Function1)function1);
        for (DataClass dc : iterable) {
            String string = this._roomExtensions.getGenerationTargetPath((EObject)dc);
            String string2 = this._roomExtensions.getPath((RoomClass)dc);
            String path = String.valueOf(string) + string2;
            String string3 = this._roomExtensions.getGenerationInfoPath((EObject)dc);
            String string4 = this._roomExtensions.getPath((RoomClass)dc);
            String infopath = String.valueOf(string3) + string4;
            String file = this._javaExtensions.getJavaFileName((RoomClass)dc);
            this.fileIO.generateFile("generating DataClass implementation", path, infopath, file, this.generate(root, dc));
        }
    }

    public CharSequence generate(Root root, DataClass dc) {
        String string;
        String string2;
        Object object;
        boolean bl;
        boolean bl2;
        String string3;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("package ");
        String string4 = this._roomExtensions.getPackage((RoomClass)dc);
        stringConcatenation.append(string4);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        stringConcatenation.newLine();
        stringConcatenation.append("import java.io.Serializable;");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        EList models = root.getReferencedModels((RoomClass)dc);
        stringConcatenation.newLineIfNotEmpty();
        for (RoomModel model : models) {
            stringConcatenation.append("import ");
            string3 = model.getName();
            stringConcatenation.append(string3);
            stringConcatenation.append(".*;");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        CharSequence charSequence = this._procedureHelpers.userCode(dc, 1);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("public class ");
        String string5 = dc.getName();
        stringConcatenation.append(string5);
        string3 = dc.getBase();
        boolean bl3 = bl2 = string3 != null;
        if (bl2) {
            stringConcatenation.append(" extends ");
            String string6 = dc.getBase().getName();
            stringConcatenation.append(string6);
        }
        stringConcatenation.append(" implements Serializable {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("private static final long serialVersionUID = ");
        string3 = this._roomExtensions.getPackage((RoomClass)dc);
        String string7 = dc.getName();
        int n = (String.valueOf(string3) + string7).hashCode();
        stringConcatenation.append((Object)n, "\t");
        stringConcatenation.append("L;");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence2 = this._procedureHelpers.userCode(dc, 2);
        stringConcatenation.append((Object)charSequence2, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence3 = this._procedureHelpers.attributes((List)dc.getAttributes());
        stringConcatenation.append((Object)charSequence3, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence4 = this._procedureHelpers.attributeSettersGettersImplementation((List)dc.getAttributes(), dc.getName());
        stringConcatenation.append((Object)charSequence4, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence5 = this._procedureHelpers.operationsImplementation((List)dc.getOperations(), dc.getName());
        stringConcatenation.append((Object)charSequence5, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("// default constructor");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("public ");
        String string8 = dc.getName();
        stringConcatenation.append(string8, "\t");
        stringConcatenation.append("() {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("super();");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        CharSequence charSequence6 = this._initialization.attributeInitialization((List<Attribute>)dc.getAttributes(), (EObject)dc, true);
        stringConcatenation.append((Object)charSequence6, "\t\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        String string9 = this._procedureHelpers.userStructorBody((RoomClass)dc, true);
        stringConcatenation.append(string9, "\t\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("// constructor using fields");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("public ");
        String string10 = dc.getName();
        stringConcatenation.append(string10, "\t");
        stringConcatenation.append("(");
        String string11 = this.argList(dc);
        stringConcatenation.append(string11, "\t");
        stringConcatenation.append(") {");
        stringConcatenation.newLineIfNotEmpty();
        Object object2 = dc.getBase();
        boolean bl4 = bl = object2 != null;
        if (bl) {
            stringConcatenation.append("\t\t");
            stringConcatenation.append("super(");
            object = this.paramList(dc.getBase());
            stringConcatenation.append((String)object, "\t\t");
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        } else {
            stringConcatenation.append("\t\t");
            stringConcatenation.append("super();");
            stringConcatenation.newLine();
        }
        stringConcatenation.newLine();
        object2 = dc.getAttributes();
        for (Attribute a : object2) {
            stringConcatenation.append("\t\t");
            stringConcatenation.append("this.");
            string2 = a.getName();
            stringConcatenation.append(string2, "\t\t");
            stringConcatenation.append(" = ");
            string = a.getName();
            stringConcatenation.append(string, "\t\t");
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        object2 = this._procedureHelpers.userStructorBody((RoomClass)dc, true);
        stringConcatenation.append((String)object2, "\t\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("// deep copy");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("public ");
        String string12 = dc.getName();
        stringConcatenation.append(string12, "\t");
        stringConcatenation.append(" deepCopy() {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        object = dc.getName();
        stringConcatenation.append((String)object, "\t\t");
        stringConcatenation.append(" copy = new ");
        string2 = dc.getName();
        stringConcatenation.append(string2, "\t\t");
        stringConcatenation.append("();");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        string = this.deepCopy(dc);
        stringConcatenation.append(string, "\t\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("return copy;");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("};");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public String paramList(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (dc != null) {
            String string;
            String string2 = this.paramList((List<Attribute>)dc.getAttributes()).toString();
            result = string = String.valueOf(string2) + result;
            if ((dc = dc.getBase()) == null) continue;
            result = ", " + result;
        }
        return result;
    }

    private CharSequence paramList(List<Attribute> attributes) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl = false;
        for (Attribute a : attributes) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation.appendImmediate((Object)", ", "");
            }
            String string = a.getName();
            stringConcatenation.append(string);
        }
        return stringConcatenation;
    }

    public String argList(DataClass dc) {
        return this._procedureHelpers.argList((Iterable)this.roomHelpers.getAllAttributes(dc));
    }

    private String deepCopy(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (dc != null) {
            String string;
            String string2 = this.deepCopy((List<Attribute>)dc.getAttributes()).toString();
            result = string = String.valueOf(string2) + result;
            dc = dc.getBase();
        }
        return result;
    }

    private CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Attribute a : attributes) {
            String string;
            String string2;
            int n;
            Object object;
            boolean bl = a.getType().isRef();
            if (bl) {
                stringConcatenation.append("copy.");
                object = a.getName();
                stringConcatenation.append((String)object);
                stringConcatenation.append(" = ");
                String string3 = a.getName();
                stringConcatenation.append(string3);
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                continue;
            }
            object = a.getType().getType();
            if (object instanceof ComplexType) {
                boolean bl2;
                stringConcatenation.append("if (");
                String string4 = a.getName();
                stringConcatenation.append(string4);
                stringConcatenation.append("!=null) {");
                stringConcatenation.newLineIfNotEmpty();
                n = a.getSize();
                boolean bl3 = bl2 = n <= 1;
                if (bl2) {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("copy.");
                    string2 = a.getName();
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(" = ");
                    string = a.getName();
                    stringConcatenation.append(string, "\t");
                    stringConcatenation.append(".deepCopy();");
                    stringConcatenation.newLineIfNotEmpty();
                } else {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("for (int i=0;i<");
                    string2 = a.getName();
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(".length;i++){");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("copy.");
                    string = a.getName();
                    stringConcatenation.append(string, "\t\t");
                    stringConcatenation.append("[i] = ");
                    String string5 = a.getName();
                    stringConcatenation.append(string5, "\t\t");
                    stringConcatenation.append("[i].deepCopy();");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("}");
                    stringConcatenation.newLine();
                }
                stringConcatenation.append("}");
                stringConcatenation.newLine();
                continue;
            }
            int n2 = a.getSize();
            int n3 = n = n2 == 0 ? 1 : 0;
            if (n != 0) {
                stringConcatenation.append("copy.");
                String string6 = a.getName();
                stringConcatenation.append(string6);
                stringConcatenation.append(" = ");
                string2 = a.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                continue;
            }
            stringConcatenation.append("for (int i=0;i<");
            String string7 = a.getName();
            stringConcatenation.append(string7);
            stringConcatenation.append(".length;i++){");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("copy.");
            string2 = a.getName();
            stringConcatenation.append(string2, "\t");
            stringConcatenation.append("[i] = ");
            string = a.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("[i];");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }
}

