/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EnumerationTypeGen {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;

    public void doGenerate(Root root) {
        Functions.Function1<EnumerationType, Boolean> function1 = new Functions.Function1<EnumerationType, Boolean>(){

            public Boolean apply(EnumerationType cl) {
                return EnumerationTypeGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)cl);
            }
        };
        Iterable iterable = IterableExtensions.filter((Iterable)root.getEnumClasses(), (Functions.Function1)function1);
        for (EnumerationType et : iterable) {
            String string = this._roomExtensions.getGenerationTargetPath((EObject)et);
            String string2 = this._roomExtensions.getPath((RoomClass)et);
            String path = String.valueOf(string) + string2;
            String string3 = this._roomExtensions.getGenerationInfoPath((EObject)et);
            String string4 = this._roomExtensions.getPath((RoomClass)et);
            String infopath = String.valueOf(string3) + string4;
            String file = this._javaExtensions.getJavaFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration implementation", path, infopath, file, this.generate(root, et));
        }
    }

    public CharSequence generate(Root root, EnumerationType et) {
        StringConcatenation stringConcatenation = null;
        String type = this._javaExtensions.getTargetType(et);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string = this._roomExtensions.getPackage((RoomClass)et);
        stringConcatenation2.append(string);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public interface ");
        String string2 = et.getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        EList eList = et.getLiterals();
        for (EnumLiteral lit : eList) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("static final ");
            stringConcatenation2.append(type, "\t");
            stringConcatenation2.append(" ");
            String string3 = lit.getName();
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(" = ");
            long l = lit.getLiteralValue();
            stringConcatenation2.append((Object)l, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

