/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.commands;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class ChangeDiagramInputJob
extends Job {
    @Inject
    private ILabelProvider labelProvider;
    private Diagram diagram;
    private DiagramEditorBase editor;
    private boolean close;
    private boolean saveOnClose;
    private boolean reOpen;
    private IFile roomFile;
    private StructureClass sc;

    public ChangeDiagramInputJob(String name, DiagramEditorBase editor) {
        super(name);
        this.editor = editor;
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
        this.diagram = editor.getDiagramTypeProvider().getDiagram();
        this.reOpen = true;
        this.saveOnClose = true;
        this.close = true;
    }

    public ChangeDiagramInputJob(String name, DiagramEditorBase editor, boolean close, boolean saveOnClose, boolean reOpen) {
        this(name, editor);
        this.close = close;
        this.saveOnClose = saveOnClose;
        this.reOpen = reOpen;
    }

    protected IStatus run(IProgressMonitor monitor) {
        URI diagramURI = this.diagram.eResource().getURI().trimFragment();
        IFile diagramFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(diagramURI.toPlatformString(true)));
        IContainer diagramFolder = diagramFile.getParent();
        final IContainer modelFolder = diagramFolder.getParent();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ChangeDiagramInputJob.this.roomFile = ChangeDiagramInputJob.this.selectRoomFile(modelFolder);
            }
        });
        if (this.roomFile == null) {
            return Status.OK_STATUS;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        URI newRoomURI = URI.createPlatformResourceURI((String)this.roomFile.getFullPath().toString(), (boolean)false);
        Resource roomRes = rs.getResource(newRoomURI, true);
        EObject rootEObject = (EObject)roomRes.getContents().iterator().next();
        if (!(rootEObject instanceof RoomModel)) {
            return Status.OK_STATUS;
        }
        final RoomModel roomModel = (RoomModel)rootEObject;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ChangeDiagramInputJob.this.sc = ChangeDiagramInputJob.this.selectSc(roomModel);
            }
        });
        if (this.sc == null) {
            return Status.OK_STATUS;
        }
        Runnable closeDiagramRunnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                workbench.getActivePage().closeEditor((IEditorPart)ChangeDiagramInputJob.this.editor, ChangeDiagramInputJob.this.saveOnClose);
            }
        };
        if (this.close) {
            Display.getDefault().syncExec(closeDiagramRunnable);
        }
        String newScName = this.sc.getName();
        String newDiagramName = String.valueOf(roomModel.getName()) + "." + newScName + "." + diagramURI.fileExtension();
        IPath newDiagramPath = diagramFile.getFullPath().removeLastSegments(1).append(newDiagramName);
        URI newDiagramURI = URI.createPlatformResourceURI((String)newDiagramPath.toString(), (boolean)false);
        EObject oldDiagramSc = (EObject)this.diagram.getLink().getBusinessObjects().iterator().next();
        URI oldScURI = EcoreUtil.getURI((EObject)oldDiagramSc);
        String oldScName = oldScURI.fragment().substring(oldScURI.fragment().indexOf(58) + 1).trim();
        URI oldRoomURI = oldScURI.trimFragment();
        if (!diagramURI.equals(newDiagramURI)) {
            try {
                diagramFile.move(newDiagramPath, false, monitor);
            }
            catch (CoreException e) {
                this.showError(e.getMessage());
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
        }
        roomRes.setURI(oldRoomURI);
        this.sc.setName(oldScName);
        Resource diagramRes = rs.getResource(newDiagramURI, true);
        EcoreUtil.resolveAll((Resource)diagramRes);
        roomRes.setURI(newRoomURI);
        this.sc.setName(newScName);
        try {
            diagramRes.save(null);
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        final IFile newDiagramFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newDiagramPath);
        Runnable openDiagramRunnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(newDiagramFile.getName());
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(newDiagramFile), desc.getId());
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.reOpen) {
            Display.getDefault().asyncExec(openDiagramRunnable);
        }
        return Status.OK_STATUS;
    }

    private void showError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Operation Failed", (String)message);
            }
        });
    }

    private IFile selectRoomFile(IContainer container) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(shell, false, container, 1);
        dialog.setMessage("Select a ROOM file");
        dialog.setInitialPattern(".room");
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    private StructureClass selectSc(RoomModel model) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, this.labelProvider);
        dialog.setMultipleSelection(false);
        dialog.setMessage("Select a new ROOM class");
        dialog.setFilter("*");
        dialog.setElements(this.getElements(model).toArray());
        if (dialog.open() == 0) {
            return (StructureClass)dialog.getFirstResult();
        }
        return null;
    }

    protected List<StructureClass> getElements(RoomModel model) {
        ArrayList<StructureClass> elements = new ArrayList<StructureClass>();
        elements.addAll((Collection<StructureClass>)model.getActorClasses());
        elements.addAll((Collection<StructureClass>)model.getSubSystemClasses());
        elements.addAll((Collection<StructureClass>)model.getSystems());
        return elements;
    }
}

