/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.base.util.RelativePathHelpers;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CompoundProtocolClass;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DocGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CodegenHelpers _codegenHelpers;
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    private ILogger logger;
    private final String IMGDIR_DEFAULT = "./images";
    private final String IMGWIDTH_DEFAULT = "1.0\\textwidth";

    public void doGenerate(final Root root) {
        EList eList = root.getModels();
        for (RoomModel model : eList) {
            final DocGenContext ctx = new DocGenContext(root, model);
            String path = this.roomExt.getDocGenerationTargetPath((EObject)model);
            String string = model.getName();
            String file = String.valueOf(string) + ".tex";
            final HashSet referencedModels = CollectionLiterals.newHashSet((Object[])new RoomModel[0]);
            this.logger.logInfo("generating LaTeX documentation: '" + file + "' in '" + path + "'");
            String string2 = model.getName();
            String string3 = String.valueOf(path) + string2;
            this.fileAccess.setOutputPath(string3);
            Consumer<LogicalSystem> consumer = new Consumer<LogicalSystem>(){

                @Override
                public void accept(LogicalSystem it) {
                    DocGen.this.saveAs(DocGen.this.generateDoc((RoomClass)it, ctx), DocGen.this.docFragmentName((RoomClass)it));
                }
            };
            model.getSystems().forEach((Consumer)consumer);
            Consumer<LogicalSystem> consumer2 = new Consumer<LogicalSystem>(){

                @Override
                public void accept(LogicalSystem it) {
                    referencedModels.addAll(root.getReferencedModels((RoomClass)it));
                }
            };
            model.getSystems().forEach((Consumer)consumer2);
            Consumer<SubSystemClass> consumer3 = new Consumer<SubSystemClass>(){

                @Override
                public void accept(SubSystemClass it) {
                    DocGen.this.saveAs(DocGen.this.generateDoc((RoomClass)it, ctx), DocGen.this.docFragmentName((RoomClass)it));
                }
            };
            model.getSubSystemClasses().forEach((Consumer)consumer3);
            Consumer<SubSystemClass> consumer4 = new Consumer<SubSystemClass>(){

                @Override
                public void accept(SubSystemClass it) {
                    referencedModels.addAll(root.getReferencedModels((RoomClass)it));
                }
            };
            model.getSubSystemClasses().forEach((Consumer)consumer4);
            Consumer<GeneralProtocolClass> consumer5 = new Consumer<GeneralProtocolClass>(){

                @Override
                public void accept(GeneralProtocolClass it) {
                    DocGen.this.saveAs(DocGen.this.generateDoc((RoomClass)it, ctx), DocGen.this.docFragmentName((RoomClass)it));
                }
            };
            model.getProtocolClasses().forEach((Consumer)consumer5);
            Consumer<GeneralProtocolClass> consumer6 = new Consumer<GeneralProtocolClass>(){

                @Override
                public void accept(GeneralProtocolClass it) {
                    referencedModels.addAll(root.getReferencedModels((RoomClass)it));
                }
            };
            model.getProtocolClasses().forEach((Consumer)consumer6);
            Consumer<EnumerationType> consumer7 = new Consumer<EnumerationType>(){

                @Override
                public void accept(EnumerationType it) {
                    DocGen.this.saveAs(DocGen.this.generateDoc((RoomClass)it, ctx), DocGen.this.docFragmentName((RoomClass)it));
                }
            };
            model.getEnumerationTypes().forEach((Consumer)consumer7);
            Consumer<EnumerationType> consumer8 = new Consumer<EnumerationType>(){

                @Override
                public void accept(EnumerationType it) {
                    referencedModels.addAll(root.getReferencedModels((RoomClass)it));
                }
            };
            model.getEnumerationTypes().forEach((Consumer)consumer8);
            Consumer<DataClass> consumer9 = new Consumer<DataClass>(){

                @Override
                public void accept(DataClass it) {
                    DocGen.this.saveAs(DocGen.this.generateDoc((RoomClass)it, ctx), DocGen.this.docFragmentName((RoomClass)it));
                }
            };
            model.getDataClasses().forEach((Consumer)consumer9);
            Consumer<DataClass> consumer10 = new Consumer<DataClass>(){

                @Override
                public void accept(DataClass it) {
                    referencedModels.addAll(root.getReferencedModels((RoomClass)it));
                }
            };
            model.getDataClasses().forEach((Consumer)consumer10);
            Consumer<ActorClass> consumer11 = new Consumer<ActorClass>(){

                @Override
                public void accept(ActorClass it) {
                    DocGen.this.saveAs(DocGen.this.generateDoc((RoomClass)it, ctx), DocGen.this.docFragmentName((RoomClass)it));
                }
            };
            model.getActorClasses().forEach((Consumer)consumer11);
            Consumer<ActorClass> consumer12 = new Consumer<ActorClass>(){

                @Override
                public void accept(ActorClass it) {
                    referencedModels.addAll(root.getReferencedModels((RoomClass)it));
                }
            };
            model.getActorClasses().forEach((Consumer)consumer12);
            this.fileAccess.setOutputPath(path);
            this.saveAs(this.generateModelDoc(ctx, referencedModels), file);
        }
    }

    private String removeLast(String str) {
        int n = str.length();
        int n2 = n - 1;
        return str.substring(0, n2);
    }

    private String appendIfNotEmpty(String txt, String suffix) {
        String string = null;
        boolean bl = txt.isEmpty();
        string = bl ? txt : String.valueOf(txt) + suffix;
        return string;
    }

    private CharSequence generateModelDoc(DocGenContext ctx, Set<RoomModel> referencedModels) {
        Object object;
        Functions.Function1<RoomModel, String> function1;
        boolean bl;
        StringConcatenation stringConcatenation = null;
        RoomModel model = ctx.model;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("\\documentclass[titlepage]{article}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\usepackage{import}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\usepackage{graphicx}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\usepackage{xr}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\usepackage{hyperref}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\IfFileExists{../doc/userinputs.tex}{\\subimport{../doc/}{userinputs.tex}}{} %hook for conditional user-specific inputs, includes, macros, ... ");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\usepackage[a4paper,text={160mm,255mm},centering,headsep=5mm,footskip=10mm]{geometry}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\usepackage{nonfloat}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\parindent 0pt");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\makeatletter");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\newcommand\\level[1]{%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("   ");
        stringConcatenation2.append("\\ifcase#1\\relax\\expandafter\\chapter\\or");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\expandafter\\section\\or");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\expandafter\\subsection\\or");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\expandafter\\subsubsection\\else");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\def\\next{\\@level{#1}}\\expandafter\\next");
        stringConcatenation2.newLine();
        stringConcatenation2.append("   ");
        stringConcatenation2.append("\\fi}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\newcommand{\\@level}[1]{%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\@startsection{level#1}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("{#1}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("{\\z@}%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("{-3.25ex\\@plus -1ex \\@minus -.2ex}%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("{1.5ex \\@plus .2ex}%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("{\\normalfont\\normalsize\\bfseries}}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\newdimen\\@leveldim");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\newdimen\\@dotsdim");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("{\\normalfont\\normalsize");
        stringConcatenation2.newLine();
        stringConcatenation2.append("  ");
        stringConcatenation2.append("\\sbox\\z@{0}\\global\\@leveldim=\\wd\\z@");
        stringConcatenation2.newLine();
        stringConcatenation2.append("  ");
        stringConcatenation2.append("\\sbox\\z@{.}\\global\\@dotsdim=\\wd\\z@");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("}  ");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\newcounter{level4}[subsubsection]");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\@namedef{thelevel4}{\\thesubsubsection.\\arabic{level4}}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\@namedef{level4mark}#1{}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\def\\l@section{\\@dottedtocline{1}{0pt}{\\dimexpr\\@leveldim*4+\\@dotsdim*1+6pt\\relax}}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\def\\l@subsection{\\@dottedtocline{2}{0pt}{\\dimexpr\\@leveldim*5+\\@dotsdim*2+6pt\\relax}}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\def\\l@subsubsection{\\@dottedtocline{3}{0pt}{\\dimexpr\\@leveldim*6+\\@dotsdim*3+6pt\\relax}}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\@namedef{l@level4}{\\@dottedtocline{4}{0pt}{\\dimexpr\\@leveldim*7+\\@dotsdim*4+6pt\\relax}}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\count@=4");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\def\\@ncp#1{\\number\\numexpr\\count@+#1\\relax}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\loop\\ifnum\\count@<100");
        stringConcatenation2.newLine();
        stringConcatenation2.append("   ");
        stringConcatenation2.append("\\begingroup\\edef\\x{\\endgroup");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\noexpand\\newcounter{level\\@ncp{1}}[level\\number\\count@]");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\noexpand\\@namedef{thelevel\\@ncp{1}}{%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("       ");
        stringConcatenation2.append("\\noexpand\\@nameuse{thelevel\\@ncp{0}}.\\noexpand\\arabic{level\\@ncp{0}}}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\noexpand\\@namedef{level\\@ncp{1}mark}####1{}%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("\\noexpand\\@namedef{l@level\\@ncp{1}}%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("       ");
        stringConcatenation2.append("{\\noexpand\\@dottedtocline{\\@ncp{1}}{0pt}{\\the\\dimexpr\\@leveldim*\\@ncp{5}+\\@dotsdim*\\@ncp{0}\\relax}}}%");
        stringConcatenation2.newLine();
        stringConcatenation2.append("   ");
        stringConcatenation2.append("\\x");
        stringConcatenation2.newLine();
        stringConcatenation2.append("   ");
        stringConcatenation2.append("\\advance\\count@\\@ne");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\repeat");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\makeatother");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\setcounter{secnumdepth}{100}");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("\\setcounter{tocdepth}{100}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\title{");
        String string = this.escapedString(model.getName());
        stringConcatenation2.append(string);
        stringConcatenation2.append(" Model Documentation}");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\\date{\\today}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\author{generated by eTrice}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\begin{document}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\pagestyle{plain}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\maketitle");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\tableofcontents");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\newpage");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\listoffigures");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\newpage");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\section{Model Description}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl2 = referencedModels.isEmpty();
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Referenced Models}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\\begin{itemize}");
            stringConcatenation2.newLine();
            function1 = new Functions.Function1<RoomModel, String>(){

                public String apply(RoomModel it) {
                    return it.getName();
                }
            };
            List list = IterableExtensions.sortBy(referencedModels, (Functions.Function1)function1);
            for (RoomModel refModel : list) {
                String relPath = this.appendIfNotEmpty(RelativePathHelpers.getRelativePath((String)this.removeLast(this.roomExt.getDocGenerationTargetPath((EObject)model)), (String)this.removeLast(this.roomExt.getDocGenerationTargetPath((EObject)refModel)), (boolean)true), "/");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\\item \\href{");
                String string2 = relPath.replace("\\", "/");
                String string3 = refModel.getName();
                String string4 = this.escapedString(String.valueOf(string2) + string3);
                stringConcatenation2.append(string4);
                stringConcatenation2.append(".pdf}{");
                String string5 = this.escapedString(refModel.getName());
                stringConcatenation2.append(string5);
                stringConcatenation2.append("}");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\\end{itemize}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\\newpage");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        bl2 = model.getSystems().isEmpty();
        boolean bl4 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Logical System Classes}");
            stringConcatenation2.newLine();
            function1 = model.getSystems();
            for (LogicalSystem s : function1) {
                object = this.generateImport((RoomClass)s, model.getName());
                stringConcatenation2.append(object);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\\newpage");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        bl2 = model.getSubSystemClasses().isEmpty();
        boolean bl5 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Subsystem Classes}");
            stringConcatenation2.newLine();
            function1 = model.getSubSystemClasses();
            for (SubSystemClass s_1 : function1) {
                object = this.generateImport((RoomClass)s_1, model.getName());
                stringConcatenation2.append(object);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\\newpage");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        bl2 = model.getProtocolClasses().isEmpty();
        boolean bl6 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Protocol Classes}");
            stringConcatenation2.newLine();
            function1 = model.getProtocolClasses();
            for (GeneralProtocolClass c : function1) {
                object = this.generateImport((RoomClass)c, model.getName());
                stringConcatenation2.append(object);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\\newpage");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        bl2 = model.getEnumerationTypes().isEmpty();
        boolean bl7 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Enumeration Types}");
            stringConcatenation2.newLine();
            function1 = model.getEnumerationTypes();
            for (EnumerationType e : function1) {
                object = this.generateImport((RoomClass)e, model.getName());
                stringConcatenation2.append(object);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\\newpage");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        bl2 = model.getDataClasses().isEmpty();
        boolean bl8 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Data Classes}");
            stringConcatenation2.newLine();
            function1 = model.getDataClasses();
            for (DataClass c_1 : function1) {
                object = this.generateImport((RoomClass)c_1, model.getName());
                stringConcatenation2.append(object);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\\newpage");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        bl2 = model.getActorClasses().isEmpty();
        boolean bl9 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("\\section{Actor Classes}");
            stringConcatenation2.newLine();
            function1 = model.getActorClasses();
            for (ActorClass c_2 : function1) {
                object = this.generateImport((RoomClass)c_2, model.getName());
                stringConcatenation2.append(object);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("\\end{document}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence _generateDoc(LogicalSystem system, DocGenContext ctx) {
        StringConcatenation stringConcatenation = null;
        String string = system.getName();
        String filename = String.valueOf(string) + "_instanceTree.jpg";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("\\level{2}{");
        String string2 = this.escapedString(system.getName());
        stringConcatenation2.append(string2);
        stringConcatenation2.append("}");
        stringConcatenation2.newLineIfNotEmpty();
        CharSequence charSequence = this.generateDocText(system.getDocu());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\\level{3}{Instance Tree}");
        stringConcatenation2.newLine();
        boolean bl = this.fileExists(ctx.model, this.getImagePath(filename)).equals("true");
        if (bl) {
            String string3 = this.getImagePath(filename);
            String string4 = system.getName();
            String string5 = String.valueOf(string4) + " Instance Tree";
            CharSequence charSequence2 = this.includeGraphics(string3, "1.0\\textwidth", string5);
            stringConcatenation2.append((Object)charSequence2);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence _generateDoc(SubSystemClass ssc, DocGenContext ctx) {
        StringConcatenation stringConcatenation = null;
        String string = this.escapedString(ssc.getName());
        String filename = String.valueOf(string) + "_structure.jpg";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("\\level{2}{");
        String string2 = this.escapedString(ssc.getName());
        stringConcatenation2.append(string2);
        stringConcatenation2.append("}");
        stringConcatenation2.newLineIfNotEmpty();
        CharSequence charSequence = this.generateDocText(ssc.getDocu());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\\level{3}{Structure}");
        stringConcatenation2.newLine();
        boolean bl = this.fileExists(ctx.model, this.getImagePath(filename)).equals("true");
        if (bl) {
            String string3 = this.getImagePath(filename);
            String string4 = ssc.getName();
            String string5 = String.valueOf(string4) + " Structure";
            CharSequence charSequence2 = this.includeGraphics(string3, "1.0\\textwidth", string5);
            stringConcatenation2.append((Object)charSequence2);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence _generateDoc(EnumerationType dc, DocGenContext ctx) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\level{2} {");
        String string = this.escapedString(dc.getName());
        stringConcatenation.append(string);
        stringConcatenation.append("}");
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence = this.generateDocText(dc.getDocu());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        PrimitiveType primitiveType = dc.getPrimitiveType();
        boolean bl2 = bl = primitiveType != null;
        if (bl) {
            stringConcatenation.append("The literals of this enumeration are based on PrimitiveType ");
            String string2 = this.escapedString(dc.getPrimitiveType().getName());
            stringConcatenation.append(string2);
            stringConcatenation.append(".");
            stringConcatenation.newLineIfNotEmpty();
        } else {
            stringConcatenation.append("The literals of this enumeration are of type \\texttt{int}.");
            stringConcatenation.newLine();
        }
        stringConcatenation.append("\\level{3}{Literals}");
        stringConcatenation.newLine();
        stringConcatenation.append("\\begin{tabular}[ht]{|l|r|r|r|}");
        stringConcatenation.newLine();
        stringConcatenation.append("\\hline");
        stringConcatenation.newLine();
        stringConcatenation.append("\\textbf{Name} & \\textbf{Value} & \\textbf{Hex Value} & \\textbf{Binary Value}\\\\");
        stringConcatenation.newLine();
        primitiveType = dc.getLiterals();
        for (EnumLiteral lit : primitiveType) {
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            String string3 = this.escapedString(lit.getName());
            stringConcatenation.append(string3);
            stringConcatenation.append(" & ");
            long l = lit.getLiteralValue();
            stringConcatenation.append((Object)l);
            stringConcatenation.append(" & 0x");
            String string4 = Long.toHexString(lit.getLiteralValue());
            stringConcatenation.append(string4);
            stringConcatenation.append(" & ");
            String string5 = Long.toBinaryString(lit.getLiteralValue());
            stringConcatenation.append(string5);
            stringConcatenation.append("\\\\");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("\\hline");
        stringConcatenation.newLine();
        stringConcatenation.append("\\end{tabular}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence _generateDoc(DataClass dc, DocGenContext ctx) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\level{2} {");
        String string = this.escapedString(dc.getName());
        stringConcatenation.append(string);
        stringConcatenation.append("}");
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence = this.generateDocText(dc.getDocu());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\\level{3}{Attributes}");
        stringConcatenation.newLine();
        CharSequence charSequence2 = this.generateAttributesDoc((List<Attribute>)dc.getAttributes());
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\\level{3}{Operations}");
        stringConcatenation.newLine();
        CharSequence charSequence3 = this.generateOperationsDoc((List<StandardOperation>)dc.getOperations());
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    private CharSequence _generateDoc(ProtocolClass pc, DocGenContext ctx) {
        String string;
        boolean bl;
        Object object;
        String string2;
        List list;
        boolean bl2;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\level{2} {");
        String string3 = this.escapedString(pc.getName());
        stringConcatenation.append(string3);
        stringConcatenation.append("}");
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence = this.generateDocText(pc.getDocu());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        boolean bl3 = this._roomHelpers.getAllIncomingMessages(pc).isEmpty();
        boolean bl4 = bl2 = !bl3;
        if (bl2) {
            stringConcatenation.append("\\level{3}{Incoming Messages}");
            stringConcatenation.newLine();
            stringConcatenation.newLine();
            stringConcatenation.append("\\begin{tabular}[ht]{|l|l|p{8cm}|}");
            stringConcatenation.newLine();
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("Message & Type & Description\\\\");
            stringConcatenation.newLine();
            list = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message ims : list) {
                stringConcatenation.append("\\hline");
                stringConcatenation.newLine();
                string2 = this.escapedString(ims.getName());
                stringConcatenation.append(string2);
                stringConcatenation.append(" & ");
                object = ims.getData();
                boolean bl5 = bl = object != null;
                if (bl) {
                    stringConcatenation.append(" ");
                    string = this.escapedString(ims.getData().getRefType().getType().getName());
                    stringConcatenation.append(string);
                    stringConcatenation.append(" ");
                }
                stringConcatenation.append(" & ");
                object = this.generateDocText(ims.getDocu());
                stringConcatenation.append(object);
                stringConcatenation.append("\\\\");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\\end{tabular}");
            stringConcatenation.newLine();
        }
        boolean bl6 = bl2 = !(bl3 = this._roomHelpers.getAllOutgoingMessages(pc).isEmpty());
        if (bl2) {
            stringConcatenation.append("\\level{3}{Outgoing Messages}");
            stringConcatenation.newLine();
            stringConcatenation.append("\\begin{tabular}[ht]{|l|l|p{8cm}|}");
            stringConcatenation.newLine();
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("Message & Type & Description\\\\");
            stringConcatenation.newLine();
            list = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message oms : list) {
                stringConcatenation.append("\\hline");
                stringConcatenation.newLine();
                string2 = this.escapedString(oms.getName());
                stringConcatenation.append(string2);
                stringConcatenation.append(" & ");
                object = oms.getData();
                boolean bl7 = bl = object != null;
                if (bl) {
                    stringConcatenation.append(" ");
                    string = this.escapedString(oms.getData().getRefType().getType().getName());
                    stringConcatenation.append(string);
                    stringConcatenation.append(" ");
                }
                stringConcatenation.append(" & ");
                object = this.generateDocText(oms.getDocu());
                stringConcatenation.append(object);
                stringConcatenation.append("\\\\");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\\end{tabular}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    private CharSequence _generateDoc(CompoundProtocolClass pc, DocGenContext ctx) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\level{2} {");
        String string = this.escapedString(pc.getName());
        stringConcatenation.append(string);
        stringConcatenation.append("}");
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence = this.generateDocText(pc.getDocu());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\\level{3}{Sub Protocols}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\\begin{tabular}[ht]{|l|l|}");
        stringConcatenation.newLine();
        stringConcatenation.append("\\hline");
        stringConcatenation.newLine();
        stringConcatenation.append("\\textbf{Name} & \\textbf{Protocol}\\\\");
        stringConcatenation.newLine();
        EList eList = pc.getSubProtocols();
        for (SubProtocol sub : eList) {
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            String string2 = this.escapedString(sub.getName());
            stringConcatenation.append(string2);
            stringConcatenation.append(" & ");
            String string3 = this.escapedString(sub.getProtocol().getName());
            stringConcatenation.append(string3);
            stringConcatenation.append("\\\\");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("\\hline");
        stringConcatenation.newLine();
        stringConcatenation.append("\\end{tabular}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence _generateDoc(ActorClass ac, DocGenContext ctx) {
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        CharSequence charSequence2;
        CharSequence charSequence3;
        Object object;
        StringConcatenation stringConcatenation = null;
        String string = ac.getName();
        String filename = String.valueOf(string) + "_structure.jpg";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("\\level{2}{");
        String string2 = this.escapedString(ac.getName());
        stringConcatenation2.append(string2);
        stringConcatenation2.append("}");
        stringConcatenation2.newLineIfNotEmpty();
        CharSequence charSequence4 = this.generateDocText(ac.getDocu());
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (!(!this.fileExists(ctx.model, this.getImagePath(filename)).equals("true") || this._roomHelpers.getAllInterfaceItems(ac).isEmpty() && ac.getActorRefs().isEmpty())) {
            stringConcatenation2.append("\\level{3}{Structure}");
            stringConcatenation2.newLine();
            object = this.generateDocText(ac.getStructureDocu());
            stringConcatenation2.append(object);
            stringConcatenation2.newLineIfNotEmpty();
            String string3 = this.getImagePath(filename);
            charSequence3 = ac.getName();
            charSequence2 = String.valueOf(charSequence3) + " Structure";
            charSequence = this.includeGraphics(string3, "1.0\\textwidth", (String)charSequence2);
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.newLineIfNotEmpty();
        } else {
            boolean bl3;
            object = ac.getStructureDocu();
            boolean bl4 = bl3 = object != null;
            if (bl3) {
                stringConcatenation2.append("\\level{3}{Structure}");
                stringConcatenation2.newLine();
                charSequence3 = this.generateDocText(ac.getStructureDocu());
                stringConcatenation2.append((Object)charSequence3);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        boolean bl5 = this._roomHelpers.getAllPorts(ac).isEmpty();
        boolean bl6 = bl2 = !bl5;
        if (bl2) {
            stringConcatenation2.append("\\level{3}{Ports}");
            stringConcatenation2.newLine();
            charSequence3 = this.generatePortDoc(ac);
            stringConcatenation2.append((String)charSequence3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        bl5 = this._roomHelpers.isBehaviorAnnotationPresent(ac, "BehaviorManual");
        if (bl5) {
            stringConcatenation2.append("\\level{3}{Behavior}");
            stringConcatenation2.newLine();
            CharSequence charSequence5 = this.generateDocText(ac.getBehaviorDocu());
            stringConcatenation2.append((Object)charSequence5);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("The behavior for ActorClass ");
            charSequence3 = ac.getName();
            stringConcatenation2.append((String)charSequence3);
            stringConcatenation2.append(" is implemented manually.");
            stringConcatenation2.newLineIfNotEmpty();
        } else {
            bl2 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
            if (bl2) {
                stringConcatenation2.append("\\level{3}{Behavior}");
                stringConcatenation2.newLine();
                charSequence3 = this.generateDocText(ac.getBehaviorDocu());
                stringConcatenation2.append((Object)charSequence3);
                stringConcatenation2.newLineIfNotEmpty();
                charSequence2 = this.generateFsmDoc(ctx.model, ac);
                stringConcatenation2.append((Object)charSequence2);
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                boolean bl7;
                charSequence3 = ac.getBehaviorDocu();
                boolean bl8 = bl7 = charSequence3 != null;
                if (bl7) {
                    stringConcatenation2.append("\\level{3}{Behavior}");
                    stringConcatenation2.newLine();
                    charSequence = this.generateDocText(ac.getBehaviorDocu());
                    stringConcatenation2.append((Object)charSequence);
                    stringConcatenation2.newLineIfNotEmpty();
                }
            }
        }
        stringConcatenation2.newLine();
        bl5 = ac.getAttributes().isEmpty();
        boolean bl9 = bl = !bl5;
        if (bl) {
            stringConcatenation2.append("\\level{3}{Attributes}");
            stringConcatenation2.newLine();
            charSequence3 = this.generateAttributesDoc((List<Attribute>)ac.getAttributes());
            stringConcatenation2.append((Object)charSequence3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        bl5 = ac.getOperations().isEmpty();
        boolean bl10 = bl = !bl5;
        if (bl) {
            stringConcatenation2.append("\\level{3}{Operations}");
            stringConcatenation2.newLine();
            charSequence3 = this.generateOperationsDoc((List<StandardOperation>)ac.getOperations());
            stringConcatenation2.append((Object)charSequence3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateFsmDoc(RoomModel model, ActorClass ac) {
        CharSequence charSequence;
        String string;
        String string2;
        StringConcatenation stringConcatenation = null;
        String string3 = ac.getName();
        String filename = String.valueOf(string3) + "_behavior.jpg";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("\\level{4}{Top Level}");
        stringConcatenation2.newLine();
        boolean bl = this.fileExists(model, this.getImagePath(filename)).equals("true");
        if (bl) {
            String string4 = this.getImagePath(filename);
            String string5 = ac.getName();
            string2 = String.valueOf(string5) + " Top State";
            CharSequence charSequence2 = this.includeGraphics(string4, "1.0\\textwidth", string2);
            stringConcatenation2.append((Object)charSequence2);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\begin{par}");
        stringConcatenation2.newLine();
        EList eList = ac.getStateMachine().getStates();
        for (State s : eList) {
            boolean bl2;
            string2 = s.getDocu();
            boolean bl3 = bl2 = string2 != null;
            if (!bl2) continue;
            stringConcatenation2.append("\\textbf{State description} \\textit{");
            string = this._codegenHelpers.getGenStatePathName(s).replaceAll("_", "\\\\_");
            stringConcatenation2.append(string);
            stringConcatenation2.append("}:");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\\newline");
            stringConcatenation2.newLine();
            charSequence = this.generateDocText(s.getDocu());
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\\newline\\newline");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        eList = ac.getStateMachine().getChPoints();
        for (ChoicePoint c : eList) {
            boolean bl4;
            string2 = c.getDocu();
            boolean bl5 = bl4 = string2 != null;
            if (!bl4) continue;
            stringConcatenation2.append("\\textbf{Choicepoint description} \\textit{");
            string = this.escapedString(c.getName());
            stringConcatenation2.append(string);
            stringConcatenation2.append("}:");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\\newline");
            stringConcatenation2.newLine();
            charSequence = this.generateDocText(c.getDocu());
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\\newline\\newline");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\\end{par}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        eList = ac.getStateMachine().getStates();
        for (State s_1 : eList) {
            boolean bl6;
            boolean bl7 = this._roomHelpers.isLeaf(s_1);
            boolean bl8 = bl6 = !bl7;
            if (!bl6) continue;
            string = this.generateStateDoc(model, ac, s_1);
            stringConcatenation2.append(string);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String getType(Port p) {
        String string = null;
        boolean bl = p.isConjugated();
        string = bl ? "conj." : "reg.";
        return string;
    }

    private String getKind(Port p) {
        String string = null;
        boolean bl = this._roomHelpers.isInternal(p);
        if (bl) {
            string = "internal";
        } else {
            String string2 = null;
            boolean bl2 = this._roomHelpers.isExternal(p);
            if (bl2) {
                string2 = "external";
            } else {
                String string3 = null;
                boolean bl3 = this._roomHelpers.isRelay(p);
                string3 = bl3 ? "relay" : "?";
                string2 = string3;
            }
            string = string2;
        }
        return string;
    }

    private String getMultAsText(Port p) {
        String string = null;
        int n = p.getMultiplicity();
        boolean bl = n == -1;
        string = bl ? "*" : Integer.valueOf(p.getMultiplicity()).toString();
        return string;
    }

    private String generatePortDoc(ActorClass ac) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\begin{tabular}[ht]{|l|l|l|l|l|p{5cm}|}");
        stringConcatenation.newLine();
        stringConcatenation.append("\\hline");
        stringConcatenation.newLine();
        stringConcatenation.append("\\textbf{Name} & \\textbf{Protocol} & \\textbf{Type} & \\textbf{Kind} & \\textbf{Multiplicity} & \\textbf{Description}\\\\");
        stringConcatenation.newLine();
        List list = this._roomHelpers.getAllPorts(ac);
        for (Port at : list) {
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            String string = this.escapedString(at.getName());
            stringConcatenation.append(string);
            stringConcatenation.append(" & ");
            String string2 = this.escapedString(at.getProtocol().getName());
            stringConcatenation.append(string2);
            stringConcatenation.append(" & ");
            String string3 = this.getType(at);
            stringConcatenation.append(string3);
            stringConcatenation.append(" & ");
            String string4 = this.getKind(at);
            stringConcatenation.append(string4);
            stringConcatenation.append(" & ");
            String string5 = this.getMultAsText(at);
            stringConcatenation.append(string5);
            stringConcatenation.append(" & ");
            CharSequence charSequence = this.generateDocText(at.getDocu());
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.append("\\\\");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("\\hline");
        stringConcatenation.newLine();
        stringConcatenation.append("\\end{tabular}");
        stringConcatenation.newLine();
        return stringConcatenation.toString();
    }

    private String generateStateDoc(RoomModel model, ActorClass ac, State state) {
        CharSequence charSequence;
        String string;
        String string2;
        String string3 = null;
        String string4 = ac.getName();
        String string5 = String.valueOf(string4) + "_";
        String string6 = this._codegenHelpers.getGenStatePathName(state);
        String string7 = String.valueOf(string5) + string6;
        String filename = String.valueOf(string7) + "_behavior.jpg";
        this.logger.logInfo("Gen Filename: " + filename);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\level{4}{Subgraph ");
        String string8 = this._codegenHelpers.getGenStatePathName(state).replaceAll("_", "\\\\_");
        stringConcatenation.append(string8);
        stringConcatenation.append("}");
        stringConcatenation.newLineIfNotEmpty();
        boolean bl = this.fileExists(model, this.getImagePath(filename)).equals("true");
        if (bl) {
            String string9 = this.getImagePath(filename);
            String string10 = ac.getName();
            string2 = String.valueOf(string10) + "_";
            String string11 = this._codegenHelpers.getGenStatePathName(state);
            string = String.valueOf(string2) + string11;
            charSequence = this.includeGraphics(string9, "1.0\\textwidth", string);
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("\\begin{par}");
        stringConcatenation.newLine();
        EList eList = state.getSubgraph().getStates();
        for (State s : eList) {
            boolean bl2;
            string2 = s.getDocu();
            boolean bl3 = bl2 = string2 != null;
            if (!bl2) continue;
            stringConcatenation.append("\\textbf{State description} \\textit{");
            string = this._codegenHelpers.getGenStatePathName(s).replaceAll("_", "\\\\_");
            stringConcatenation.append(string);
            stringConcatenation.append("}:");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\\newline");
            stringConcatenation.newLine();
            charSequence = this.generateDocText(s.getDocu());
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\\newline\\newline");
            stringConcatenation.newLine();
        }
        stringConcatenation.newLine();
        eList = state.getSubgraph().getChPoints();
        for (ChoicePoint c : eList) {
            boolean bl4;
            string2 = c.getDocu();
            boolean bl5 = bl4 = string2 != null;
            if (!bl4) continue;
            stringConcatenation.append("\\textbf{Choicepoint description} \\textit{");
            string = this.escapedString(c.getName());
            stringConcatenation.append(string);
            stringConcatenation.append("}:");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\\newline");
            stringConcatenation.newLine();
            charSequence = this.generateDocText(c.getDocu());
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\\newline\\newline");
            stringConcatenation.newLine();
        }
        stringConcatenation.append("\\end{par}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.newLine();
        eList = state.getSubgraph().getStates();
        for (State s_1 : eList) {
            boolean bl6;
            boolean bl7 = this._roomHelpers.isLeaf(s_1);
            boolean bl8 = bl6 = !bl7;
            if (!bl6) continue;
            string = this.generateStateDoc(model, ac, s_1);
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
        }
        string3 = stringConcatenation.toString();
        return string3;
    }

    private CharSequence generateAttributesDoc(List<Attribute> attributes) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl2 = attributes.isEmpty();
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation.append("\\begin{tabular}[ht]{|l|l|p{8cm}|}");
            stringConcatenation.newLine();
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\\textbf{Name} & \\textbf{Type} & \\textbf{Description}\\\\");
            stringConcatenation.newLine();
            for (Attribute at : attributes) {
                stringConcatenation.append("\\hline");
                stringConcatenation.newLine();
                String string = this.escapedString(at.getName());
                stringConcatenation.append(string);
                stringConcatenation.append(" & ");
                String string2 = this.escapedString(at.getType().getType().getName());
                stringConcatenation.append(string2);
                stringConcatenation.append(" & ");
                CharSequence charSequence = this.generateDocText(at.getDocu());
                stringConcatenation.append((Object)charSequence);
                stringConcatenation.append("\\\\");
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\\end{tabular}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    private CharSequence generateOperationsDoc(List<StandardOperation> operations) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (StandardOperation op : operations) {
            CharSequence charSequence;
            boolean bl;
            stringConcatenation.append("\\begin{tabular}[ht]{|l|l|}");
            stringConcatenation.newLine();
            stringConcatenation.append("\\hline\t\t");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("Name: & ");
            String string = this.escapedString(op.getName());
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("\\\\");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("ReturnType: &  ");
            RefableType refableType = op.getReturnType();
            boolean bl2 = bl = refableType != null;
            if (bl) {
                String string2 = this.escapedString(op.getReturnType().getType().getName());
                stringConcatenation.append(string2, "\t");
            } else {
                stringConcatenation.append("void");
            }
            stringConcatenation.append("\\\\");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append("Arguments: & ");
            refableType = op.getArguments();
            bl = false;
            for (VarDecl pa : refableType) {
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "\t");
                }
                charSequence = this.escapedString(pa.getName());
                stringConcatenation.append(charSequence, "\t");
                stringConcatenation.append(":");
                String string3 = this.escapedString(pa.getRefType().getType().getName());
                stringConcatenation.append(string3, "\t");
            }
            stringConcatenation.append("\\\\");
            stringConcatenation.newLineIfNotEmpty();
            refableType = op.getDocu();
            boolean bl3 = bl = refableType != null;
            if (bl) {
                boolean bl4;
                stringConcatenation.append("\t");
                stringConcatenation.append("\\hline");
                stringConcatenation.newLine();
                int n = op.getDocu().toString().length();
                boolean bl5 = bl4 = n > 85;
                if (bl4) {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\\multicolumn{2} {|p{13cm}|} {");
                    charSequence = this.generateDocText(op.getDocu());
                    stringConcatenation.append((Object)charSequence, "\t");
                    stringConcatenation.append("}\\\\");
                    stringConcatenation.newLineIfNotEmpty();
                } else {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\\multicolumn{2} {|l|} {");
                    charSequence = this.generateDocText(op.getDocu());
                    stringConcatenation.append((Object)charSequence, "\t");
                    stringConcatenation.append("}\\\\");
                    stringConcatenation.newLineIfNotEmpty();
                }
            }
            stringConcatenation.append("\t");
            stringConcatenation.append("\\hline");
            stringConcatenation.newLine();
            stringConcatenation.append("\\end{tabular}");
            stringConcatenation.newLine();
            stringConcatenation.append("\\newline\\newline\\newline");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    private CharSequence generateDocText(Documentation doc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        if (doc != null) {
            stringConcatenation.append("% begin text from user Documentation");
            stringConcatenation.newLine();
            EList eList = doc.getLines();
            for (String line : eList) {
                String string = this.escapedString(line);
                stringConcatenation.append(string);
                stringConcatenation.newLineIfNotEmpty();
            }
            stringConcatenation.append("% end text from user Documentation");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    private String fileExists(RoomModel model, String f) {
        String string = this.roomExt.getDocGenerationTargetPath((EObject)model);
        String absPath = String.valueOf(string) + f;
        File file = new File(absPath);
        boolean exist = file.exists();
        if (exist) {
            this.logger.logInfo("File found ! " + f);
            return "true";
        }
        this.logger.logInfo("File not found ! " + f);
        return "false";
    }

    private CharSequence includeGraphics(String filename, String width, String caption) {
        StringConcatenation stringConcatenation = null;
        String latexCaption = caption.replaceAll("_", "\\\\_");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\centering{}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\\includegraphics[width=");
        stringConcatenation2.append(width);
        stringConcatenation2.append("]{");
        stringConcatenation2.append(filename);
        stringConcatenation2.append("}");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\\figcaption{");
        stringConcatenation2.append(latexCaption);
        stringConcatenation2.append("}");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String escapedString(String text) {
        return text.replace("_", "\\_");
    }

    private String getImagePath(String filename) {
        String filenamei = String.valueOf("./images") + "/" + filename;
        filenamei = filenamei.replaceAll("\\\\", "/");
        return filenamei;
    }

    private void saveAs(CharSequence content, String filename) {
        this.fileAccess.generateFile(filename, content);
    }

    private String docFragmentName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + ".tex";
    }

    private CharSequence generateImport(RoomClass rc, String dir) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.generateImport(this.docFragmentName(rc), dir);
        stringConcatenation.append((Object)charSequence);
        return stringConcatenation;
    }

    private CharSequence generateImport(String name, String dir) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("\\subimport*{");
        stringConcatenation.append(dir);
        stringConcatenation.append("/}{");
        stringConcatenation.append(name);
        stringConcatenation.append("}");
        return stringConcatenation;
    }

    private CharSequence generateDoc(RoomClass ac, DocGenContext ctx) {
        if (ac instanceof ActorClass) {
            return this._generateDoc((ActorClass)ac, ctx);
        }
        if (ac instanceof DataClass) {
            return this._generateDoc((DataClass)ac, ctx);
        }
        if (ac instanceof SubSystemClass) {
            return this._generateDoc((SubSystemClass)ac, ctx);
        }
        if (ac instanceof CompoundProtocolClass) {
            return this._generateDoc((CompoundProtocolClass)ac, ctx);
        }
        if (ac instanceof EnumerationType) {
            return this._generateDoc((EnumerationType)ac, ctx);
        }
        if (ac instanceof LogicalSystem) {
            return this._generateDoc((LogicalSystem)ac, ctx);
        }
        if (ac instanceof ProtocolClass) {
            return this._generateDoc((ProtocolClass)ac, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ac, ctx).toString());
    }

    public static class DocGenContext {
        private final Root root;
        private final RoomModel model;

        public DocGenContext(Root r, RoomModel m) {
            this.root = r;
            this.model = m;
        }
    }
}

