/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class InstanceDiagramGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList eList = root.getModels();
        for (RoomModel model : eList) {
            String string = this.roomExt.getDocGenerationTargetPath((EObject)model);
            String path = String.valueOf(string) + "/images";
            this.fileAccess.setOutputPath(path);
            String batchFile = "dot2jpg.bat";
            EList eList2 = root.getSystemInstances();
            for (SystemInstance sys : eList2) {
                String string2 = sys.getName();
                String file = String.valueOf(string2) + "_instanceTree.dot";
                this.logger.logInfo("generating instance tree diagram: '" + file + "' in '" + path + "'");
                this.fileAccess.generateFile(file, this.generate(root, sys));
            }
            this.fileAccess.generateFile(batchFile, this.generate2jpg(root));
            this.runDot2Jpg(path, batchFile);
        }
    }

    private CharSequence generate2jpg(Root root) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        EList eList = root.getSystemInstances();
        for (SystemInstance sys : eList) {
            stringConcatenation.append("dot -Tjpg -o ");
            String string = sys.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("_instanceTree.jpg ");
            String string2 = sys.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append("_instanceTree.dot");
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation;
    }

    private CharSequence generate(Root root, SystemInstance sys) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("digraph ");
        String string = sys.getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("rankdir=LR;");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("node [shape=box];");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        String string2 = this.roomExt.getPathName(sys.getPath());
        stringConcatenation.append(string2, "\t");
        stringConcatenation.append(" [label=\"");
        String string3 = sys.getName();
        stringConcatenation.append(string3, "\t");
        stringConcatenation.append("\\n(");
        String string4 = sys.getName();
        stringConcatenation.append(string4, "\t");
        stringConcatenation.append(")\" style=filled color=red];");
        stringConcatenation.newLineIfNotEmpty();
        EList eList = sys.getInstances();
        for (SubSystemInstance ssi : eList) {
            stringConcatenation.append("\t");
            String string5 = this.roomExt.getPathName(ssi.getPath());
            stringConcatenation.append(string5, "\t");
            stringConcatenation.append(" [label=\"");
            String string6 = ssi.getName();
            stringConcatenation.append(string6, "\t");
            stringConcatenation.append("\\n(");
            String string7 = ssi.getSubSystemClass().getName();
            stringConcatenation.append(string7, "\t");
            stringConcatenation.append(")\" style=filled color=yellow];");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            String string8 = this.roomExt.getPathName(sys.getPath());
            stringConcatenation.append(string8, "\t");
            stringConcatenation.append(" -> ");
            String string9 = this.roomExt.getPathName(ssi.getPath());
            stringConcatenation.append(string9, "\t");
            stringConcatenation.append(";  ");
            stringConcatenation.newLineIfNotEmpty();
            EList eList2 = ssi.getInstances();
            for (AbstractInstance ai : eList2) {
                stringConcatenation.append("\t");
                String string10 = this.instance(ai);
                stringConcatenation.append(string10, "\t");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private String instance(AbstractInstance ai) {
        boolean bl;
        String string = null;
        EObject eObject = ai.eContainer();
        StructureInstance parent = (StructureInstance)eObject;
        ETMapUtil.MappedThread pthread = ETMapUtil.getMappedThread((AbstractInstance)ai);
        String string2 = null;
        boolean bl2 = Objects.equal((Object)pthread, null);
        string2 = bl2 ? "?" : pthread.getThread().getName();
        String tname = string2;
        NodeRef node = ETMapUtil.getNodeRef((AbstractInstance)ai);
        String string3 = null;
        boolean bl3 = Objects.equal((Object)node, null);
        string3 = bl3 ? "?" : node.getName();
        String nname = string3;
        String string4 = null;
        string4 = ai instanceof ActorInterfaceInstance ? "optional " : "";
        String optional = string4;
        String string5 = null;
        if (ai instanceof ActorInstance) {
            string5 = ((ActorInstance)ai).getActorClass().getName();
        } else {
            String string6 = null;
            string6 = ai instanceof ActorInterfaceInstance ? ((ActorInterfaceInstance)ai).getActorClass().getName() : "?";
            string5 = string6;
        }
        String clsname = string5;
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string7 = this.roomExt.getPathName(ai.getPath());
        stringConcatenation.append(string7);
        stringConcatenation.append(" [label=\"");
        stringConcatenation.append(optional);
        String string8 = ai.getName();
        stringConcatenation.append(string8);
        stringConcatenation.append("\\n(");
        stringConcatenation.append(clsname);
        stringConcatenation.append(")\\n@");
        stringConcatenation.append(nname);
        stringConcatenation.append(":");
        stringConcatenation.append(tname);
        stringConcatenation.append("\"");
        boolean bl4 = optional.isEmpty();
        boolean bl5 = bl = !bl4;
        if (bl) {
            stringConcatenation.append(" color=blue style=dashed");
        }
        stringConcatenation.append("];");
        stringConcatenation.newLineIfNotEmpty();
        String string9 = this.roomExt.getPathName(parent.getPath());
        stringConcatenation.append(string9);
        stringConcatenation.append(" -> ");
        String string10 = this.roomExt.getPathName(ai.getPath());
        stringConcatenation.append(string10);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        if (ai instanceof StructureInstance) {
            EList eList = ((StructureInstance)ai).getInstances();
            for (AbstractInstance sub_ai : eList) {
                String string11 = this.instance(sub_ai);
                stringConcatenation.append(string11);
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        string = stringConcatenation.toString();
        return string;
    }

    private void runDot2Jpg(String path, String bat) {
        File wdir = new File(path);
        try {
            Process p = Runtime.getRuntime().exec("cmd /C " + bat, null, wdir);
            int n = p.waitFor();
            String string = String.valueOf(bat) + " finished with " + Integer.valueOf(n);
            this.logger.logInfo(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception e = (Exception)throwable;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }
}

