/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.base;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.generator.base.logging.ILogger;

public class Diagnostician
implements IDiagnostician {
    private boolean validationFailed = false;
    private ILogger logger;
    private FSMNameProvider fsmNameProvider;

    @Inject
    public Diagnostician(ILogger logger, FSMNameProvider fsmNameProvider) {
        this.logger = logger;
        this.fsmNameProvider = fsmNameProvider;
    }

    public void warning(String msg, EObject source, EStructuralFeature feature) {
        this.logger.logInfo("Validation warning: " + this.getMsgTxt(msg, source, feature, -1));
    }

    public void warning(String msg, EObject source, EStructuralFeature feature, int idx) {
        this.logger.logInfo("Validation warning: " + this.getMsgTxt(msg, source, feature, idx));
    }

    public void error(String msg, EObject source, EStructuralFeature feature) {
        this.validationFailed = true;
        this.logger.logError("Validation error: " + this.getMsgTxt(msg, source, feature, -1));
    }

    public void error(String msg, EObject source, EStructuralFeature feature, int idx) {
        this.validationFailed = true;
        this.logger.logError("Validation error: " + this.getMsgTxt(msg, source, feature, idx));
    }

    public boolean isFailed() {
        return this.validationFailed;
    }

    private String getMsgTxt(String msg, EObject source, EStructuralFeature feature, int idx) {
        StringBuilder result = new StringBuilder(msg);
        if (source != null) {
            URI uri;
            result.append(" ");
            if (feature != null) {
                result.append("(" + this.fsmNameProvider.getName(source) + ", " + feature.getName());
                if (idx != -1) {
                    result.append(" at index " + idx);
                }
                result.append(")");
            }
            String objInfo = (uri = EcoreUtil.getURI((EObject)source)) != null && !source.eIsProxy() ? uri.toString() : source.toString();
            result.append(objInfo);
        }
        return result.toString();
    }
}

