/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.etrice.core.common.ui.modelpath.ModelPathDescription;
import org.eclipse.etrice.core.common.ui.modelpath.WorkspaceModelPath;

public class ModelPathManager
implements IResourceChangeListener {
    public static final ModelPathManager INSTANCE = new ModelPathManager();
    public static final Path MODELPATH_FILE = new Path("modelpath");
    private HashMap<IProject, ModelPathDescription> descriptionCache = new HashMap();
    private HashMap<IProject, WorkspaceModelPath> modelpathCache = new HashMap();
    private List<IModelPathListener> listeners = new ArrayList<IModelPathListener>();

    private ModelPathManager() {
    }

    public synchronized WorkspaceModelPath getModelPath(IProject project) {
        return this.modelpathCache.computeIfAbsent(project, this::computeModelPath);
    }

    public synchronized void addListener(IModelPathListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(IModelPathListener listener) {
        this.listeners.remove(listener);
    }

    public void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        IResourceDelta[] projectDeltas = rootDelta.getAffectedChildren();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IResourceDelta[] iResourceDeltaArray = projectDeltas;
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta projectDelta = iResourceDeltaArray[n2];
            IResourceDelta modelpathDelta = projectDelta.findMember((IPath)MODELPATH_FILE);
            if (modelpathDelta != null && ((modelpathDelta.getFlags() & 0x100) != 0 || modelpathDelta.getKind() == 1 || modelpathDelta.getKind() == 2)) {
                IProject project = (IProject)projectDelta.getResource();
                projects.add(project);
            }
            ++n2;
        }
        if (!projects.isEmpty()) {
            new ModelPathUpdateJob(projects).schedule();
        }
    }

    private WorkspaceModelPath computeModelPath(IProject project) {
        HashSet<IProject> dependencies = new HashSet<IProject>();
        this.addAllProjectDependencies(project, dependencies);
        List<IContainer> paths = dependencies.stream().flatMap(p -> this.getSourceDirectories((IProject)p).stream()).collect(Collectors.toList());
        return new WorkspaceModelPath(paths);
    }

    private void addAllProjectDependencies(IProject project, Set<IProject> dependencies) {
        if (dependencies.add(project)) {
            this.getProjectDependencies(project).forEach(p -> this.addAllProjectDependencies((IProject)p, dependencies));
        }
    }

    private List<IProject> getProjectDependencies(IProject project) {
        return this.getModelPathDescription(project).map(ModelPathDescription::getProjectDependencies).orElse(Collections.emptyList());
    }

    private List<IFolder> getSourceDirectories(IProject project) {
        return this.getModelPathDescription(project).map(ModelPathDescription::getSourceDirectories).orElse(Collections.emptyList());
    }

    private Optional<ModelPathDescription> getModelPathDescription(IProject project) {
        return Optional.ofNullable(this.descriptionCache.computeIfAbsent(project, this::loadModelPathDescription));
    }

    private ModelPathDescription loadModelPathDescription(IProject project) {
        IFile file = project.getFile((IPath)MODELPATH_FILE);
        if (file.exists()) {
            try {
                return ModelPathDescription.load(file);
            }
            catch (CoreException coreException) {
                try {
                    file.refreshLocal(0, null);
                }
                catch (CoreException coreException2) {}
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface IModelPathListener {
        public void onChange(Collection<IProject> var1);
    }

    private class ModelPathUpdateJob
    extends WorkspaceJob {
        private Collection<IProject> projects;

        public ModelPathUpdateJob(Collection<IProject> projects) {
            super("modelpath updater");
            this.projects = projects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ModelPathManager modelPathManager = ModelPathManager.this;
            synchronized (modelPathManager) {
                this.projects.forEach(project -> {
                    ModelPathDescription modelPathDescription = ModelPathManager.this.descriptionCache.compute(project, (p, d) -> ModelPathManager.this.loadModelPathDescription(p));
                });
                ModelPathManager.this.modelpathCache.clear();
                ModelPathManager.this.listeners.forEach(listener -> listener.onChange(this.projects));
            }
            return Status.OK_STATUS;
        }
    }
}

