/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.xtext.naming.QualifiedName;

public class WorkspaceModelPath
implements IModelPath {
    private List<IContainer> paths;

    public WorkspaceModelPath(List<IContainer> paths) {
        this.paths = paths;
    }

    public Stream<URI> getFiles(QualifiedName name) {
        Stream<URI> stream = Stream.empty();
        while (!name.isEmpty()) {
            name = name.skipLast(1);
            stream = Stream.concat(stream, this.getPackage(name));
        }
        return stream;
    }

    public Stream<URI> getAllFiles() {
        return this.paths.stream().filter(container -> container.isAccessible()).flatMap(container -> this.getAllFiles((IContainer)container));
    }

    public Optional<QualifiedName> getQualifiedName(URI uri) {
        if (uri.isPlatform()) {
            Path path = new Path(uri.toPlatformString(true));
            return this.paths.stream().map(container -> container.getFullPath()).filter(arg_0 -> WorkspaceModelPath.lambda$3((IPath)path, arg_0)).map(arg_0 -> WorkspaceModelPath.lambda$4((IPath)path, arg_0)).map(p -> QualifiedName.create((String[])p.segments())).findFirst();
        }
        return Optional.empty();
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public List<IContainer> getPaths() {
        return this.paths;
    }

    public String toString() {
        return this.paths.toString();
    }

    private Stream<URI> getPackage(QualifiedName name) {
        String pathStr = name.toString().replace('.', '/');
        Path path = new Path(pathStr);
        return this.paths.stream().map(container -> container.getFolder((IPath)path)).filter(folder -> folder.exists()).flatMap(folder -> this.getFiles((IContainer)folder));
    }

    private Stream<URI> getFiles(IContainer container) {
        return this.getMembers(container).filter(resource -> resource.getType() == 1).map(IFile.class::cast).map(file -> this.createURI((IResource)file));
    }

    private Stream<URI> getAllFiles(IContainer container) {
        return this.getMembers(container).flatMap(resource -> {
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                URI uri = this.createURI((IResource)file);
                return Stream.of(uri);
            }
            if (resource.getType() == 2) {
                IFolder subfolder = (IFolder)resource;
                return this.getAllFiles((IContainer)subfolder);
            }
            return Stream.empty();
        });
    }

    private URI createURI(IResource resource) {
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    private Stream<IResource> getMembers(IContainer container) {
        try {
            return Stream.of(container.members());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$3(IPath iPath, IPath p) {
        return p.isPrefixOf(iPath);
    }

    private static /* synthetic */ IPath lambda$4(IPath iPath, IPath p) {
        return iPath.makeRelativeTo(p).removeFileExtension();
    }
}

