/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.highlight;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.common.ui.highlight.BaseSemanticHighlighter;
import org.eclipse.etrice.core.converter.RoomValueConverterService;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.services.RoomGrammarAccess;
import org.eclipse.etrice.core.ui.highlight.XtextHighlightStyles;
import org.eclipse.etrice.core.ui.util.UIExpressionUtil;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.expressions.ui.highlight.AbstractHighlightStyles;
import org.eclipse.etrice.expressions.ui.highlight.ExpressionRuleFactory;
import org.eclipse.etrice.expressions.ui.highlight.TargetLanguageRuleFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.util.CancelIndicator;

public class RoomSemanticHighlightingCalculator
extends BaseSemanticHighlighter {
    @Inject
    RoomGrammarAccess grammar;
    @Inject
    RoomValueConverterService converterService;
    @Inject
    RoomHelpers roomHelpers;
    @Inject
    ImportUriResolver importUriResolver;
    Map<EClass, Boolean> annotatedClasses = Maps.newHashMap();

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        UIExpressionUtil.ExpressionCache expressionCache = new UIExpressionUtil.ExpressionCache();
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            if (cancelIndicator.isCanceled()) break;
            super.provideHighlightingFor(node, resource, acceptor);
            EObject obj = node.getGrammarElement();
            if (obj instanceof RuleCall) {
                RuleCall ruleCall = (RuleCall)obj;
                if (ruleCall.getRule() == this.grammar.getAnnotationRule()) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"hl_annotation"});
                    continue;
                }
                if (ruleCall.getRule() == this.grammar.getCC_STRINGRule()) {
                    this.detailCodeHighlight(node, acceptor, expressionCache);
                    continue;
                }
                if (ruleCall.getRule() != this.grammar.getIDRule() && ruleCall.getRule() != this.grammar.getFQNRule()) continue;
                this.highlightDeprecated(node, acceptor);
                continue;
            }
            if (!(obj instanceof CrossReference)) continue;
            this.highlightDeprecated(node, acceptor);
        }
    }

    protected void detailCodeHighlight(INode node, IHighlightedPositionAcceptor acceptor, UIExpressionUtil.ExpressionCache cache) {
        String text = this.converterService.getCC_StringConverter().stripDelim(node.getText());
        int offset = node.getOffset() + this.converterService.getCC_StringConverter().getDelim().length();
        DetailCode dc = null;
        if (node.getParent().getSemanticElement() instanceof DetailCode) {
            dc = (DetailCode)node.getParent().getSemanticElement();
        }
        IDetailExpressionProvider exprProvider = UIExpressionUtil.getExpressionProvider(dc, null, cache);
        XtextHighlightStyles styles = new XtextHighlightStyles();
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules((IRule[])Iterables.toArray((Iterable)Iterables.concat((Iterable)TargetLanguageRuleFactory.getGeneralLiteralRules((AbstractHighlightStyles)styles), (Iterable)ExpressionRuleFactory.getInitialExpressionRules((IDetailExpressionProvider)exprProvider, (AbstractHighlightStyles)styles), (Iterable)TargetLanguageRuleFactory.getGeneralKeywordRules((AbstractHighlightStyles)styles)), IRule.class));
        scanner.setRange((IDocument)new Document(text), 0, text.length());
        IToken lastToken = null;
        while (lastToken != Token.EOF) {
            lastToken = scanner.nextToken();
            if (lastToken == null || lastToken.getData() == null) continue;
            acceptor.addPosition(offset + scanner.getTokenOffset(), scanner.getTokenLength(), new String[]{(String)lastToken.getData()});
        }
    }

    protected void highlightDeprecated(INode node, IHighlightedPositionAcceptor acceptor) {
        if (node.getSemanticElement() instanceof Import) {
            Annotation annotation;
            EObject annotatedElement;
            Predicate nameMatcher;
            Import importElement = (Import)node.getSemanticElement();
            Optional matches = ImportHelpers.getImportedObjectsFor((Import)importElement, (ImportUriResolver)this.importUriResolver, (Predicate)(nameMatcher = input -> importElement.getImportedNamespace().equals(input.getQualifiedName().toString())));
            if (matches.isPresent() && ((List)matches.get()).size() == 1 && (annotatedElement = ((IEObjectDescription)((List)matches.get()).get(0)).getEObjectOrProxy()) instanceof RoomElement && (annotation = this.roomHelpers.findDeprecatedAnnotation((RoomElement)annotatedElement)) != null) {
                ICompositeNode importNode = NodeModelUtils.getNode((EObject)importElement);
                acceptor.addPosition(importNode.getOffset(), importNode.getLength(), new String[]{"hl_deprecated_type"});
            }
        } else if (node.getGrammarElement() instanceof CrossReference) {
            Annotation annotation;
            EObject annotatedElement;
            EReference ref = GrammarUtil.getReference((CrossReference)((CrossReference)node.getGrammarElement()), (EClass)node.getSemanticElement().eClass());
            EObject eObject = annotatedElement = ref != null ? (EObject)node.getSemanticElement().eGet((EStructuralFeature)ref) : null;
            if (annotatedElement instanceof RoomElement && (annotation = this.roomHelpers.findDeprecatedAnnotation((RoomElement)annotatedElement)) != null) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"hl_deprecated_type"});
            }
        } else {
            Annotation annotation;
            EObject annotatedElement = node.getSemanticElement();
            if (annotatedElement instanceof RoomElement && (annotation = this.roomHelpers.findDeprecatedAnnotation((RoomElement)annotatedElement)) != null) {
                boolean noGenerate = this.roomHelpers.isDeprecatedGeneration((RoomElement)annotatedElement);
                if (noGenerate) {
                    ICompositeNode completeNode = NodeModelUtils.findActualNodeFor((EObject)annotatedElement);
                    acceptor.addPosition(completeNode.getOffset(), completeNode.getLength(), new String[]{"hl_deprecated_type"});
                } else {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"hl_deprecated_type"});
                }
            }
        }
    }
}

