/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.quickfix;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.BaseFactory;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.scoping.ModelPathGlobalScopeProvider;
import org.eclipse.etrice.core.common.scoping.RelativeFileURIHandler;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.ui.quickfix.RoomQuickfixProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RoomQuickFixProviderXtend
extends RoomQuickfixProvider {
    @Inject
    private ModelPathGlobalScopeProvider modelPathGlobalScopeProvider;
    @Inject
    private IResourceDescriptions resourceDescriptions;

    public List<IssueResolution> getResolutionsForLinkingIssue(final Issue issue) {
        final IXtextDocument xtextDocument = this.getModificationContextFactory().createModificationContext(issue).getXtextDocument();
        List list = null;
        if (xtextDocument != null) {
            IUnitOfWork<List<IssueResolution>, XtextResource> iUnitOfWork = new IUnitOfWork<List<IssueResolution>, XtextResource>(){

                public List<IssueResolution> exec(XtextResource resource) throws Exception {
                    List list = null;
                    String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                    IssueResolutionAcceptor acceptor = (IssueResolutionAcceptor)RoomQuickFixProviderXtend.this.getIssueResolutionAcceptorProvider().get();
                    RoomQuickFixProviderXtend.this.createLinkingQuickFixes(issue, issueString, resource, acceptor);
                    list = acceptor.getIssueResolutions();
                    return list;
                }
            };
            list = (List)xtextDocument.readOnly((IUnitOfWork)iUnitOfWork);
        }
        List resolutions = list;
        List list2 = super.getResolutionsForLinkingIssue(issue);
        return IterableExtensions.toList((Iterable)Iterables.concat(resolutions, (Iterable)list2));
    }

    protected void createLinkingQuickFixes(Issue issue, String issueString, XtextResource resource, IssueResolutionAcceptor acceptor) {
        EObject target = resource.getEObject(issue.getUriToProblem().fragment());
        EReference reference = this.getUnresolvedEReference(issue, target);
        if (reference != null) {
            this.importQuickfixElementWithoutURI(issueString, (Resource)resource, reference, issue, acceptor);
            this.importQuickfixNamespace(issueString, reference.getEReferenceType(), issue, acceptor);
            boolean bl = Objects.equal((Object)reference, (Object)RoomPackage.Literals.ACTOR_CLASS);
            if (bl) {
                this.importQuickfixElement(issueString, reference.getEReferenceType(), issue, acceptor);
            }
        }
    }

    protected void importQuickfixElementWithoutURI(final String issueString, Resource resource, EReference reference, final Issue issue, final IssueResolutionAcceptor acceptor) {
        Predicate<IEObjectDescription> predicate = new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription it) {
                return it.getName().getLastSegment().equalsIgnoreCase(issueString);
            }
        };
        Consumer<IEObjectDescription> consumer = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(final IEObjectDescription eObjDesc) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("Import '");
                QualifiedName qualifiedName = eObjDesc.getQualifiedName();
                stringConcatenation.append((Object)qualifiedName);
                stringConcatenation.append("' ");
                ISemanticModification iSemanticModification = new ISemanticModification(){

                    public void apply(EObject elem, IModificationContext ctx) throws Exception {
                        RoomModel model = (RoomModel)EcoreUtil2.getContainerOfType((EObject)elem, RoomModel.class);
                        EList eList = model.getImports();
                        Import import_ = BaseFactory.eINSTANCE.createImport();
                        Procedures.Procedure1<Import> procedure1 = new Procedures.Procedure1<Import>(){

                            public void apply(Import it) {
                                it.setImportedNamespace(eObjDesc.getQualifiedName().toString());
                            }
                        };
                        Import import_2 = (Import)ObjectExtensions.operator_doubleArrow((Object)import_, (Procedures.Procedure1)procedure1);
                        eList.add((Object)import_2);
                    }
                };
                acceptor.accept(issue, stringConcatenation.toString(), "", null, iSemanticModification);
            }
        };
        this.modelPathGlobalScopeProvider.getScope(resource, reference, (Predicate)predicate).getAllElements().forEach(consumer);
    }

    protected void importQuickfixNamespace(final String issueString, EClass type, final Issue issue, final IssueResolutionAcceptor acceptor) {
        Functions.Function1<IEObjectDescription, Boolean> function1 = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                return it.getName().getLastSegment().equalsIgnoreCase(issueString);
            }
        };
        Consumer<IEObjectDescription> consumer = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(final IEObjectDescription eObjDesc) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("Import namespace '");
                QualifiedName qualifiedName = eObjDesc.getQualifiedName().skipLast(1);
                stringConcatenation.append((Object)qualifiedName);
                stringConcatenation.append("' from '");
                String string = eObjDesc.getEObjectURI().lastSegment();
                stringConcatenation.append(string);
                stringConcatenation.append("' ");
                ISemanticModification iSemanticModification = new ISemanticModification(){

                    public void apply(EObject elem, IModificationContext ctx) throws Exception {
                        final RoomModel model = (RoomModel)EcoreUtil2.getContainerOfType((EObject)elem, RoomModel.class);
                        EList eList = model.getImports();
                        Import import_ = BaseFactory.eINSTANCE.createImport();
                        Procedures.Procedure1<Import> procedure1 = new Procedures.Procedure1<Import>(){

                            public void apply(Import it) {
                                QualifiedName qualifiedName = eObjDesc.getQualifiedName().skipLast(1);
                                String string = qualifiedName + ".*";
                                it.setImportedNamespace(string);
                                it.setImportURI(RoomQuickFixProviderXtend.this.computeImportURIString(model.eResource().getURI(), eObjDesc.getEObjectURI()));
                            }
                        };
                        Import import_2 = (Import)ObjectExtensions.operator_doubleArrow((Object)import_, (Procedures.Procedure1)procedure1);
                        eList.add((Object)import_2);
                    }
                };
                acceptor.accept(issue, stringConcatenation.toString(), "", null, iSemanticModification);
            }
        };
        IterableExtensions.filter((Iterable)this.resourceDescriptions.getExportedObjectsByType(type), (Functions.Function1)function1).forEach(consumer);
    }

    protected void importQuickfixElement(final String issueString, EClass type, final Issue issue, final IssueResolutionAcceptor acceptor) {
        Functions.Function1<IEObjectDescription, Boolean> function1 = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                return it.getName().getLastSegment().equalsIgnoreCase(issueString);
            }
        };
        Consumer<IEObjectDescription> consumer = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(final IEObjectDescription eObjDesc) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("Import '");
                QualifiedName qualifiedName = eObjDesc.getQualifiedName();
                stringConcatenation.append((Object)qualifiedName);
                stringConcatenation.append("' from '");
                String string = eObjDesc.getEObjectURI().lastSegment();
                stringConcatenation.append(string);
                stringConcatenation.append("' ");
                ISemanticModification iSemanticModification = new ISemanticModification(){

                    public void apply(EObject elem, IModificationContext ctx) throws Exception {
                        final RoomModel model = (RoomModel)EcoreUtil2.getContainerOfType((EObject)elem, RoomModel.class);
                        EList eList = model.getImports();
                        Import import_ = BaseFactory.eINSTANCE.createImport();
                        Procedures.Procedure1<Import> procedure1 = new Procedures.Procedure1<Import>(){

                            public void apply(Import it) {
                                it.setImportedNamespace(eObjDesc.getQualifiedName().toString());
                                it.setImportURI(RoomQuickFixProviderXtend.this.computeImportURIString(model.eResource().getURI(), eObjDesc.getEObjectURI()));
                            }
                        };
                        Import import_2 = (Import)ObjectExtensions.operator_doubleArrow((Object)import_, (Procedures.Procedure1)procedure1);
                        eList.add((Object)import_2);
                    }
                };
                acceptor.accept(issue, stringConcatenation.toString(), "", null, iSemanticModification);
            }
        };
        IterableExtensions.filter((Iterable)this.resourceDescriptions.getExportedObjectsByType(type), (Functions.Function1)function1).forEach(consumer);
    }

    private String computeImportURIString(URI base, URI toImport) {
        String string = null;
        final URI trimmedBase = base.trimQuery().trimFragment();
        URI trimmedImport = toImport.trimQuery().trimFragment();
        RelativeFileURIHandler relativeFileURIHandler = new RelativeFileURIHandler();
        Procedures.Procedure1<RelativeFileURIHandler> procedure1 = new Procedures.Procedure1<RelativeFileURIHandler>(){

            public void apply(RelativeFileURIHandler it) {
                it.setBaseURI(trimmedBase);
            }
        };
        RelativeFileURIHandler fileHandler = (RelativeFileURIHandler)ObjectExtensions.operator_doubleArrow((Object)relativeFileURIHandler, (Procedures.Procedure1)procedure1);
        URI resolvedRelative = fileHandler.deresolve(trimmedImport);
        if (base.isPlatformResource() && toImport.isPlatformResource() && Objects.equal((Object)base.segment(1), (Object)toImport.segment(1))) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String string2 = base.trimSegments(1).toPlatformString(false);
            Path path = new Path(string2);
            String baseLocation = iWorkspaceRoot.getFile((IPath)path).getLocation().toFile().getAbsolutePath();
            if (resolvedRelative.isRelative() && Files.exists(Paths.get(baseLocation, resolvedRelative.toString()), new LinkOption[0])) {
                return resolvedRelative.toString();
            }
            return trimmedImport.toString();
        }
        String string3 = null;
        string3 = base.isPlatformResource() && toImport.isPlatformResource() ? trimmedImport.toString() : resolvedRelative.toString();
        string = string3;
        return string;
    }
}

