/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.StateMachineGen;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    @Extension
    protected CExtensions _cExtensions;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    protected ILanguageExtension langExt;
    @Inject
    protected IGeneratorFileIO fileIO;
    @Inject
    protected ILogger logger;

    public void doGenerate(final Root root) {
        Functions.Function1<ActorClass, Boolean> function1 = new Functions.Function1<ActorClass, Boolean>(){

            public Boolean apply(ActorClass it) {
                boolean bl = ActorClassGen.this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
                return !bl;
            }
        };
        Functions.Function1<ActorClass, ExpandedActorClass> function12 = new Functions.Function1<ActorClass, ExpandedActorClass>(){

            public ExpandedActorClass apply(ActorClass it) {
                return root.getExpandedActorClass(it);
            }
        };
        Consumer<ExpandedActorClass> consumer = new Consumer<ExpandedActorClass>(){

            @Override
            public void accept(ExpandedActorClass xpac) {
                String path = ActorClassGen.this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
                String file = ActorClassGen.this._cExtensions.getCHeaderFileName((RoomClass)xpac.getActorClass());
                ActorClassGen.this.fileIO.generateFile("generating ActorClass header", String.valueOf(path) + file, ActorClassGen.this.generateHeaderFile(root, xpac));
                file = ActorClassGen.this._cExtensions.getCUtilsFileName((RoomClass)xpac.getActorClass());
                ActorClassGen.this.fileIO.generateFile("generating ActorClass utils", String.valueOf(path) + file, ActorClassGen.this.generateUtilsFile(root, xpac));
                boolean bl = ActorClassGen.this._roomHelpers.isBehaviorAnnotationPresent(xpac.getActorClass(), "BehaviorManual");
                if (bl) {
                    String string = xpac.getActorClass().getName();
                    String string2 = "omitting ActorClass source for '" + string;
                    String string3 = String.valueOf(string2) + "' since @BehaviorManual is specified";
                    ActorClassGen.this.logger.logInfo(string3);
                } else {
                    file = ActorClassGen.this._cExtensions.getCSourceFileName((RoomClass)xpac.getActorClass());
                    ActorClassGen.this.fileIO.generateFile("generating ActorClass source", String.valueOf(path) + file, ActorClassGen.this.generateSourceFile(root, xpac));
                }
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)function1), (Functions.Function1)function12).forEach(consumer);
    }

    protected CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac) {
        Object ep_12;
        CharSequence charSequence;
        String string;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1<Port, Boolean> function1 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                GeneralProtocolClass generalProtocolClass = p.getProtocol();
                CommunicationType communicationType = ((ProtocolClass)generalProtocolClass).getCommType();
                return Objects.equal((Object)communicationType, (Object)CommunicationType.EVENT_DRIVEN);
            }
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function1);
        Functions.Function1<Port, Boolean> function12 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                return Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && p.isConjugated();
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function12);
        Functions.Function1<Port, Boolean> function13 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                return Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && !p.isConjugated();
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function13);
        ComponentCommunicationType componentCommunicationType = ac.getCommType();
        boolean dataDriven = Objects.equal((Object)componentCommunicationType, (Object)ComponentCommunicationType.DATA_DRIVEN);
        ComponentCommunicationType componentCommunicationType2 = ac.getCommType();
        boolean async = Objects.equal((Object)componentCommunicationType2, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        boolean hasConstData = !IterableExtensions.isEmpty((Iterable)eventPorts) || !IterableExtensions.isEmpty((Iterable)recvPorts) || !this._roomHelpers.getAllSAPs(ac).isEmpty() || !this._roomHelpers.getAllServiceImplementations(ac).isEmpty() || this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        boolean isEmptyStateGraph = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
        boolean hasVarData = !IterableExtensions.isEmpty((Iterable)sendPorts) || !this._roomHelpers.getAllAttributes(ac).isEmpty() || !isEmptyStateGraph || hasConstData;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of ActorClass ");
        String string2 = ac.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this._cExtensions.generateIncludeGuardBegin((RoomClass)ac);
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etDatatypes.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etMessage.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* include all referenced room classes */");
        stringConcatenation2.newLine();
        Object object = root.getReferencedDataClasses((RoomClass)ac);
        Object object2 = root.getReferencedEnumClasses((RoomClass)ac);
        Object object3 = Iterables.concat((Iterable)object, (Iterable)object2);
        Object object4 = root.getReferencedProtocolClasses((RoomClass)ac);
        Object object5 = new Functions.Function1<RoomClass, String>(){

            public String apply(RoomClass it) {
                return it.getName();
            }
        };
        Object object6 = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)object3, (Iterable)object4), (Functions.Function1)object5);
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            RoomClass rc = (RoomClass)object7.next();
            stringConcatenation2.append("#include ");
            string = this._cExtensions.getIncludePath(rc);
            stringConcatenation2.append(string);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object = this._procedureHelpers.userCode((ActorContainerClass)ac, 1, true);
        stringConcatenation2.append(object);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("typedef struct ");
        object2 = ac.getName();
        stringConcatenation2.append((String)object2);
        stringConcatenation2.append(" ");
        object3 = ac.getName();
        stringConcatenation2.append((String)object3);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* const part of ActorClass (ROM) */");
        stringConcatenation2.newLine();
        if (hasConstData) {
            stringConcatenation2.append("typedef struct ");
            object4 = ac.getName();
            stringConcatenation2.append((String)object4);
            stringConcatenation2.append("_const {");
            stringConcatenation2.newLineIfNotEmpty();
            boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const char* instName;");
                stringConcatenation2.newLine();
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* simple ports */");
            stringConcatenation2.newLine();
            for (Port ep : eventPorts) {
                boolean bl2;
                int n = ep.getMultiplicity();
                boolean bl3 = bl2 = n == 1;
                if (!bl2) continue;
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const ");
                string = this._roomExtensions.getPortClassName((RoomElement)ep);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append(" ");
                charSequence = ep.getName();
                stringConcatenation2.append(charSequence, "\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* data receive ports */");
            stringConcatenation2.newLine();
            for (Port ep_12 : recvPorts) {
                boolean bl4;
                int n = ep_12.getMultiplicity();
                boolean bl5 = bl4 = n == 1;
                if (!bl4) continue;
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const ");
                string = this._roomExtensions.getPortClassName((RoomElement)ep_12);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append(" ");
                charSequence = ep_12.getName();
                stringConcatenation2.append(charSequence, "\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* saps */");
            stringConcatenation2.newLine();
            ep_12 = this._roomHelpers.getAllSAPs(ac);
            Iterator iterator = ep_12.iterator();
            while (iterator.hasNext()) {
                SAP sap = (SAP)iterator.next();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const ");
                object7 = this._roomExtensions.getPortClassName((RoomElement)sap);
                stringConcatenation2.append((String)object7, "\t");
                stringConcatenation2.append(" ");
                string = sap.getName();
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* replicated ports */");
            stringConcatenation2.newLine();
            ep_12 = this._roomHelpers.getAllEndPorts(ac);
            iterator = ep_12.iterator();
            while (iterator.hasNext()) {
                boolean bl6;
                Port ep_2 = (Port)iterator.next();
                int n = ep_2.getMultiplicity();
                boolean bl7 = bl6 = n != 1;
                if (!bl6) continue;
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const etReplPort ");
                charSequence = ep_2.getName();
                stringConcatenation2.append(charSequence, "\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* services */");
            stringConcatenation2.newLine();
            ep_12 = this._roomHelpers.getAllServiceImplementations(ac);
            iterator = ep_12.iterator();
            while (iterator.hasNext()) {
                ServiceImplementation svc = (ServiceImplementation)iterator.next();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const etReplPort ");
                String string3 = svc.getSpp().getName();
                stringConcatenation2.append(string3, "\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("} ");
            ep_12 = ac.getName();
            stringConcatenation2.append((String)ep_12);
            stringConcatenation2.append("_const;");
            stringConcatenation2.newLineIfNotEmpty();
        } else {
            stringConcatenation2.append("/* this actor class has no ports and thus no constant data */");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        if (!isEmptyStateGraph) {
            stringConcatenation2.newLine();
            object4 = this._stateMachineGen.genHeaderConstants(xpac);
            stringConcatenation2.append(object4);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* variable part of ActorClass (RAM) */");
        stringConcatenation2.newLine();
        if (hasVarData) {
            stringConcatenation2.append("struct ");
            object4 = ac.getName();
            stringConcatenation2.append((String)object4);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            if (hasConstData) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("const ");
                ep_12 = ac.getName();
                stringConcatenation2.append((String)ep_12, "\t");
                stringConcatenation2.append("_const* const constData;");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* data send ports */");
            stringConcatenation2.newLine();
            for (Port ep_3 : sendPorts) {
                boolean bl;
                int n = ep_3.getMultiplicity();
                boolean bl8 = bl = n == 1;
                if (!bl) continue;
                stringConcatenation2.append("\t");
                String string4 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                stringConcatenation2.append(string4, "\t");
                stringConcatenation2.append(" ");
                charSequence = ep_3.getName();
                stringConcatenation2.append(charSequence, "\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            object5 = this._procedureHelpers.attributes(this._roomHelpers.getAllAttributes(ac));
            stringConcatenation2.append(object5, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
            if (!isEmptyStateGraph) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                object6 = this._stateMachineGen.genDataMembers(xpac);
                stringConcatenation2.append(object6, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
        } else {
            stringConcatenation2.append("struct ");
            object4 = ac.getName();
            stringConcatenation2.append((String)object4);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* This actor class has no data at all.");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t   ");
            stringConcatenation2.append("But the private actor instance data is passed to all life cycle functions.");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t   ");
            stringConcatenation2.append("By introducing the dummy data we keep this case simple");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("*/");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("int dummy;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        object4 = ac.getName();
        stringConcatenation2.append((String)object4);
        stringConcatenation2.append("_init(");
        object5 = ac.getName();
        stringConcatenation2.append((String)object5);
        stringConcatenation2.append("* self);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        object6 = ac.getName();
        stringConcatenation2.append((String)object6);
        stringConcatenation2.append("_receiveMessage(void* self, const void* ifitem, const etMessage* msg);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (dataDriven || async) {
            stringConcatenation2.append("void ");
            String string5 = ac.getName();
            stringConcatenation2.append(string5);
            stringConcatenation2.append("_execute(");
            String string6 = ac.getName();
            stringConcatenation2.append(string6);
            stringConcatenation2.append("* self);");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        String string7 = this._procedureHelpers.userStructorsDeclaration((RoomClass)ac);
        stringConcatenation2.append(string7);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this._procedureHelpers.operationsDeclaration(this._roomHelpers.getLatestOperations(ac), ac.getName());
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._procedureHelpers.userCode((ActorContainerClass)ac, 2, true);
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        charSequence = this._cExtensions.generateIncludeGuardEnd((RoomClass)ac);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    protected CharSequence generateUtilsFile(Root root, ExpandedActorClass xpac) {
        String params;
        String string;
        String string2;
        String string3;
        boolean sap2;
        String string4;
        Object object;
        Object ep_42;
        EList eList;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        boolean bl;
        boolean bl2;
        Object object2;
        String string10;
        Object msg;
        Object object3;
        Object object4;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1<Port, Boolean> function1 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                GeneralProtocolClass generalProtocolClass = p.getProtocol();
                CommunicationType communicationType = ((ProtocolClass)generalProtocolClass).getCommType();
                return Objects.equal((Object)communicationType, (Object)CommunicationType.EVENT_DRIVEN);
            }
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function1);
        Functions.Function1<Port, Boolean> function12 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                int n = it.getMultiplicity();
                return n != 1;
            }
        };
        Iterable replEventPorts = IterableExtensions.filter((Iterable)eventPorts, (Functions.Function1)function12);
        Functions.Function1<Port, Boolean> function13 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                return Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && p.isConjugated() && p.getMultiplicity() == 1;
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function13);
        Functions.Function1<Port, Boolean> function14 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                return Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && !p.isConjugated() && p.getMultiplicity() == 1;
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function14);
        Functions.Function1<InterfaceItem, Boolean> function15 = new Functions.Function1<InterfaceItem, Boolean>(){

            public Boolean apply(InterfaceItem p) {
                return ActorClassGen.this._roomHelpers.getPortClass(p) != null && ActorClassGen.this._roomHelpers.getPortClass(p).getOperations().size() > 0;
            }
        };
        Iterable portsWithOperations = IterableExtensions.filter((Iterable)this._roomHelpers.getAllInterfaceItems(ac), (Functions.Function1)function15);
        EObject eObject = ac.eContainer();
        String string11 = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string12 = String.valueOf(string11) + "_";
        String string13 = ac.getName();
        String string14 = String.valueOf(string12) + string13;
        String filename = String.valueOf(string14) + "_Utils";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Utils File of ActorClass ");
        String string15 = ac.getName();
        stringConcatenation2.append(string15, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._cExtensions.generateIncludeGuardBegin(filename);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include ");
        String string16 = this._cExtensions.getIncludePath((RoomClass)ac);
        stringConcatenation2.append(string16);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* access macros for ports, operations and attributes");
        stringConcatenation2.newLine();
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* simple event ports */");
        stringConcatenation2.newLine();
        Functions.Function1<Port, Boolean> function16 = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                int n = it.getMultiplicity();
                return n == 1;
            }
        };
        Iterator iterator = IterableExtensions.filter((Iterable)eventPorts, (Functions.Function1)function16);
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Port ep = (Port)iterator2.next();
            object4 = this._roomHelpers.getOutgoing((InterfaceItem)ep);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                msg = (Message)object3.next();
                string10 = null;
                object2 = msg.getData();
                bl2 = object2 != null;
                string10 = bl2 ? "data" : "";
                String data1 = string10;
                stringConcatenation2.newLineIfNotEmpty();
                String string17 = null;
                MessageData messageData = msg.getData();
                bl = messageData != null;
                string17 = bl ? ", data" : "";
                String data2 = string17;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                string9 = ep.getName();
                stringConcatenation2.append(string9);
                stringConcatenation2.append("_");
                string8 = msg.getName();
                stringConcatenation2.append(string8);
                stringConcatenation2.append("(");
                stringConcatenation2.append(data1);
                stringConcatenation2.append(") ");
                string7 = this._roomExtensions.getPortClassName((RoomElement)ep);
                stringConcatenation2.append(string7);
                stringConcatenation2.append("_");
                string6 = msg.getName();
                stringConcatenation2.append(string6);
                stringConcatenation2.append("(&self->constData->");
                string5 = ep.getName();
                stringConcatenation2.append(string5);
                stringConcatenation2.append(data2);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data receive ports */");
        stringConcatenation2.newLine();
        for (Port ep_1 : recvPorts) {
            eList = this._roomHelpers.getIncoming((InterfaceItem)ep_1);
            for (Message msg_1 : eList) {
                stringConcatenation2.append("#define ");
                msg = ep_1.getName();
                stringConcatenation2.append((String)msg);
                stringConcatenation2.append("_");
                object3 = msg_1.getName();
                stringConcatenation2.append((String)object3);
                stringConcatenation2.append(" ");
                string10 = this._roomExtensions.getPortClassName((RoomElement)ep_1);
                stringConcatenation2.append(string10);
                stringConcatenation2.append("_");
                object2 = msg_1.getName();
                stringConcatenation2.append((String)object2);
                stringConcatenation2.append("_get(&self->constData->");
                String string18 = ep_1.getName();
                stringConcatenation2.append(string18);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data send ports */");
        stringConcatenation2.newLine();
        for (Object ep_42 : sendPorts) {
            eList = this._roomHelpers.getOutgoing((InterfaceItem)ep_42);
            for (Object msg_2 : eList) {
                msg = null;
                object3 = msg_2.getData();
                boolean bl3 = object3 != null;
                msg = bl3 ? "data" : "";
                Object data1_1 = msg;
                stringConcatenation2.newLineIfNotEmpty();
                String string19 = null;
                object = msg_2.getData();
                boolean bl4 = object != null;
                string19 = bl4 ? ", data" : "";
                String data2_1 = string19;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                String string20 = ep_42.getName();
                stringConcatenation2.append(string20);
                stringConcatenation2.append("_");
                string4 = msg_2.getName();
                stringConcatenation2.append(string4);
                stringConcatenation2.append("(");
                stringConcatenation2.append((String)data1_1);
                stringConcatenation2.append(") ");
                string9 = this._roomExtensions.getPortClassName((RoomElement)ep_42);
                stringConcatenation2.append(string9);
                stringConcatenation2.append("_");
                string8 = msg_2.getName();
                stringConcatenation2.append(string8);
                stringConcatenation2.append("_set(&self->");
                string7 = ep_42.getName();
                stringConcatenation2.append(string7);
                stringConcatenation2.append(data2_1);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* saps */");
        stringConcatenation2.newLine();
        ep_42 = this._roomHelpers.getAllSAPs(ac);
        eList = ep_42.iterator();
        while (eList.hasNext()) {
            Object msg_2;
            SAP sap2 = (SAP)eList.next();
            msg_2 = this._roomHelpers.getOutgoing((InterfaceItem)sap2);
            msg = msg_2.iterator();
            while (msg.hasNext()) {
                Message msg_3 = (Message)msg.next();
                object3 = null;
                MessageData messageData = msg_3.getData();
                boolean data1_1 = messageData != null;
                object3 = data1_1 ? "data" : "";
                Object data1_2 = object3;
                stringConcatenation2.newLineIfNotEmpty();
                object = null;
                MessageData messageData2 = msg_3.getData();
                boolean data2_1 = messageData2 != null;
                object = data2_1 ? ", data" : "";
                Object data2_2 = object;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                string4 = sap2.getName();
                stringConcatenation2.append(string4);
                stringConcatenation2.append("_");
                string9 = msg_3.getName();
                stringConcatenation2.append(string9);
                stringConcatenation2.append("(");
                stringConcatenation2.append((String)data1_2);
                stringConcatenation2.append(") ");
                string8 = this._roomExtensions.getPortClassName((RoomElement)sap2);
                stringConcatenation2.append(string8);
                stringConcatenation2.append("_");
                string7 = msg_3.getName();
                stringConcatenation2.append(string7);
                stringConcatenation2.append("(&self->constData->");
                string6 = sap2.getName();
                stringConcatenation2.append(string6);
                stringConcatenation2.append((String)data2_2);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* replicated event ports */");
        stringConcatenation2.newLine();
        boolean ep_42 = IterableExtensions.isEmpty((Iterable)replEventPorts);
        boolean bl5 = sap2 = !ep_42;
        if (sap2) {
            stringConcatenation2.append("#define ifitem_index (((etReplSubPort*)ifitem)->index)");
            stringConcatenation2.newLine();
        }
        for (Port ep_3 : replEventPorts) {
            eList = this._roomHelpers.getOutgoing((InterfaceItem)ep_3);
            for (Object msg_4 : eList) {
                msg = null;
                object3 = msg_4.getData();
                boolean bl6 = object3 != null;
                msg = bl6 ? "data" : "";
                Object data1_3 = msg;
                stringConcatenation2.newLineIfNotEmpty();
                String data1_2 = null;
                object = msg_4.getData();
                boolean bl7 = object != null;
                data1_2 = bl7 ? ", data" : "";
                String data2_3 = data1_2;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                String data2_2 = ep_3.getName();
                stringConcatenation2.append(data2_2);
                stringConcatenation2.append("_");
                string4 = msg_4.getName();
                stringConcatenation2.append(string4);
                stringConcatenation2.append("_broadcast(");
                stringConcatenation2.append((String)data1_3);
                stringConcatenation2.append(") ");
                string9 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                stringConcatenation2.append(string9);
                stringConcatenation2.append("_");
                string8 = msg_4.getName();
                stringConcatenation2.append(string8);
                stringConcatenation2.append("_broadcast(&self->constData->");
                string7 = ep_3.getName();
                stringConcatenation2.append(string7);
                stringConcatenation2.append(data2_3);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                string6 = ep_3.getName();
                stringConcatenation2.append(string6);
                stringConcatenation2.append("_");
                string5 = msg_4.getName();
                stringConcatenation2.append(string5);
                stringConcatenation2.append("(idx");
                stringConcatenation2.append(data2_3);
                stringConcatenation2.append(") ");
                string3 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                stringConcatenation2.append(string3);
                stringConcatenation2.append("_");
                string2 = msg_4.getName();
                stringConcatenation2.append(string2);
                stringConcatenation2.append("(&self->constData->");
                string = ep_3.getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append(", idx");
                stringConcatenation2.append(data2_3);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* services */");
        stringConcatenation2.newLine();
        List ep_3 = this._roomHelpers.getAllServiceImplementations(ac);
        for (ServiceImplementation svc : ep_3) {
            Object msg_4;
            msg_4 = this._roomHelpers.getOutgoing((InterfaceItem)svc.getSpp());
            msg = msg_4.iterator();
            while (msg.hasNext()) {
                Message msg_5 = (Message)msg.next();
                object3 = null;
                MessageData messageData = msg_5.getData();
                boolean bl8 = messageData != null;
                object3 = bl8 ? "data" : "";
                Object data1_4 = object3;
                stringConcatenation2.newLineIfNotEmpty();
                object = null;
                MessageData messageData3 = msg_5.getData();
                boolean bl9 = messageData3 != null;
                object = bl9 ? ", data" : "";
                Object data2_4 = object;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                string4 = svc.getSpp().getName();
                stringConcatenation2.append(string4);
                stringConcatenation2.append("_");
                string9 = msg_5.getName();
                stringConcatenation2.append(string9);
                stringConcatenation2.append("_broadcast(");
                stringConcatenation2.append((String)data1_4);
                stringConcatenation2.append(") ");
                string8 = this._roomExtensions.getPortClassName((RoomElement)svc.getSpp());
                stringConcatenation2.append(string8);
                stringConcatenation2.append("_");
                string7 = msg_5.getName();
                stringConcatenation2.append(string7);
                stringConcatenation2.append("_broadcast(&self->constData->");
                string6 = svc.getSpp().getName();
                stringConcatenation2.append(string6);
                stringConcatenation2.append((String)data2_4);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                string5 = svc.getSpp().getName();
                stringConcatenation2.append(string5);
                stringConcatenation2.append("_");
                string3 = msg_5.getName();
                stringConcatenation2.append(string3);
                stringConcatenation2.append("(idx");
                stringConcatenation2.append((String)data2_4);
                stringConcatenation2.append(") ");
                string2 = this._roomExtensions.getPortClassName((RoomElement)svc.getSpp());
                stringConcatenation2.append(string2);
                stringConcatenation2.append("_");
                string = msg_5.getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append("(&self->constData->");
                String string21 = svc.getSpp().getName();
                stringConcatenation2.append(string21);
                stringConcatenation2.append(", idx");
                stringConcatenation2.append((String)data2_4);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* operations */");
        stringConcatenation2.newLine();
        ep_3 = this._roomHelpers.getLatestOperations(ac);
        for (StandardOperation op : ep_3) {
            params = this.operationParams((Operation)op);
            stringConcatenation2.newLineIfNotEmpty();
            String args = this.operationArgs((Operation)op);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            msg = op.getName();
            stringConcatenation2.append((String)msg);
            stringConcatenation2.append("(");
            stringConcatenation2.append(params);
            stringConcatenation2.append(") ");
            object3 = ac.getName();
            stringConcatenation2.append((String)object3);
            stringConcatenation2.append("_");
            String string22 = op.getName();
            stringConcatenation2.append(string22);
            stringConcatenation2.append("(self");
            boolean bl10 = op.getArguments().isEmpty();
            boolean bl11 = bl2 = !bl10;
            if (bl2) {
                stringConcatenation2.append(", ");
                stringConcatenation2.append(args);
            }
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* attributes */");
        stringConcatenation2.newLine();
        ep_3 = this._roomHelpers.getAllAttributes(ac);
        for (Attribute a : ep_3) {
            stringConcatenation2.append("#define ");
            params = a.getName();
            stringConcatenation2.append(params);
            stringConcatenation2.append(" (self->");
            object4 = a.getName();
            stringConcatenation2.append((String)object4);
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* port operations */");
        stringConcatenation2.newLine();
        for (InterfaceItem p : portsWithOperations) {
            eList = this._roomHelpers.getPortClass(p).getOperations();
            for (PortOperation op_1 : eList) {
                boolean bl12;
                String params_1 = this.operationParams((Operation)op_1);
                stringConcatenation2.newLineIfNotEmpty();
                String args_1 = this.operationArgs((Operation)op_1);
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                String string23 = p.getName();
                stringConcatenation2.append(string23);
                stringConcatenation2.append("_");
                String string24 = op_1.getName();
                stringConcatenation2.append(string24);
                stringConcatenation2.append("(");
                stringConcatenation2.append(params_1);
                stringConcatenation2.append(") ");
                String string25 = this._roomExtensions.getPortClassName((RoomElement)p);
                stringConcatenation2.append(string25);
                stringConcatenation2.append("_");
                object = op_1.getName();
                stringConcatenation2.append((String)object);
                stringConcatenation2.append("((");
                String string26 = this._roomExtensions.getPortClassName((RoomElement)p);
                stringConcatenation2.append(string26);
                stringConcatenation2.append("*)&self->constData->");
                String string27 = p.getName();
                stringConcatenation2.append(string27);
                bl = op_1.getArguments().isEmpty();
                boolean bl13 = bl12 = !bl;
                if (bl12) {
                    stringConcatenation2.append(", ");
                    stringConcatenation2.append(args_1);
                }
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this._cExtensions.generateIncludeGuardEnd(filename);
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String operationParams(Operation op) {
        Functions.Function1<VarDecl, String> function1 = new Functions.Function1<VarDecl, String>(){

            public String apply(VarDecl it) {
                String string = null;
                boolean bl = false;
                boolean bl2 = it.isVarargs();
                if (bl2) {
                    bl = true;
                    string = "...";
                }
                if (!bl) {
                    string = it.getName();
                }
                return string;
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1<VarDecl, String> function1 = new Functions.Function1<VarDecl, String>(){

            public String apply(VarDecl it) {
                String string = null;
                boolean bl = false;
                boolean bl2 = it.isVarargs();
                if (bl2) {
                    bl = true;
                    string = "__VA_ARGS__";
                }
                if (!bl) {
                    string = it.getName();
                }
                return string;
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    protected CharSequence generateSourceFile(Root root, ExpandedActorClass xpac) {
        CharSequence charSequence;
        String string;
        CharSequence charSequence2;
        CharSequence charSequence3;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        ComponentCommunicationType componentCommunicationType = ac.getCommType();
        boolean async = Objects.equal((Object)componentCommunicationType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType componentCommunicationType2 = ac.getCommType();
        boolean eventDriven = Objects.equal((Object)componentCommunicationType2, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        ComponentCommunicationType componentCommunicationType3 = ac.getCommType();
        boolean dataDriven = Objects.equal((Object)componentCommunicationType3, (Object)ComponentCommunicationType.DATA_DRIVEN);
        boolean handleEvents = async || eventDriven;
        boolean isEmptyStateGraph = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of ActorClass ");
        String string2 = ac.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string3 = this._cExtensions.getCHeaderFileName((RoomClass)ac);
        stringConcatenation2.append(string3);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"modelbase/etActor.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etUnit/etUnit.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"base/etMemory.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        Object object = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : object) {
            stringConcatenation2.append("#include ");
            charSequence3 = this._cExtensions.getIncludePath((RoomClass)pc);
            stringConcatenation2.append(charSequence3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        object = this._cExtensions.getCUtilsFileName((RoomClass)ac);
        stringConcatenation2.append((String)object);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._procedureHelpers.userCode((ActorContainerClass)ac, 3, true);
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* interface item IDs */");
        stringConcatenation2.newLine();
        String string4 = this.genInterfaceItemConstants(xpac);
        stringConcatenation2.append(string4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (!isEmptyStateGraph) {
            charSequence3 = this._stateMachineGen.genStateMachine(xpac.getGraphContainer());
            stringConcatenation2.append((Object)charSequence3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        charSequence3 = ac.getName();
        stringConcatenation2.append(charSequence3);
        stringConcatenation2.append("_init(");
        String string5 = ac.getName();
        stringConcatenation2.append(string5);
        stringConcatenation2.append("* self){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String string6 = ac.getName();
        stringConcatenation2.append(string6, "\t");
        stringConcatenation2.append("\", \"init\")");
        stringConcatenation2.newLineIfNotEmpty();
        if (!isEmptyStateGraph) {
            stringConcatenation2.append("\t");
            charSequence2 = this._stateMachineGen.genInitialization(xpac);
            stringConcatenation2.append((Object)charSequence2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        charSequence2 = ac.getName();
        stringConcatenation2.append((String)charSequence2);
        stringConcatenation2.append("_receiveMessage(void* self, const void* ifitem, const etMessage* msg){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String string7 = ac.getName();
        stringConcatenation2.append(string7, "\t");
        stringConcatenation2.append("\", \"_receiveMessage\")");
        stringConcatenation2.newLineIfNotEmpty();
        if (!isEmptyStateGraph) {
            if (handleEvents) {
                stringConcatenation2.append("\t");
                string = this.langExt.operationScope(ac.getName(), false);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append("receiveEvent(self, (etPort*)ifitem, msg->evtID, (void*)(((char*)msg)+MEM_CEIL(sizeof(etMessage))));");
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                stringConcatenation2.append("\t");
                string = this.langExt.operationScope(ac.getName(), false);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append("receiveEventInternal(self);");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        if (dataDriven || async) {
            stringConcatenation2.append("void ");
            string = ac.getName();
            stringConcatenation2.append(string);
            stringConcatenation2.append("_execute(");
            charSequence = ac.getName();
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append("* self) {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
            String string8 = ac.getName();
            stringConcatenation2.append(string8, "\t");
            stringConcatenation2.append("\", \"_execute\")");
            stringConcatenation2.newLineIfNotEmpty();
            if (!isEmptyStateGraph) {
                stringConcatenation2.newLine();
                if (handleEvents) {
                    stringConcatenation2.append("\t");
                    String string9 = this.langExt.operationScope(ac.getName(), false);
                    stringConcatenation2.append(string9, "\t");
                    stringConcatenation2.append("receiveEvent(self, NULL, 0, NULL);");
                    stringConcatenation2.newLineIfNotEmpty();
                } else {
                    stringConcatenation2.append("\t");
                    String string10 = this.langExt.operationScope(ac.getName(), false);
                    stringConcatenation2.append(string10, "\t");
                    stringConcatenation2.append("receiveEventInternal(self);");
                    stringConcatenation2.newLineIfNotEmpty();
                }
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        string = this._procedureHelpers.userStructorsImplementation((RoomClass)ac);
        stringConcatenation2.append(string);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        charSequence = this._procedureHelpers.operationsImplementation(this._roomHelpers.getLatestOperations(ac), ac.getName());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

