/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CExtensions
implements ILanguageExtension {
    @Inject
    protected IDiagnostician diagnostician;
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        String string = null;
        string = msg instanceof Message ? this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()] : "";
        return string;
    }

    public String accessLevelPrivate() {
        return "static ";
    }

    public String accessLevelProtected() {
        return "static ";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "self->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        String string = null;
        string = hasArgs ? "* self, " : "* self";
        return String.valueOf(classname) + string;
    }

    public String selfPointer(boolean hasArgs) {
        String string = null;
        string = hasArgs ? "self, " : "self";
        return string;
    }

    public String scopeSeparator() {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return String.valueOf(classname) + "_";
    }

    public String memberInDeclaration(String namespace, String member) {
        return String.valueOf(namespace) + "_" + member;
    }

    public String memberInUse(String namespace, String member) {
        return String.valueOf(namespace) + "_" + member;
    }

    public String getCHeaderFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + ".h";
    }

    public String getCSourceFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + ".c";
    }

    public String getCUtilsFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + "_Utils.h";
    }

    public String getInstSourceFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + "_Inst.h";
    }

    public String getDispSourceFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + "_Disp.h";
    }

    public String getCHeaderFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String string4 = String.valueOf(string2) + string3;
        return String.valueOf(string4) + ".h";
    }

    public String getCSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String string4 = String.valueOf(string2) + string3;
        return String.valueOf(string4) + ".c";
    }

    public String getInstSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String string4 = String.valueOf(string2) + string3;
        return String.valueOf(string4) + "_Inst.h";
    }

    public String getDispSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String string4 = String.valueOf(string2) + string3;
        return String.valueOf(string4) + "_Disp.h";
    }

    public CharSequence getIncludeGuardString(String filename) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_");
        String string = filename.toUpperCase();
        stringConcatenation.append(string);
        stringConcatenation.append("_H_");
        return stringConcatenation;
    }

    public CharSequence generateIncludeGuardBegin(RoomClass rc) {
        CharSequence charSequence = null;
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string2 = String.valueOf(string) + "_";
        String string3 = rc.getName();
        String filename = String.valueOf(string2) + string3;
        charSequence = this.generateIncludeGuardBegin(filename);
        return charSequence;
    }

    public CharSequence generateIncludeGuardEnd(RoomClass rc) {
        CharSequence charSequence = null;
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string2 = String.valueOf(string) + "_";
        String string3 = rc.getName();
        String filename = String.valueOf(string2) + string3;
        charSequence = this.generateIncludeGuardEnd(filename);
        return charSequence;
    }

    public CharSequence generateIncludeGuardBegin(String filename) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#ifndef ");
        CharSequence charSequence = this.getIncludeGuardString(filename);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#define ");
        CharSequence charSequence2 = this.getIncludeGuardString(filename);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public CharSequence generateIncludeGuardEnd(String filename) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#endif /* ");
        CharSequence charSequence = this.getIncludeGuardString(filename);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append(" */");
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public boolean usesInheritance() {
        return false;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String string = null;
        boolean bl = entries.isEmpty();
        if (bl) {
            return "/* empty enum not generated */";
        }
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("enum ");
        stringConcatenation.append(name);
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        boolean bl2 = false;
        for (Pair<String, String> entry : entries) {
            if (!bl2) {
                bl2 = true;
            } else {
                stringConcatenation.appendImmediate((Object)",", "\t");
            }
            stringConcatenation.append("\t");
            String string2 = (String)entry.getFirst();
            stringConcatenation.append(string2, "\t");
            stringConcatenation.append(" = ");
            String string3 = (String)entry.getSecond();
            stringConcatenation.append(string3, "\t");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("};");
        stringConcatenation.newLine();
        string = stringConcatenation.toString();
        return string;
    }

    public String booleanConstant(boolean b) {
        String string = null;
        string = b ? "ET_TRUE" : "ET_FALSE";
        return string;
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "NULL";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayType(String type, int size, boolean isRef) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(type);
        if (isRef) {
            stringConcatenation.append("*");
        }
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation.toString();
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(type);
        if (isRef) {
            stringConcatenation.append("*");
        }
        stringConcatenation.append(" ");
        stringConcatenation.append(name);
        stringConcatenation.append("[");
        stringConcatenation.append((Object)size);
        stringConcatenation.append("]");
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation.toString();
    }

    public String superCall(String baseClassName, String method, String args) {
        return "";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        Object object;
        boolean bl;
        String string = null;
        String string2 = type.getTargetName();
        boolean bl2 = false;
        if (type.getTargetName().equals("char") && value.length() == 1) {
            bl2 = true;
            string = "'" + value + "'";
        }
        if (!bl2 && (bl = Objects.equal((Object)(object = type.getType()), (Object)LiteralType.CHAR))) {
            bl2 = true;
            string = "\"" + value + "\"";
        }
        if (!bl2 && (value.contains(",") || value.contains("{"))) {
            bl2 = true;
            object = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl3 = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl3) {
                    bl3 = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.toValueLiteral(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            object = stringConcatenation.toString();
            string = object;
        }
        if (!bl2 && Objects.equal((Object)string2, (Object)"boolean")) {
            bl2 = true;
            object = null;
            bl = value.equals("true");
            object = bl ? "ET_TRUE" : "ET_FALSE";
            string = object;
        }
        if (!bl2) {
            string = value;
        }
        return string;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        String string = null;
        if (value.contains(",") || value.contains("{")) {
            String string2 = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.convertStringEnumLiteral(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            string = string2 = stringConcatenation.toString();
        } else {
            string = this.convertStringEnumLiteral(type, value);
        }
        return string;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        boolean bl = v.startsWith(type.getName());
        if (bl) {
            int n = type.getName().length();
            int n2 = n + 1;
            v = v.substring(n2);
        }
        EList eList = type.getLiterals();
        for (EnumLiteral l : eList) {
            boolean bl2 = l.getName().equals(v);
            if (!bl2) continue;
            String string = type.getName();
            String string2 = String.valueOf(string) + "_";
            String string3 = l.getName();
            return String.valueOf(string2) + string3;
        }
        return null;
    }

    public String defaultValue(DataType dt) {
        String string;
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        String string2 = null;
        boolean bl2 = false;
        if (dt instanceof PrimitiveType) {
            bl2 = true;
            string2 = this.toValueLiteral((PrimitiveType)dt, ((PrimitiveType)dt).getDefaultValueLiteral());
        }
        if (!bl2 && dt instanceof EnumerationType) {
            bl2 = true;
            string2 = this.getDefaultValue((EnumerationType)dt);
        }
        if (!bl2 && dt instanceof ExternalType) {
            bl2 = true;
            object3 = null;
            object2 = ((ExternalType)dt).getDefaultValueLiteral();
            boolean bl3 = bl = object2 != null;
            if (bl) {
                return ((ExternalType)dt).getDefaultValueLiteral();
            }
            String string3 = ((ExternalType)dt).getName();
            object = "external type " + string3;
            string = String.valueOf(object) + "has no default initialization";
            this.diagnostician.error(string, ((ExternalType)dt).eContainer(), ((ExternalType)dt).eContainingFeature());
            object3 = "";
            string2 = object3;
        }
        if (!bl2 && dt instanceof DataClass) {
            bl2 = true;
            object3 = new StringConcatenation();
            object3.append("{");
            object3.newLine();
            object2 = this._roomHelpers.getAllAttributes((DataClass)dt);
            bl = false;
            object = object2.iterator();
            while (object.hasNext()) {
                Attribute att = (Attribute)object.next();
                if (!bl) {
                    bl = true;
                } else {
                    object3.appendImmediate((Object)",", "\t");
                }
                object3.append("\t");
                string = this.initializationWithDefaultValues(att);
                object3.append(string, "\t");
                object3.newLineIfNotEmpty();
            }
            object3.append("}");
            object3.newLine();
            string2 = object3.toString();
        }
        return string2;
    }

    public String getDefaultValue(EnumerationType type) {
        String string = null;
        boolean bl = type.getLiterals().isEmpty();
        string = bl ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return string;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String string = null;
        String dv = this.defaultValue(dt);
        string = this.initializer(dv, size);
        return string;
    }

    private String initializer(String dv, int size) {
        String string = null;
        if (size > 1) {
            String string2 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = String.valueOf(res) + dv;
                if (++i >= size) continue;
                res = String.valueOf(res) + ",";
            }
            string = string2 = String.valueOf(res) + "}";
        } else {
            string = dv;
        }
        return string;
    }

    public String initializationWithDefaultValues(Attribute att) {
        String string = null;
        String dv = att.getDefaultValueLiteral();
        String string2 = null;
        if (dv != null) {
            String string3 = null;
            boolean bl = dv.startsWith("{");
            string3 = bl ? dv : this.initializer(dv, att.getSize());
            string2 = string3;
        } else {
            String string4 = null;
            boolean bl = att.getType().isRef();
            string4 = bl ? this.initializer("NULL", att.getSize()) : this.initializationWithDefaultValues(att.getType().getType(), att.getSize());
            string2 = string4;
        }
        string = string2;
        return string;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        boolean isPrim;
        String ct;
        DataType dataType;
        Object object;
        Object object2;
        DataType dataType2;
        Object object3;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        if (data == null) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        String string = null;
        DataType dataType3 = data.getRefType().getType();
        if (dataType3 instanceof PrimitiveType) {
            object3 = data.getRefType().getType();
            string = ((PrimitiveType)object3).getTargetName();
        } else {
            object3 = null;
            dataType2 = data.getRefType().getType();
            if (dataType2 instanceof EnumerationType) {
                object2 = data.getRefType().getType();
                object3 = this.getTargetType((EnumerationType)object2);
            } else {
                object2 = null;
                object = data.getRefType().getType();
                if (object instanceof ExternalType) {
                    dataType = data.getRefType().getType();
                    object2 = ((ExternalType)dataType).getTargetName();
                } else {
                    object2 = data.getRefType().getType().getName();
                }
                object3 = object2;
            }
            string = object3;
        }
        String typeName = string;
        dataType2 = null;
        object2 = data.getRefType().getType();
        if (object2 instanceof PrimitiveType) {
            object = null;
            dataType = data.getRefType().getType();
            ct = ((PrimitiveType)dataType).getCastName();
            String string2 = null;
            string2 = ct != null && !ct.isEmpty() ? ct : typeName;
            dataType2 = object = string2;
        } else {
            object = null;
            dataType = data.getRefType().getType();
            if (dataType instanceof EnumerationType) {
                ct = data.getRefType().getType();
                object = this.getCastType((EnumerationType)ct);
            } else {
                object = typeName;
            }
            dataType2 = object;
        }
        Object castTypeName = dataType2;
        castTypeName = String.valueOf(castTypeName) + "*";
        String deRef = "*";
        boolean isRef = data.getRefType().isRef();
        boolean bl = isPrim = data.getRefType().getType() instanceof PrimitiveType || data.getRefType().getType() instanceof EnumerationType;
        if (isRef) {
            typeName = String.valueOf(typeName) + "*";
            castTypeName = String.valueOf(castTypeName) + "*";
        } else if (!isPrim) {
            typeName = String.valueOf(typeName) + "*";
            deRef = "";
        }
        String string3 = null;
        string3 = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        String dataName = string3;
        String dataArg = ", " + dataName;
        String typedData = String.valueOf(typeName) + " " + dataName + " = " + deRef + "((" + (String)castTypeName + ") generic_data__et);\n";
        String typedArgList = ", " + typeName + " " + dataName;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getIncludePath(RoomClass rc) {
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "/");
        String string2 = "\"" + string;
        String string3 = String.valueOf(string2) + "/";
        String string4 = this.getCHeaderFileName(rc);
        String string5 = String.valueOf(string3) + string4;
        return String.valueOf(string5) + "\"";
    }

    public String getUtilsIncludePath(RoomClass rc) {
        EObject eObject = rc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "/");
        String string2 = "\"" + string;
        String string3 = String.valueOf(string2) + "/";
        String string4 = this.getCUtilsFileName(rc);
        String string5 = String.valueOf(string3) + string4;
        return String.valueOf(string5) + "\"";
    }

    public String getTargetType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getTargetName() : type.getName();
        return string;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean bl;
        String string = null;
        EObject eObject = literal.eContainer();
        EnumerationType type = (EnumerationType)eObject;
        String cast = this.getTargetType(type);
        String string2 = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl2 = bl = primitiveType == null;
        if (bl) {
            string2 = Long.toString(literal.getLiteralValue());
        } else {
            String string3 = Long.toString(literal.getLiteralValue());
            String string4 = "((" + cast + ")" + string3;
            string2 = String.valueOf(string4) + ")";
        }
        string = string2;
        return string;
    }

    public String getCastType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getCastName() : type.getName();
        return string;
    }

    public String makeOverridable() {
        return "";
    }

    public String getTypeSignature(RefableType type) {
        boolean bl;
        String string = null;
        RefableType it = type;
        boolean bl2 = false;
        if (Objects.equal((Object)it, null)) {
            bl2 = true;
            string = "void";
        }
        if (!bl2 && (bl = it.isRef())) {
            bl2 = true;
            String string2 = this.getDataTypeName(type.getType());
            String string3 = this.pointerLiteral();
            string = String.valueOf(string2) + string3;
        }
        if (!bl2) {
            string = this.getDataTypeName(type.getType());
        }
        return string;
    }

    public String getDataTypeName(DataType it) {
        String string = null;
        boolean bl = false;
        if (it instanceof PrimitiveType) {
            bl = true;
            string = ((PrimitiveType)it).getTargetName();
        }
        if (!bl && it instanceof EnumerationType) {
            bl = true;
            string = this.getTargetType((EnumerationType)it);
        }
        if (!bl && it instanceof ExternalType) {
            bl = true;
            string = ((ExternalType)it).getTargetName();
        }
        if (!bl) {
            string = it.getName();
        }
        return string;
    }

    public String toParameterDecl(VarDecl it) {
        String string = null;
        boolean bl = false;
        boolean bl2 = it.isVarargs();
        if (bl2) {
            bl = true;
            string = "...";
        }
        if (!bl) {
            String string2 = this.getTypeSignature(it.getRefType());
            String string3 = String.valueOf(string2) + " ";
            String string4 = it.getName();
            string = String.valueOf(string3) + string4;
        }
        return string;
    }
}

