/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.generator.base.DefaultTranslationProvider;
import org.eclipse.etrice.generator.generic.ILanguageExtension;

public class CTranslationProvider
extends DefaultTranslationProvider {
    @Inject
    ILanguageExtension langExt;

    public boolean translateMembers() {
        return true;
    }

    public String getAttributeSetter(Attribute att, String index, String value, String orig) {
        if (index == null) {
            return String.valueOf(att.getName()) + " = " + value;
        }
        return String.valueOf(att.getName()) + "[" + index + "] = " + value;
    }

    public String getInterfaceItemMessageText(AbstractInterfaceItem item, EObject abstractMsg, List<String> args, String index, String orig) {
        if (!(abstractMsg instanceof Message)) {
            return orig;
        }
        Message msg = (Message)abstractMsg;
        StringBuilder argtext = new StringBuilder();
        for (String arg : args) {
            argtext.append(", " + arg);
        }
        String argtext2 = argtext.length() == 0 ? "" : argtext.substring(2);
        String result = orig;
        if (item instanceof Port) {
            Port p = (Port)item;
            if (p.getProtocol() instanceof ProtocolClass) {
                ProtocolClass pc = (ProtocolClass)p.getProtocol();
                if (pc.getCommType() == CommunicationType.EVENT_DRIVEN) {
                    result = p.getMultiplicity() == 1 ? String.valueOf(item.getName()) + "_" + msg.getName() + "(" + argtext2 + ")" : (index == null ? String.valueOf(item.getName()) + "_" + msg.getName() + "_broadcast(" + argtext2 + ")" : String.valueOf(item.getName()) + "_" + msg.getName() + "(" + index + argtext + ")");
                } else if (pc.getCommType() == CommunicationType.DATA_DRIVEN) {
                    result = p.isConjugated() ? String.valueOf(item.getName()) + "_" + msg.getName() + "(" + argtext2 + ")" : String.valueOf(item.getName()) + "_" + msg.getName();
                }
            }
        } else if (item instanceof SAP) {
            result = String.valueOf(item.getName()) + "_" + msg.getName() + "(" + argtext2 + ")";
        } else if (item instanceof SPP) {
            result = index == null ? String.valueOf(item.getName()) + "_" + msg.getName() + "_broadcast(" + argtext2 + ")" : String.valueOf(item.getName()) + "_" + msg.getName() + "(" + index + argtext + ")";
        }
        return result;
    }

    public String getInterfaceItemMessageValue(InterfaceItem item, Message msg, String orig) {
        String result = orig;
        if (item instanceof Port) {
            result = String.valueOf(item.getName()) + "_" + msg.getName();
        }
        return result;
    }

    public String getInterfaceItemOperationText(AbstractInterfaceItem item, PortOperation op, List<String> args, String orig) {
        StringBuilder argtext = new StringBuilder();
        for (String arg : args) {
            argtext.append(", " + arg);
        }
        String argtext2 = argtext.length() == 0 ? "" : argtext.substring(2);
        return String.valueOf(item.getName()) + "_" + op.getName() + "(" + argtext2 + ")";
    }

    public boolean translateTags() {
        return true;
    }

    public String translateTag(String tag, DetailCode code) {
        if (tag.equals("ifitem.index")) {
            return "ifitem_index";
        }
        return super.translateTag(tag, code);
    }

    public boolean translateEnums() {
        return true;
    }

    public String getEnumText(EnumLiteral literal) {
        EnumerationType et = (EnumerationType)literal.eContainer();
        return this.getTranslationSwitch(String.valueOf(et.getName()) + " dot " + literal.getName(), String.valueOf(et.getName()) + "_" + literal.getName());
    }

    private String getTranslationSwitch(String orig, String translated) {
        return "\n#ifdef ET_USE_ORIG_CODE\n" + orig + "\n#else\n" + translated + "\n#endif\n";
    }
}

