/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.Initialization;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.base.IntelligentSeparator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private Initialization attrInitGenAddon;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                String filepath = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String file = this._cExtensions.getCHeaderFileName(nr, ssi);
                this.checkDataPorts(ssi);
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                this.fileIO.generateFile("generating Node declaration", String.valueOf(filepath) + file, this.generateHeaderFile(root, ssi));
                file = this._cExtensions.getCSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node implementation", String.valueOf(filepath) + file, this.generateSourceFile(root, ssi, usedThreads));
                file = this._cExtensions.getInstSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node instance file", String.valueOf(filepath) + file, this.generateInstanceFile(root, ssi, usedThreads));
                file = this._cExtensions.getDispSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node dispatcher file", String.valueOf(filepath) + file, this.generateDispatcherFile(root, ssi, usedThreads));
            }
        }
    }

    private CharSequence generateHeaderFile(Root root, SubSystemInstance ssi) {
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String clsname = String.valueOf(string2) + string3;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of Node ");
        String string4 = nr.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string5 = ssi.getName();
        stringConcatenation2.append(string5, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._cExtensions.generateIncludeGuardBegin(clsname);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etDatatypes.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this.helpers.userCode(ssc.getUserCode1());
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* lifecycle functions");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* init -> start -> run (loop) -> stop -> destroy");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_init(void);\t\t/* lifecycle init  \t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_start(void);\t/* lifecycle start \t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_run(etBool runAsTest);\t\t/* lifecycle run \t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_stop(void); \t/* lifecycle stop\t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_destroy(void); \t/* lifecycle destroy */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_shutdown(void);  /* shutdown the dispatcher loop */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this.helpers.userCode(ssc.getUserCode2());
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._cExtensions.generateIncludeGuardEnd(clsname);
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateSourceFile(Root root, SubSystemInstance ssi, final Collection<PhysicalThread> usedThreads) {
        Object object;
        String string;
        String string2;
        String string3;
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String string4 = nr.getName();
        String string5 = String.valueOf(string4) + "_";
        String string6 = ssi.getName();
        String clsname = String.valueOf(string5) + string6;
        Functions.Function1<PhysicalThread, Boolean> function1 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        boolean logData = this._generatorOptionsHelper.isGenerateDataInstrumentation(Main.getSettings()) && this._roomHelpers.isAnnotationPresent((List)ssc.getAnnotations(), "DataLogging");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of Node ");
        String string7 = nr.getName();
        stringConcatenation2.append(string7, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string8 = ssi.getName();
        stringConcatenation2.append(string8, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include <stdio.h>");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include <string.h>");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string9 = this._cExtensions.getCHeaderFileName(nr, ssi);
        stringConcatenation2.append(string9);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etDataLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etSystemProtocol.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"osal/etTimer.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"osal/etSema.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"runtime/etRuntime.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etRuntimeConfig.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this.helpers.userCode(ssc.getUserCode3());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data for Node ");
        String string10 = nr.getName();
        stringConcatenation2.append(string10);
        stringConcatenation2.append(" with SubSystem ");
        String string11 = ssi.getName();
        stringConcatenation2.append(string11);
        stringConcatenation2.append(" */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("typedef struct ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("char *name;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("volatile int shutdownRequest;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("} ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("Inst = {\"");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("\", 0};");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_initActorInstances(void);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_constructActorInstances(void);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* include instances for all classes */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string12 = this._cExtensions.getInstSourceFileName(nr, ssi);
        stringConcatenation2.append(string12);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("#include \"");
        String string13 = this._cExtensions.getDispSourceFileName(nr, ssi);
        stringConcatenation2.append(string13);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_initMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"initMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("etTime interval;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("/* initialization of all message services */");
        stringConcatenation2.newLine();
        Object object2 = new Functions.Function1<PhysicalThread, Long>(){

            public Long apply(PhysicalThread it) {
                long l = it.getPrio();
                return -l;
            }
        };
        Iterator iterator = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)object2);
        Object object3 = iterator.iterator();
        while (object3.hasNext()) {
            PhysicalThread thread = (PhysicalThread)object3.next();
            if (Objects.equal((Object)thread.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread.getExecmode(), (Object)ExecMode.MIXED)) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("interval.sec = ");
                long l = TimeConverter.split((long)thread.getTime(), (String)"s", (boolean)true);
                stringConcatenation2.append((Object)l, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("interval.nSec = ");
                long l2 = TimeConverter.split((long)thread.getTime(), (String)"ms", (boolean)false);
                stringConcatenation2.append((Object)l2, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("etMessageService_init(");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("&msgService_");
            string3 = thread.getName();
            stringConcatenation2.append(string3, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("msgBuffer_");
            string2 = thread.getName();
            stringConcatenation2.append(string2, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            string = thread.getName().toUpperCase();
            stringConcatenation2.append(string, "\t\t\t");
            stringConcatenation2.append("_POOL_SIZE,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            String string14 = thread.getName().toUpperCase();
            stringConcatenation2.append(string14, "\t\t\t");
            stringConcatenation2.append("_BLOCK_SIZE,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            int n = thread.getStacksize();
            stringConcatenation2.append((Object)n, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            long l = thread.getPrio();
            stringConcatenation2.append((Object)l, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("interval,");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MsgDispatcher_");
            String string15 = thread.getName();
            stringConcatenation2.append(string15, "\t\t\t");
            stringConcatenation2.append("_receiveMessage,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("EXECMODE_");
            String string16 = thread.getExecmode().toString().toUpperCase();
            stringConcatenation2.append(string16, "\t\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_startMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"startMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        object2 = new Functions.Function1<PhysicalThread, Long>(){

            public Long apply(PhysicalThread it) {
                long l = it.getPrio();
                return -l;
            }
        };
        iterator = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)object2);
        object3 = iterator.iterator();
        while (object3.hasNext()) {
            PhysicalThread thread_1 = (PhysicalThread)object3.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etMessageService_start(&msgService_");
            string3 = thread_1.getName();
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_stopMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"stopMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        for (PhysicalThread thread_2 : threads) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etMessageService_stop(&msgService_");
            object = thread_2.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_destroyMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"destroyMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        for (PhysicalThread thread_3 : threads) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etMessageService_destroy(&msgService_");
            object = thread_3.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_init(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"init\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_init\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* construct all actors */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_constructActorInstances();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* initialization of all message services */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_initMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* init all actors */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_initActorInstances();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (logData) {
            for (PhysicalThread thread_4 : threads) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("MsgDispatcher_");
                object = thread_4.getName();
                stringConcatenation2.append((String)object, "\t");
                stringConcatenation2.append("_logDataHeaders();");
                stringConcatenation2.newLineIfNotEmpty();
            }
            for (PhysicalThread thread_5 : threads) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("MsgDispatcher_");
                object = thread_5.getName();
                stringConcatenation2.append((String)object, "\t");
                stringConcatenation2.append("_logData();");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_start(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"start\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_start\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_startMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_run(etBool runAsTest) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("#ifdef ET_RUNNER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"run\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("if (runAsTest) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("etSema_waitForWakeup(etRuntime_getTerminateSemaphore());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("else {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("printf(\"type quit to exit\\n\");");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("fflush(stdout);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("while (ET_TRUE) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("char line[64];");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("if (fgets(line, 64, stdin) != NULL) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("if (strncmp(line, \"quit\", 4)==0)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t\t");
        stringConcatenation2.append("break;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_stop(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"stop\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_stop\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_stopMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_destroy(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"destroy\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_destroy\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        object2 = ssi.getAllContainedInstances();
        for (ActorInstance ai : object2) {
            stringConcatenation2.append("\t");
            object3 = ai.getActorClass();
            string3 = this._roomExtensions.getPathName(ai.getPath());
            string2 = "&" + string3;
            string = this.helpers.invokeUserStructor((RoomClass)object3, string2, false);
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_destroyMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_shutdown(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"shutdown\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_shutdown\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.shutdownRequest = 1;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_constructActorInstances(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"constructActorInstances\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        object2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : object2) {
            stringConcatenation2.append("\t");
            object3 = ai_1.getActorClass();
            string3 = this._roomExtensions.getPathName(ai_1.getPath());
            string2 = "&" + string3;
            string = this.helpers.invokeUserStructor((RoomClass)object3, string2, true);
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_initActorInstances(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"initActorInstances\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        object2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : object2) {
            stringConcatenation2.append("\t");
            object3 = ai_2.getActorClass().getName();
            stringConcatenation2.append((String)object3, "\t");
            stringConcatenation2.append("_init(&");
            string3 = this._roomExtensions.getPathName(ai_2.getPath());
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateInstanceFile(Root root, SubSystemInstance ssi, final Collection<PhysicalThread> usedThreads) {
        String string;
        String string2;
        int n;
        CharSequence charSequence;
        Object object;
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Instance File of Node ");
        String string3 = nr.getName();
        stringConcatenation2.append(string3, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string4 = ssi.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* - instantiation of all actor instances and port instances");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* - configuration of data and connection of ports");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etMessageService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* include all referenced room classes */");
        stringConcatenation2.newLine();
        Object object2 = root.getReferencedActorClasses((RoomClass)ssi.getSubSystemClass());
        Object object3 = root.getReferencedProtocolClasses((RoomClass)ssi.getSubSystemClass());
        Functions.Function1<RoomClass, String> function1 = new Functions.Function1<RoomClass, String>(){

            public String apply(RoomClass it) {
                return it.getName();
            }
        };
        Object object4 = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)object2, (Iterable)object3), (Functions.Function1)function1);
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            RoomClass dc = (RoomClass)object5.next();
            stringConcatenation2.append("#include ");
            object = this._cExtensions.getIncludePath(dc);
            stringConcatenation2.append((String)object);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* instantiation of message services and message buffers */");
        stringConcatenation2.newLine();
        object2 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        object3 = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)object2);
        object4 = object3.iterator();
        while (object4.hasNext()) {
            PhysicalThread thread = (PhysicalThread)object4.next();
            stringConcatenation2.append("/* ");
            charSequence = thread.getName();
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append(" */");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            object5 = thread.getName().toUpperCase();
            stringConcatenation2.append((String)object5);
            stringConcatenation2.append("_POOL_SIZE\t\t");
            int n2 = thread.getMsgpoolsize();
            stringConcatenation2.append((Object)n2);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            String string5 = thread.getName().toUpperCase();
            stringConcatenation2.append(string5);
            stringConcatenation2.append("_BLOCK_SIZE\t");
            n = thread.getMsgblocksize();
            stringConcatenation2.append((Object)n);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("static uint8 msgBuffer_");
            string2 = thread.getName();
            stringConcatenation2.append(string2);
            stringConcatenation2.append("[");
            string = thread.getName().toUpperCase();
            stringConcatenation2.append(string);
            stringConcatenation2.append("_POOL_SIZE * ");
            String string6 = thread.getName().toUpperCase();
            stringConcatenation2.append(string6);
            stringConcatenation2.append("_BLOCK_SIZE];");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("static etMessageService msgService_");
            String string7 = thread.getName();
            stringConcatenation2.append(string7);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* declarations of all ActorClass instances (const and variable structs) */");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* forward declaration of variable actor structs */");
        stringConcatenation2.newLine();
        object2 = ssi.getAllContainedInstances();
        for (ActorInstance ai : object2) {
            stringConcatenation2.append("static ");
            object4 = ai.getActorClass().getName();
            stringConcatenation2.append((String)object4);
            stringConcatenation2.append(" ");
            charSequence = this._roomExtensions.getPathName(ai.getPath());
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* forward declaration of variable port structs */");
        stringConcatenation2.newLine();
        object2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : object2) {
            boolean bl = ai_1.getOrderedIfItemInstances().isEmpty();
            if (bl) {
                stringConcatenation2.append("/* nothing to do */");
                stringConcatenation2.newLine();
                continue;
            }
            charSequence = ai_1.getOrderedIfItemInstances();
            object = charSequence.iterator();
            while (object.hasNext()) {
                int n3;
                InterfaceItemInstance pi = (InterfaceItemInstance)object.next();
                int n4 = this.getPortClassAttributesSize(pi);
                int n5 = n = n4 > 0 ? 1 : 0;
                if (n == 0) continue;
                stringConcatenation2.append("static ");
                string2 = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                stringConcatenation2.append(string2);
                stringConcatenation2.append("_var ");
                string = this._roomExtensions.getPathName(pi.getPath());
                stringConcatenation2.append(string);
                stringConcatenation2.append("_var");
                int n6 = pi.isReplicated();
                if (n6 != 0) {
                    stringConcatenation2.append("[");
                    n3 = pi.getPeers().size();
                    stringConcatenation2.append((Object)n3);
                    stringConcatenation2.append("]");
                }
                stringConcatenation2.append("={");
                stringConcatenation2.newLineIfNotEmpty();
                n6 = 0;
                n3 = pi.getPeers().size();
                boolean bl2 = n3 == 0;
                n6 = bl2 ? 1 : pi.getPeers().size();
                IntegerRange integerRange = new IntegerRange(1, n6);
                boolean bl3 = false;
                Iterator iterator = integerRange.iterator();
                while (iterator.hasNext()) {
                    Integer cfr_ignored_0 = (Integer)iterator.next();
                    if (!bl3) {
                        bl3 = true;
                    } else {
                        stringConcatenation2.appendImmediate((Object)", ", "\t");
                    }
                    stringConcatenation2.append("\t");
                    CharSequence charSequence2 = this.attrInitGenAddon.generateAttributeInit((InstanceBase)pi, (List<Attribute>)this._roomHelpers.getPortClass(pi.getInterfaceItem()).getAttributes());
                    stringConcatenation2.append((Object)charSequence2, "\t");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t\t\t\t\t\t\t");
                }
                stringConcatenation2.append("};");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        object2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : object2) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("/* instance ");
            String string8 = this._roomExtensions.getPathName(ai_2.getPath());
            stringConcatenation2.append(string8);
            stringConcatenation2.append(" */");
            stringConcatenation2.newLineIfNotEmpty();
            if (!this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && ai_2.getOrderedIfItemInstances().isEmpty()) {
                stringConcatenation2.append("/* no ports/saps/services - nothing to initialize statically */");
                stringConcatenation2.newLine();
                continue;
            }
            charSequence = this.genActorInstanceInitializer(root, ai_2);
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private int getPortClassAttributesSize(InterfaceItemInstance pi) {
        int n = 0;
        PortClass portClass = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
        EList eList = null;
        if (portClass != null) {
            eList = portClass.getAttributes();
        }
        EList attribs = eList;
        int n2 = 0;
        n2 = attribs == null ? 0 : attribs.size();
        n = n2;
        return n;
    }

    private CharSequence genActorInstanceInitializer(Root root, ActorInstance ai) {
        CharSequence charSequence;
        Object object;
        Object object2;
        StringConcatenation stringConcatenation = null;
        String instName = this._roomExtensions.getPathName(ai.getPath());
        ArrayList replEventItems = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> function1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                return e.isReplicated();
            }
        };
        Iterables.addAll(replEventItems, (Iterable)IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)function1));
        Functions.Function1<InterfaceItemInstance, Boolean> function12 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean bl = e.getPeers().isEmpty();
                return !bl;
            }
        };
        InterfaceItemInstance interfaceItemInstance = (InterfaceItemInstance)IterableExtensions.findFirst(replEventItems, (Functions.Function1)function12);
        boolean haveReplSubItems = interfaceItemInstance != null;
        Functions.Function1<InterfaceItemInstance, Boolean> function13 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof Port;
            }
        };
        Iterable replEventPorts = IterableExtensions.filter(replEventItems, (Functions.Function1)function13);
        Functions.Function1<InterfaceItemInstance, Boolean> function14 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof SPP;
            }
        };
        Iterable replEventSPPs = IterableExtensions.filter(replEventItems, (Functions.Function1)function14);
        Functions.Function1<InterfaceItemInstance, Boolean> function15 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                return e.isSimple();
            }
        };
        Iterable simplePorts = IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)function15);
        ArrayList simpleEventItems = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> function16 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                CommunicationType communicationType = p.getProtocol().getCommType();
                return Objects.equal((Object)communicationType, (Object)CommunicationType.EVENT_DRIVEN);
            }
        };
        Iterables.addAll(simpleEventItems, (Iterable)IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)function16));
        Functions.Function1<InterfaceItemInstance, Boolean> function17 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof Port;
            }
        };
        Iterable simpleEventPorts = IterableExtensions.filter(simpleEventItems, (Functions.Function1)function17);
        Functions.Function1<InterfaceItemInstance, Boolean> function18 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof SAP;
            }
        };
        Iterable simpleEventSAPs = IterableExtensions.filter(simpleEventItems, (Functions.Function1)function18);
        Functions.Function1<InterfaceItemInstance, Boolean> function19 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                CommunicationType communicationType = p.getProtocol().getCommType();
                return Objects.equal((Object)communicationType, (Object)CommunicationType.DATA_DRIVEN);
            }
        };
        Iterable dataPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)function19);
        Functions.Function1<InterfaceItemInstance, Boolean> function110 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                return p instanceof PortInstance && !((PortInstance)p).getPort().isConjugated();
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)function110);
        Functions.Function1<InterfaceItemInstance, Boolean> function111 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                return p instanceof PortInstance && ((PortInstance)p).getPort().isConjugated();
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)function111);
        HashMap<InterfaceItemInstance, Integer> offsets = new HashMap<InterfaceItemInstance, Integer>();
        int offset = 0;
        for (InterfaceItemInstance p : replEventItems) {
            int n;
            offsets.put(p, offset);
            int n2 = p.getPeers().size();
            offset = n = offset + n2;
        }
        String string = null;
        string = haveReplSubItems ? String.valueOf(instName) + "_repl_sub_ports" : "NULL";
        String replSubPortsArray = string;
        boolean haveConstData = !simpleEventItems.isEmpty() || !IterableExtensions.isEmpty((Iterable)recvPorts) || !replEventItems.isEmpty() || this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        IntelligentSeparator sep = new IntelligentSeparator(",");
        String string2 = null;
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        string2 = bl ? "/*const*/" : "const";
        String const_ = string2;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        boolean bl2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl2) {
            object2 = this.genPeerPortArrays(root, ai);
            stringConcatenation2.append(object2);
            stringConcatenation2.newLineIfNotEmpty();
        }
        if (haveReplSubItems) {
            stringConcatenation2.append("static const etReplSubPort ");
            stringConcatenation2.append(replSubPortsArray);
            stringConcatenation2.append("[");
            stringConcatenation2.append((Object)offset);
            stringConcatenation2.append("] = {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* Replicated Sub Ports: {varData, msgService, peerAddress, localId, index} */");
            stringConcatenation2.newLine();
            Functions.Function1<InterfaceItemInstance, Boolean> function112 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                public Boolean apply(InterfaceItemInstance e) {
                    boolean bl = e.getPeers().isEmpty();
                    return !bl;
                }
            };
            object2 = IterableExtensions.filter(replEventItems, (Functions.Function1)function112);
            boolean bl3 = false;
            object = object2.iterator();
            while (object.hasNext()) {
                InterfaceItemInstance pi = (InterfaceItemInstance)object.next();
                if (!bl3) {
                    bl3 = true;
                } else {
                    stringConcatenation2.appendImmediate((Object)",", "\t");
                }
                stringConcatenation2.append("\t");
                String string3 = this.genReplSubPortInitializers(root, ai, pi);
                stringConcatenation2.append(string3, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
        }
        if (haveConstData) {
            stringConcatenation2.append("static ");
            stringConcatenation2.append(const_);
            stringConcatenation2.append(" ");
            String string4 = ai.getActorClass().getName();
            stringConcatenation2.append(string4);
            stringConcatenation2.append("_const ");
            stringConcatenation2.append(instName);
            stringConcatenation2.append("_const = {");
            stringConcatenation2.newLineIfNotEmpty();
            boolean bl4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl4) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)sep, "\t");
                stringConcatenation2.append("\"");
                String string5 = ai.getPath();
                stringConcatenation2.append(string5, "\t");
                stringConcatenation2.append("\"");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* Ports: {varData, msgService, peerAddress, localId} */");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* simple ports */");
            stringConcatenation2.newLine();
            for (InterfaceItemInstance pi_1 : simpleEventPorts) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)sep, "\t");
                charSequence = this.genPortInitializer(root, ai, pi_1);
                stringConcatenation2.append((String)charSequence, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* data receive ports */");
            stringConcatenation2.newLine();
            for (InterfaceItemInstance pi_2 : recvPorts) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)sep, "\t");
                charSequence = this.genRecvPortInitializer(root, ai, pi_2);
                stringConcatenation2.append((String)charSequence, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* saps */");
            stringConcatenation2.newLine();
            for (InterfaceItemInstance pi_3 : simpleEventSAPs) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)sep, "\t");
                charSequence = this.genPortInitializer(root, ai, pi_3);
                stringConcatenation2.append((String)charSequence, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* replicated ports */");
            stringConcatenation2.newLine();
            for (InterfaceItemInstance pi_4 : replEventPorts) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)sep, "\t");
                stringConcatenation2.append("{");
                int n = pi_4.getPeers().size();
                stringConcatenation2.append((Object)n, "\t");
                stringConcatenation2.append(", ");
                stringConcatenation2.append(replSubPortsArray, "\t");
                stringConcatenation2.append("+");
                object = (Integer)offsets.get(pi_4);
                stringConcatenation2.append(object, "\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* services */");
            stringConcatenation2.newLine();
            for (InterfaceItemInstance pi_5 : replEventSPPs) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append((Object)sep, "\t");
                stringConcatenation2.append("{");
                int n = pi_5.getPeers().size();
                stringConcatenation2.append((Object)n, "\t");
                stringConcatenation2.append(", ");
                stringConcatenation2.append(replSubPortsArray, "\t");
                stringConcatenation2.append("+");
                object = (Integer)offsets.get(pi_5);
                stringConcatenation2.append(object, "\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("static ");
        String string6 = ai.getActorClass().getName();
        stringConcatenation2.append(string6);
        stringConcatenation2.append(" ");
        stringConcatenation2.append(instName);
        stringConcatenation2.append(" = {");
        stringConcatenation2.newLineIfNotEmpty();
        if (haveConstData) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("&");
            stringConcatenation2.append(instName, "\t");
            stringConcatenation2.append("_const,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* data send ports */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_6 : sendPorts) {
            stringConcatenation2.append("\t");
            charSequence = this.genSendPortInitializer(pi_6);
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* attributes */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        CharSequence charSequence2 = this.attrInitGenAddon.generateAttributeInit((InstanceBase)ai, this._roomHelpers.getAllAttributes(ai.getActorClass()));
        stringConcatenation2.append((Object)charSequence2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* state and history are initialized in init function */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genPeerPortArrays(Root root, ActorInstance ai) {
        boolean bl;
        StringConcatenation stringConcatenation = null;
        Functions.Function1<InterfaceItemInstance, Boolean> function1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                return e.isSimple() && e instanceof PortInstance;
            }
        };
        Functions.Function1<InterfaceItemInstance, PortInstance> function12 = new Functions.Function1<InterfaceItemInstance, PortInstance>(){

            public PortInstance apply(InterfaceItemInstance inst) {
                return (PortInstance)inst;
            }
        };
        Iterable simplePorts = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)function1), (Functions.Function1)function12);
        Functions.Function1<PortInstance, Boolean> function13 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance p) {
                return p.getPort().isConjugated() && Objects.equal((Object)p.getProtocol().getCommType(), (Object)CommunicationType.DATA_DRIVEN);
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)function13);
        Functions.Function1<PortInstance, Boolean> function14 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance p) {
                Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

                    public Boolean apply(Message m) {
                        return NodeGen.this._typeHelpers.isEnumeration(m.getData().getRefType().getType()) || NodeGen.this._typeHelpers.isBoolean(m.getData().getRefType().getType());
                    }
                };
                boolean bl = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)NodeGen.this._roomHelpers.getOutgoing((InterfaceItem)p.getPort()), (Functions.Function1)function1));
                return !bl;
            }
        };
        Iterable loggedPorts = IterableExtensions.filter((Iterable)sendPorts, (Functions.Function1)function14);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        boolean bl2 = IterableExtensions.isEmpty((Iterable)loggedPorts);
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            for (PortInstance pi : loggedPorts) {
                stringConcatenation2.append("static const char* ");
                String string = this._roomExtensions.getPathName(pi.getPath());
                stringConcatenation2.append(string);
                stringConcatenation2.append("_peers[");
                int n = pi.getPeers().size();
                int n2 = n + 1;
                stringConcatenation2.append((Object)n2);
                stringConcatenation2.append("] = {");
                stringConcatenation2.newLineIfNotEmpty();
                EList eList = pi.getPeers();
                for (InterfaceItemInstance peer : eList) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\"");
                    EObject eObject = peer.eContainer();
                    String string2 = ((ActorInstance)eObject).getPath();
                    stringConcatenation2.append(string2, "\t");
                    stringConcatenation2.append("\",");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("NULL");
                stringConcatenation2.newLine();
                stringConcatenation2.append("};");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String genPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        String string6 = null;
        int n = 0;
        boolean bl = pi.getPeers().isEmpty();
        n = bl ? 0 : ((InterfaceItemInstance)pi.getPeers().get(0)).getObjId();
        int objId = n;
        int n2 = 0;
        boolean bl2 = pi.getPeers().isEmpty();
        n2 = bl2 ? 0 : ((InterfaceItemInstance)pi.getPeers().get(0)).getPeers().indexOf((Object)pi);
        int idx = n2;
        String string7 = null;
        boolean bl3 = pi.getPeers().isEmpty();
        if (bl3) {
            string7 = "NULL";
        } else {
            EObject eObject = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
            String string8 = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)eObject)).getThread().getName();
            string7 = "&msgService_" + string8;
        }
        String msgSvc = string7;
        String myInst = "";
        String peerInst = "";
        boolean bl4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl4) {
            boolean bl5;
            object = pi.eContainer();
            string5 = ((ActorInstance)object).getPath();
            string4 = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE\n,\"" + string5;
            myInst = string3 = String.valueOf(string4) + "\",";
            string2 = null;
            boolean bl6 = pi.getPeers().isEmpty();
            boolean bl7 = bl5 = !bl6;
            if (bl5) {
                EObject eObject = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
                String string9 = ((ActorInstance)eObject).getPath();
                string = "\"" + string9;
                string2 = String.valueOf(string) + "\"\n#endif\n";
            } else {
                string2 = "\n#endif\n";
            }
            peerInst = string2;
        }
        object = this.getInterfaceItemInstanceData(pi);
        string5 = "{" + (String)object;
        string4 = String.valueOf(string5) + ", ";
        string3 = String.valueOf(string4) + msgSvc;
        string2 = String.valueOf(string3) + ", ";
        String string10 = String.valueOf(string2) + Integer.valueOf(objId + idx);
        String string11 = String.valueOf(string10) + "+BASE_ADDRESS, ";
        int n3 = root.getExpandedActorClass(ai).getInterfaceItemLocalId((AbstractInterfaceItem)pi.getInterfaceItem());
        int n4 = n3 + 1;
        string = String.valueOf(string11) + Integer.valueOf(n4);
        String string12 = String.valueOf(string) + myInst;
        String string13 = String.valueOf(string12) + peerInst;
        String string14 = String.valueOf(string13) + "} /* Port ";
        String string15 = pi.getName();
        String string16 = String.valueOf(string14) + string15;
        string6 = String.valueOf(string16) + " */";
        return string6;
    }

    private CharSequence genSendPortInitializer(InterfaceItemInstance pi) {
        StringConcatenation stringConcatenation = null;
        GeneralProtocolClass generalProtocolClass = ((PortInstance)pi).getPort().getProtocol();
        ProtocolClass pc = (ProtocolClass)generalProtocolClass;
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                MessageData messageData = m.getData();
                return messageData != null;
            }
        };
        Iterable messages = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        Functions.Function1<Message, Boolean> function12 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
            }
        };
        Iterable enumMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)function12);
        Functions.Function1<Message, Boolean> function13 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isBoolean(m.getData().getRefType().getType());
            }
        };
        Iterable boolMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)function13);
        boolean usesMSC = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && (!IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs));
        EObject eObject = pi.eContainer();
        String instName = ((ActorInstance)eObject).getPath();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        Object object = pc.getIncomingMessages();
        boolean bl = false;
        for (Message m : object) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation2.appendImmediate((Object)",", "\t");
            }
            stringConcatenation2.append("\t");
            String string = this._cExtensions.defaultValue(m.getData().getRefType().getType());
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        if (usesMSC) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append(", \"");
            stringConcatenation2.append(instName, "\t\t");
            stringConcatenation2.append("\",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            object = this._roomExtensions.getPathName(pi.getPath());
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append("_peers");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("} /* send port ");
        object = pi.getName();
        stringConcatenation2.append((String)object);
        stringConcatenation2.append(" */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String getInterfaceItemInstanceData(InterfaceItemInstance pi) {
        boolean bl;
        PortClass portClass = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
        boolean bl2 = bl = portClass == null;
        if (bl) {
            return "NULL";
        }
        boolean bl3 = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi)).getAttributes().isEmpty();
        if (bl3) {
            return "NULL";
        }
        String string = this._roomExtensions.getPathName(pi.getPath());
        String string2 = "&" + string;
        return String.valueOf(string2) + "_var";
    }

    private String genRecvPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        boolean bl;
        String string;
        String string2;
        Object object;
        String string3 = null;
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                MessageData messageData = m.getData();
                return messageData != null;
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getIncoming(pi.getInterfaceItem()), (Functions.Function1)function1);
        Functions.Function1<Message, Boolean> function12 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
            }
        };
        Iterable enumMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)function12);
        Functions.Function1<Message, Boolean> function13 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isBoolean(m.getData().getRefType().getType());
            }
        };
        Iterable boolMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)function13);
        boolean usesMSC = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && (!IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs));
        String enumVal = "";
        if (usesMSC) {
            String string4 = ai.getPath();
            String string5 = "\n, \"" + string4;
            object = String.valueOf(string5) + "\"";
            enumVal = object;
            for (Message msg : enumMsgs) {
                string2 = this._cExtensions.defaultValue(msg.getData().getRefType().getType());
                enumVal = string = String.valueOf(enumVal) + "\n, " + string2;
            }
            for (Message msg_1 : boolMsgs) {
                string2 = this._cExtensions.defaultValue(msg_1.getData().getRefType().getType());
                enumVal = string = String.valueOf(enumVal) + "\n, " + string2;
            }
            enumVal = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE" + enumVal + "\n#endif\n";
        }
        if (bl = pi.getPeers().isEmpty()) {
            return "{NULL" + enumVal + "}";
        }
        InterfaceItemInstance peer = (InterfaceItemInstance)pi.getPeers().get(0);
        object = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
        ActorInstance peerInst = (ActorInstance)object;
        String instName = this._roomExtensions.getPathName(peerInst.getPath());
        string2 = peer.getName();
        string = "{&" + instName + "." + string2;
        String string6 = String.valueOf(string) + enumVal;
        string3 = String.valueOf(string6) + "}";
        return string3;
    }

    private String genReplSubPortInitializers(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String string;
        String result = "";
        String string2 = null;
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            EObject eObject = pi.eContainer();
            string = ((ActorInstance)eObject).getPath();
            String string3 = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE\n,\"" + string;
            string2 = String.valueOf(string3) + "\"\n";
        } else {
            string2 = "";
        }
        String myInst = string2;
        string = pi.getPeers();
        Iterator iterator = string.iterator();
        while (iterator.hasNext()) {
            String string4;
            String string5;
            InterfaceItemInstance p = (InterfaceItemInstance)iterator.next();
            int idx = pi.getPeers().indexOf((Object)p);
            String string6 = null;
            int n = pi.getPeers().size();
            int n2 = n - 1;
            boolean bl2 = idx < n2;
            string6 = bl2 ? "," : "";
            String comma = string6;
            EObject eObject = p.eContainer();
            String thread = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)eObject)).getThread().getName();
            String iiiD = this.getInterfaceItemInstanceData(pi);
            String string7 = null;
            boolean bl3 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl3) {
                EObject eObject2 = p.eContainer();
                string5 = ((ActorInstance)eObject2).getPath();
                String string8 = ",\"" + string5;
                string7 = String.valueOf(string8) + "\"\n#endif\n";
            } else {
                string7 = "";
            }
            String peerInst = string7;
            string5 = null;
            boolean bl4 = iiiD.equals("NULL");
            string5 = bl4 ? String.valueOf(iiiD) + "," : String.valueOf(iiiD) + "[" + Integer.valueOf(idx) + "],";
            iiiD = string5;
            int n3 = p.getObjId();
            String string9 = String.valueOf(result) + "{{" + iiiD + "&msgService_" + thread + ", " + Integer.valueOf(n3);
            String string10 = String.valueOf(string9) + "+BASE_ADDRESS, ";
            int n4 = root.getExpandedActorClass(ai).getInterfaceItemLocalId((AbstractInterfaceItem)pi.getInterfaceItem());
            int n5 = n4 + 1;
            String string11 = String.valueOf(string10) + Integer.valueOf(n5);
            String string12 = String.valueOf(string11) + myInst;
            String string13 = String.valueOf(string12) + peerInst;
            String string14 = String.valueOf(string13) + "},";
            String string15 = String.valueOf(string14) + Integer.valueOf(idx);
            String string16 = String.valueOf(string15) + "}";
            String string17 = String.valueOf(string16) + comma;
            String string18 = String.valueOf(string17) + " /* Repl Sub Port ";
            String string19 = pi.getName();
            String string20 = String.valueOf(string18) + string19;
            String string21 = String.valueOf(string20) + " idx +";
            String string22 = String.valueOf(string21) + Integer.valueOf(idx);
            result = string4 = String.valueOf(string22) + "*/\n";
        }
        return result;
    }

    private CharSequence generateDispatcherFile(Root root, SubSystemInstance ssi, final Collection<PhysicalThread> usedThreads) {
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        boolean logData = this._generatorOptionsHelper.isGenerateDataInstrumentation(Main.getSettings()) && this._roomHelpers.isAnnotationPresent((List)ssi.getSubSystemClass().getAnnotations(), "DataLogging");
        ArrayList arrayList = null;
        arrayList = logData ? this.loggedPorts(ssi) : CollectionLiterals.newArrayList((Object[])new PortInstance[0]);
        ArrayList loggedPorts = arrayList;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Dispatcher File of Node ");
        String string = nr.getName();
        stringConcatenation2.append(string, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string2 = ssi.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* contains a generated message dispatcher (receiveMessage) for each MessageService (Thread)");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etMessageReceiver.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        Functions.Function1<PhysicalThread, Boolean> function1 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable iterable = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        boolean bl = false;
        for (final PhysicalThread thread : iterable) {
            boolean bl2;
            Object object;
            Object object2;
            String string3;
            Object object3;
            String string4;
            String string5;
            boolean bl3;
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation2.appendImmediate((Object)"\n", "");
            }
            Functions.Function1<ActorInstance, Boolean> function12 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    PhysicalThread physicalThread = ETMapUtil.getMappedThread((AbstractInstance)ai).getThread();
                    return Objects.equal((Object)physicalThread, (Object)thread);
                }
            };
            Iterable instancesOnThread = IterableExtensions.filter((Iterable)ssi.getAllContainedInstances(), (Functions.Function1)function12);
            stringConcatenation2.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> function13 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    return Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.EVENT_DRIVEN) || Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS);
                }
            };
            Iterable dispatchedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)function13);
            stringConcatenation2.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> function14 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    return Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN) || Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS);
                }
            };
            Iterable executedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)function14);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
            int n = IterableExtensions.size((Iterable)executedInstances);
            boolean bl4 = bl3 = n > 0;
            if (bl3) {
                Object object4;
                stringConcatenation2.append("/**");
                stringConcatenation2.newLine();
                stringConcatenation2.append(" ");
                stringConcatenation2.append("* generated execute function for all cyclic execute calls for the async or datadriven actor instances of thread \"");
                string5 = thread.getName();
                stringConcatenation2.append(string5, " ");
                stringConcatenation2.append("\"");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append(" ");
                stringConcatenation2.append("*/");
                stringConcatenation2.newLine();
                stringConcatenation2.append("static void MsgDispatcher_");
                string4 = thread.getName();
                stringConcatenation2.append(string4);
                stringConcatenation2.append("_poll(void){");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
                String string6 = thread.getName();
                stringConcatenation2.append(string6, "\t");
                stringConcatenation2.append("\", \"execute\")");
                stringConcatenation2.newLineIfNotEmpty();
                for (ActorInstance ai : executedInstances) {
                    stringConcatenation2.append("\t");
                    object3 = ai.getActorClass().getName();
                    stringConcatenation2.append((String)object3, "\t");
                    stringConcatenation2.append("_execute((void*)&");
                    object4 = this._roomExtensions.getPathName(ai.getPath());
                    stringConcatenation2.append((String)object4, "\t");
                    stringConcatenation2.append(");");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
                stringConcatenation2.newLine();
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                if (logData) {
                    stringConcatenation2.append("static void MsgDispatcher_");
                    string3 = thread.getName();
                    stringConcatenation2.append(string3);
                    stringConcatenation2.append("_logDataHeaders(void){");
                    stringConcatenation2.newLineIfNotEmpty();
                    for (PortInstance pi : loggedPorts) {
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("ET_DATA_LOGGER_LOG_STRING(\"");
                        object4 = pi.getPath();
                        stringConcatenation2.append((String)object4, "\t");
                        stringConcatenation2.append("\")");
                        stringConcatenation2.newLineIfNotEmpty();
                    }
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("static void MsgDispatcher_");
                    object2 = thread.getName();
                    stringConcatenation2.append((String)object2);
                    stringConcatenation2.append("_logData(void){");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("ET_DATA_LOGGER_NEW_ROW");
                    stringConcatenation2.newLine();
                    for (PortInstance pi_1 : loggedPorts) {
                        stringConcatenation2.append("\t");
                        object = this.createLoggerCall(pi_1);
                        stringConcatenation2.append((String)object, "\t");
                        stringConcatenation2.newLineIfNotEmpty();
                    }
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                }
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("/**");
            stringConcatenation2.newLine();
            stringConcatenation2.append(" ");
            stringConcatenation2.append("* generated dispatch function for all messages for the thread \"");
            String string7 = thread.getName();
            stringConcatenation2.append(string7, " ");
            stringConcatenation2.append("\"");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append(" ");
            stringConcatenation2.append("*/");
            stringConcatenation2.newLine();
            stringConcatenation2.append("static etBool MsgDispatcher_");
            String string8 = thread.getName();
            stringConcatenation2.append(string8);
            stringConcatenation2.append("_receiveMessage(const etMessage* msg){");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
            string5 = thread.getName();
            stringConcatenation2.append(string5, "\t");
            stringConcatenation2.append("\", \"receiveMessage\")");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("switch(msg->address){");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("case MESSAGESERVICE_ADDRESS:");
            stringConcatenation2.newLine();
            boolean bl5 = IterableExtensions.isEmpty((Iterable)executedInstances);
            boolean bl6 = bl2 = !bl5;
            if (bl2) {
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("if (msg->evtID == etSystemProtocol_IN_poll) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("MsgDispatcher_");
                string3 = thread.getName();
                stringConcatenation2.append(string3, "\t\t\t\t");
                stringConcatenation2.append("_poll();");
                stringConcatenation2.newLineIfNotEmpty();
                if (logData) {
                    stringConcatenation2.append("\t\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("MsgDispatcher_");
                    object2 = thread.getName();
                    stringConcatenation2.append((String)object2, "\t\t\t\t");
                    stringConcatenation2.append("_logData();");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("else");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("if (msg->evtID == etSystemProtocol_IN_terminate)");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t\t\t");
            stringConcatenation2.append("return ET_FALSE;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("break;");
            stringConcatenation2.newLine();
            for (ActorInstance ai_1 : dispatchedInstances) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("/* interface items of ");
                string3 = ai_1.getPath();
                stringConcatenation2.append(string3, "\t\t");
                stringConcatenation2.append(" */");
                stringConcatenation2.newLineIfNotEmpty();
                object2 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                    public Boolean apply(InterfaceItemInstance p) {
                        CommunicationType communicationType = p.getProtocol().getCommType();
                        return Objects.equal((Object)communicationType, (Object)CommunicationType.EVENT_DRIVEN);
                    }
                };
                object3 = IterableExtensions.filter((Iterable)ai_1.getOrderedIfItemInstances(), (Functions.Function1)object2);
                object = object3.iterator();
                while (object.hasNext()) {
                    String string9;
                    String string10;
                    Object object5;
                    Object object6;
                    String string11;
                    String string12;
                    String string13;
                    Object object7;
                    Object object8;
                    InterfaceItemInstance pi_2 = (InterfaceItemInstance)object.next();
                    boolean bl7 = pi_2.isReplicated();
                    if (bl7) {
                        EList eList = pi_2.getPeers();
                        for (InterfaceItemInstance peer : eList) {
                            int n2;
                            String string14;
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("case ");
                            int n3 = pi_2.getObjId();
                            int n4 = pi_2.getPeers().indexOf((Object)peer);
                            int n5 = n3 + n4;
                            stringConcatenation2.append((Object)n5, "\t\t");
                            stringConcatenation2.append("+BASE_ADDRESS:");
                            stringConcatenation2.newLineIfNotEmpty();
                            boolean bl8 = this._roomExtensions.handlesReceive(pi_2.getProtocol(), this._roomExtensions.isConjugated(pi_2));
                            if (bl8) {
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("switch (msg->evtID){");
                                stringConcatenation2.newLine();
                                object8 = this._roomExtensions.getReceiveHandlers(pi_2.getProtocol(), this._roomExtensions.isConjugated(pi_2));
                                object7 = object8.iterator();
                                while (object7.hasNext()) {
                                    MessageHandler h = (MessageHandler)object7.next();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("case ");
                                    string13 = pi_2.getProtocol().getName();
                                    stringConcatenation2.append(string13, "\t\t\t\t");
                                    stringConcatenation2.append("_");
                                    String string15 = this._roomExtensions.getCodeName(h.getMsg());
                                    stringConcatenation2.append(string15, "\t\t\t\t");
                                    stringConcatenation2.append(":");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    string12 = this._roomExtensions.getPortClassName(pi_2.getProtocol(), this._roomExtensions.isConjugated(pi_2));
                                    stringConcatenation2.append(string12, "\t\t\t\t\t");
                                    stringConcatenation2.append("_");
                                    string14 = h.getMsg().getName();
                                    stringConcatenation2.append(string14, "\t\t\t\t\t");
                                    stringConcatenation2.append("_receiveHandler((etPort *)&");
                                    String string16 = this._roomExtensions.getPathName(ai_1.getPath());
                                    stringConcatenation2.append(string16, "\t\t\t\t\t");
                                    stringConcatenation2.append("_const.");
                                    String string17 = pi_2.getName();
                                    stringConcatenation2.append(string17, "\t\t\t\t\t");
                                    stringConcatenation2.append(".ports[");
                                    int n6 = pi_2.getPeers().indexOf((Object)peer);
                                    stringConcatenation2.append((Object)n6, "\t\t\t\t\t");
                                    stringConcatenation2.append("],msg,(void*)&");
                                    String string18 = this._roomExtensions.getPathName(ai_1.getPath());
                                    stringConcatenation2.append(string18, "\t\t\t\t\t");
                                    stringConcatenation2.append(",");
                                    String string19 = ai_1.getActorClass().getName();
                                    stringConcatenation2.append(string19, "\t\t\t\t\t");
                                    stringConcatenation2.append("_receiveMessage);");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("break;");
                                    stringConcatenation2.newLine();
                                }
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("default: ");
                                object8 = ai_1.getActorClass().getName();
                                stringConcatenation2.append((String)object8, "\t\t\t\t");
                                stringConcatenation2.append("_receiveMessage((void*)&");
                                string11 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append(string11, "\t\t\t\t");
                                stringConcatenation2.append(",(etPort*)&");
                                object7 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append((String)object7, "\t\t\t\t");
                                stringConcatenation2.append("_const.");
                                string13 = pi_2.getName();
                                stringConcatenation2.append(string13, "\t\t\t\t");
                                stringConcatenation2.append(".ports[");
                                n2 = pi_2.getPeers().indexOf((Object)peer);
                                stringConcatenation2.append((Object)n2, "\t\t\t\t");
                                stringConcatenation2.append("], msg);");
                                stringConcatenation2.newLineIfNotEmpty();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("break;");
                                stringConcatenation2.newLine();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("}");
                                stringConcatenation2.newLine();
                            } else {
                                boolean bl9 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                                if (bl9) {
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_IN(");
                                    stringConcatenation2.newLine();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    string11 = this._roomExtensions.getPathName(ai_1.getPath());
                                    stringConcatenation2.append(string11, "\t\t\t\t");
                                    stringConcatenation2.append("_const.");
                                    object7 = pi_2.getName();
                                    stringConcatenation2.append((String)object7, "\t\t\t\t");
                                    stringConcatenation2.append(".ports[");
                                    int n7 = pi_2.getPeers().indexOf((Object)peer);
                                    stringConcatenation2.append((Object)n7, "\t\t\t\t");
                                    stringConcatenation2.append("].port.peerInstName,");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    String string20 = pi_2.getProtocol().getName();
                                    stringConcatenation2.append(string20, "\t\t\t\t");
                                    stringConcatenation2.append("_getMessageString(msg->evtID),");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    string12 = this._roomExtensions.getPathName(ai_1.getPath());
                                    stringConcatenation2.append(string12, "\t\t\t\t");
                                    stringConcatenation2.append("_const.");
                                    string14 = pi_2.getName();
                                    stringConcatenation2.append(string14, "\t\t\t\t");
                                    stringConcatenation2.append(".ports[");
                                    int n8 = pi_2.getPeers().indexOf((Object)peer);
                                    stringConcatenation2.append((Object)n8, "\t\t\t\t");
                                    stringConcatenation2.append("].port.myInstName");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append(")");
                                    stringConcatenation2.newLine();
                                }
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                object8 = ai_1.getActorClass().getName();
                                stringConcatenation2.append((String)object8, "\t\t\t");
                                stringConcatenation2.append("_receiveMessage((void*)&");
                                string11 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append(string11, "\t\t\t");
                                stringConcatenation2.append(",&");
                                object7 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append((String)object7, "\t\t\t");
                                stringConcatenation2.append("_const.");
                                string13 = pi_2.getName();
                                stringConcatenation2.append(string13, "\t\t\t");
                                stringConcatenation2.append(".ports[");
                                n2 = pi_2.getPeers().indexOf((Object)peer);
                                stringConcatenation2.append((Object)n2, "\t\t\t");
                                stringConcatenation2.append("].port, msg);");
                                stringConcatenation2.newLineIfNotEmpty();
                            }
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("break;");
                            stringConcatenation2.newLine();
                        }
                        continue;
                    }
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("case ");
                    int n9 = pi_2.getObjId();
                    stringConcatenation2.append((Object)n9, "\t\t");
                    stringConcatenation2.append("+BASE_ADDRESS:");
                    stringConcatenation2.newLineIfNotEmpty();
                    boolean bl10 = this._roomExtensions.handlesReceive(pi_2.getProtocol(), this._roomExtensions.isConjugated(pi_2));
                    if (bl10) {
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("switch (msg->evtID){");
                        stringConcatenation2.newLine();
                        object6 = this._roomExtensions.getReceiveHandlers(pi_2.getProtocol(), this._roomExtensions.isConjugated(pi_2));
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            MessageHandler h_1 = (MessageHandler)object5.next();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("case ");
                            String string21 = pi_2.getProtocol().getName();
                            stringConcatenation2.append(string21, "\t\t\t\t");
                            stringConcatenation2.append("_");
                            String string22 = this._roomExtensions.getCodeName(h_1.getMsg());
                            stringConcatenation2.append(string22, "\t\t\t\t");
                            stringConcatenation2.append(":");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            object8 = this._roomExtensions.getPortClassName(pi_2.getProtocol(), this._roomExtensions.isConjugated(pi_2));
                            stringConcatenation2.append((String)object8, "\t\t\t\t\t");
                            stringConcatenation2.append("_");
                            string11 = h_1.getMsg().getName();
                            stringConcatenation2.append(string11, "\t\t\t\t\t");
                            stringConcatenation2.append("_receiveHandler((etPort *)&");
                            object7 = this._roomExtensions.getPathName(ai_1.getPath());
                            stringConcatenation2.append((String)object7, "\t\t\t\t\t");
                            stringConcatenation2.append("_const.");
                            string13 = pi_2.getName();
                            stringConcatenation2.append(string13, "\t\t\t\t\t");
                            stringConcatenation2.append(",msg,(void*)&");
                            String string23 = this._roomExtensions.getPathName(ai_1.getPath());
                            stringConcatenation2.append(string23, "\t\t\t\t\t");
                            stringConcatenation2.append(",");
                            string12 = ai_1.getActorClass().getName();
                            stringConcatenation2.append(string12, "\t\t\t\t\t");
                            stringConcatenation2.append("_receiveMessage);");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("break;");
                            stringConcatenation2.newLine();
                        }
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("default: ");
                        object6 = ai_1.getActorClass().getName();
                        stringConcatenation2.append((String)object6, "\t\t\t\t");
                        stringConcatenation2.append("_receiveMessage((void*)&");
                        string10 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append(string10, "\t\t\t\t");
                        stringConcatenation2.append(",(etPort*)&");
                        object5 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append((String)object5, "\t\t\t\t");
                        stringConcatenation2.append("_const.");
                        string9 = pi_2.getName();
                        stringConcatenation2.append(string9, "\t\t\t\t");
                        stringConcatenation2.append(", msg);");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("break;");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("}");
                        stringConcatenation2.newLine();
                    } else {
                        boolean bl11 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                        if (bl11) {
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_IN(");
                            stringConcatenation2.newLine();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("((etPort*)&");
                            String string24 = this._roomExtensions.getPathName(ai_1.getPath());
                            stringConcatenation2.append(string24, "\t\t\t\t");
                            stringConcatenation2.append("_const.");
                            String string25 = pi_2.getName();
                            stringConcatenation2.append(string25, "\t\t\t\t");
                            stringConcatenation2.append(")->peerInstName,");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            String string26 = pi_2.getProtocol().getName();
                            stringConcatenation2.append(string26, "\t\t\t\t");
                            stringConcatenation2.append("_getMessageString(msg->evtID),");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("((etPort*)&");
                            String string27 = this._roomExtensions.getPathName(ai_1.getPath());
                            stringConcatenation2.append(string27, "\t\t\t\t");
                            stringConcatenation2.append("_const.");
                            object8 = pi_2.getName();
                            stringConcatenation2.append((String)object8, "\t\t\t\t");
                            stringConcatenation2.append(")->myInstName");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append(")");
                            stringConcatenation2.newLine();
                        }
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        object6 = ai_1.getActorClass().getName();
                        stringConcatenation2.append((String)object6, "\t\t\t");
                        stringConcatenation2.append("_receiveMessage((void*)&");
                        string10 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append(string10, "\t\t\t");
                        stringConcatenation2.append(",(etPort*)&");
                        object5 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append((String)object5, "\t\t\t");
                        stringConcatenation2.append("_const.");
                        string9 = pi_2.getName();
                        stringConcatenation2.append(string9, "\t\t\t");
                        stringConcatenation2.append(", msg);");
                        stringConcatenation2.newLineIfNotEmpty();
                    }
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("break;");
                    stringConcatenation2.newLine();
                }
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("default:");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("etLogger_logErrorF(\"MessageService_");
            string4 = thread.getName();
            stringConcatenation2.append(string4, "\t\t\t");
            stringConcatenation2.append("_receiveMessage: address %d does not exist \", msg->address);");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("break;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return ET_TRUE;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String createLoggerCall(PortInstance pi) {
        String string = null;
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return m.getData() != null && NodeGen.this._typeHelpers.isEnumerationOrPrimitive(m.getData().getRefType().getType());
            }
        };
        Message msg = ((Message[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)pi.getProtocol().getIncomingMessages(), (Functions.Function1)function1), Message.class))[0];
        EObject eObject = pi.eContainer();
        ActorInstance ai = (ActorInstance)eObject;
        String string2 = this._roomExtensions.getPathName(ai.getPath());
        String string3 = String.valueOf(string2) + ".";
        String string4 = pi.getName();
        String string5 = String.valueOf(string3) + string4;
        String string6 = String.valueOf(string5) + ".";
        String string7 = msg.getName();
        String data = String.valueOf(string6) + string7;
        LiteralType literalType = null;
        DataType dataType = msg.getData().getRefType().getType();
        if (dataType instanceof EnumerationType) {
            literalType = LiteralType.INT;
        } else {
            DataType dataType2 = msg.getData().getRefType().getType();
            literalType = ((PrimitiveType)dataType2).getType();
        }
        LiteralType type = literalType;
        String string8 = null;
        if (type != null) {
            switch (type) {
                case BOOL: {
                    string8 = "ET_DATA_LOGGER_LOG_BOOL((int)" + data + ")";
                    break;
                }
                case CHAR: {
                    string8 = "ET_DATA_LOGGER_LOG_INT((int)" + data + ")";
                    break;
                }
                case INT: {
                    string8 = "ET_DATA_LOGGER_LOG_INT((int)" + data + ")";
                    break;
                }
                case REAL: {
                    string8 = "ET_DATA_LOGGER_LOG_DOUBLE((double)" + data + ")";
                    break;
                }
                default: {
                    string8 = "internal error: unknown primitive type";
                    break;
                }
            }
        } else {
            string8 = "internal error: unknown primitive type";
        }
        string = string8;
        return string;
    }

    private ArrayList<PortInstance> loggedPorts(SubSystemInstance ssi) {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new PortInstance[0]);
        boolean bl = this._roomHelpers.isAnnotationPresent((List)ssi.getSubSystemClass().getAnnotations(), "DataLogging");
        if (bl) {
            this.logger.logInfo("Data Logging is configured by annotation");
            String filters = this._roomHelpers.getAttribute((List)ssi.getSubSystemClass().getAnnotations(), "DataLogging", "pathlist");
            String[] filterList = filters.split(",");
            String[] stringArray = filterList;
            int n = filterList.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                this.logger.logInfo("  filter: " + filter);
                ++n2;
            }
            ArrayList notLogged = CollectionLiterals.newArrayList((Object[])new String[0]);
            this.logger.logInfo("  logged ports:");
            TreeIterator iter = ssi.eAllContents();
            while (iter.hasNext()) {
                CommunicationType communicationType;
                boolean bl2;
                boolean bl3;
                EObject obj = (EObject)iter.next();
                if (!(obj instanceof PortInstance)) continue;
                PortInstance pi = (PortInstance)obj;
                boolean bl4 = this._roomHelpers.isRelay(pi.getPort());
                boolean bl5 = bl3 = !bl4;
                if (!bl3 || !(bl2 = Objects.equal((Object)(communicationType = pi.getProtocol().getCommType()), (Object)CommunicationType.DATA_DRIVEN))) continue;
                boolean bl6 = pi.getPort().isConjugated();
                if (bl6) {
                    String string;
                    String path = pi.getPath();
                    boolean matched = false;
                    boolean primitive = false;
                    String[] stringArray2 = filterList;
                    int n3 = filterList.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filter_1 = stringArray2[n4];
                        boolean bl7 = path.matches(filter_1);
                        if (bl7) {
                            boolean bl8;
                            matched = true;
                            Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

                                public Boolean apply(Message m) {
                                    return m.getData() != null && NodeGen.this._typeHelpers.isEnumerationOrPrimitive(m.getData().getRefType().getType());
                                }
                            };
                            boolean bl9 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)pi.getProtocol().getIncomingMessages(), (Functions.Function1)function1));
                            boolean bl10 = bl8 = !bl9;
                            if (bl8) {
                                result.add(pi);
                                primitive = true;
                                String string2 = pi.getPath();
                                String string3 = "    data driven port " + string2;
                                String string4 = String.valueOf(string3) + " (matched ";
                                String string5 = String.valueOf(string4) + filter_1;
                                String string6 = String.valueOf(string5) + ")";
                                this.logger.logInfo(string6);
                            }
                        }
                        ++n4;
                    }
                    if (primitive) continue;
                    if (matched) {
                        string = pi.getPath();
                        String string7 = "    data driven port " + string;
                        String string8 = String.valueOf(string7) + " (matched but contains no primitive data)";
                        notLogged.add(string8);
                        continue;
                    }
                    string = pi.getPath();
                    String string9 = "    data driven port " + string;
                    String string10 = String.valueOf(string9) + " (no match found)";
                    notLogged.add(string10);
                    continue;
                }
                String string = pi.getPath();
                String string11 = "    data driven port " + string;
                String string12 = String.valueOf(string11) + " (receive port)";
                notLogged.add(string12);
            }
            this.logger.logInfo("  NOT logged ports:");
            for (String nl : notLogged) {
                this.logger.logInfo(nl);
            }
        }
        return result;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> found = new HashSet<String>();
        EList eList = comp.getAllContainedInstances();
        for (ActorInstance ai : eList) {
            int thread = ai.getThreadId();
            EList eList2 = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : eList2) {
                CommunicationType communicationType = pi.getProtocol().getCommType();
                boolean bl = Objects.equal((Object)communicationType, (Object)CommunicationType.DATA_DRIVEN);
                if (!bl) continue;
                EList eList3 = pi.getPeers();
                for (InterfaceItemInstance peer : eList3) {
                    boolean bl2;
                    EObject eObject = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)eObject;
                    int peer_thread = peer_ai.getThreadId();
                    if (thread == peer_thread) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String string = null;
                    int n = path.compareTo(ppath);
                    boolean bl3 = n < 0;
                    string = bl3 ? String.valueOf(path) + " and " + ppath : String.valueOf(ppath) + " and " + path;
                    String pair = string;
                    boolean bl4 = found.contains(pair);
                    boolean bl5 = bl2 = !bl4;
                    if (!bl2) continue;
                    found.add(pair);
                    this._cExtensions.diagnostician.error(String.valueOf(pair) + ": data ports placed on different threads (not supported yet)", (EObject)pi.getInterfaceItem(), pi.getInterfaceItem().eContainingFeature());
                }
            }
        }
    }
}

