/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.etrice.core.common.base.util.BaseHelpers;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private BaseHelpers _baseHelpers;
    @Inject
    @Extension
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public void doGenerate(Root root) {
        boolean first = true;
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                String string = nr.getName();
                String string2 = String.valueOf(string) + "_";
                String string3 = ssi.getName();
                String clsname = String.valueOf(string2) + string3;
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String file = String.valueOf(clsname) + "_Runner.c";
                this.fileIO.generateFile("generating Node runner file", String.valueOf(path) + file, this.generateSourceFile(root, ssi, first));
                first = false;
            }
        }
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssi, boolean first) {
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String clsname = String.valueOf(string2) + string3;
        boolean logData = this._generatorOptionsHelper.isGenerateDataInstrumentation(Main.getSettings()) && this._baseHelpers.isAnnotationPresent((List)ssi.getSubSystemClass().getAnnotations(), "DataLogging");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* this class contains the main function running Node ");
        String string4 = nr.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string5 = ssi.getName();
        stringConcatenation2.append(string5, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* it instantiates Node ");
        String string6 = nr.getName();
        stringConcatenation2.append(string6, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string7 = ssi.getName();
        stringConcatenation2.append(string7, " ");
        stringConcatenation2.append(" and starts and ends the lifecycle");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include <string.h>");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string8 = this._cExtensions.getCHeaderFileName(nr, ssi);
        stringConcatenation2.append(string8);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etDataLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"osal/etPlatformLifecycle.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* ");
        String string9 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        stringConcatenation2.append(string9, " ");
        stringConcatenation2.append(" function");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* creates components and starts and stops the lifecycle");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("int ");
        String string10 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        stringConcatenation2.append(string10);
        stringConcatenation2.append("(int argc, char** argv) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etBool runAsTest = ET_FALSE;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#ifdef ET_DO_NOT_USE_ARGC_ARGV");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#else");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("if (argc>1 && strcmp(argv[1], \"-headless\")==0)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("runAsTest = ET_TRUE;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("if (argc>1 && strcmp(argv[1], \"-run_as_test\")==0)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("runAsTest = ET_TRUE;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#endif\t\t");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etUserEntry(); /* platform specific */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfo(\"***   T H E   B E G I N   ***\");");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_OPEN(\"main\");");
        stringConcatenation2.newLine();
        if (logData) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_DATA_LOGGER_OPEN(\"main\");");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* startup sequence  of lifecycle */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_init(); \t\t/* lifecycle init */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_start(); \t/* lifecycle start */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etUserPreRun(); /* platform specific */");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* run Scheduler */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_run(runAsTest);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etUserPostRun(); /* platform specific */");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* shutdown sequence of lifecycle */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_stop(); \t\t/* lifecycle stop */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_destroy(); \t/* lifecycle destroy */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (logData) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_DATA_LOGGER_CLOSE");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_CLOSE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfo(\"***   T H E   E N D   ***\");");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etUserExit(); /* platform specific */");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("return 0;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

