/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.gnuplot;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class GnuplotScriptGenerator {
    @Inject
    private IGeneratorFileIO fileIo;

    public void doGenerate(Root root) {
        boolean bl;
        boolean bl2 = root.getSubSystemInstances().isEmpty();
        if (bl2) {
            return;
        }
        SubSystemInstance ssi = (SubSystemInstance)IterableExtensions.head((Iterable)root.getSubSystemInstances());
        Functions.Function1<Annotation, Boolean> function1 = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation a) {
                String string = a.getType().getName();
                return Objects.equal((Object)string, (Object)"Gnuplot");
            }
        };
        boolean bl3 = IterableExtensions.exists((Iterable)ssi.getSubSystemClass().getAnnotations(), (Functions.Function1)function1);
        boolean bl4 = bl = !bl3;
        if (bl) {
            return;
        }
        try {
            String string = ssi.getName();
            String string2 = "Generating gnuplot script for subsystem " + string;
            this.fileIo.generateFile(string2, "/gnuplot/main.data.csv-script.plt", this.generatePlotScript(ssi));
            this.fileIo.generateFile("Generating gnuplot launch configuration", "/gnuplot/create_gnuplot.launch", this.gnuPlotLaunchFile());
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception cfr_ignored_0 = (Exception)throwable;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    protected CharSequence gnuPlotLaunchFile() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        stringConcatenation.newLine();
        stringConcatenation.append("<launchConfiguration type=\"org.eclipse.ui.externaltools.ProgramLaunchConfigurationType\">");
        stringConcatenation.newLine();
        stringConcatenation.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE\" value=\"${none}\"/>");
        stringConcatenation.newLine();
        stringConcatenation.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_LOCATION\" value=\"${system_path:gnuplot}\"/>");
        stringConcatenation.newLine();
        stringConcatenation.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS\" value=\"${project_loc}/src-gen/gnuplot/main.data.csv-script.plt\"/>");
        stringConcatenation.newLine();
        stringConcatenation.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY\" value=\"${project_loc}\"/>");
        stringConcatenation.newLine();
        stringConcatenation.append("</launchConfiguration>");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    protected KeyValue getAttribute(Annotation anno, final String name) {
        Functions.Function1<KeyValue, Boolean> function1 = new Functions.Function1<KeyValue, Boolean>(){

            public Boolean apply(KeyValue attr) {
                String string = attr.getKey();
                return Objects.equal((Object)string, (Object)name);
            }
        };
        return (KeyValue)IterableExtensions.findFirst((Iterable)anno.getAttributes(), (Functions.Function1)function1);
    }

    protected String asString(KeyValue kv) {
        String string = null;
        Literal literal = kv.getValue();
        if (literal instanceof StringLiteral) {
            Literal literal2 = kv.getValue();
            string = ((StringLiteral)literal2).getValue();
        } else {
            string = null;
        }
        return string;
    }

    protected Double asReal(KeyValue kv) {
        Double d = null;
        Literal literal = kv.getValue();
        if (literal instanceof RealLiteral) {
            Literal literal2 = kv.getValue();
            d = ((RealLiteral)literal2).getValue();
        } else {
            Double d2 = null;
            Literal literal3 = kv.getValue();
            if (literal3 instanceof IntLiteral) {
                Literal literal4 = kv.getValue();
                long l = ((IntLiteral)literal4).getValue();
                d2 = l;
            } else {
                d2 = null;
            }
            d = d2;
        }
        return d;
    }

    protected Long asInteger(KeyValue kv) {
        Long l = null;
        Literal literal = kv.getValue();
        if (literal instanceof IntLiteral) {
            Literal literal2 = kv.getValue();
            l = ((IntLiteral)literal2).getValue();
        } else {
            l = null;
        }
        return l;
    }

    protected CharSequence generatePlotScript(SubSystemInstance ssi) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#!/gnuplot");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("# Color Brewer set1 5-set");
        stringConcatenation.newLine();
        stringConcatenation.append("set linetype 1 lc rgb '#e41a1c' lw 1");
        stringConcatenation.newLine();
        stringConcatenation.append("set linetype 2 lc rgb '#377eb8' lw 1");
        stringConcatenation.newLine();
        stringConcatenation.append("set linetype 3 lc rgb '#4daf4a' lw 1");
        stringConcatenation.newLine();
        stringConcatenation.append("set linetype 4 lc rgb '#984ea3' lw 1");
        stringConcatenation.newLine();
        stringConcatenation.append("set linetype 5 lc rgb '#ff7f00' lw 1");
        stringConcatenation.newLine();
        stringConcatenation.append("set linetype cycle 5");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("cd 'log'");
        stringConcatenation.newLine();
        stringConcatenation.append("set datafile separator comma");
        stringConcatenation.newLine();
        stringConcatenation.append("set terminal \u00ef\u00bf\u00bdformat\u00ef\u00bf\u00bd size \u00ef\u00bf\u00bdwidth\u00ef\u00bf\u00bd,\u00ef\u00bf\u00bdheight\u00ef\u00bf\u00bd font \",\u00ef\u00bf\u00bdfontsize\u00ef\u00bf\u00bd\" background \"white\"");
        stringConcatenation.newLine();
        stringConcatenation.append("set output '\u00ef\u00bf\u00bdoutputfile\u00ef\u00bf\u00bd'");
        stringConcatenation.newLine();
        stringConcatenation.append("set size 1,1");
        stringConcatenation.newLine();
        stringConcatenation.append("set multiplot layout \u00ef\u00bf\u00bdgraphAnnotations.size\u00ef\u00bf\u00bd,1");
        stringConcatenation.newLine();
        stringConcatenation.append("set grid");
        stringConcatenation.newLine();
        stringConcatenation.append("show grid");
        stringConcatenation.newLine();
        stringConcatenation.append("set format y \"% 5.3f\"");
        stringConcatenation.newLine();
        stringConcatenation.append("\u00ef\u00bf\u00bdvar i = 0\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("\u00ef\u00bf\u00bdFOR a : graphAnnotations\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("\u00ef\u00bf\u00bdssi.generateGraph(a, i++, graphAnnotations.size)\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("\u00ef\u00bf\u00bdENDFOR\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("unset multiplot");
        stringConcatenation.newLine();
        stringConcatenation.append("unset output");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    protected CharSequence generateGraph(SubSystemInstance ssi, Annotation graph, int index, int total) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("set yrange [\u00ef\u00bf\u00bdymin ?: \"*\"\u00ef\u00bf\u00bd : \u00ef\u00bf\u00bdymax ?: \"*\"\u00ef\u00bf\u00bd]");
        stringConcatenation.newLine();
        stringConcatenation.append("set xtics rotate \u00ef\u00bf\u00bdxtics\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("set mxtics \u00ef\u00bf\u00bdmxtics\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("set ylabel");
        stringConcatenation.newLine();
        stringConcatenation.append("set xlabel \"time (ms)\"");
        stringConcatenation.newLine();
        stringConcatenation.append("timeInMs(x) = \u00ef\u00bf\u00bdinterval\u00ef\u00bf\u00bd * x");
        stringConcatenation.newLine();
        stringConcatenation.append("set origin 0,\u00ef\u00bf\u00bdvertOrigin\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("set size 1,\u00ef\u00bf\u00bdvertSize\u00ef\u00bf\u00bd");
        stringConcatenation.newLine();
        stringConcatenation.append("plot 'main.data.csv' using (timeInMs(column(1))):(column(\"\u00ef\u00bf\u00bdpaths\u00ef\u00bf\u00bd\")) with lines");
        stringConcatenation.newLine();
        return stringConcatenation;
    }
}

