/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.FileSystemHelpers;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private IGeneratorFileIo fileIO;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                boolean _notEquals;
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)ssi, null);
                if (!_notEquals) {
                    _and = false;
                } else {
                    boolean _isValidGenerationLocation;
                    SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                    _and = _isValidGenerationLocation = this._fileSystemHelpers.isValidGenerationLocation((EObject)_subSystemClass);
                }
                if (!_and) continue;
                String _javaClassName = this._javaExtensions.getJavaClassName(nr, ssi);
                String file = String.valueOf(_javaClassName) + "Runner.java";
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)_subSystemClass_1);
                SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
                String _path = this.roomExt.getPath((RoomClass)_subSystemClass_2);
                String filepath = String.valueOf(_generationTargetPath) + _path;
                SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
                String _generationInfoPath = this.roomExt.getGenerationInfoPath((EObject)_subSystemClass_3);
                SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
                String _path_1 = this.roomExt.getPath((RoomClass)_subSystemClass_4);
                String infopath = String.valueOf(_generationInfoPath) + _path_1;
                CharSequence _generate = this.generate(root, ssi);
                this.fileIO.generateFile("generating SubSystemRunner implementation", filepath, infopath, file, _generate);
            }
        }
    }

    public CharSequence generate(Root root, SubSystemInstance ssc) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._javaExtensions.getJavaClassName(nr, ssc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        String _package = this.roomExt.getPackage((RoomClass)cc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.RTSystem;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)(String.valueOf(clsname) + "Runner"), "");
        _builder.append((Object)" extends SubSystemRunnerBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* main function");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* creates the main component and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void main(String[] args) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// instantiate the main component");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"RTSystem sys = ");
        EObject _eContainer = ssc.eContainer();
        if (_eContainer instanceof SystemInstance) {
            _builder.append((Object)"new RTSystem(\"");
            EObject _eContainer_1 = ssc.eContainer();
            String _name_2 = ((SystemInstance)_eContainer_1).getName();
            _builder.append((Object)_name_2, "\t\t");
            _builder.append((Object)"\")");
        } else {
            _builder.append((Object)"null");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)" main_component = new ");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"(sys, \"");
        String _name_3 = ssc.getName();
        _builder.append((Object)_name_3, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"run(main_component, args);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

