/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.FileSystemHelpers;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.DataClassGen;
import org.eclipse.etrice.generator.java.gen.GlobalSettings;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private DataClassGen _dataClassGen;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        Functions.Function1<ProtocolClass, Boolean> _function = new Functions.Function1<ProtocolClass, Boolean>(){

            public Boolean apply(ProtocolClass cl) {
                return ProtocolClassGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)cl);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_usedProtocolClasses, (Functions.Function1)_function);
        for (ProtocolClass pc : _filter) {
            CharSequence contents;
            String _string;
            boolean _isEmpty;
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)pc);
            String _path = this._roomExtensions.getPath((RoomClass)pc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)pc);
            String _path_1 = this._roomExtensions.getPath((RoomClass)pc);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            String file = this._javaExtensions.getJavaFileName((RoomClass)pc);
            CharSequence _switchResult = null;
            CommunicationType _commType = pc.getCommType();
            if (_commType != null) {
                switch (_commType) {
                    case EVENT_DRIVEN: {
                        _switchResult = this.generate(root, pc);
                        break;
                    }
                    case DATA_DRIVEN: {
                        _switchResult = this.generateDataDriven(root, pc);
                        break;
                    }
                    case SYNCHRONOUS: {
                        _switchResult = "";
                        break;
                    }
                }
            }
            if (_isEmpty = (_string = (contents = _switchResult).toString()).isEmpty()) {
                this.logger.logError("synchronous protocols not supported yet", (EObject)pc);
                continue;
            }
            this.fileIO.generateFile("generating ProtocolClass implementation", path, infopath, file, contents);
        }
    }

    public CharSequence generate(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)pc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.Message;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.EventMessage;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.EventWithDataMessage;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.IInterfaceItemOwner;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.PortBase;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.ReplicatedPortBase;");
        _builder.newLine();
        GlobalSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (_generateMSCInstrumentation) {
            _builder.append((Object)"import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            _builder.newLine();
        }
        _builder.append((Object)"import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList models = root.getReferencedModels((RoomClass)pc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = pc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// message IDs");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append((Object)_genMessageIDs, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static String messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = RoomHelpers.getAllOutgoingMessages((ProtocolClass)pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append((Object)"\"");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)" ");
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append((Object)"\"");
            String _name_3 = m_1.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)"\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getMessageString(int msg_id) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (msg_id<MSG_MIN || msg_id>MSG_MAX+1){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// id out of range");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"else{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return messageStrings[msg_id];");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _portClass = this.portClass(pc, false);
        _builder.append((Object)_portClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _portClass_1 = this.portClass(pc, true);
        _builder.append((Object)_portClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence portClass(ProtocolClass pc, Boolean conj) {
        boolean _notEquals_2;
        boolean _handlesReceive;
        GlobalSettings _settings;
        boolean _generateMSCInstrumentation;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this._roomExtensions.getPortClass(pc, conj.booleanValue());
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue(), true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"// port class");
        _builder.newLine();
        _builder.append((Object)"static public class ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)" extends PortBase {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)pclass, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _userCode = pclass.getUserCode();
            CharSequence _userCode_1 = this._procedureHelpers.userCode(_userCode);
            _builder.append((Object)_userCode_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructors");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)"(IInterfaceItemOwner actor, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this(actor, name, localId, 0);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)"(IInterfaceItemOwner actor, String name, int localId, int idx) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(actor, name, localId, idx);");
        _builder.newLine();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pclass, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t\t");
            EList _attributes = pclass.getAttributes();
            CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)_attributes, (EObject)pclass, true);
            _builder.append((Object)_attributeInitialization, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        if (_generateMSCInstrumentation = (_settings = Main.getSettings()).generateMSCInstrumentation()) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"DebuggingService.getInstance().addPortInstance(this);");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GlobalSettings _settings_1 = Main.getSettings();
        boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
        if (_generateMSCInstrumentation_1) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void destroy() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().removePortInstance(this);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"super.destroy();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void receive(Message m) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!(m instanceof EventMessage))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"EventMessage msg = (EventMessage) m;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (0 < msg.getEvtId() && msg.getEvtId() < MSG_MAX) {");
        _builder.newLine();
        GlobalSettings _settings_2 = Main.getSettings();
        boolean _generateMSCInstrumentation_2 = _settings_2.generateMSCInstrumentation();
        if (_generateMSCInstrumentation_2) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"DebuggingService.getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), messageStrings[msg.getEvtId()]);");
            _builder.newLine();
        }
        if (_handlesReceive = this._roomExtensions.handlesReceive(pc, conj.booleanValue())) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"switch (msg.getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, conj.booleanValue());
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"case ");
                Message _msg = hdlr.getMsg();
                String _codeName = this._roomExtensions.getCodeName(_msg);
                _builder.append((Object)_codeName, "\t\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                DetailCode _detailCode = hdlr.getDetailCode();
                EList _lines = _detailCode.getLines();
                for (String command : _lines) {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)command, "\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (msg instanceof EventWithDataMessage)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"getActor().receiveEvent(this, msg.getEvtId(), ((EventWithDataMessage)msg).getData());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"getActor().receiveEvent(this, msg.getEvtId(), null);");
        _builder.newLine();
        boolean _handlesReceive_1 = this._roomExtensions.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive_1) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)pclass, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            EList _attributes_1 = pclass.getAttributes();
            CharSequence _attributes_2 = this._procedureHelpers.attributes((List)_attributes_1);
            _builder.append((Object)_attributes_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _attributes_3 = pclass.getAttributes();
            CharSequence _attributeSettersGettersImplementation = this._procedureHelpers.attributeSettersGettersImplementation((List)_attributes_3, null);
            _builder.append((Object)_attributeSettersGettersImplementation, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _operations = pclass.getOperations();
            CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)_operations, portClassName);
            _builder.append((Object)_operationsImplementation, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// sent messages");
        _builder.newLine();
        List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
        for (Message m : _allMessages) {
            _builder.append((Object)"\t");
            CharSequence _sendMessage = this.sendMessage(m, conj);
            _builder.append((Object)_sendMessage, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// replicated port class");
        _builder.newLine();
        _builder.append((Object)"static public class ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)" extends ReplicatedPortBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)replPortClassName, "\t");
        _builder.append((Object)"(IInterfaceItemOwner actor, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(actor, name, localId);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getReplication() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return getNInterfaceItems();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getIndexOf(InterfaceItemBase ifitem){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ifitem.getIdx();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)" get(int idx) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)") getInterfaceItem(idx);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected InterfaceItemBase createInterfaceItem(IInterfaceItemOwner rcv, String name, int lid, int idx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new ");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)"(rcv, name, lid, idx);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        if (conj.booleanValue()) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
            for (Message m_1 : _allIncomingMessages) {
                _builder.append((Object)"\t");
                CharSequence _messageSignature = this.messageSignature(m_1);
                _builder.append((Object)_messageSignature, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"for (InterfaceItemBase item : getItems()) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"((");
                _builder.append((Object)portClassName, "\t\t\t");
                _builder.append((Object)")item).");
                CharSequence _messageCall = this.messageCall(m_1);
                _builder.append((Object)_messageCall, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = RoomHelpers.getAllOutgoingMessages((ProtocolClass)pc);
            for (Message m_2 : _allOutgoingMessages) {
                _builder.append((Object)"\t");
                CharSequence _messageSignature_1 = this.messageSignature(m_2);
                _builder.append((Object)_messageSignature_1, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"for (InterfaceItemBase item : getItems()) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"((");
                _builder.append((Object)portClassName, "\t\t\t");
                _builder.append((Object)")item).");
                CharSequence _messageCall_1 = this.messageCall(m_2);
                _builder.append((Object)_messageCall_1, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageSignature(Message m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPriv = m.isPriv();
        if (_isPriv) {
            _builder.append((Object)"private");
        } else {
            _builder.append((Object)"public");
        }
        _builder.append((Object)" void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            VarDecl _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence messageSignatureExplicit(Message m) {
        StringConcatenation _xblockexpression = null;
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        DataType _type = _refType.getType();
        DataClass dc = (DataClass)_type;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        String _argList = this._dataClassGen.argList(dc);
        _builder.append((Object)_argList, "");
        _builder.append((Object)")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageCall(Message m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            _builder.append((Object)" ");
            VarDecl _data_1 = m.getData();
            String _name_1 = _data_1.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence sendMessage(Message m, boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        MessageHandler hdlr = this._roomExtensions.getSendHandler(m, conj);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageSignature = this.messageSignature(m);
        _builder.append((Object)_messageSignature, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)hdlr, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _detailCode = hdlr.getDetailCode();
            EList _lines = _detailCode.getLines();
            for (String command : _lines) {
                _builder.append((Object)"\t");
                _builder.append((Object)command, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            GlobalSettings _settings = Main.getSettings();
            boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
            if (_generateMSCInstrumentation) {
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService.getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(), messageStrings[");
                _builder.append((Object)dir, "\t");
                _builder.append((Object)"_");
                String _name = m.getName();
                _builder.append((Object)_name, "\t");
                _builder.append((Object)"]);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"if (getPeerAddress()!=null)");
            _builder.newLine();
            VarDecl _data = m.getData();
            boolean _equals = Objects.equal((Object)_data, null);
            if (_equals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"getPeerMsgReceiver().receive(new EventMessage(getPeerAddress(), ");
                _builder.append((Object)dir, "\t\t");
                _builder.append((Object)"_");
                String _name_1 = m.getName();
                _builder.append((Object)_name_1, "\t\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            } else {
                VarDecl _data_3;
                RefableType _refType_1;
                DataType _type;
                boolean _isEnumerationOrPrimitive;
                boolean _not_1;
                boolean _not;
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"getPeerMsgReceiver().receive(new EventWithDataMessage(getPeerAddress(), ");
                _builder.append((Object)dir, "\t\t");
                _builder.append((Object)"_");
                String _name_2 = m.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)", ");
                VarDecl _data_1 = m.getData();
                String _name_3 = _data_1.getName();
                _builder.append((Object)_name_3, "\t\t");
                boolean _and = false;
                VarDecl _data_2 = m.getData();
                RefableType _refType = _data_2.getRefType();
                boolean _isRef = _refType.isRef();
                boolean bl2 = _not = !_isRef;
                _and = !_not ? false : (_not_1 = !(_isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(_type = (_refType_1 = (_data_3 = m.getData()).getRefType()).getType())));
                if (_and) {
                    _builder.append((Object)".deepCopy()");
                }
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        boolean _and_1 = false;
        VarDecl _data_4 = m.getData();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_data_4, null);
        if (!_notEquals_1) {
            _and_1 = false;
        } else {
            VarDecl _data_5 = m.getData();
            RefableType _refType_2 = _data_5.getRefType();
            DataType _type_1 = _refType_2.getType();
            _and_1 = _type_1 instanceof DataClass;
        }
        if (_and_1) {
            CharSequence _messageSignatureExplicit = this.messageSignatureExplicit(m);
            _builder.append((Object)_messageSignatureExplicit, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_4 = m.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)"(new ");
            VarDecl _data_6 = m.getData();
            RefableType _refType_3 = _data_6.getRefType();
            DataType _type_2 = _refType_3.getType();
            String _name_5 = _type_2.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"(");
            VarDecl _data_7 = m.getData();
            RefableType _refType_4 = _data_7.getRefType();
            DataType _type_3 = _refType_4.getType();
            String _paramList = this._dataClassGen.paramList((DataClass)_type_3);
            _builder.append((Object)_paramList, "\t");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateDataDriven(Root root, ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                return !Objects.equal((Object)_data, null);
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)_allIncomingMessages, (Functions.Function1)_function);
        EList models = root.getReferencedModels((RoomClass)pc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)pc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.IRTObject;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.DataReceivePort;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.DataSendPort;");
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = pc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// send port holds data");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static public class ");
        String _portClassName = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName, "\t");
        _builder.append((Object)" extends DataSendPort {");
        _builder.newLineIfNotEmpty();
        for (Message msg : sentMsgs) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"private ");
            VarDecl _data = msg.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "\t\t");
            _builder.append((Object)" ");
            String _name_2 = msg.getName();
            _builder.append((Object)_name_2, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// constructor");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public ");
        String _portClassName_1 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_1, "\t\t");
        _builder.append((Object)"(IRTObject parent, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"super(parent, name, localId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// getters and setters");
        _builder.newLine();
        for (Message msg_1 : sentMsgs) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public void ");
            String _name_3 = msg_1.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append((Object)"(");
            VarDecl _data_1 = msg_1.getData();
            RefableType _refType_1 = _data_1.getRefType();
            DataType _type_1 = _refType_1.getType();
            String _typeName_1 = this._typeHelpers.typeName(_type_1);
            _builder.append((Object)_typeName_1, "\t\t");
            _builder.append((Object)" ");
            String _name_4 = msg_1.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _name_5 = msg_1.getName();
            _builder.append((Object)_name_5, "\t\t\t");
            _builder.append((Object)" = ");
            String _name_6 = msg_1.getName();
            _builder.append((Object)_name_6, "\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public ");
            VarDecl _data_2 = msg_1.getData();
            RefableType _refType_2 = _data_2.getRefType();
            DataType _type_2 = _refType_2.getType();
            String _typeName_2 = this._typeHelpers.typeName(_type_2);
            _builder.append((Object)_typeName_2, "\t\t");
            _builder.append((Object)" ");
            String _name_7 = msg_1.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_8 = msg_1.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// receive port accesses send port");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static public class ");
        String _portClassName_2 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_2, "\t");
        _builder.append((Object)" extends DataReceivePort {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private ");
        String _portClassName_3 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_3, "\t\t");
        _builder.append((Object)" peer;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// constructor");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public ");
        String _portClassName_4 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_4, "\t\t");
        _builder.append((Object)"(IRTObject parent, String name, int localId) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"super(parent, name, localId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// getters");
        _builder.newLine();
        for (Message msg_2 : sentMsgs) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public ");
            VarDecl _data_3 = msg_2.getData();
            RefableType _refType_3 = _data_3.getRefType();
            DataType _type_3 = _refType_3.getType();
            String _typeName_3 = this._typeHelpers.typeName(_type_3);
            _builder.append((Object)_typeName_3, "\t\t");
            _builder.append((Object)" ");
            String _name_9 = msg_2.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (peer==null)");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ");
            VarDecl _data_4 = msg_2.getData();
            RefableType _refType_4 = _data_4.getRefType();
            DataType _type_4 = _refType_4.getType();
            String _defaultValue = this._javaExtensions.defaultValue(_type_4);
            _builder.append((Object)_defaultValue, "\t\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return peer.");
            String _name_10 = msg_2.getName();
            _builder.append((Object)_name_10, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"protected void connect(DataSendPort dataSendPort) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (dataSendPort instanceof ");
        String _portClassName_5 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_5, "\t\t\t");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"peer = (");
        String _portClassName_6 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_6, "\t\t\t\t");
        _builder.append((Object)")dataSendPort;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

